/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFESystem;
import ffe.core.KeywordComponent;
import ffe.core.MainPanel;
import ffe.lang.Keyword;
import ffe.parsers.KeyFileFilter;
import ffe.parsers.KeyFilter;
import ffe.tinker.DTDResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class KeywordPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger("ffe");
    private boolean fileOpen = false;
    private Hashtable<String, Keyword> currentKeys;
    private File currentKeyFile;
    private FFESystem currentSystem;
    private MainPanel mainPanel;
    private LinkedHashMap<String, KeywordComponent> keywordHashMap;
    private LinkedHashMap<String, String> groupHashMap;
    private JComboBox groupComboBox;
    private JPanel editPanel;
    private JToolBar toolBar;
    private JSplitPane splitPane;
    private JLabel statusLabel = new JLabel("  ");
    private JScrollPane editScrollPane;
    private JScrollPane descriptScrollPane;
    private JTextArea descriptTextArea;
    private JCheckBoxMenuItem descriptCheckBox;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private GridBagConstraints gridBagConstraints = new GridBagConstraints();
    private JPanel gridPanel = new JPanel(this.gridBagLayout);
    private StringBuffer commentStringBuffer = new StringBuffer();
    private JTextArea flatfileTextArea;
    private JLabel noSystemLabel = new JLabel("Keywords for the active system are edited here. ");
    private JLabel noKeywordLabel = new JLabel("Keyword desciptions are displayed here.");
    private JPanel noKeywordPanel = new JPanel(new FlowLayout(0, 5, 5));
    private FlowLayout flowLayout = new FlowLayout(0, 5, 5);
    private BorderLayout borderLayout = new BorderLayout();
    private File paramDir = null;
    private File[] paramFiles = null;
    private String[] paramNames = null;
    private Hashtable<String, String> paramHashtable = null;

    public KeywordPanel(MainPanel f) {
        this.mainPanel = f;
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        if (arg.equals("Open...")) {
            this.keyOpen();
        } else if (arg.equals("Close")) {
            this.keyClose();
        } else if (arg.equals("Save")) {
            this.keySave(this.currentKeyFile);
        } else if (arg.equals("Save As...")) {
            this.keySaveAs();
        } else if (arg.equals("Description")) {
            JCheckBoxMenuItem box = (JCheckBoxMenuItem)evt.getSource();
            this.setDivider(box.isSelected());
        }
        if (evt.getSource() instanceof JComboBox) {
            this.loadKeywordGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeyword(String key) {
        if (key == null) {
            return null;
        }
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            KeywordComponent keyword = this.keywordHashMap.get(key.toUpperCase());
            if (keyword == null) {
                return null;
            }
            return keyword.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeywordDescription(String key) {
        if (key == null) {
            return null;
        }
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            KeywordComponent keyword = this.keywordHashMap.get(key.toUpperCase());
            if (keyword == null) {
                return null;
            }
            return keyword.getKeywordDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeywordValue(String key) {
        if (key == null) {
            return null;
        }
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            KeywordComponent keyword = this.keywordHashMap.get(key.toUpperCase());
            if (keyword == null) {
                return null;
            }
            String value = keyword.toString().trim();
            if (value == null) {
                return null;
            }
            int firstSpace = value.indexOf(" ");
            if (firstSpace < 1) {
                return value;
            }
            return value.substring(firstSpace, value.length());
        }
    }

    public String[] getParamFiles() {
        return this.paramNames;
    }

    public String getParamPath(String key) {
        return this.paramHashtable.get(key);
    }

    private void initialize() {
        this.loadXML();
        this.flatfileTextArea = new JTextArea();
        this.flatfileTextArea.setEditable(false);
        this.flatfileTextArea.setFont(Font.decode("monospaced plain 12"));
        Insets insets = this.flatfileTextArea.getInsets();
        insets.set(5, 5, 5, 5);
        this.flatfileTextArea.setMargin(insets);
        this.editPanel = new JPanel(this.flowLayout);
        ClassLoader loader = this.getClass().getClassLoader();
        ImageIcon icKeyPanel = new ImageIcon(loader.getResource("ffe/icons/keywords.png"));
        this.noSystemLabel.setIcon(icKeyPanel);
        ImageIcon icon = new ImageIcon(loader.getResource("ffe/icons/info.png"));
        this.noKeywordLabel.setIcon(icon);
        this.noKeywordPanel.add(this.noKeywordLabel);
        this.editScrollPane = new JScrollPane(this.editPanel, 22, 32);
        this.descriptScrollPane = new JScrollPane(this.descriptTextArea, 22, 32);
        Border eb = BorderFactory.createEtchedBorder(0);
        this.descriptScrollPane.setBorder(eb);
        this.splitPane = new JSplitPane(0, this.editScrollPane, this.descriptScrollPane);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setOneTouchExpandable(true);
        this.statusLabel.setBorder(eb);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.add((Component)this.statusLabel, "South");
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.gridheight = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.fill = 2;
        this.initToolBar();
        this.add((Component)this.toolBar, "North");
        this.setParamPath();
        this.loadPrefs();
        this.loadKeywordGroup();
    }

    public void initToolBar() {
        this.toolBar = new JToolBar("Keyword Editor");
        this.toolBar.setLayout(this.flowLayout);
        ClassLoader loader = this.getClass().getClassLoader();
        JButton jbopen = new JButton(new ImageIcon(loader.getResource("ffe/icons/open.png")));
        jbopen.setActionCommand("Open...");
        jbopen.setToolTipText("Open a *.KEY File for Editing");
        jbopen.addActionListener(this);
        jbopen.setBorderPainted(false);
        Insets insets = jbopen.getInsets();
        insets.top = 2;
        insets.bottom = 2;
        insets.left = 2;
        insets.right = 2;
        jbopen.setMargin(insets);
        this.toolBar.add(jbopen);
        JButton jbsave = new JButton(new ImageIcon(loader.getResource("ffe/icons/save.png")));
        jbsave.setActionCommand("Save");
        jbsave.setToolTipText("Save the Active *.KEY File");
        jbsave.addActionListener(this);
        jbsave.setBorderPainted(false);
        jbsave.setMargin(insets);
        this.toolBar.add(jbsave);
        JButton jbsaveas = new JButton(new ImageIcon(loader.getResource("ffe/icons/saveAs.png")));
        jbsaveas.setActionCommand("Save As...");
        jbsaveas.setToolTipText("Save the Active *.KEY File Under a New Name");
        jbsaveas.addActionListener(this);
        jbsaveas.setBorderPainted(false);
        jbsaveas.setMargin(insets);
        this.toolBar.add(jbsaveas);
        JButton jbclose = new JButton(new ImageIcon(loader.getResource("ffe/icons/close.png")));
        jbclose.setActionCommand("Close");
        jbclose.setToolTipText("Close the Active *.KEY File");
        jbclose.addActionListener(this);
        jbclose.setBorderPainted(false);
        jbclose.setMargin(insets);
        this.toolBar.add(jbclose);
        this.toolBar.addSeparator();
        this.groupComboBox.setMaximumSize(this.groupComboBox.getPreferredSize());
        this.groupComboBox.addActionListener(this);
        this.groupComboBox.setEditable(false);
        this.toolBar.add(this.groupComboBox);
        this.toolBar.addSeparator();
        ImageIcon icinfo = new ImageIcon(loader.getResource("ffe/icons/info.png"));
        this.descriptCheckBox = new JCheckBoxMenuItem(icinfo);
        this.descriptCheckBox.setActionCommand("Description");
        this.descriptCheckBox.setToolTipText("Show/Hide Keyword Descriptions");
        this.descriptCheckBox.addActionListener(this);
        this.descriptCheckBox.setMargin(insets);
        this.toolBar.add(this.descriptCheckBox);
        this.toolBar.add(new JLabel(""));
        this.toolBar.setBorderPainted(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setOrientation(0);
    }

    public boolean isFileOpen() {
        return this.fileOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeyword(String key) {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            KeywordComponent keyword = this.keywordHashMap.get(key.toUpperCase());
            return keyword != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyClear() {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            for (KeywordComponent kw : this.keywordHashMap.values()) {
                kw.clearKeywordComponent();
            }
            KeywordComponent.setKeywordModified(false);
            this.fileOpen = false;
            this.currentKeys = null;
            this.currentSystem = null;
            this.currentKeyFile = null;
            this.commentStringBuffer = new StringBuffer();
            this.statusLabel.setText("  ");
            this.loadKeywordGroup();
        }
    }

    public boolean keyClose() {
        if (KeywordComponent.isKeywordModified()) {
            return false;
        }
        this.keyClear();
        return true;
    }

    public void keyOpen() {
        File newKeyFile;
        File cwd;
        if (this.fileOpen && KeywordComponent.isKeywordModified()) {
            int option = JOptionPane.showConfirmDialog(this, "Save Changes First", "Opening New File", 1, 1);
            if (option == 2) {
                return;
            }
            if (option == 0) {
                this.keySave(this.currentKeyFile);
            }
            this.keyClear();
        }
        JFileChooser d = MainPanel.getFileChooser();
        if (this.currentSystem != null && (cwd = this.currentSystem.getFile()) != null && cwd.getParentFile() != null) {
            d.setCurrentDirectory(cwd.getParentFile());
        }
        d.setAcceptAllFileFilterUsed(false);
        d.setFileFilter(MainPanel.keyfilefilter);
        d.setDialogTitle("Open KEY File");
        int result = d.showOpenDialog(this);
        if (result == 0 && (newKeyFile = d.getSelectedFile()) != null && newKeyFile.exists() && newKeyFile.canRead()) {
            this.keyOpen(newKeyFile);
        }
    }

    public boolean keyOpen(File newKeyFile) {
        Hashtable<String, Keyword> newKeys;
        if (newKeyFile != null && newKeyFile.exists() && newKeyFile.canRead() && (newKeys = KeyFilter.open(newKeyFile)) != null && newKeys.size() > 0) {
            if (this.currentSystem != null) {
                this.currentSystem.setKeyFile(this.currentKeyFile);
                this.currentSystem.setKeywords(this.currentKeys);
            }
            this.loadActive(this.currentSystem, newKeys, newKeyFile);
            return true;
        }
        return false;
    }

    public void keySave(File f) {
        if (f != null) {
            this.currentKeyFile = f;
        }
        if (!this.fileOpen || this.currentKeyFile == null) {
            return;
        }
        this.storeActive();
        this.saveKeywords(this.currentKeyFile, this.keywordHashMap, this.commentStringBuffer);
    }

    public void keySaveAs() {
        if (!this.fileOpen) {
            return;
        }
        JFileChooser d = MainPanel.getFileChooser();
        d.setDialogTitle("Save KEY File");
        d.setAcceptAllFileFilterUsed(false);
        if (this.currentKeyFile != null) {
            d.setCurrentDirectory(this.currentKeyFile.getParentFile());
            d.setSelectedFile(this.currentKeyFile);
        }
        d.setFileFilter(new KeyFileFilter());
        int result = d.showSaveDialog(this);
        if (result == 0) {
            this.currentKeyFile = d.getSelectedFile();
            this.keySave(this.currentKeyFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadActive(FFESystem newSystem) {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            if (newSystem == null) {
                this.keyClear();
                return false;
            }
            File newKeyFile = newSystem.getKeyFile();
            Hashtable<String, Keyword> newKeys = newSystem.getKeywords();
            if (newKeyFile == null || newKeys == null) {
                return false;
            }
            return this.loadActive(newSystem, newKeys, newKeyFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadActive(FFESystem newSystem, Hashtable<String, Keyword> newKeys, File newKeyFile) {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            if (this.currentKeys != null && KeywordComponent.isKeywordModified()) {
                if (this.currentSystem != null && this.currentSystem != newSystem) {
                    this.storeActive();
                } else {
                    this.saveChanges();
                }
            }
            this.keyClear();
            if (newKeys == null || newKeys.size() == 0) {
                return false;
            }
            this.currentSystem = newSystem;
            this.currentKeyFile = newKeyFile;
            this.currentKeys = newKeys;
            this.fileOpen = true;
            Vector<String> keysToRemove = new Vector<String>();
            Keyword comments = this.currentKeys.get("COMMENTS");
            for (Keyword keyword : this.currentKeys.values()) {
                String label = keyword.getKeyword();
                Vector<String> data = keyword.getEntries();
                if (label.equals("COMMENTS")) continue;
                KeywordComponent tk = this.keywordHashMap.get(label.toUpperCase());
                if (tk == null) {
                    keysToRemove.add(keyword.getKeyword());
                    if (data.size() == 0) {
                        comments.append(label);
                        continue;
                    }
                    if (label.equalsIgnoreCase("MULTIPOLE")) {
                        int count = 5;
                        for (String entry : data) {
                            if (++count > 5) {
                                comments.append(label + " " + entry);
                                count = 1;
                                continue;
                            }
                            comments.append(entry);
                        }
                        continue;
                    }
                    if (label.equalsIgnoreCase("TORTORS")) {
                        int points = 0;
                        int count = 0;
                        for (String entry : data) {
                            if (++count > points) {
                                String[] res = entry.split(" +");
                                int xres = Integer.parseInt(res[5]);
                                int yres = Integer.parseInt(res[5]);
                                points = xres * yres;
                                comments.append(label + " " + entry);
                                count = 0;
                                continue;
                            }
                            comments.append(entry);
                        }
                        continue;
                    }
                    for (String entry : data) {
                        comments.append(label + " " + entry);
                    }
                    continue;
                }
                if (data.size() == 0) {
                    tk.loadKeywordEntry(label);
                }
                for (String s : data) {
                    tk.loadKeywordEntry(s);
                }
            }
            Vector<String> entries = comments.getEntries();
            if (entries != null) {
                for (String s : entries) {
                    if (s.length() > 1) {
                        if (this.groupHashMap.containsKey(s.substring(1).toUpperCase().trim())) continue;
                        this.commentStringBuffer.append(s + "\n");
                        continue;
                    }
                    this.commentStringBuffer.append(s + "\n");
                }
            }
            for (String k : keysToRemove) {
                this.currentKeys.remove(k);
            }
            if (this.currentSystem != null) {
                this.currentSystem.setKeywords(this.currentKeys);
                this.currentSystem.setKeyFile(this.currentKeyFile);
            }
            this.loadKeywordGroup();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeywordGroup() {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            this.editPanel.removeAll();
            String selectedGroup = (String)this.groupComboBox.getSelectedItem();
            if (this.currentKeys == null) {
                this.editPanel.setLayout(this.flowLayout);
                this.editPanel.add(this.noSystemLabel);
                int temp = this.splitPane.getDividerLocation();
                this.splitPane.setBottomComponent(this.noKeywordPanel);
                this.splitPane.setDividerLocation(temp);
            } else if (selectedGroup.equalsIgnoreCase("Flat File View")) {
                this.editPanel.setLayout(this.borderLayout);
                this.publishKeywords();
                this.editPanel.add((Component)this.flatfileTextArea, "Center");
                int temp = this.splitPane.getDividerLocation();
                this.splitPane.setBottomComponent(this.noKeywordPanel);
                this.splitPane.setDividerLocation(temp);
            } else if (selectedGroup.equalsIgnoreCase("Active Keywords")) {
                this.gridPanel.removeAll();
                this.gridBagConstraints.gridy = 0;
                this.gridBagConstraints.anchor = 17;
                this.gridBagConstraints.gridheight = 1;
                this.gridBagConstraints.gridwidth = 1;
                this.gridBagConstraints.fill = 2;
                for (KeywordComponent keywordComponent : this.keywordHashMap.values()) {
                    if (!keywordComponent.isActive()) continue;
                    JPanel jptemp = keywordComponent.getKeywordGUI();
                    this.gridBagLayout.setConstraints(jptemp, this.gridBagConstraints);
                    this.gridPanel.add(jptemp);
                    ++this.gridBagConstraints.gridy;
                }
                KeywordComponent.fillPanel(this.gridPanel, this.gridBagLayout, this.gridBagConstraints);
                this.editPanel.setLayout(this.flowLayout);
                this.editPanel.add(this.gridPanel);
                int temp = this.splitPane.getDividerLocation();
                this.splitPane.setBottomComponent(this.descriptScrollPane);
                this.splitPane.setDividerLocation(temp);
            } else {
                this.gridPanel.removeAll();
                this.gridBagConstraints.gridy = 0;
                this.gridBagConstraints.gridx = 0;
                this.gridBagConstraints.anchor = 17;
                this.gridBagConstraints.gridheight = 1;
                this.gridBagConstraints.gridwidth = 1;
                this.gridBagConstraints.fill = 2;
                for (KeywordComponent keywordComponent : this.keywordHashMap.values()) {
                    if (!keywordComponent.getKeywordGroup().equalsIgnoreCase(selectedGroup)) continue;
                    JPanel jptemp = keywordComponent.getKeywordGUI();
                    this.gridBagLayout.setConstraints(jptemp, this.gridBagConstraints);
                    this.gridPanel.add(jptemp);
                    ++this.gridBagConstraints.gridy;
                }
                KeywordComponent.fillPanel(this.gridPanel, this.gridBagLayout, this.gridBagConstraints);
                this.editPanel.setLayout(this.flowLayout);
                this.editPanel.add(this.gridPanel);
                int temp = this.splitPane.getDividerLocation();
                this.splitPane.setBottomComponent(this.descriptScrollPane);
                this.splitPane.setDividerLocation(temp);
            }
            if (this.currentKeyFile != null) {
                this.statusLabel.setText("  " + this.currentKeyFile.toString());
            } else {
                this.statusLabel.setText("  ");
            }
            this.editScrollPane.validate();
            this.editScrollPane.repaint();
        }
    }

    public void loadPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(KeywordPanel.class);
        this.descriptCheckBox.setSelected(!prefs.getBoolean("KeywordPanel_description", true));
        this.descriptCheckBox.doClick();
    }

    private void loadXML() {
        NodeList groups = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new DTDResolver());
            URL keyURL = this.getClass().getClassLoader().getResource("ffe/tinker/keywords.xml");
            Document doc = db.parse(keyURL.openStream());
            Element document = doc.getDocumentElement();
            Element body = (Element)document.getElementsByTagName("body").item(0);
            groups = body.getElementsByTagName("section");
        }
        catch (ParserConfigurationException e) {
            this.logger.warning(String.valueOf(e));
        }
        catch (SAXException e) {
            this.logger.warning(String.valueOf(e));
        }
        catch (IOException e) {
            this.logger.warning(String.valueOf(e));
        }
        this.keywordHashMap = new LinkedHashMap();
        this.groupHashMap = new LinkedHashMap();
        this.groupHashMap.put("ACTIVE KEYWORDS", "Active Keywords");
        this.groupHashMap.put("FLAT FILE VIEW", "Flat File View");
        this.groupComboBox = new JComboBox();
        this.groupComboBox.addItem("Active Keywords");
        this.groupComboBox.addItem("Flat File View");
        this.descriptTextArea = new JTextArea();
        this.descriptTextArea.setLineWrap(true);
        this.descriptTextArea.setWrapStyleWord(true);
        Insets insets = this.descriptTextArea.getInsets();
        insets.set(5, 5, 5, 5);
        this.descriptTextArea.setMargin(insets);
        int length = groups.getLength();
        for (int i = 0; i < length; ++i) {
            Element group = (Element)groups.item(i);
            String groupName = group.getAttribute("name");
            this.groupComboBox.addItem(groupName);
            NodeList keywords = group.getElementsByTagName("subsection");
            int klength = keywords.getLength();
            for (int j = 0; j < klength; ++j) {
                KeywordComponent key;
                KeywordComponent.SwingRepresentation type;
                Element keyword = (Element)keywords.item(j);
                String keywordName = keyword.getAttribute("name");
                Node text = keyword.getFirstChild();
                String keywordDescription = text.getNodeValue().replace('\n', ' ');
                keywordDescription = keywordDescription.replace("  ", " ");
                String keywordGUI = keyword.getAttribute("rep");
                try {
                    type = KeywordComponent.SwingRepresentation.valueOf(keywordGUI.toUpperCase());
                }
                catch (Exception e) {
                    type = null;
                    this.logger.warning(keywordName + ": Unknown GUI Component - " + String.valueOf((Object)type));
                    System.exit(-1);
                }
                if (type == KeywordComponent.SwingRepresentation.CHECKBOXES || type == KeywordComponent.SwingRepresentation.COMBOBOX) {
                    NodeList values = keyword.getElementsByTagName("Value");
                    String[] labels = new String[values.getLength()];
                    for (int k = 0; k < values.getLength(); ++k) {
                        Element value = (Element)values.item(k);
                        labels[k] = value.getAttribute("name");
                    }
                    key = new KeywordComponent(keywordName, groupName, type, keywordDescription, this.descriptTextArea, labels);
                } else {
                    key = new KeywordComponent(keywordName, groupName, type, keywordDescription, this.descriptTextArea);
                }
                this.keywordHashMap.put(keywordName.toUpperCase(), key);
                this.groupHashMap.put(groupName.toUpperCase(), groupName);
            }
        }
        this.groupComboBox.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishKeywords() {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            this.flatfileTextArea.setText("");
            boolean writegroup = false;
            String pgroup = null;
            for (KeywordComponent keyword : this.keywordHashMap.values()) {
                String line;
                String group = keyword.getKeywordGroup();
                if (pgroup == null || !group.equalsIgnoreCase(pgroup)) {
                    writegroup = true;
                    pgroup = group;
                }
                if ((line = keyword.toString()) == null) continue;
                if (writegroup) {
                    this.flatfileTextArea.append("\n");
                    this.flatfileTextArea.append("# " + group);
                    this.flatfileTextArea.append("\n");
                    writegroup = false;
                }
                this.flatfileTextArea.append(line);
                this.flatfileTextArea.append("\n");
            }
            this.flatfileTextArea.append("\n");
            String s = this.commentStringBuffer.toString();
            if (s != null && !s.trim().equals("")) {
                this.flatfileTextArea.append(s.trim());
            }
            this.flatfileTextArea.append("\n");
        }
    }

    public boolean saveChanges() {
        if (KeywordComponent.isKeywordModified() && this.currentKeyFile != null) {
            this.keySave(this.currentKeyFile);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveKeywords(File keyFile, LinkedHashMap<String, KeywordComponent> keywordHashMap, StringBuffer comments) {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                fw = new FileWriter(keyFile);
                bw = new BufferedWriter(fw);
                boolean writegroup = false;
                String pgroup = null;
                for (KeywordComponent keyword : keywordHashMap.values()) {
                    String line;
                    String group = keyword.getKeywordGroup();
                    if (pgroup == null || !group.equalsIgnoreCase(pgroup)) {
                        writegroup = true;
                        pgroup = group;
                    }
                    if ((line = keyword.toString()) == null) continue;
                    if (writegroup) {
                        bw.newLine();
                        bw.write("# " + group);
                        bw.newLine();
                        writegroup = false;
                    }
                    bw.write(line);
                    bw.newLine();
                }
                bw.newLine();
                String s = comments.toString();
                if (s != null && !s.trim().equals("")) {
                    bw.write(s.trim());
                }
                bw.newLine();
                bw.flush();
                KeywordComponent.setKeywordModified(false);
            }
            catch (FileNotFoundException e) {
                this.logger.warning(e.toString());
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                this.logger.warning(e.toString());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (Exception e2) {
                    this.logger.warning(e2.toString());
                }
            }
            return true;
        }
    }

    public void savePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(KeywordPanel.class);
        prefs.putInt("KeywordPanel_divider", this.splitPane.getDividerLocation());
        prefs.putBoolean("KeywordPanel_description", this.descriptCheckBox.isSelected());
    }

    public void selected() {
        this.setDivider(this.descriptCheckBox.isSelected());
        this.validate();
        this.repaint();
    }

    public void setDivider(boolean b) {
        if (b) {
            this.descriptCheckBox.setSelected(b);
            int spDivider = (int)((float)this.getHeight() * 0.6f);
            this.splitPane.setDividerLocation(spDivider);
        } else {
            this.splitPane.setDividerLocation(1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeywordGroup(String keygroup) {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            keygroup = this.groupHashMap.get(keygroup.toUpperCase());
            if (keygroup == null) {
                return;
            }
            if (!this.groupComboBox.getSelectedItem().equals(keygroup)) {
                this.groupComboBox.setSelectedItem(keygroup);
                this.loadKeywordGroup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeywordValue(String key, String value) {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            KeywordComponent keyword = this.keywordHashMap.get(key.toUpperCase());
            if (keyword == null) {
                return;
            }
            keyword.loadKeywordEntry(value);
            String keygroup = keyword.getKeywordGroup();
            if (!this.groupComboBox.getSelectedItem().equals(keygroup)) {
                this.groupComboBox.setSelectedItem(keygroup);
                this.loadKeywordGroup();
            }
            this.mainPanel.setPanel(1);
        }
    }

    public void setParamPath() {
        this.paramDir = new File(MainPanel.tinkerDir.getAbsolutePath() + File.separator + "params");
        if (this.paramDir != null && this.paramDir.exists()) {
            this.paramFiles = this.paramDir.listFiles();
            this.paramHashtable = new Hashtable();
            for (int i = 0; i < this.paramFiles.length; ++i) {
                File f = this.paramFiles[i];
                if (!f.exists() || !f.canRead() || !MainPanel.forceFieldFileFilter.accept(f)) continue;
                this.paramHashtable.put(f.getName(), f.getAbsolutePath());
            }
            int num = this.paramHashtable.size();
            this.paramNames = new String[num + 1];
            int i = 1;
            Enumeration<String> e = this.paramHashtable.keys();
            while (e.hasMoreElements()) {
                this.paramNames[i] = e.nextElement();
                ++i;
            }
            this.paramNames[0] = "AAA";
            Arrays.sort(this.paramNames);
            this.paramNames[0] = "Use an existing Tinker KEY file".intern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(FFESystem sys) {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            FFESystem back = this.currentSystem;
            this.currentSystem = sys;
            this.storeActive();
            this.currentSystem = back;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeActive() {
        KeywordPanel keywordPanel = this;
        synchronized (keywordPanel) {
            if (this.currentSystem == null) {
                return;
            }
            if (!KeywordComponent.isKeywordModified()) {
                return;
            }
            Hashtable<String, Keyword> currentKeys = this.currentSystem.getKeywords();
            Hashtable<String, Keyword> newKeys = new Hashtable<String, Keyword>();
            for (KeywordComponent kc : this.keywordHashMap.values()) {
                if (!kc.isActive()) continue;
                Keyword keywordData = null;
                if (currentKeys != null) {
                    keywordData = currentKeys.get(kc.getKeyword());
                }
                if (keywordData == null) {
                    keywordData = new Keyword(kc.getKeyword());
                } else {
                    keywordData.clear();
                }
                kc.getKeywordData(keywordData);
                newKeys.put(kc.getKeyword(), keywordData);
            }
            Keyword comments = new Keyword("COMMENTS", this.commentStringBuffer.toString());
            newKeys.put("COMMENTS", comments);
            this.currentSystem.setKeywords(newKeys);
        }
    }

    @Override
    public String toString() {
        return "Keyword Editor";
    }
}

