/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.lang.HashCodeUtil;
import ffe.lang.Keyword;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class KeywordComponent
implements MouseListener,
ActionListener,
ChangeListener,
DocumentListener {
    private static boolean isModified = false;
    private static String spaces = new String("                             ");
    private Logger logger = Logger.getLogger("ffe");
    private static Dimension labelDimension = null;
    private static Dimension entryDimension = null;
    private String keyword;
    private String keywordGroup;
    private ArrayList<Component> keywordValues;
    private JPanel keywordGUI = null;
    private FlowLayout flowLayout = new FlowLayout(0, 5, 5);
    private SwingRepresentation swingRepresentation;
    private String[] options;
    private String keywordDescription;
    private JTextArea output;
    private boolean active;
    private boolean init = false;

    public static void fillPanel(JPanel p, GridBagLayout g, GridBagConstraints c) {
        JLabel jfill = new JLabel(" ");
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 0;
        g.setConstraints(jfill, c);
        p.add(jfill);
    }

    public static boolean isKeywordModified() {
        return isModified;
    }

    public static void setKeywordModified(boolean b) {
        isModified = b;
    }

    public KeywordComponent(String k, String kg, SwingRepresentation s, String d, JTextArea jta) {
        this.keyword = k;
        this.keywordGroup = kg;
        this.keywordValues = new ArrayList();
        this.swingRepresentation = s;
        this.keywordDescription = d;
        this.output = jta;
        this.active = false;
        this.flowLayout.setHgap(2);
        this.flowLayout.setVgap(1);
    }

    public KeywordComponent(String k, String kg, SwingRepresentation s, String d, JTextArea jta, String[] o) {
        this(k, kg, s, d, jta);
        this.options = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        KeywordComponent keywordComponent = this;
        synchronized (keywordComponent) {
            isModified = true;
            if (evt.getSource() instanceof JButton) {
                JButton button = (JButton)evt.getSource();
                if (button.getText().equalsIgnoreCase("Add")) {
                    JTextField text = (JTextField)this.keywordValues.get(3);
                    String s = text.getText();
                    if (s != null && !s.trim().equals("")) {
                        JComboBox jcb = (JComboBox)this.keywordValues.get(1);
                        jcb.addItem(s);
                        text.setText("");
                        this.active = true;
                    }
                } else if (button.getText().equalsIgnoreCase("Remove")) {
                    JComboBox jcb = (JComboBox)this.keywordValues.get(1);
                    if (jcb.getItemCount() > 0) {
                        jcb.removeItemAt(jcb.getSelectedIndex());
                    }
                    if (jcb.getItemCount() == 0) {
                        this.active = false;
                    }
                }
            } else if (evt.getSource() instanceof JComboBox) {
                JComboBox jcb = (JComboBox)evt.getSource();
                String selected = (String)jcb.getSelectedItem();
                this.active = selected == null ? false : !selected.equalsIgnoreCase("DEFAULT");
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        isModified = true;
    }

    private void checkBoxesInit() {
        this.checkBoxInit();
        for (String s : this.options) {
            this.checkBoxInit(s);
        }
    }

    private void checkBoxInit() {
        JCheckBox cb = new JCheckBox(this.keyword, false);
        cb.setPreferredSize(labelDimension);
        cb.setMaximumSize(labelDimension);
        cb.addMouseListener(this);
        cb.addChangeListener(this);
        this.keywordValues.add(cb);
    }

    private void checkBoxInit(String label) {
        JCheckBox cb = new JCheckBox(label, false);
        cb.addMouseListener(this);
        cb.addChangeListener(this);
        this.keywordValues.add(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeywordComponent() {
        KeywordComponent keywordComponent = this;
        synchronized (keywordComponent) {
            this.active = false;
            if (!this.init) {
                return;
            }
            if (this.swingRepresentation == SwingRepresentation.CHECKBOX) {
                ((JCheckBox)this.keywordValues.get(0)).setSelected(false);
            } else if (this.swingRepresentation == SwingRepresentation.CHECKBOXES) {
                ListIterator<Component> li = this.keywordValues.listIterator();
                while (li.hasNext()) {
                    ((JCheckBox)li.next()).setSelected(false);
                }
            } else if (this.swingRepresentation == SwingRepresentation.COMBOBOX) {
                JComboBox jcb = (JComboBox)this.keywordValues.get(1);
                jcb.setSelectedItem("DEFAULT");
            } else if (this.swingRepresentation == SwingRepresentation.EDITCOMBOBOX) {
                ((JComboBox)this.keywordValues.get(1)).removeAllItems();
            } else if (this.swingRepresentation == SwingRepresentation.TEXTFIELD) {
                ((JTextField)this.keywordValues.get(1)).setText("");
            } else {
                this.logger.severe("Keyword Component: Unknown Keyword Type");
                this.logger.severe("Force Field Explorer can not continue...");
                System.exit(-1);
            }
        }
    }

    private void comboBoxInit() {
        JLabel jl = new JLabel(this.keyword);
        jl.addMouseListener(this);
        jl.setPreferredSize(labelDimension);
        jl.setMaximumSize(labelDimension);
        this.keywordValues.add(jl);
        JComboBox<String> cb = new JComboBox<String>();
        cb.setEditable(false);
        cb.addMouseListener(this);
        cb.addActionListener(this);
        cb.setPreferredSize(entryDimension);
        cb.setMaximumSize(entryDimension);
        for (String s : this.options) {
            cb.addItem(s);
        }
        cb.setSelectedItem("DEFAULT");
        this.keywordValues.add(cb);
    }

    private void editComboBoxInit() {
        JLabel jl = new JLabel(this.keyword);
        this.keywordValues.add(jl);
        jl.addMouseListener(this);
        jl.setPreferredSize(labelDimension);
        jl.setMaximumSize(labelDimension);
        JComboBox cb = new JComboBox();
        cb.setEditable(false);
        cb.addActionListener(this);
        cb.setPreferredSize(entryDimension);
        cb.setMaximumSize(entryDimension);
        this.keywordValues.add(cb);
        JButton remove = new JButton("Remove");
        remove.addActionListener(this);
        this.keywordValues.add(remove);
        JTextField textField = new JTextField();
        textField.setPreferredSize(entryDimension);
        textField.setMaximumSize(entryDimension);
        this.keywordValues.add(textField);
        JButton add = new JButton("Add");
        add.addActionListener(this);
        this.keywordValues.add(add);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KeywordComponent other = (KeywordComponent)object;
        return this.keyword.equalsIgnoreCase(other.keyword);
    }

    public String getKeyword() {
        return this.keyword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getKeywordData(Keyword keywordData) {
        KeywordComponent keywordComponent = this;
        synchronized (keywordComponent) {
            if (keywordData == null || !this.active) {
                return;
            }
            for (Component c : this.keywordValues) {
                JComponent cb;
                if (c instanceof JTextField) {
                    JTextField tf = (JTextField)c;
                    if (tf.getText().equals("")) break;
                    keywordData.append(tf.getText());
                    break;
                }
                if (c instanceof JComboBox) {
                    cb = (JComboBox)c;
                    if (this.swingRepresentation == SwingRepresentation.COMBOBOX) {
                        String s = (String)((JComboBox)cb).getSelectedItem();
                        if (s == "DEFAULT") {
                            this.logger.warning("Keyword should not be active: " + this.toString());
                            return;
                        }
                        keywordData.append(s);
                        break;
                    }
                    int num = ((JComboBox)cb).getItemCount();
                    for (int i = 0; i < num; ++i) {
                        String s = (String)((JComboBox)cb).getItemAt(i);
                        keywordData.append(s);
                    }
                    break;
                }
                if (!(c instanceof JCheckBox)) continue;
                cb = (JCheckBox)c;
                String text = ((AbstractButton)cb).getText();
                if (!((AbstractButton)cb).isSelected()) continue;
                keywordData.append(text);
            }
        }
    }

    public String getKeywordDescription() {
        return this.keywordDescription;
    }

    public String getKeywordGroup() {
        return this.keywordGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel getKeywordGUI() {
        KeywordComponent keywordComponent = this;
        synchronized (keywordComponent) {
            if (this.keywordGUI == null) {
                if (!this.init) {
                    this.initSwingComponents();
                }
                if (this.swingRepresentation == SwingRepresentation.MULTIPOLE) {
                    this.keywordGUI.add(this.keywordValues.get(0));
                } else {
                    this.keywordGUI = new JPanel(this.flowLayout);
                    for (Component c : this.keywordValues) {
                        this.keywordGUI.add(c);
                    }
                }
            }
            return this.keywordGUI;
        }
    }

    public int hashCode() {
        return HashCodeUtil.hash(106, this.keyword.hashCode());
    }

    private void initSwingComponents() {
        if (this.swingRepresentation == SwingRepresentation.CHECKBOX) {
            this.checkBoxInit();
        } else if (this.swingRepresentation == SwingRepresentation.CHECKBOXES) {
            this.checkBoxesInit();
        } else if (this.swingRepresentation == SwingRepresentation.COMBOBOX) {
            this.comboBoxInit();
        } else if (this.swingRepresentation == SwingRepresentation.EDITCOMBOBOX) {
            this.editComboBoxInit();
        } else if (this.swingRepresentation == SwingRepresentation.TEXTFIELD) {
            this.textFieldInit();
        } else {
            return;
        }
        this.init = true;
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        isModified = true;
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadKeywordEntry(String s) {
        KeywordComponent keywordComponent = this;
        synchronized (keywordComponent) {
            if (!this.init) {
                this.initSwingComponents();
            }
            for (Component c : this.keywordValues) {
                JComponent cb;
                if (c instanceof JCheckBox) {
                    cb = (JCheckBox)c;
                    if (s != null && s.equalsIgnoreCase(((AbstractButton)cb).getText())) {
                        ((AbstractButton)cb).setSelected(true);
                        continue;
                    }
                    if (s != null) continue;
                    ((AbstractButton)cb).setSelected(false);
                    continue;
                }
                if (c instanceof JTextField) {
                    JTextField tf = (JTextField)c;
                    tf.setText(s);
                    break;
                }
                if (!(c instanceof JComboBox) || s == null) continue;
                cb = (JComboBox)c;
                if (this.swingRepresentation == SwingRepresentation.EDITCOMBOBOX) {
                    ((JComboBox)cb).addItem(s);
                    break;
                }
                ((JComboBox)cb).setSelectedItem(s);
                break;
            }
            this.active = true;
            if (this.toString() == null) {
                this.active = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent evt) {
        KeywordComponent keywordComponent = this;
        synchronized (keywordComponent) {
            this.active = true;
            if (this.toString() == null) {
                this.active = false;
            }
            this.output.setText(this.keyword + ": " + this.keywordDescription);
            JViewport jsp = (JViewport)this.output.getParent();
            jsp.setViewPosition(new Point(20, 20));
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.mouseClicked(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.mouseClicked(evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        isModified = true;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        isModified = true;
    }

    private void textFieldInit() {
        JLabel jl = new JLabel(this.keyword);
        jl.addMouseListener(this);
        jl.setPreferredSize(labelDimension);
        jl.setMaximumSize(labelDimension);
        this.keywordValues.add(jl);
        JTextField tf = new JTextField("");
        tf.setColumns(25);
        tf.setActionCommand(this.keyword);
        tf.addMouseListener(this);
        tf.getDocument().addDocumentListener(this);
        if (this.keyword.equalsIgnoreCase("PARAMETERS") || this.keyword.equalsIgnoreCase("FORCEFIELD")) {
            tf.setEditable(false);
            EmptyBorder b = new EmptyBorder(1, 1, 1, 1);
            tf.setBorder(b);
            tf.setForeground(Color.BLUE);
        }
        tf.setPreferredSize(entryDimension);
        tf.setMaximumSize(entryDimension);
        this.keywordValues.add(tf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        KeywordComponent keywordComponent = this;
        synchronized (keywordComponent) {
            if (!this.active || !this.init) {
                return null;
            }
            StringBuffer s = !this.keyword.equalsIgnoreCase("TORSION") ? new StringBuffer(this.keyword + spaces.substring(0, 18 - this.keyword.length())) : new StringBuffer(this.keyword);
            for (Component c : this.keywordValues) {
                JComponent cb;
                if (c instanceof JCheckBox) {
                    cb = (JCheckBox)c;
                    if (this.keywordValues.size() == 1) {
                        if (((AbstractButton)cb).isSelected()) continue;
                        return null;
                    }
                    if (((AbstractButton)cb).getText().equalsIgnoreCase(this.keyword)) {
                        if (((AbstractButton)cb).isSelected()) continue;
                        s = new StringBuffer();
                        continue;
                    }
                    if (!((AbstractButton)cb).isSelected()) continue;
                    if (s.length() > 0) {
                        s.append("\n" + this.keyword + " " + ((AbstractButton)cb).getText());
                        continue;
                    }
                    s.append(this.keyword + " " + ((AbstractButton)cb).getText());
                    continue;
                }
                if (c instanceof JTextField) {
                    JTextField tf = (JTextField)c;
                    if (tf.getText().equals("")) {
                        return null;
                    }
                    String v = tf.getText();
                    if (v.length() < 8) {
                        s.append(v + spaces.substring(0, 8 - v.length()));
                        break;
                    }
                    s.append(v);
                    break;
                }
                if (!(c instanceof JComboBox)) continue;
                cb = (JComboBox)c;
                if (this.swingRepresentation == SwingRepresentation.EDITCOMBOBOX) {
                    int count = ((JComboBox)cb).getItemCount();
                    if (count == 0) {
                        return null;
                    }
                    Object[] entries = new String[count];
                    for (int i = 0; i < count; ++i) {
                        entries[i] = (String)((JComboBox)cb).getItemAt(i);
                    }
                    Arrays.sort(entries);
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < count; ++i) {
                        sb.append(this.keyword + spaces.substring(0, 18 - this.keyword.length()));
                        sb.append(((String)entries[i]).toUpperCase());
                        if (i >= count - 1) continue;
                        sb.append("\n");
                    }
                    s = sb;
                    break;
                }
                String selection = (String)((JComboBox)cb).getSelectedItem();
                if (selection.startsWith("DEFAULT")) {
                    return null;
                }
                if (selection.equalsIgnoreCase("PRESENT")) break;
                s.append(" " + selection);
                break;
            }
            if (s.length() == 0) {
                return null;
            }
            return s.toString();
        }
    }

    static {
        JTextField textField = new JTextField(20);
        labelDimension = textField.getPreferredSize();
        textField = new JTextField(25);
        entryDimension = textField.getPreferredSize();
    }

    public static enum SwingRepresentation {
        TEXTFIELD,
        CHECKBOX,
        CHECKBOXES,
        EDITCOMBOBOX,
        COMBOBOX,
        MULTIPOLE;

    }
}

