/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFESystem;
import ffe.core.FileCloser;
import ffe.core.MainPanel;
import ffe.lang.MSNode;
import ffe.lang.MSRoot;
import ffe.lang.ROLSP;
import ffe.lang.RendererCache;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class Hierarchy
extends JTree
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private MSRoot root;
    private MainPanel mainPanel;
    private DefaultTreeModel treeModel;
    private DefaultTreeSelectionModel treeSelectionModel;
    private FFESystem activeSystem = null;
    private MSNode activeNode = null;
    private ArrayList<MSNode> activeNodes = new ArrayList();
    private JLabel status = null;
    private JLabel step = null;
    private JLabel energy = null;
    ArrayList<TreePath> newPaths = new ArrayList();
    ArrayList<TreePath> removedPaths = new ArrayList();
    ArrayList<TreePath> prePaths = new ArrayList();
    ArrayList<MSNode> picks = new ArrayList();
    TreePath nullPath = null;

    public Hierarchy(MainPanel f) {
        this.mainPanel = f;
        this.root = this.mainPanel.getDataRoot();
        this.initTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelection(MSNode f) {
        if (f == null) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            TreePath path = new TreePath(f.getPath());
            try {
                this.addSelectionPath(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.setSelected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelections(ArrayList<MSNode> a) {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            for (MSNode f : a) {
                this.addSelection(f);
            }
        }
    }

    public void addSystemNode(FFESystem newSystem) {
        this.addTreeNode(newSystem, this.root, this.root.getChildCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeNode(MSNode nodeToAdd, MSNode parent, int index) {
        if (nodeToAdd == null || nodeToAdd.getParent() != null) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            int childCount = parent.getChildCount();
            if (index < 0 || index > childCount) {
                index = parent.getChildCount();
            }
            if (ROLSP.GO_PARALLEL) {
                ROLSP parallelNode = new ROLSP();
                parallelNode.add(nodeToAdd);
                this.treeModel.insertNodeInto(parallelNode, parent, index);
            } else {
                this.treeModel.insertNodeInto(nodeToAdd, parent, index);
            }
            if (nodeToAdd instanceof FFESystem) {
                this.attach((FFESystem)nodeToAdd);
                this.treeModel.nodeStructureChanged(nodeToAdd);
            }
            this.onlySelection(nodeToAdd);
            if (!this.isRootVisible()) {
                this.setRootVisible(true);
            }
        }
    }

    private void attach(FFESystem newModel) {
        if (newModel == null) {
            return;
        }
        newModel.finalize(true);
        this.mainPanel.getGraphics3D().attachModel(newModel);
        if (newModel.getBondList().size() == 0) {
            this.mainPanel.getGraphics3D().updateScene(newModel, false, true, RendererCache.ViewModel.SPACEFILL, false, null);
        }
    }

    public void collapseAll() {
        for (int row = this.getRowCount() - 1; row >= 0; --row) {
            this.collapseRow(row);
        }
    }

    private void detach(FFESystem closedModel) {
        if (closedModel == null) {
            return;
        }
        closedModel.setView(RendererCache.ViewModel.DESTROY, null);
        FileCloser cf = new FileCloser(closedModel);
        Thread t = new Thread(cf);
        t.setPriority(1);
        t.start();
    }

    public FFESystem getActive() {
        return this.activeSystem;
    }

    public MSNode getActiveNode() {
        return this.activeNode;
    }

    public ArrayList<MSNode> getActiveNodes() {
        return this.activeNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FFESystem[] getNonActiveSystems() {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            int childCount = this.root.getChildCount();
            if (childCount == 0) {
                return null;
            }
            FFESystem[] systems = new FFESystem[childCount - 1];
            int index = 0;
            Enumeration<TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                FFESystem system = (FFESystem)e.nextElement();
                if (system == this.getActive()) continue;
                systems[index++] = system;
            }
            return systems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FFESystem[] getSystems() {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            int childCount = this.root.getChildCount();
            if (childCount == 0) {
                return null;
            }
            FFESystem[] systems = new FFESystem[childCount];
            int index = 0;
            Enumeration<TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                systems[index++] = (FFESystem)e.nextElement();
            }
            return systems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void groupSelection(MSNode f1, MSNode f2) {
        if (f1 == null || f2 == null) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            TreePath[] paths = new TreePath[]{new TreePath(f1.getPath()), new TreePath(f2.getPath())};
            RowMapper rm = this.treeSelectionModel.getRowMapper();
            int[] rows = rm.getRowsForPaths(paths);
            this.setSelectionInterval(rows[0], rows[1]);
        }
    }

    public void initTree() {
        this.addTreeSelectionListener(this);
        this.setExpandsSelectedPaths(true);
        this.setScrollsOnExpand(true);
        this.setLargeModel(true);
        this.setEditable(false);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        DefaultTreeCellRenderer tcr = new DefaultTreeCellRenderer();
        tcr.setBackgroundSelectionColor(Color.yellow);
        tcr.setBorderSelectionColor(Color.black);
        tcr.setTextSelectionColor(Color.black);
        this.setCellRenderer(tcr);
        this.treeModel = new DefaultTreeModel(this.root);
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.setModel(this.treeModel);
        this.setSelectionModel(this.treeSelectionModel);
        this.setRootVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onlySelection(MSNode f) {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            if (this.activeNodes != null) {
                int num = this.activeNodes.size();
                TreePath[] paths = new TreePath[num];
                for (int i = 0; i < num; ++i) {
                    paths[i] = new TreePath(this.activeNodes.get(i).getPath());
                }
                this.removeSelectionPaths(paths);
            }
            this.collapseAll();
            this.addSelection(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelection(MSNode f) {
        if (f == null) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            TreePath path = new TreePath(f.getPath());
            Enumeration<TreePath> e = this.getExpandedDescendants(path);
            while (e.hasMoreElements()) {
                TreePath treePath = new TreePath((DefaultMutableTreeNode)((Object)e.nextElement()));
                this.collapsePath(treePath);
            }
            this.removeSelectionPath(path);
            f.setSelected(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelections(ArrayList<MSNode> a) {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            for (MSNode f : a) {
                this.removeSelection(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeNode(MSNode nodeToRemove) {
        if (nodeToRemove == null) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            if (this.root.getChildCount() <= 1) {
                this.setRootVisible(false);
            }
            this.treeModel.removeNodeFromParent(nodeToRemove);
            if (this.getActive() == nodeToRemove && this.root.getChildCount() != 0) {
                FFESystem m = (FFESystem)this.root.getChildAt(0);
                this.setActive(m);
                this.onlySelection(this.activeSystem);
            } else {
                this.setActive(null);
            }
            if (nodeToRemove instanceof FFESystem) {
                this.detach((FFESystem)nodeToRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        if (this.activeSystem == null) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            this.onlySelection(this.root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(FFESystem s) {
        if (s == this.activeSystem) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            this.activeSystem = s;
            this.updateStatus();
            if (this.mainPanel.getKeywordPanel() != null) {
                this.mainPanel.getKeywordPanel().loadActive(this.activeSystem);
            }
            if (this.mainPanel.getModelingPanel() != null) {
                this.mainPanel.getModelingPanel().loadActive(this.activeSystem);
            }
            if (this.mainPanel.getModelingShell() != null) {
                this.mainPanel.getModelingShell().sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(int i) {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            if (i < this.root.getChildCount()) {
                this.setActive((FFESystem)this.root.getChildAt(i));
            } else if (this.root.getChildCount() == 0) {
                this.setActive(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlighting(boolean h) {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            if (RendererCache.highlightSelections != h) {
                RendererCache.highlightSelections = h;
                for (MSNode node : this.activeNodes) {
                    node.setSelected(h);
                }
                this.mainPanel.getGraphics3D().updateScene(this.activeNodes, false, false, null, true, RendererCache.ColorModel.SELECT);
            }
        }
    }

    public void setStatus(JLabel s, JLabel t, JLabel e) {
        this.status = s;
        this.step = t;
        this.energy = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleSelection(MSNode f) {
        if (f == null) {
            return;
        }
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            TreePath path = new TreePath(f.getPath());
            if (this.isPathSelected(path)) {
                this.removeSelectionPath(path);
            } else {
                this.addSelectionPath(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleSelections(ArrayList<MSNode> a) {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            for (MSNode f : a) {
                this.toggleSelection(f);
            }
        }
    }

    @Override
    public String toString() {
        return "Structural Hierarchy";
    }

    public void updateStatus() {
        if (this.activeSystem == null) {
            this.status.setText("  ");
            this.step.setText("  ");
            this.energy.setText("  ");
            return;
        }
        if (this.activeSystem.getFile() != null) {
            this.status.setText("  " + this.activeSystem.toFFString());
        } else {
            this.status.setText("  " + this.activeSystem.toString());
        }
        if (this.activeSystem.isSimulation()) {
            this.step.setText(this.activeSystem.getTimeString() + " ");
        } else if (this.activeSystem.isOptimization()) {
            this.step.setText(this.activeSystem.getStepString() + " ");
        } else if (this.activeSystem.getCycles() > 1) {
            this.step.setText(this.activeSystem.getCurrentCycle() + "/" + this.activeSystem.getCycles());
        } else {
            this.step.setText("");
        }
        if (this.activeSystem.isSimulation()) {
            this.energy.setText(this.activeSystem.getEnergyString() + " ");
        } else if (this.activeSystem.isOptimization()) {
            this.energy.setText(this.activeSystem.getEnergyString() + " ");
        } else if (this.activeSystem.getCycles() > 1) {
            this.energy.setText("");
        } else {
            this.energy.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Hierarchy hierarchy = this;
        synchronized (hierarchy) {
            Object f;
            boolean change;
            int j;
            int i;
            TreePath pathj;
            TreePath[] paths;
            MSNode lastNode = (MSNode)this.getLastSelectedPathComponent();
            if (lastNode != null) {
                this.activeNode = lastNode;
                FFESystem s = (FFESystem)this.activeNode.getMSNode(FFESystem.class);
                if (s != null) {
                    this.setActive(s);
                }
            }
            if ((paths = e.getPaths()) == null) {
                return;
            }
            ArrayList<TreePath> temp = this.prePaths;
            this.prePaths = this.newPaths;
            this.newPaths = temp;
            this.newPaths.clear();
            this.removedPaths.clear();
            for (int i2 = 0; i2 < paths.length; ++i2) {
                if (e.isAddedPath(i2)) {
                    this.newPaths.add(paths[i2]);
                    continue;
                }
                this.removedPaths.add(paths[i2]);
            }
            for (int i3 = 0; i3 < this.newPaths.size(); ++i3) {
                TreePath pathi = this.newPaths.get(i3);
                if (pathi == this.nullPath) continue;
                for (int j2 = i3 + 1; j2 < this.newPaths.size(); ++j2) {
                    pathj = this.newPaths.get(j2);
                    if (pathi == this.nullPath || pathj == this.nullPath) continue;
                    if (pathi.isDescendant(pathj)) {
                        this.newPaths.set(j2, this.nullPath);
                        continue;
                    }
                    if (!pathj.isDescendant(pathi)) continue;
                    this.newPaths.set(i3, this.nullPath);
                }
            }
            boolean check = true;
            while (check) {
                check = this.newPaths.remove(this.nullPath);
            }
            for (i = 0; i < this.removedPaths.size(); ++i) {
                TreePath pathi = this.removedPaths.get(i);
                if (pathi == this.nullPath) continue;
                for (j = i + 1; j < this.removedPaths.size(); ++j) {
                    pathj = this.removedPaths.get(j);
                    if (pathi == this.nullPath || pathj == this.nullPath) continue;
                    if (pathi.isDescendant(pathj)) {
                        this.removedPaths.set(j, this.nullPath);
                        continue;
                    }
                    if (!pathj.isDescendant(pathi)) continue;
                    this.removedPaths.set(i, this.nullPath);
                }
            }
            check = true;
            while (check) {
                check = this.removedPaths.remove(this.nullPath);
            }
            block10: for (i = 0; i < this.prePaths.size(); ++i) {
                TreePath pathi = this.prePaths.get(i);
                for (j = 0; j < this.removedPaths.size(); ++j) {
                    pathj = this.removedPaths.get(j);
                    if (!pathj.isDescendant(pathi)) continue;
                    this.prePaths.set(i, this.nullPath);
                    continue block10;
                }
            }
            check = true;
            while (check) {
                check = this.prePaths.remove(this.nullPath);
            }
            for (i = 0; i < this.newPaths.size(); ++i) {
                TreePath pathi = this.newPaths.get(i);
                if (pathi == this.nullPath) continue;
                for (j = 0; j < this.prePaths.size(); ++j) {
                    pathj = this.prePaths.get(j);
                    if (pathj == this.nullPath || pathi == this.nullPath || pathj == this.nullPath) continue;
                    if (pathi.isDescendant(pathj)) {
                        this.prePaths.set(j, this.nullPath);
                        continue;
                    }
                    if (!pathj.isDescendant(pathi)) continue;
                    this.newPaths.set(i, this.nullPath);
                }
            }
            check = true;
            while (check) {
                check = this.newPaths.remove(this.nullPath);
            }
            check = true;
            while (check) {
                check = this.prePaths.remove(this.nullPath);
            }
            this.newPaths.addAll(this.prePaths);
            this.activeNodes.clear();
            for (i = 0; i < this.newPaths.size(); ++i) {
                TreePath pathi = this.newPaths.get(i);
                this.activeNodes.add((MSNode)pathi.getLastPathComponent());
            }
            if (this.activeNode != null) {
                TreePath activePath = new TreePath(this.activeNode);
                this.expandPath(activePath.getParentPath());
                this.makeVisible(activePath);
                this.scrollPathToVisible(activePath);
            }
            this.picks = new ArrayList();
            for (TreePath r : this.removedPaths) {
                change = true;
                for (TreePath n : this.newPaths) {
                    if (!n.isDescendant(r)) continue;
                    change = false;
                }
                if (!change) continue;
                f = (MSNode)r.getLastPathComponent();
                ((MSNode)f).setSelected(false);
                this.picks.add((MSNode)f);
            }
            for (TreePath n : this.newPaths) {
                change = true;
                for (TreePath p : this.prePaths) {
                    if (!p.isDescendant(n)) continue;
                    change = false;
                }
                if (!change) continue;
                f = (MSNode)n.getLastPathComponent();
                ((MSNode)f).setSelected(true);
                this.picks.add((MSNode)f);
            }
            if (RendererCache.highlightSelections) {
                this.mainPanel.getGraphics3D().updateScene(this.picks, false, false, null, true, RendererCache.ColorModel.SELECT);
            } else if (RendererCache.labelAtoms || RendererCache.labelResidues) {
                this.mainPanel.getGraphics3D().setLabelsUpdated();
            }
        }
    }
}

