/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.lang.MSRoot;
import ffe.lang.RendererCache;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphicsPrefs
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MSRoot root;
    private GridBagConstraints constraints;
    private boolean change = false;
    private Logger logger = Logger.getLogger("ffe");

    public GraphicsPrefs(Frame frame, MSRoot r) {
        super(frame, "", true);
        this.root = r;
        this.setTitle("Graphics Preferences");
        this.setSize(400, 200);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.weighty = 100.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 2;
        this.constraints.ipadx = 5;
        this.constraints.ipady = 5;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        JSlider radius = new JSlider(0, 200, 1);
        radius.setMajorTickSpacing(50);
        radius.setMinorTickSpacing(10);
        radius.setPaintLabels(true);
        radius.setPaintTicks(true);
        radius.setValue((int)(RendererCache.radius * 100.0));
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("0%"));
        labelTable.put(new Integer(50), new JLabel("50%"));
        labelTable.put(new Integer(100), new JLabel("100%"));
        labelTable.put(new Integer(150), new JLabel("150%"));
        labelTable.put(new Integer(200), new JLabel("200%"));
        radius.setLabelTable(labelTable);
        this.addSlider(radius, " Radius", 1);
        JSlider bondwidth = new JSlider(1, 5, 5);
        bondwidth.setMajorTickSpacing(1);
        bondwidth.setMinorTickSpacing(1);
        bondwidth.setPaintLabels(true);
        bondwidth.setPaintTicks(true);
        labelTable = new Hashtable();
        labelTable.put(new Integer(1), new JLabel("1"));
        labelTable.put(new Integer(3), new JLabel("3"));
        labelTable.put(new Integer(5), new JLabel("5"));
        bondwidth.setLabelTable(labelTable);
        bondwidth.setValue(RendererCache.bondwidth);
        this.addSlider(bondwidth, " Wireframe Thickness", 3);
        JSlider detail = new JSlider(0, 10, 10);
        detail.setMajorTickSpacing(1);
        detail.setMinorTickSpacing(1);
        detail.setPaintLabels(true);
        detail.setPaintTicks(true);
        detail.setValue(RendererCache.detail);
        labelTable = new Hashtable();
        labelTable.put(new Integer(0), new JLabel("Performance"));
        labelTable.put(new Integer(10), new JLabel("Quality"));
        detail.setLabelTable(labelTable);
        this.addSlider(detail, " Detail", 2);
        this.constraints.gridwidth = 1;
        JButton jb = new JButton("Apply");
        jb.addActionListener(this);
        this.getContentPane().add((Component)jb, this.constraints);
        JButton jbclose = new JButton("Close");
        jbclose.addActionListener(this);
        ++this.constraints.gridx;
        this.getContentPane().add((Component)jbclose, this.constraints);
        this.pack();
        Dimension dim = this.getToolkit().getScreenSize();
        Dimension ddim = this.getSize();
        this.setLocation((dim.width - ddim.width) / 2, (dim.height - ddim.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("Apply")) {
            if (this.change) {
                this.root.setView(RendererCache.ViewModel.DETAIL, null);
            }
            this.change = false;
        } else if (e.getActionCommand().equalsIgnoreCase("Close")) {
            if (this.change) {
                this.root.setView(RendererCache.ViewModel.DETAIL, null);
            }
            this.change = false;
            this.dispose();
        }
    }

    public void addSlider(JSlider s, String description, final int sliderID) {
        Border eb = BorderFactory.createEtchedBorder(1);
        s.setSnapToTicks(true);
        s.setBorder(new TitledBorder(eb, description));
        s.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (source.getValueIsAdjusting()) {
                    return;
                }
                int value = source.getValue();
                switch (sliderID) {
                    case 1: {
                        if (value < 1) {
                            return;
                        }
                        double temp = (double)value / 100.0;
                        if (temp == RendererCache.radius) break;
                        GraphicsPrefs.this.change = true;
                        RendererCache.radius = temp;
                        break;
                    }
                    case 2: {
                        if (RendererCache.detail == value) break;
                        GraphicsPrefs.this.change = true;
                        RendererCache.detail = value;
                        break;
                    }
                    case 3: {
                        if (RendererCache.bondwidth == value) break;
                        GraphicsPrefs.this.change = true;
                        RendererCache.bondwidth = value;
                        break;
                    }
                    default: {
                        GraphicsPrefs.this.logger.info("Unknown Slider");
                    }
                }
            }
        });
        this.constraints.gridx = 0;
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.getContentPane().add((Component)s, this.constraints);
        ++this.constraints.gridy;
    }
}

