/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.behaviors.PickMouseBehavior;
import ffe.core.FFESystem;
import ffe.core.GraphicsCanvas;
import ffe.core.MainPanel;
import ffe.core.ModelingShell;
import ffe.lang.Atom;
import ffe.lang.MSNode;
import ffe.lang.MolecularAssembly;
import ffe.lang.Molecule;
import ffe.lang.Polymer;
import ffe.lang.RendererCache;
import ffe.lang.Residue;
import ffe.lang.ValenceTerm;
import ffe.lang.VectorMath;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.picking.PickIntersection;
import org.jogamp.java3d.utils.picking.PickResult;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class GraphicsPicking
extends PickMouseBehavior {
    public static final Hashtable<String, PickLevel> pickLevelHash;
    private MainPanel mainPanel;
    private boolean picking = false;
    private static Logger logger;
    private PickLevel pickLevel = PickLevel.PICKATOM;
    private PickLevel newPickLevel = PickLevel.PICKATOM;
    private Atom previousAtom = null;
    private int pickNumber = 0;
    private MSNode previousPick = null;
    private Vector<Atom> atomCache = new Vector(4);
    private int count = 0;
    private double[] a = new double[3];
    private double[] b = new double[3];
    private double[] c = new double[3];
    private double[] d = new double[3];
    private Transform3D systemTransform3D = new Transform3D();
    private Vector3d syspos = new Vector3d();
    private Vector3d atpos = new Vector3d();

    public GraphicsPicking(BranchGroup base, Bounds bounds, GraphicsCanvas g, MainPanel f) {
        super(g, base, bounds);
        this.mainPanel = f;
        this.pickCanvas.setMode(256);
        this.pickCanvas.setTolerance(3.0f);
    }

    public void clear() {
        if (this.previousPick != null) {
            this.mainPanel.getHierarchy().collapsePath(new TreePath(this.previousPick.getPath()));
            this.previousPick.setSelected(false);
            this.previousPick.setColor(RendererCache.ColorModel.SELECT, null, null);
            this.previousPick = null;
            this.pickNumber = 0;
        }
        for (Atom a : this.atomCache) {
            a.setSelected(false);
            a.setColor(RendererCache.ColorModel.SELECT, null, null);
        }
        this.atomCache.clear();
    }

    private void distance(Atom atom, double[] pos) {
        MolecularAssembly m = (MolecularAssembly)atom.getMSNode(MolecularAssembly.class);
        m.getTransformGroup().getTransform(this.systemTransform3D);
        this.systemTransform3D.get(this.syspos);
        this.systemTransform3D.setScale(1.0);
        this.systemTransform3D.setTranslation(new Vector3d(0.0, 0.0, 0.0));
        atom.getV3D(this.atpos);
        this.systemTransform3D.transform(this.atpos);
        this.atpos.add((Tuple3d)this.syspos);
        this.atpos.get(pos);
    }

    public MSNode getPick() {
        return this.previousPick;
    }

    public boolean getPicking() {
        return this.picking;
    }

    public String getPickLevel() {
        return this.pickLevel.toString();
    }

    private void measure() {
        String measurement = null;
        double value = 0.0;
        switch (this.pickLevel) {
            case MEASUREDISTANCE: {
                if (this.atomCache.size() < 2) {
                    return;
                }
                Atom a1 = this.atomCache.get(0);
                Atom a2 = this.atomCache.get(1);
                this.distance(a1, this.a);
                this.distance(a2, this.b);
                value = VectorMath.dist(this.a, this.b);
                measurement = "\nDistance\t" + a1.xyzindex + ", " + a2.xyzindex + ":   \t" + String.format("%10.5f", value);
                break;
            }
            case MEASUREANGLE: {
                if (this.atomCache.size() < 3) {
                    return;
                }
                Atom a1 = this.atomCache.get(0);
                Atom a2 = this.atomCache.get(1);
                Atom a3 = this.atomCache.get(2);
                this.distance(a1, this.a);
                this.distance(a2, this.b);
                this.distance(a3, this.c);
                value = VectorMath.bondAngle(this.a, this.b, this.c);
                value = Math.toDegrees(value);
                measurement = "\nAngle\t" + a1.xyzindex + ", " + a2.xyzindex + ", " + a3.xyzindex + ":   \t" + String.format("%10.5f", value);
                break;
            }
            case MEASUREDIHEDRAL: {
                if (this.atomCache.size() < 4) {
                    return;
                }
                Atom a1 = this.atomCache.get(0);
                Atom a2 = this.atomCache.get(1);
                Atom a3 = this.atomCache.get(2);
                Atom a4 = this.atomCache.get(3);
                this.distance(a1, this.a);
                this.distance(a2, this.b);
                this.distance(a3, this.c);
                this.distance(a4, this.d);
                value = VectorMath.dihedralAngle(this.a, this.b, this.c, this.d);
                value = Math.toDegrees(value);
                measurement = "\nDihedral\t" + a1.xyzindex + ", " + a2.xyzindex + ", " + a3.xyzindex + ", " + a4.xyzindex + ":\t" + String.format("%10.5f", value);
                break;
            }
            default: {
                return;
            }
        }
        logger.info(measurement);
        ModelingShell modelingShell = this.mainPanel.getModelingShell();
        modelingShell.setMeasurement(measurement, value);
        this.count = 0;
    }

    public void resetCount() {
        this.count = 0;
    }

    public void setPicking(boolean m) {
        this.picking = m;
        if (!this.picking) {
            this.clear();
        }
    }

    public void setPickLevel(String newPick) {
        if (pickLevelHash.containsKey(newPick.toUpperCase())) {
            this.newPickLevel = pickLevelHash.get(newPick.toUpperCase());
        }
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        if (!this.picking) {
            return;
        }
        this.pickCanvas.setShapeLocation(xpos, ypos);
        PickResult result = this.pickCanvas.pickClosest();
        if (result != null) {
            SceneGraphPath sceneGraphPath = result.getSceneGraphPath();
            Node node = sceneGraphPath.getObject();
            if (!(node instanceof Shape3D)) {
                return;
            }
            Shape3D pickedShape3D = (Shape3D)node;
            Object userData = pickedShape3D.getUserData();
            if (userData instanceof MolecularAssembly) {
                FFESystem sys = (FFESystem)userData;
                if (result.numIntersections() > 0) {
                    PickIntersection pickIntersection = result.getIntersection(0);
                    int[] coords = pickIntersection.getPrimitiveCoordinateIndices();
                    userData = sys.getAtomFromWireVertex(coords[0]);
                } else {
                    return;
                }
            }
            if (userData instanceof Atom) {
                String pickLevelString;
                boolean measure;
                Atom a = (Atom)userData;
                if (this.pickLevel != this.newPickLevel) {
                    this.pickLevel = this.newPickLevel;
                    this.pickNumber = 0;
                }
                if (!(measure = (pickLevelString = this.pickLevel.toString()).startsWith("MEASURE")) || this.count == 0) {
                    for (Atom matom : this.atomCache) {
                        matom.setSelected(false);
                        matom.setColor(RendererCache.ColorModel.SELECT, null, null);
                    }
                    this.atomCache.clear();
                    this.count = 0;
                }
                if (measure && !this.atomCache.contains(a)) {
                    this.atomCache.add(0, a);
                    a.setSelected(true);
                    a.setColor(RendererCache.ColorModel.PICK, null, null);
                    ++this.count;
                    this.measure();
                }
                if (!measure) {
                    if (a == this.previousAtom) {
                        ++this.pickNumber;
                    } else {
                        this.previousAtom = a;
                        this.pickNumber = 0;
                    }
                    MSNode currentPick = null;
                    switch (this.pickLevel) {
                        case PICKATOM: {
                            currentPick = a;
                            break;
                        }
                        case PICKBOND: 
                        case PICKANGLE: 
                        case PICKDIHEDRAL: {
                            ArrayList<ValenceTerm> terms = null;
                            if (this.pickLevel == PickLevel.PICKBOND) {
                                terms = a.getBonds();
                            } else if (this.pickLevel == PickLevel.PICKANGLE) {
                                terms = a.getAngles();
                            } else if (this.pickLevel == PickLevel.PICKDIHEDRAL) {
                                terms = a.getDihedrals();
                            }
                            if (terms == null) {
                                return;
                            }
                            int num = terms.size();
                            if (this.pickNumber >= num) {
                                this.pickNumber = 0;
                            }
                            currentPick = terms.get(this.pickNumber);
                            break;
                        }
                        case PICKRESIDUE: 
                        case PICKPOLYMER: 
                        case PICKMOLECULE: 
                        case PICKSYSTEM: {
                            MSNode dataNode = null;
                            if (this.pickLevel == PickLevel.PICKRESIDUE) {
                                dataNode = (MSNode)a.getMSNode(Residue.class);
                            } else if (this.pickLevel == PickLevel.PICKPOLYMER) {
                                dataNode = (MSNode)a.getMSNode(Polymer.class);
                            } else if (this.pickLevel == PickLevel.PICKSYSTEM) {
                                dataNode = (MSNode)a.getMSNode(MolecularAssembly.class);
                            } else if (this.pickLevel == PickLevel.PICKMOLECULE && (dataNode = (MSNode)a.getMSNode(Molecule.class)) == null) {
                                dataNode = (MSNode)a.getMSNode(Polymer.class);
                            }
                            currentPick = dataNode;
                            break;
                        }
                    }
                    if (currentPick != null) {
                        if (this.controlButton) {
                            this.mainPanel.getHierarchy().toggleSelection(currentPick);
                        } else if (currentPick != this.previousPick) {
                            this.mainPanel.getHierarchy().onlySelection(currentPick);
                        }
                        this.mainPanel.getGraphics3D().updateScene(currentPick, false, false, null, true, RendererCache.ColorModel.PICK);
                    }
                    if (this.previousPick != null && this.previousPick != currentPick) {
                        this.previousPick.setColor(RendererCache.ColorModel.REVERT, null, null);
                    }
                    this.previousPick = currentPick;
                }
            }
        }
    }

    static {
        PickLevel[] values;
        pickLevelHash = new Hashtable();
        for (PickLevel value : values = PickLevel.values()) {
            pickLevelHash.put(value.toString(), value);
        }
        logger = Logger.getLogger("ffe");
    }

    public static enum PickLevel {
        PICKATOM,
        PICKBOND,
        PICKANGLE,
        PICKDIHEDRAL,
        PICKRESIDUE,
        PICKMOLECULE,
        PICKPOLYMER,
        PICKSYSTEM,
        MEASUREDISTANCE,
        MEASUREANGLE,
        MEASUREDIHEDRAL;

    }
}

