/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.behaviors.GlobalBehavior;
import ffe.behaviors.MouseRotate;
import ffe.behaviors.MouseTranslate;
import ffe.behaviors.MouseZoom;
import ffe.core.GraphicsAxis;
import ffe.core.GraphicsCanvas;
import ffe.core.MainPanel;
import ffe.lang.Atom;
import ffe.lang.MolecularAssembly;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.java3d.WakeupOnBehaviorPost;
import org.jogamp.java3d.WakeupOr;
import org.jogamp.java3d.utils.behaviors.vp.ViewPlatformBehavior;
import org.jogamp.java3d.utils.picking.PickCanvas;
import org.jogamp.java3d.utils.picking.PickIntersection;
import org.jogamp.java3d.utils.picking.PickResult;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Point3d;

public class GraphicsEvents
extends Behavior {
    public static int ROTATEPOST = 1;
    public static int TRANSLATEPOST = 2;
    public static int ZOOMPOST = 3;
    public static int BEHAVIORDONEPOST = 4;
    private MainPanel mainPanel;
    private GraphicsCanvas graphics3D;
    private GraphicsAxis globalAxis;
    private SimpleUniverse simpleUniverse;
    private TransformGroup viewTransformGroup;
    private Bounds bounds;
    private BranchGroup baseBranchGroup;
    private TransformGroup baseTransform;
    private WakeupOr mouseCriterion;
    private WakeupOr postCriterion;
    private boolean buttonPress;
    private int x;
    private int y;
    private boolean leftButton;
    private boolean rightButton;
    private boolean middleButton;
    private PickCanvas pickCanvas;
    private PickResult pickResult;
    private Atom atom;
    private boolean axisSelected;
    private MouseRotate systemRotate;
    private MouseTranslate systemTranslate;
    private MouseZoom globalZoom;
    private GlobalBehavior viewOrbitBehavior;

    public GraphicsEvents(MainPanel f, GraphicsCanvas g, GraphicsAxis n, SimpleUniverse u, Bounds b, BranchGroup root, TransformGroup tg) {
        this.mainPanel = f;
        this.graphics3D = g;
        this.globalAxis = n;
        this.simpleUniverse = u;
        this.bounds = b;
        this.baseBranchGroup = root;
        this.baseTransform = tg;
        this.viewTransformGroup = u.getViewingPlatform().getViewPlatformTransform();
        this.setSchedulingBounds(b);
        this.systemRotate = new MouseRotate(1, this.viewTransformGroup, this, ROTATEPOST, BEHAVIORDONEPOST);
        this.systemRotate.setFactor(0.025);
        this.systemRotate.setSchedulingBounds(this.bounds);
        this.baseBranchGroup.addChild((Node)this.systemRotate);
        this.systemTranslate = new MouseTranslate(1, this.viewTransformGroup, this, TRANSLATEPOST, BEHAVIORDONEPOST);
        this.systemTranslate.setFactor(0.5);
        this.systemTranslate.setSchedulingBounds(this.bounds);
        this.baseBranchGroup.addChild((Node)this.systemTranslate);
        this.globalZoom = new MouseZoom(1, this.viewTransformGroup, this, ZOOMPOST, BEHAVIORDONEPOST);
        this.globalZoom.setFactor(5.0E-4);
        this.globalZoom.setSchedulingBounds(this.bounds);
        this.globalZoom.setTransformGroup(this.baseTransform);
        this.baseBranchGroup.addChild((Node)this.globalZoom);
        this.viewOrbitBehavior = new GlobalBehavior(this.graphics3D);
        this.viewOrbitBehavior.setUpCallback(this.globalAxis);
        this.viewOrbitBehavior.setSchedulingBounds(this.bounds);
        u.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)this.viewOrbitBehavior);
        this.pickCanvas = new PickCanvas((Canvas3D)this.graphics3D, this.simpleUniverse.getLocale());
        this.pickCanvas.setMode(256);
        this.pickCanvas.setTolerance(20.0f);
    }

    public void centerView(boolean resetRotation, boolean resetTranslation, boolean resetZoom) {
        this.viewOrbitBehavior.centerView(resetRotation, resetTranslation);
    }

    private boolean globalZoom() {
        this.postId(ZOOMPOST);
        return true;
    }

    public void initialize() {
        WakeupCriterion[] behaviorPost = new WakeupCriterion[]{new WakeupOnBehaviorPost((Behavior)this.systemRotate, BEHAVIORDONEPOST), new WakeupOnBehaviorPost((Behavior)this.systemTranslate, BEHAVIORDONEPOST), new WakeupOnBehaviorPost((Behavior)this.globalZoom, BEHAVIORDONEPOST)};
        this.postCriterion = new WakeupOr(behaviorPost);
        WakeupCriterion[] awtCriterion = new WakeupCriterion[]{new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(502)};
        this.mouseCriterion = new WakeupOr(awtCriterion);
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void processMouseEvent(MouseEvent evt) {
        this.buttonPress = false;
        this.leftButton = false;
        this.middleButton = false;
        this.rightButton = false;
        int mod = evt.getModifiersEx();
        if (evt.getID() == 501) {
            this.buttonPress = true;
        }
        if ((mod & 0x400) == 1024) {
            this.leftButton = true;
        }
        if ((mod & 0x800) == 2048) {
            this.middleButton = true;
        }
        if ((mod & 0x200) == 512 && this.leftButton) {
            this.middleButton = true;
            this.leftButton = false;
        }
        if ((mod & 0x1000) == 4096) {
            this.rightButton = true;
        }
        if ((mod & 0x40) == 64 && this.leftButton) {
            this.rightButton = true;
            this.leftButton = false;
        }
        this.x = evt.getX();
        this.y = evt.getY();
        this.atom = null;
        this.axisSelected = false;
        if (this.buttonPress) {
            SceneGraphPath sgp;
            Node node;
            this.pickCanvas.setShapeLocation(this.x, this.y);
            try {
                this.pickResult = this.pickCanvas.pickClosest();
            }
            catch (Exception e) {
                this.pickResult = null;
            }
            if (this.pickResult != null && (node = (sgp = this.pickResult.getSceneGraphPath()).getObject()) instanceof Shape3D) {
                Shape3D s = (Shape3D)node;
                Object o = s.getUserData();
                if (o instanceof MolecularAssembly) {
                    MolecularAssembly sys = (MolecularAssembly)o;
                    if (this.pickResult.numIntersections() > 0) {
                        PickIntersection pi = this.pickResult.getIntersection(0);
                        int[] coords = pi.getPrimitiveCoordinateIndices();
                        this.atom = sys.getAtomFromWireVertex(coords[0]);
                    }
                } else if (o instanceof Atom) {
                    this.atom = (Atom)o;
                } else if (o instanceof GraphicsAxis) {
                    this.axisSelected = true;
                }
            }
        }
    }

    public void processStimulus(Iterator criteria) {
        this.viewOrbitBehavior.setEnable(false);
        AWTEvent[] awtEvents = null;
        while (criteria.hasNext()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.next();
            if (!(wakeup instanceof WakeupOnAWTEvent) || (awtEvents = ((WakeupOnAWTEvent)wakeup).getAWTEvent()) == null) continue;
            for (int i = 0; i < awtEvents.length; ++i) {
                MouseEvent mouseEvent = null;
                if (!(awtEvents[i] instanceof MouseEvent)) continue;
                mouseEvent = (MouseEvent)awtEvents[i];
                this.processMouseEvent(mouseEvent);
                if (!this.axisSelected) {
                    if (this.rightButton && this.buttonPress) {
                        this.systemTranslate.setMouseButton(4096);
                        if (this.systemTranslate()) {
                            this.wakeupOn((WakeupCondition)this.postCriterion);
                            return;
                        }
                    }
                    if (this.leftButton && this.buttonPress) {
                        GraphicsCanvas.LeftButtonMode leftButtonMode = this.graphics3D.getLeftButtonMode();
                        switch (leftButtonMode) {
                            case ROTATE: {
                                if (!this.systemRotate()) break;
                                this.wakeupOn((WakeupCondition)this.postCriterion);
                                return;
                            }
                            case TRANSLATE: {
                                this.systemTranslate.setMouseButton(1024);
                                if (!this.systemTranslate()) break;
                                this.wakeupOn((WakeupCondition)this.postCriterion);
                                return;
                            }
                            case ZOOM: {
                                this.globalZoom.setMouseButton(1024);
                                if (!this.globalZoom()) break;
                                this.wakeupOn((WakeupCondition)this.postCriterion);
                                return;
                            }
                        }
                    }
                    if (!this.middleButton || !this.buttonPress) continue;
                    this.globalZoom.setMouseButton(2048);
                    if (!this.globalZoom()) continue;
                    this.wakeupOn((WakeupCondition)this.postCriterion);
                    return;
                }
                this.viewOrbitBehavior.setEnable(true);
                this.wakeupOn((WakeupCondition)this.mouseCriterion);
                return;
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void setGlobalCenter(double[] d) {
        Point3d point = new Point3d(d);
        this.viewOrbitBehavior.setRotationCenter(point);
    }

    private boolean systemRotate() {
        TransformGroup tg = null;
        GraphicsCanvas.MouseMode mouseMode = this.graphics3D.getMouseMode();
        if (mouseMode == GraphicsCanvas.MouseMode.SYSTEMBELOWMOUSE && this.atom != null) {
            tg = (TransformGroup)this.pickResult.getNode(32);
        } else if (mouseMode == GraphicsCanvas.MouseMode.ACTIVESYSTEM && this.mainPanel.getHierarchy().getActive() != null) {
            tg = this.mainPanel.getHierarchy().getActive().getTransformGroup();
        }
        if (tg != null && tg.getCapability(17) && tg.getCapability(18)) {
            this.systemRotate.setTransformGroup(tg);
            this.postId(ROTATEPOST);
            return true;
        }
        return false;
    }

    private boolean systemTranslate() {
        TransformGroup tg = null;
        GraphicsCanvas.MouseMode mouseMode = this.graphics3D.getMouseMode();
        if (mouseMode == GraphicsCanvas.MouseMode.SYSTEMBELOWMOUSE && this.atom != null) {
            tg = (TransformGroup)this.pickResult.getNode(32);
        } else if (mouseMode == GraphicsCanvas.MouseMode.ACTIVESYSTEM && this.mainPanel.getHierarchy().getActive() != null) {
            tg = this.mainPanel.getHierarchy().getActive().getTransformGroup();
        }
        if (tg != null && tg.getCapability(17) && tg.getCapability(18)) {
            this.systemTranslate.setTransformGroup(tg);
            this.postId(TRANSLATEPOST);
            return true;
        }
        return false;
    }
}

