/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFESystem;
import ffe.core.GraphicsAxis;
import ffe.core.GraphicsEvents;
import ffe.core.GraphicsFullScreen;
import ffe.core.GraphicsPicking;
import ffe.core.GraphicsPrefs;
import ffe.core.Hierarchy;
import ffe.core.MainMenu;
import ffe.core.MainPanel;
import ffe.lang.MSNode;
import ffe.lang.MolecularAssembly;
import ffe.lang.Renderer;
import ffe.lang.RendererCache;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jogamp.java3d.AmbientLight;
import org.jogamp.java3d.Background;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.DirectionalLight;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.GraphicsContext3D;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Raster;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.View;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public class GraphicsCanvas
extends Canvas3D
implements ActionListener {
    public static final Hashtable<String, ImageFormat> imageFormatHash;
    private Renderer renderer;
    private GraphicsEvents graphicsEvents;
    private GraphicsPicking rendererPicking;
    private MainPanel mainPanel;
    private GraphicsAxis graphicsAxis;
    private GraphicsFullScreen fullScreenWindow;
    private static Logger logger;
    private SimpleUniverse universe;
    private Background background;
    private BranchGroup baseBranchGroup;
    private TransformGroup baseTransformGroup;
    private Transform3D baseTransform3D = new Transform3D();
    private Bounds bounds;
    private GraphicsPrefs graphics3DPrefs = null;
    private MouseMode mouseMode = MouseMode.ACTIVESYSTEM;
    private ImageFormat imageFormat = ImageFormat.PNG;
    private LeftButtonMode leftButtonMode = LeftButtonMode.ROTATE;
    private boolean imageCapture = false;
    private File imageName;

    public GraphicsCanvas(GraphicsConfiguration config, MainPanel f) {
        super(config);
        this.mainPanel = f;
        this.initialize();
    }

    public GraphicsCanvas(MainPanel f) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)new GraphicsConfigTemplate3D()), f);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        if (arg.equals("LabelSelectedAtoms")) {
            this.labelSelectedAtoms();
        } else if (arg.equals("LabelSelectedResidues")) {
            this.labelSelectedResidues();
        } else if (arg.equals("SetLabelFontColor")) {
            this.setLabelFontColor();
        } else if (arg.equals("SetLabelFontSize")) {
            this.setLabelFontSize();
        } else if (RendererCache.viewModelHash.containsKey(arg.toUpperCase())) {
            this.setViewModel(arg);
        } else if (arg.equals("Preferences")) {
            this.preferences();
        } else if (RendererCache.colorModelHash.containsKey(arg.toUpperCase())) {
            this.setColorModel(arg);
        } else if (arg.equals("SetSelectionColor")) {
            this.setSelectionColor();
        } else if (arg.equals("SetUserColor")) {
            this.setUserColor();
        } else if (arg.equals("SystemBelowMouse")) {
            this.mouseMode = MouseMode.SYSTEMBELOWMOUSE;
        } else if (arg.equals("ActiveSystem")) {
            this.mouseMode = MouseMode.ACTIVESYSTEM;
        } else if (arg.equals("Rotate")) {
            this.leftButtonMode = LeftButtonMode.ROTATE;
        } else if (arg.equals("Translate")) {
            this.leftButtonMode = LeftButtonMode.TRANSLATE;
        } else if (arg.equals("Zoom")) {
            this.leftButtonMode = LeftButtonMode.ZOOM;
        } else if (arg.equals("ResetRotation")) {
            this.resetRotation();
        } else if (arg.equals("ResetTranslation")) {
            this.resetTranslation();
        } else if (arg.equals("ResetRotationAndTranslation")) {
            this.resetRotationAndTranslation();
        } else if (arg.equalsIgnoreCase("RotateAboutPick")) {
            this.rotateAboutPick();
        } else if (arg.equalsIgnoreCase("RotateAboutCenter")) {
            this.rotateAboutCenter();
        } else if (arg.equalsIgnoreCase("ResetGlobalTranslation")) {
            this.resetGlobalTranslation();
        } else if (arg.equalsIgnoreCase("ResetGlobalRotation")) {
            this.resetGlobalRotation();
        } else if (arg.equalsIgnoreCase("ResetGlobalZoom")) {
            this.resetGlobalZoom();
        } else if (arg.equalsIgnoreCase("ResetGlobalView")) {
            this.resetGlobalView();
        } else if (arg.equals("FullScreen")) {
            this.fullScreen();
        } else if (arg.equals("SetBackgroundColor")) {
            this.setBackgroundColor();
        } else if (arg.equalsIgnoreCase("ZoomIn")) {
            this.zoomIn();
        } else if (arg.equalsIgnoreCase("ZoomOut")) {
            this.zoomOut();
        } else if (arg.equalsIgnoreCase("GraphicsPicking")) {
            this.graphicsPicking(evt);
        } else if (imageFormatHash.containsKey(arg.toUpperCase())) {
            this.setImageFormat(arg);
        } else if (arg.equals("CaptureGraphics")) {
            this.captureGraphics();
        } else if (GraphicsPicking.pickLevelHash.containsKey(arg.toUpperCase())) {
            this.setPickingLevel(arg);
        } else if (arg.equals("SetGraphicsPickingColor")) {
            this.setGraphicsPickingColor();
        } else {
            logger.warning("Graphics Menu command not found: " + arg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachModel(MolecularAssembly s) {
        if (s == null) {
            return;
        }
        GraphicsCanvas graphicsCanvas = this;
        synchronized (graphicsCanvas) {
            BranchGroup bg = s.getBranchGroup();
            this.resetGlobalView();
            this.baseBranchGroup.addChild((Node)bg);
        }
    }

    private void captureGraphics() {
        FFESystem active = this.mainPanel.getHierarchy().getActive();
        if (active == null) {
            return;
        }
        this.imageName = null;
        String name = active.getName();
        JFileChooser fileChooser = MainPanel.getFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        this.imageName = this.mainPanel.getHierarchy().getActive() != null ? this.mainPanel.getHierarchy().getActive().getFile() : null;
        if (this.imageName != null) {
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.indexOf("."));
            }
            this.imageName = new File(String.valueOf(this.imageName.getParentFile()) + File.separator + name + "." + String.valueOf((Object)this.imageFormat));
            fileChooser.setSelectedFile(this.imageName);
        }
        fileChooser.setDialogTitle("Select Name for Screen Capture (" + String.valueOf((Object)this.imageFormat) + ")");
        fileChooser.setCurrentDirectory(MainPanel.getCWD());
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result == 0) {
            this.imageName = fileChooser.getSelectedFile();
            this.mainPanel.setCWD(fileChooser.getCurrentDirectory());
            this.imageCapture = true;
            this.repaint();
        }
    }

    public void fullScreen() {
        if (this.fullScreenWindow == null) {
            this.fullScreenWindow = new GraphicsFullScreen(this.mainPanel.getFrame(), this);
        }
        this.fullScreenWindow.enterFullScreen();
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public LeftButtonMode getLeftButtonMode() {
        return this.leftButtonMode;
    }

    public GraphicsAxis getNavigation() {
        return this.graphicsAxis;
    }

    public JLabel getStatusBar() {
        return this.mainPanel.getStatusBar();
    }

    public void graphicsPicking(ActionEvent evt) {
        if (evt.getSource() instanceof JButton) {
            MainMenu m = this.mainPanel.getMainMenu();
            boolean picking = m.getPicking();
            if (picking) {
                this.rendererPicking.clear();
                this.rendererPicking.setPicking(false);
                m.setPickBehavior(false);
            } else {
                this.rendererPicking.setPicking(true);
                m.setPickBehavior(true);
            }
        } else if (evt.getSource() instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)evt.getSource();
            if (jcbmi.isSelected()) {
                this.rendererPicking.setPicking(true);
            } else {
                this.rendererPicking.setPicking(false);
            }
        }
    }

    private void initialize() {
        this.setBackground(Color.black);
        this.universe = new SimpleUniverse((Canvas3D)this);
        SimpleUniverse.setJ3DThreadPriority((int)10);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        BranchGroup objRoot = new BranchGroup();
        this.baseTransformGroup = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.1);
        this.baseTransformGroup.setTransform(t3d);
        this.baseTransformGroup.setCapability(18);
        this.baseTransformGroup.setCapability(17);
        Color3f bgColor = new Color3f(RendererCache.BLACK);
        this.background = new Background(bgColor);
        this.background.setCapability(16);
        this.background.setCapability(17);
        this.bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000.0);
        this.background.setApplicationBounds(this.bounds);
        AmbientLight aLgt = new AmbientLight(new Color3f(Color.darkGray.getRGBColorComponents(null)));
        aLgt.setInfluencingBounds(this.bounds);
        Vector3f dir = new Vector3f(0.0f, -1.0f, -1.0f);
        Color3f dLgtColor = new Color3f(Color.lightGray.getRGBColorComponents(null));
        DirectionalLight dLgt = new DirectionalLight(dLgtColor, dir);
        dLgt.setInfluencingBounds(this.bounds);
        dir = new Vector3f(0.0f, 1.0f, -1.0f);
        dLgtColor = new Color3f(0.1f, 0.1f, 0.1f);
        DirectionalLight dLgt2 = new DirectionalLight(dLgtColor, dir);
        dLgt2.setInfluencingBounds(this.bounds);
        this.baseBranchGroup = new BranchGroup();
        this.baseBranchGroup.setCapability(14);
        this.baseBranchGroup.setCapability(12);
        this.baseBranchGroup.setCapability(13);
        this.baseBranchGroup.setCapability(3);
        this.baseTransformGroup.addChild((Node)this.background);
        this.baseTransformGroup.addChild((Node)this.baseBranchGroup);
        objRoot.addChild((Node)this.baseTransformGroup);
        View v = this.universe.getViewer().getView();
        v.setProjectionPolicy(0);
        v.setFrontClipPolicy(2);
        v.setFrontClipDistance(1.0);
        v.setBackClipPolicy(2);
        v.setBackClipDistance(10.0);
        v.setTransparencySortingPolicy(0);
        Transform3D trans = new Transform3D();
        trans.set(new Vector3d(0.0, 0.0, 2.0));
        TransformGroup vptg = this.universe.getViewingPlatform().getViewPlatformTransform();
        vptg.setTransform(trans);
        BranchGroup viewBranch = new BranchGroup();
        viewBranch.addChild((Node)aLgt);
        viewBranch.addChild((Node)dLgt);
        viewBranch.addChild((Node)dLgt2);
        vptg.addChild((Node)viewBranch);
        this.graphicsAxis = new GraphicsAxis(this.universe.getViewingPlatform(), this, this.bounds);
        this.graphicsEvents = new GraphicsEvents(this.mainPanel, this, this.graphicsAxis, this.universe, this.bounds, this.baseBranchGroup, this.baseTransformGroup);
        this.baseBranchGroup.addChild((Node)this.graphicsEvents);
        this.rendererPicking = new GraphicsPicking(this.baseBranchGroup, this.bounds, this, this.mainPanel);
        this.baseBranchGroup.addChild((Node)this.rendererPicking);
        this.renderer = new Renderer(this.bounds, this.mainPanel.getStatusBar());
        this.baseBranchGroup.addChild((Node)this.renderer);
        objRoot.compile();
        this.universe.addBranchGraph(objRoot);
    }

    public boolean isCacheFull() {
        return this.renderer.isCacheFull();
    }

    public boolean isSceneRendering() {
        return this.renderer.isArmed();
    }

    public void labelSelectedAtoms() {
        if (RendererCache.labelAtoms) {
            RendererCache.labelAtoms = false;
            this.getStatusBar().setText("  Atom Labeling Turned Off");
        } else {
            RendererCache.labelAtoms = true;
            this.getStatusBar().setText("  Atom Labeling Turned On");
        }
        this.repaint();
    }

    public void labelSelectedResidues() {
        if (RendererCache.labelResidues) {
            RendererCache.labelResidues = false;
            this.getStatusBar().setText("  Residue Labeling Turned Off");
        } else {
            RendererCache.labelResidues = true;
            this.getStatusBar().setText("  Residue Labeling Turned On");
        }
        this.repaint();
    }

    public void loadPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(MainPanel.class);
        RendererCache.bondwidth = prefs.getInt("Graphics_bondwidth", 3);
        RendererCache.detail = prefs.getInt("Graphics_detail", 10);
        RendererCache.radius = prefs.getDouble("Graphics_radius", 1.0);
        String s = prefs.get("Graphics_mouse", MouseMode.ACTIVESYSTEM.name());
        this.mouseMode = s.equalsIgnoreCase("ACTIVESYSTEM") || s.equalsIgnoreCase("SYSTEMBELOWMOUSE") ? MouseMode.valueOf(s) : MouseMode.ACTIVESYSTEM;
        this.mainPanel.getMainMenu().setMouseMode(this.mouseMode);
        RendererCache.highlightSelections = prefs.getBoolean("Graphics_highlight", false);
        this.mainPanel.getMainMenu().setHighlighting(RendererCache.highlightSelections);
        String[] hlColor = prefs.get("Graphics_highlightColor", "153 153 255").trim().split(" +");
        Color newColor = new Color(Integer.parseInt(hlColor[0]), Integer.parseInt(hlColor[1]), Integer.parseInt(hlColor[2]));
        RendererCache.selectionColor = new Color3f(newColor.getRGBColorComponents(null));
        RendererCache.labelAtoms = prefs.getBoolean("Graphics_labelAtoms", false);
        this.mainPanel.getMainMenu().setAtomLabels(RendererCache.labelAtoms);
        RendererCache.labelResidues = prefs.getBoolean("Graphics_labelResidues", false);
        this.mainPanel.getMainMenu().setResidueLabels(RendererCache.labelResidues);
        String[] pickColor = prefs.get("Graphics_pickColor", "102 255 102").trim().split(" +");
        newColor = new Color(Integer.parseInt(pickColor[0]), Integer.parseInt(pickColor[1]), Integer.parseInt(pickColor[2]));
        RendererCache.pickingColor = new Color3f(newColor.getRGBColorComponents(null));
        String pickLevel = prefs.get("Graphics_pickLevel", "PickAtom");
        this.mainPanel.getMainMenu().setPickLevel(pickLevel);
        boolean pickMode = prefs.getBoolean("Graphics_picking", false);
        if (pickMode) {
            this.rendererPicking.setPicking(true);
        }
        this.mainPanel.getMainMenu().setPickBehavior(pickMode);
        String[] userColor = prefs.get("Graphics_userColor", "255 255 255").trim().split(" +");
        newColor = new Color(Integer.parseInt(userColor[0]), Integer.parseInt(userColor[1]), Integer.parseInt(userColor[2]));
        RendererCache.userColor = new Color3f(newColor.getRGBColorComponents(null));
    }

    public void paint(Graphics g) {
        super.paint(g);
        Toolkit.getDefaultToolkit().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRender() {
        if (RendererCache.labelAtoms || RendererCache.labelResidues) {
            J3DGraphics2D g2D = this.getGraphics2D();
            Hierarchy hierarchy = this.mainPanel.getHierarchy();
            synchronized (hierarchy) {
                ArrayList<MSNode> nodes = this.mainPanel.getHierarchy().getActiveNodes();
                if (nodes != null && nodes.size() > 0) {
                    for (MSNode node : nodes) {
                        MolecularAssembly sys = (MolecularAssembly)node.getMSNode(MolecularAssembly.class);
                        if (sys == null) continue;
                        node.drawLabel(this, g2D, sys.getWireFrame());
                    }
                } else {
                    return;
                }
            }
            g2D.flush(true);
        }
    }

    public void postSwap() {
        if (!this.imageCapture || this.mainPanel.getHierarchy().getActive() == null) {
            return;
        }
        GraphicsContext3D ctx = this.getGraphicsContext3D();
        Rectangle rect = this.getBounds();
        BufferedImage img = new BufferedImage(rect.width, rect.height, 1);
        ImageComponent2D comp = new ImageComponent2D(1, img);
        Raster ras = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, rect.width, rect.height, comp, null);
        ctx.readRaster(ras);
        img = ras.getImage().getImage();
        try {
            if (!ImageIO.write((RenderedImage)img, this.imageFormat.toString(), this.imageName)) {
                String os = System.getProperty("os.name");
                logger.severe("No image writer was found for " + this.imageFormat.toString() + " on " + os + ".\nThis Java Runtime Environment (JRE) fails to meet the javax.imageio specification.\nShame on you " + os + "!\nPlease try a different image format.\n");
                this.imageName.delete();
            } else {
                logger.info(String.valueOf(this.imageName) + " was captured.");
            }
        }
        catch (IOException e) {
            logger.warning("Image capture failed.\n" + String.valueOf(e));
        }
        this.imageCapture = false;
    }

    public void preferences() {
        if (this.graphics3DPrefs == null) {
            this.graphics3DPrefs = new GraphicsPrefs(this.mainPanel.getFrame(), this.mainPanel.getDataRoot());
            this.graphics3DPrefs.setModal(false);
        }
        this.graphics3DPrefs.setVisible(true);
        this.graphics3DPrefs.toFront();
    }

    public void resetGlobalRotation() {
        this.graphicsEvents.centerView(true, false, false);
    }

    public void resetGlobalTranslation() {
        this.graphicsEvents.centerView(false, true, false);
    }

    public void resetGlobalView() {
        double radius = this.mainPanel.getDataRoot().getExtent();
        Transform3D t3d = new Transform3D();
        t3d.setScale(1.0 / (1.2 * radius));
        this.baseTransformGroup.setTransform(t3d);
        this.graphicsEvents.centerView(true, true, true);
    }

    public void resetGlobalZoom() {
        double radius = this.mainPanel.getDataRoot().getExtent();
        this.baseTransformGroup.getTransform(this.baseTransform3D);
        this.baseTransform3D.setScale(1.0 / (1.2 * radius));
        this.baseTransformGroup.setTransform(this.baseTransform3D);
    }

    public void resetRotation() {
        FFESystem sys = this.mainPanel.getHierarchy().getActive();
        if (sys != null) {
            sys.centerView(true, false);
        }
    }

    public void resetRotationAndTranslation() {
        FFESystem sys = this.mainPanel.getHierarchy().getActive();
        if (sys != null) {
            sys.centerView(true, true);
        }
    }

    public void resetTranslation() {
        FFESystem sys = this.mainPanel.getHierarchy().getActive();
        if (sys != null) {
            sys.centerView(false, true);
        }
    }

    public void rotateAboutCenter() {
        FFESystem sys = this.mainPanel.getHierarchy().getActive();
        double[] center = sys.getMultiScaleCenter(false);
        sys.rotateAbout(new Vector3d(center));
    }

    public void rotateAboutPick() {
        MSNode node = this.rendererPicking.getPick();
        if (node != null) {
            double[] center = node.getCenter(false);
            MolecularAssembly m = (MolecularAssembly)node.getMSNode(MolecularAssembly.class);
            m.rotateAbout(new Vector3d(center));
        }
    }

    public void savePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(MainPanel.class);
        prefs.putInt("Graphics_bondwidth", RendererCache.bondwidth);
        prefs.putInt("Graphics_detail", RendererCache.detail);
        prefs.putDouble("Graphics_radius", RendererCache.radius);
        prefs.put("Graphics_mouse", this.mouseMode.name());
        prefs.putBoolean("Graphics_highlight", RendererCache.highlightSelections);
        float[] rgbColor = new float[3];
        RendererCache.selectionColor.get(rgbColor);
        Color col = new Color(rgbColor[0], rgbColor[1], rgbColor[2]);
        prefs.put("Graphics_highlightColor", col.getRed() + " " + col.getGreen() + " " + col.getBlue());
        prefs.putBoolean("Graphics_labelAtoms", RendererCache.labelAtoms);
        prefs.putBoolean("Graphics_labelResidues", RendererCache.labelResidues);
        prefs.putInt("Graphics_labelSize", this.getGraphics2D().getFont().getSize());
        Color fontColor = this.getGraphics2D().getColor();
        prefs.put("Graphics_labelColor", fontColor.getRed() + " " + fontColor.getGreen() + " " + fontColor.getBlue());
        RendererCache.pickingColor.get(rgbColor);
        col = new Color(rgbColor[0], rgbColor[1], rgbColor[2]);
        prefs.put("Graphics_pickColor", col.getRed() + " " + col.getGreen() + " " + col.getBlue());
        prefs.putBoolean("Graphics_picking", this.rendererPicking.getPicking());
        prefs.put("Graphics_pickLevel", this.rendererPicking.getPickLevel());
        RendererCache.userColor.get(rgbColor);
        col = new Color(rgbColor[0], rgbColor[1], rgbColor[2]);
        prefs.put("Graphics_userColor", col.getRed() + " " + col.getGreen() + " " + col.getBlue());
        Color3f temp = new Color3f();
        this.background.getColor(temp);
        temp.get(rgbColor);
        col = new Color(rgbColor[0], rgbColor[1], rgbColor[2]);
        prefs.put("Graphics_backgroundColor", col.getRed() + " " + col.getGreen() + " " + col.getBlue());
    }

    public void selected() {
        this.validate();
        this.repaint();
    }

    public void setAxisShowing(boolean b) {
        if (b && this.graphicsAxis == null) {
            this.graphicsAxis = new GraphicsAxis(this.universe.getViewingPlatform(), this, this.bounds);
        } else if (this.graphicsAxis != null) {
            this.graphicsAxis.showAxis(b);
        }
    }

    public void setBackgroundColor() {
        Color3f col = new Color3f();
        this.background.getColor(col);
        float[] rgbColor = new float[3];
        col.get(rgbColor);
        Color newcolor = JColorChooser.showDialog((Component)((Object)this), "Choose Background Color", new Color(rgbColor[0], rgbColor[1], rgbColor[2]));
        if (newcolor != null && newcolor != new Color(rgbColor[0], rgbColor[1], rgbColor[2])) {
            this.background.setColor(new Color3f(newcolor.getRGBColorComponents(null)));
        }
    }

    public void setCaptures(boolean c) {
        this.imageCapture = c;
    }

    public void setColorModel(String model) {
        if (!RendererCache.colorModelHash.containsKey(model.toUpperCase())) {
            return;
        }
        RendererCache.ColorModel colorModel = RendererCache.colorModelHash.get(model.toUpperCase());
        ArrayList<MSNode> active = this.mainPanel.getHierarchy().getActiveNodes();
        if (active == null) {
            return;
        }
        this.renderer.arm(active, false, false, null, true, colorModel);
    }

    public void setColorModel(String model, MSNode node) {
        if (node == null) {
            return;
        }
        if (!RendererCache.colorModelHash.containsKey(model.toUpperCase())) {
            return;
        }
        RendererCache.ColorModel colorModel = RendererCache.colorModelHash.get(model.toUpperCase());
        this.renderer.arm(node, false, false, null, true, colorModel);
    }

    public void setGraphicsPickingColor() {
        Color3f col = new Color3f();
        RendererCache.pickingColor.get((Tuple3f)col);
        float[] rgbColor = new float[3];
        col.get(rgbColor);
        Color newcolor = JColorChooser.showDialog((Component)((Object)this), "Choose Picking Color", new Color(rgbColor[0], rgbColor[1], rgbColor[2]));
        if (newcolor != null) {
            RendererCache.pickingColor = new Color3f(newcolor.getRGBColorComponents(null));
        }
    }

    public void setImageFormat(String format) {
        if (format == null) {
            return;
        }
        if (!imageFormatHash.containsKey(format = format.toUpperCase())) {
            return;
        }
        this.imageFormat = imageFormatHash.get(format);
    }

    public void setLabelFontColor() {
        Color color = this.getGraphics2D().getColor();
        Color newColor = JColorChooser.showDialog((Component)((Object)this), "Choose Font Color", color);
        if (newColor != null && newColor != color) {
            this.getGraphics2D().setPaint((Paint)newColor);
            if (RendererCache.labelAtoms || RendererCache.labelResidues) {
                this.repaint();
            }
            this.getStatusBar().setText("  Label Font Color Changed to (" + newColor.getRed() + "," + newColor.getGreen() + "," + newColor.getBlue() + ")");
        }
    }

    public void setLabelFontSize() {
        Font currentFont = this.getGraphics2D().getFont();
        int currentSize = currentFont.getSize();
        String size = new String("" + currentSize);
        size = JOptionPane.showInputDialog("Set the Font Size (8 to 64)", (Object)size);
        try {
            int f = Integer.parseInt(size);
            if (f < 8 || f > 64 || f == currentSize) {
                return;
            }
            Font newFont = new Font(currentFont.getName(), currentFont.getStyle(), f);
            this.getGraphics2D().setFont(newFont);
            if (RendererCache.labelAtoms || RendererCache.labelResidues) {
                this.repaint();
            }
            this.getStatusBar().setText("  Label Font Size Changed to " + newFont.getSize());
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public void setLabelsUpdated() {
        this.repaint();
    }

    public void setPickingLevel(String level) {
        if (level == null) {
            return;
        }
        if (GraphicsPicking.pickLevelHash.containsKey(level = level.toUpperCase())) {
            GraphicsPicking.PickLevel pickLevel = GraphicsPicking.pickLevelHash.get(level);
            switch (pickLevel) {
                case PICKATOM: 
                case PICKBOND: 
                case PICKANGLE: 
                case PICKDIHEDRAL: 
                case PICKRESIDUE: 
                case PICKPOLYMER: 
                case PICKSYSTEM: {
                    this.rendererPicking.setPickLevel(level);
                    break;
                }
                case MEASUREDISTANCE: 
                case MEASUREANGLE: 
                case MEASUREDIHEDRAL: {
                    this.rendererPicking.setPickLevel(level);
                    this.rendererPicking.setPicking(true);
                    this.mainPanel.getMainMenu().setPickBehavior(true);
                    this.rendererPicking.clear();
                    this.rendererPicking.resetCount();
                    break;
                }
                default: {
                    logger.warning("Unexpected PickingLevel");
                }
            }
        }
    }

    public void setPosition() {
        this.setPosition(this.mainPanel.getHierarchy().getActive());
    }

    public void setPosition(MSNode node) {
        this.updateScene(node, true, false, null, true, null);
    }

    public void setSelectionColor() {
        Color3f col = new Color3f();
        RendererCache.selectionColor.get((Tuple3f)col);
        float[] rgbColor = new float[3];
        col.get(rgbColor);
        Color newcolor = JColorChooser.showDialog((Component)((Object)this), "Choose Selection Color", new Color(rgbColor[0], rgbColor[1], rgbColor[2]));
        if (newcolor != null) {
            RendererCache.selectionColor = new Color3f(newcolor.getRGBColorComponents(null));
        }
        if (RendererCache.highlightSelections) {
            this.updateScene(this.mainPanel.getDataRoot(), false, false, null, true, RendererCache.ColorModel.SELECT);
        }
    }

    public void setUserColor() {
        Color3f col = new Color3f();
        RendererCache.selectionColor.get((Tuple3f)col);
        float[] rgbColor = new float[3];
        col.get(rgbColor);
        Color newcolor = JColorChooser.showDialog((Component)((Object)this), "Choose User Color", new Color(rgbColor[0], rgbColor[1], rgbColor[2]));
        if (newcolor != null) {
            RendererCache.userColor = new Color3f(newcolor.getRGBColorComponents(null));
        }
    }

    public void setViewModel(String model) {
        if (!RendererCache.viewModelHash.containsKey(model.toUpperCase())) {
            return;
        }
        RendererCache.ViewModel viewModel = RendererCache.viewModelHash.get(model.toUpperCase());
        if (viewModel == RendererCache.ViewModel.RESTRICT) {
            this.renderer.arm(this.mainPanel.getDataRoot(), false, true, viewModel, false, null);
            return;
        }
        ArrayList<MSNode> active = this.mainPanel.getHierarchy().getActiveNodes();
        if (active == null) {
            return;
        }
        this.renderer.arm(active, false, true, viewModel, false, null);
    }

    public void setViewModel(String model, MSNode node) {
        if (node == null) {
            return;
        }
        if (!RendererCache.viewModelHash.containsKey(model.toUpperCase())) {
            return;
        }
        RendererCache.ViewModel viewModel = RendererCache.viewModelHash.get(model.toUpperCase());
        this.renderer.arm(node, false, true, viewModel, false, null);
    }

    public String toString() {
        return "3D Graphics";
    }

    public void updateScene(ArrayList<MSNode> n, boolean t, boolean v, RendererCache.ViewModel newViewModel, boolean c, RendererCache.ColorModel newColorModel) {
        if (n != null) {
            this.renderer.arm(n, t, v, newViewModel, c, newColorModel);
        }
    }

    public void updateScene(MSNode n, boolean t, boolean v, RendererCache.ViewModel newViewModel, boolean c, RendererCache.ColorModel newColorModel) {
        if (n != null) {
            this.renderer.arm(n, t, v, newViewModel, c, newColorModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSceneWait(ArrayList<MSNode> n, boolean t, boolean v, RendererCache.ViewModel newViewModel, boolean c, RendererCache.ColorModel newColorModel) {
        if (n != null) {
            this.renderer.arm(n, t, v, newViewModel, c, newColorModel);
        }
        while (this.isSceneRendering() || this.isCacheFull()) {
            GraphicsCanvas graphicsCanvas = this;
            synchronized (graphicsCanvas) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSceneWait(MSNode n, boolean t, boolean v, RendererCache.ViewModel newViewModel, boolean c, RendererCache.ColorModel newColorModel) {
        if (n != null) {
            this.renderer.arm(n, t, v, newViewModel, c, newColorModel);
        }
        while (this.isSceneRendering() || this.isCacheFull()) {
            GraphicsCanvas graphicsCanvas = this;
            synchronized (graphicsCanvas) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void zoomIn() {
        this.baseTransformGroup.getTransform(this.baseTransform3D);
        double scale = this.baseTransform3D.getScale() + 0.01;
        this.baseTransform3D.setScale(scale);
        this.baseTransformGroup.setTransform(this.baseTransform3D);
    }

    public void zoomOut() {
        this.baseTransformGroup.getTransform(this.baseTransform3D);
        double scale = this.baseTransform3D.getScale() - 0.01;
        if (scale > 0.0) {
            this.baseTransform3D.setScale(scale);
            this.baseTransformGroup.setTransform(this.baseTransform3D);
        }
    }

    static {
        ImageFormat[] values;
        imageFormatHash = new Hashtable();
        for (ImageFormat value : values = ImageFormat.values()) {
            imageFormatHash.put(value.toString(), value);
        }
        logger = Logger.getLogger("ffe");
    }

    public static enum LeftButtonMode {
        ROTATE,
        TRANSLATE,
        ZOOM;

    }

    public static enum MouseMode {
        SYSTEMBELOWMOUSE,
        ACTIVESYSTEM;

    }

    public static enum ImageFormat {
        BMP,
        GIF,
        JPEG,
        PNG,
        WBMP;

    }
}

