/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.behaviors.MouseBehaviorCallback;
import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Font3D;
import org.jogamp.java3d.FontExtrusion;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Text3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.Cone;
import org.jogamp.java3d.utils.geometry.Cylinder;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.java3d.utils.picking.PickTool;
import org.jogamp.java3d.utils.universe.ViewingPlatform;
import org.jogamp.vecmath.AxisAngle4f;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Vector3d;

public final class GraphicsAxis
extends Group
implements MouseBehaviorCallback {
    Canvas3D canvas;
    ViewingPlatform viewingPlatform;
    Bounds axisBounds;
    BranchGroup axisBranchGroup = new BranchGroup();
    TransformGroup axisTransformGroup = new TransformGroup();
    Transform3D axisTransform3D = new Transform3D();
    Vector3d axisVector3d = new Vector3d(-0.7, -0.6, -1.25);
    public Matrix3d matrix = new Matrix3d();

    public GraphicsAxis(ViewingPlatform v, Canvas3D c, Bounds b) {
        this.viewingPlatform = v;
        this.canvas = c;
        this.axisBounds = b;
        this.setCapability(1);
        this.createAxis();
        this.setBounds(this.axisBounds);
        this.axisTransform3D.setTranslation(this.axisVector3d);
        this.axisTransform3D.setScale(0.015);
        this.axisTransformGroup.setTransform(this.axisTransform3D);
        this.axisTransformGroup.addChild((Node)this);
        this.axisTransformGroup.setCapability(18);
        this.axisTransformGroup.setCapability(17);
        this.axisTransformGroup.setCapability(1);
        this.axisBranchGroup.setCapability(17);
        this.axisBranchGroup.setCapability(1);
        this.axisBranchGroup.addChild((Node)this.axisTransformGroup);
        this.axisBranchGroup.compile();
        this.viewingPlatform.getViewPlatformTransform().addChild((Node)this.axisBranchGroup);
    }

    public void center() {
        this.axisTransform3D.setIdentity();
        this.axisTransform3D.setScale(0.015);
        this.axisTransform3D.setTranslation(this.axisVector3d);
        this.axisTransformGroup.setTransform(this.axisTransform3D);
    }

    public void createAxis() {
        Appearance ap = new Appearance();
        Color3f col = new Color3f(Color.lightGray.getRGBColorComponents(null));
        Color3f black = new Color3f(Color.black.getRGBColorComponents(null));
        Color3f white = new Color3f(Color.white.getRGBColorComponents(null));
        Material mat = new Material(col, black, col, white, 50.0f);
        mat.setLightingEnable(true);
        ap.setMaterial(mat);
        Cone xcone = new Cone(2.0f, 3.0f, ap);
        xcone.setUserData((Object)this);
        Transform3D xconeT3d = new Transform3D();
        xconeT3d.setTranslation(new Vector3d(10.0, 0.0, 0.0));
        xconeT3d.setRotation(new AxisAngle4f(0.0f, 0.0f, 1.0f, -1.5707964f));
        TransformGroup xconeTG = new TransformGroup(xconeT3d);
        xconeTG.addChild((Node)xcone);
        Cylinder xcylinder = new Cylinder(1.0f, 9.0f, ap);
        xcylinder.setUserData((Object)this);
        Transform3D xcyT3d = new Transform3D();
        xcyT3d.setTranslation(new Vector3d(4.5, 0.0, 0.0));
        xcyT3d.setRotation(new AxisAngle4f(0.0f, 0.0f, 1.0f, 1.5707964f));
        TransformGroup xcyTG = new TransformGroup(xcyT3d);
        xcyTG.addChild((Node)xcylinder);
        this.setCapabilities(xcone, xcylinder);
        this.addChild((Node)xconeTG);
        this.addChild((Node)xcyTG);
        Cone ycone = new Cone(2.0f, 3.0f, ap);
        ycone.setUserData((Object)this);
        Transform3D yconeT3d = new Transform3D();
        yconeT3d.setTranslation(new Vector3d(0.0, 10.0, 0.0));
        TransformGroup yconeTG = new TransformGroup(yconeT3d);
        yconeTG.addChild((Node)ycone);
        Cylinder ycylinder = new Cylinder(1.0f, 9.0f, ap);
        ycylinder.setUserData((Object)this);
        Transform3D ycyT3d = new Transform3D();
        ycyT3d.setTranslation(new Vector3d(0.0, 4.5, 0.0));
        TransformGroup ycyTG = new TransformGroup(ycyT3d);
        ycyTG.addChild((Node)ycylinder);
        this.setCapabilities(ycone, ycylinder);
        this.addChild((Node)yconeTG);
        this.addChild((Node)ycyTG);
        Cone zcone = new Cone(2.0f, 3.0f, ap);
        zcone.setUserData((Object)this);
        Transform3D zconeT3d = new Transform3D();
        zconeT3d.setTranslation(new Vector3d(0.0, 0.0, 10.0));
        zconeT3d.setRotation(new AxisAngle4f(1.0f, 0.0f, 0.0f, 1.5707964f));
        TransformGroup zconeTG = new TransformGroup(zconeT3d);
        zconeTG.addChild((Node)zcone);
        Cylinder zcylinder = new Cylinder(1.0f, 9.0f, ap);
        zcylinder.setUserData((Object)this);
        Transform3D zcyT3d = new Transform3D();
        zcyT3d.setTranslation(new Vector3d(0.0, 0.0, 4.5));
        zcyT3d.setRotation(new AxisAngle4f(1.0f, 0.0f, 0.0f, 1.5707964f));
        TransformGroup zcyTG = new TransformGroup(zcyT3d);
        zcyTG.addChild((Node)zcylinder);
        this.setCapabilities(zcone, zcylinder);
        this.addChild((Node)zconeTG);
        this.addChild((Node)zcyTG);
        Sphere sphere = new Sphere(1.0f, ap);
        if (!sphere.getShape().getGeometry(0).isCompiled() && !sphere.getShape().getGeometry(0).isLive()) {
            PickTool.setCapabilities((Node)sphere.getShape(), (int)4098);
        }
        this.addChild((Node)sphere);
        ap = new Appearance();
        col = new Color3f(Color.yellow.getRGBColorComponents(null));
        mat = new Material(col, black, col, white, 50.0f);
        mat.setLightingEnable(true);
        ap.setMaterial(mat);
        Font font = new Font("Arial", 0, 4);
        Font3D font3d = new Font3D(font, new FontExtrusion());
        this.addChild((Node)this.createAxisLabel("X", font3d, ap, 11.0, 0.0, 0.0));
        this.addChild((Node)this.createAxisLabel("Y", font3d, ap, 0.0, 11.0, 0.0));
        this.addChild((Node)this.createAxisLabel("Z", font3d, ap, 0.0, 0.0, 11.0));
    }

    private TransformGroup createAxisLabel(String letter, Font3D font3d, Appearance ap, double x, double y, double z) {
        Text3D text = new Text3D(font3d, letter);
        text.setUserData((Object)this);
        Transform3D t3D = new Transform3D();
        t3D.setTranslation(new Vector3d(x, y, z));
        TransformGroup tg = new TransformGroup(t3D);
        Shape3D text3d = new Shape3D((Geometry)text, ap);
        text3d.setUserData((Object)this);
        Iterator e = text3d.getAllGeometries();
        while (e.hasNext()) {
            Geometry g = (Geometry)e.next();
            g.setCapability(18);
        }
        text3d.setCapability(1);
        text3d.setCapability(12);
        tg.addChild((Node)text3d);
        return tg;
    }

    public TransformGroup getAxisTransformGroup() {
        return this.axisTransformGroup;
    }

    private void setCapabilities(Cone cone, Cylinder cylinder) {
        if (!cone.getShape(0).getGeometry(0).isLive() && !cone.getShape(0).getGeometry(0).isCompiled()) {
            PickTool.setCapabilities((Node)cone.getShape(0), (int)4098);
            cone.getShape(0).setUserData((Object)this);
            PickTool.setCapabilities((Node)cone.getShape(1), (int)4098);
            cone.getShape(1).setUserData((Object)this);
            PickTool.setCapabilities((Node)cylinder.getShape(0), (int)4098);
            cylinder.getShape(0).setUserData((Object)this);
            PickTool.setCapabilities((Node)cylinder.getShape(1), (int)4098);
            cylinder.getShape(1).setUserData((Object)this);
            PickTool.setCapabilities((Node)cylinder.getShape(2), (int)4098);
            cylinder.getShape(2).setUserData((Object)this);
        }
    }

    public void showAxis(boolean b) {
        if (b && !this.axisBranchGroup.isLive()) {
            this.viewingPlatform.getViewPlatformTransform().addChild((Node)this.axisBranchGroup);
        } else if (!b && this.axisBranchGroup.isLive()) {
            this.axisBranchGroup.detach();
        }
    }

    @Override
    public void transformChanged(int type, Transform3D viewTransform) {
        viewTransform.get(this.matrix);
        this.matrix.invert();
        viewTransform.set(this.matrix);
        this.axisTransform3D.set(viewTransform);
        this.axisTransform3D.setTranslation(this.axisVector3d);
        this.axisTransform3D.setScale(0.015);
        this.axisTransformGroup.setTransform(this.axisTransform3D);
    }

    @Override
    public void transformClicked(int type, Transform3D transform) {
        this.transformChanged(type, transform);
    }

    @Override
    public void transformDoubleClicked(int type, Transform3D transform) {
        this.transformChanged(type, transform);
    }
}

