/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFESystem;
import ffe.core.MainPanel;
import ffe.lang.Utilities;
import ffe.parsers.SystemFilter;
import java.awt.Cursor;
import java.util.logging.Logger;
import org.apache.commons.lang.time.StopWatch;

public class FileOpener
implements Runnable {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    SystemFilter systemFilter = null;
    MainPanel mainPanel = null;
    private boolean timer = false;
    private boolean gc = false;
    private long occupiedMemory;
    private StopWatch stopWatch;
    private Logger logger = Logger.getLogger("ffe");

    public FileOpener(SystemFilter systemFilter, MainPanel mainPanel) {
        this.systemFilter = systemFilter;
        this.mainPanel = mainPanel;
        if (System.getProperty("ffe.timer", "false").equalsIgnoreCase("true")) {
            this.timer = true;
            if (System.getProperty("ffe.timer.gc", "false").equalsIgnoreCase("true")) {
                this.gc = true;
            }
        }
    }

    private void open() {
        if (this.timer) {
            this.startTimer();
        }
        FFESystem ffeSystem = null;
        if (this.systemFilter != null && this.systemFilter.readFile()) {
            ffeSystem = (FFESystem)this.systemFilter.getMolecularSystem();
            if (ffeSystem.getFileType() != Utilities.FileType.PDB) {
                this.logger.info("Determining Structure");
                Utilities.biochemistry(ffeSystem, this.systemFilter.getAtomList());
            }
            this.logger.info("Finalizing Model");
            this.mainPanel.getHierarchy().addSystemNode(ffeSystem);
        }
        this.mainPanel.setCursor(Cursor.getDefaultCursor());
        if (ffeSystem != null && this.timer) {
            this.stopTimer(ffeSystem);
        }
    }

    @Override
    public void run() {
        if (this.mainPanel != null && this.systemFilter != null) {
            this.open();
        }
    }

    private void startTimer() {
        this.stopWatch = new StopWatch();
        Runtime runtime = Runtime.getRuntime();
        if (this.gc) {
            runtime.runFinalization();
            runtime.gc();
        }
        this.occupiedMemory = runtime.totalMemory() - runtime.freeMemory();
        this.stopWatch.start();
    }

    private void stopTimer(FFESystem ffeSystem) {
        this.stopWatch.stop();
        this.logger.info("Opened " + ffeSystem.toString() + " with " + ffeSystem.getAtomList().size() + " atoms.\nFile Op Time  (msec): " + this.stopWatch.getTime());
        Runtime runtime = Runtime.getRuntime();
        if (this.gc) {
            runtime.runFinalization();
            runtime.gc();
            long moleculeMemory = runtime.totalMemory() - runtime.freeMemory() - this.occupiedMemory;
            this.logger.info("File Op Memory  (Kb): " + moleculeMemory / 1024L);
        }
        this.occupiedMemory = runtime.totalMemory() - runtime.freeMemory();
        this.logger.info("\nAfter File Op FFE Up-Time       (sec): " + MainPanel.stopWatch.getTime() / 1000L + "\nAfter File Op FFE Memory         (Mb): " + this.occupiedMemory / 0x100000L + " " + runtime.freeMemory() / 0x100000L + " " + runtime.totalMemory() / 0x100000L);
    }
}

