/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.Trajectory;
import ffe.lang.Atom;
import ffe.lang.Keyword;
import ffe.lang.MolecularAssembly;
import ffe.mm.ForceField;
import ffe.tinker.TinkerUpdate;
import java.io.File;
import java.util.Hashtable;

public class FFESystem
extends MolecularAssembly {
    private static final long serialVersionUID = 50L;
    public static final int MultiScaleLevel = 4;
    private File logFile;
    private File keyFile;
    private Hashtable<String, Keyword> keywords = new Hashtable();
    private ForceField forceField;
    private String commandDescription = null;
    private Trajectory trajectory = null;
    private int simulation = 0;
    private double time;
    private double temperature;
    private double energy;
    private int step;
    private boolean closing = false;

    public FFESystem(String name, String description, File file, boolean bondsKnown) {
        super(name, bondsKnown);
        this.setFile(file);
        this.commandDescription = description;
    }

    public void addKeyword(Keyword k) {
        if (this.keywords.containsKey(k.getKeyword())) {
            return;
        }
        this.keywords.put(k.getKeyword(), k);
    }

    @Override
    public boolean destroy() {
        this.setClosing(true);
        return super.destroy();
    }

    public double getEnergy() {
        return this.energy;
    }

    public String getEnergyString() {
        return String.format("Energy: %9.3f kcal/mole", this.energy);
    }

    public ForceField getForceField() {
        return this.forceField;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public Keyword getKeyword(String k) {
        return this.keywords.get(k);
    }

    public Hashtable<String, Keyword> getKeywords() {
        return this.keywords;
    }

    public File getLogFile() {
        if (this.logFile == null) {
            if (this.getFile() == null) {
                return null;
            }
            Object fileName = this.getFile().getName();
            int dot = ((String)fileName).lastIndexOf(".");
            fileName = String.valueOf(((String)fileName).subSequence(0, dot)) + ".log";
            this.logFile = new File((String)fileName);
        }
        return this.logFile;
    }

    public String getStepString() {
        return String.format("Step: %12d", this.step);
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTime() {
        return this.time;
    }

    public String getTimeString() {
        return String.format("Time: %9.3f picoseconds", this.time);
    }

    public Trajectory getTrajectory() {
        return this.trajectory;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isOptimization() {
        return this.simulation == TinkerUpdate.OPTIMIZATION;
    }

    public boolean isSimulation() {
        return this.simulation == TinkerUpdate.SIMULATION;
    }

    public boolean isStale() {
        for (Atom a : this.getAtomList()) {
            if (!a.isStale()) continue;
            return true;
        }
        return false;
    }

    public void removeKeyword(Keyword kd) {
        if (this.keywords.containsKey(kd.getKeyword())) {
            this.keywords.remove(kd.getKeyword());
        }
    }

    public void setClosing(boolean b) {
        this.closing = b;
    }

    public void setCommandDescription(String command) {
        this.commandDescription = command;
    }

    public void setEnergy(double e) {
        this.energy = e;
    }

    public void setForceField(ForceField forceField) {
        this.forceField = forceField;
    }

    public void setKeyFile(File f) {
        this.keyFile = f;
    }

    public void setKeywords(Hashtable<String, Keyword> k) {
        this.keywords = k;
    }

    public void setLogFile(File f) {
        this.logFile = f;
    }

    public void setSimulation(int type) {
        this.simulation = type;
    }

    public void setStep(int s) {
        this.step = s;
    }

    public void setTemperature(double t) {
        this.temperature = t;
    }

    public void setTime(double t) {
        this.time = t;
    }

    public void setTrajectory(Trajectory t) {
        this.trajectory = t;
    }

    public String toFFString() {
        String ff;
        StringBuffer sb = new StringBuffer(this.toString());
        if (this.forceField != null && (ff = this.forceField.toString("forcefield")) != null) {
            ff = ff.substring(10).trim();
            sb.append(" (");
            sb.append(ff);
            sb.append(")");
        }
        return sb.toString();
    }

    public String toFileString() {
        String ff;
        if (this.getFile() == null) {
            return this.toFFString();
        }
        StringBuffer sb = new StringBuffer(this.getFile().getAbsolutePath());
        if (this.forceField != null && (ff = this.forceField.toString("forcefield")) != null) {
            ff = ff.substring(10).trim();
            sb.append(" (");
            sb.append(ff);
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        if (this.getFile() != null) {
            if (this.commandDescription != null) {
                return this.getFile().getName() + " (" + this.commandDescription + ")";
            }
            return this.getFile().getName();
        }
        if (this.getName() != null) {
            if (this.commandDescription != null) {
                return this.getName() + this.commandDescription;
            }
            return this.getName();
        }
        return "FFE System";
    }
}

