/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFESystem;
import ffe.core.MainPanel;
import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class FFEExec
implements Runnable {
    private static String path;
    private static String ld_library_path;
    private static String classpath;
    private static Logger logger;
    private FFESystem system;
    private String name;
    private String args;
    private String dir;
    private MainPanel mainPanel;
    private File newFile;
    private boolean alive = true;
    private boolean openOnto;
    private int returnValue = 0;

    private void setEnv() {
        path = new File(String.valueOf(MainPanel.tinkerDir) + File.separator + "bin").getAbsolutePath();
        classpath = MainPanel.classpath;
        ld_library_path = System.getProperty("java.home", ".");
        if (SystemUtils.IS_OS_LINUX) {
            ld_library_path = ld_library_path + "/lib/amd64/server:" + ld_library_path + "/lib/amd64";
        } else if (SystemUtils.IS_OS_MAC) {
            ld_library_path = ld_library_path + "/lib/server:" + ld_library_path + "/lib";
        } else if (SystemUtils.IS_OS_WINDOWS) {
            ld_library_path = ld_library_path + "\\bin\\client";
            path = path + File.pathSeparator + ld_library_path;
        }
    }

    public FFEExec(FFESystem s, String n, String a, String d, MainPanel m, File file, boolean o) {
        this.system = s;
        this.name = n;
        this.args = a;
        this.dir = d;
        this.mainPanel = m;
        this.newFile = file;
        this.openOnto = o;
        logger.info(this.toString());
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private native int nativeExec(String var1, String var2, String var3, String var4, String var5);

    @Override
    public void run() {
        this.setEnv();
        if (this.args == null || this.dir == null || path == null || classpath == null || ld_library_path == null) {
            Logger.getLogger("ffe").severe("Native Command Cannot be Executed\nCOMMAND: " + this.args + "\nDIR: " + this.dir + "\nPATH: " + path + "\nCLASSPATH: " + classpath + "\nLD_LIBRARY_PATH: " + ld_library_path);
            return;
        }
        Logger.getLogger("ffe").info("Native Command Executed\nCOMMAND: " + this.args + "\nDIR: " + this.dir + "\nPATH: " + path + "\nCLASSPATH: " + classpath + "\nLD_LIBRARY_PATH: " + ld_library_path);
        System.out.println("args: " + this.args);
        System.out.println("dir: " + this.dir);
        System.out.println("path: " + path);
        System.out.println("classpath: " + classpath);
        this.returnValue = this.nativeExec(this.args, this.dir, path, classpath, ld_library_path);
        if (this.returnValue < 0) {
            Logger.getLogger("ffe").warning("The following job exited with a failure status: " + this.returnValue + "\n" + this.args);
        }
        if (this.mainPanel != null) {
            if (this.newFile != null) {
                String[] labels = this.args.split(" +");
                String command = labels[0].toUpperCase() + " on " + this.system.getFile().getName();
                if (this.openOnto) {
                    this.mainPanel.openOn(this.newFile, this.system, command);
                } else {
                    this.mainPanel.open(this.newFile, command);
                }
            }
            this.mainPanel.getLogPanel().setDone(this.name);
        }
        this.alive = false;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this).append((Object)path).append((Object)classpath).append((Object)ld_library_path);
        return toStringBuilder.toString();
    }

    static {
        logger = Logger.getLogger("ffe");
    }
}

