/*
 * Decompiled with CFR 0.152.
 */
package ffe.behaviors;

import ffe.behaviors.MouseBehaviorCallback;
import ffe.behaviors.MouseProperties;
import ffe.behaviors.PickMouseBehavior;
import ffe.behaviors.PickingCallback;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.picking.PickResult;

public class PickPropertiesBehavior
extends PickMouseBehavior
implements MouseBehaviorCallback {
    MouseProperties drag;
    private PickingCallback callback = null;
    private TransformGroup currentTG;

    public PickPropertiesBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, TransformGroup VPTG, int pickMode) {
        super(canvas, root, bounds);
        this.drag = new MouseProperties(1, VPTG);
        this.drag.setTransformGroup(this.currGrp);
        this.currGrp.addChild((Node)this.drag);
        this.drag.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.pickCanvas.setMode(pickMode);
    }

    public int getPickMode() {
        return this.pickCanvas.getMode();
    }

    public void setPickMode(int pickMode) {
        this.pickCanvas.setMode(pickMode);
    }

    public void setupCallback(PickingCallback c) {
        this.callback = c;
        if (this.callback == null) {
            this.drag.setupCallback(null);
        } else {
            this.drag.setupCallback(this);
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(5, this.currentTG);
    }

    @Override
    public void transformClicked(int type, Transform3D transform) {
        this.callback.transformClicked(5, this.currentTG);
    }

    @Override
    public void transformDoubleClicked(int type, Transform3D transform) {
        this.callback.transformDoubleClicked(5, this.currentTG);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        TransformGroup tg = null;
        if (!this.mevent.isMetaDown() && !this.mevent.isAltDown()) {
            this.pickCanvas.setShapeLocation(xpos, ypos);
            PickResult r = this.pickCanvas.pickClosest();
            if (r != null) {
                tg = (TransformGroup)r.getNode(32);
                if (tg != null && tg.getCapability(17) && tg.getCapability(18)) {
                    this.drag.wakeup();
                    this.currentTG = tg;
                    if (this.callback != null && this.mevent.getClickCount() == 2) {
                        this.callback.transformDoubleClicked(5, this.currentTG);
                    }
                }
            } else if (this.callback != null) {
                this.callback.transformDoubleClicked(3, null);
            }
        }
    }
}

