/*
 * Decompiled with CFR 0.152.
 */
package ffe.behaviors;

import ffe.behaviors.MouseBehaviorCallback;
import ffe.behaviors.MouseOrbit;
import ffe.behaviors.PickMouseBehavior;
import ffe.behaviors.PickingCallback;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.picking.PickResult;

public class PickOrbitBehavior
extends PickMouseBehavior
implements MouseBehaviorCallback {
    public MouseOrbit orbit;
    private PickingCallback callback = null;
    private TransformGroup currentTG;

    public PickOrbitBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, TransformGroup VPTG, int pickMode) {
        super(canvas, root, bounds);
        this.orbit = new MouseOrbit(1, VPTG);
        this.orbit.setTransformGroup(this.currGrp);
        this.currGrp.addChild((Node)this.orbit);
        this.orbit.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.pickCanvas.setMode(pickMode);
    }

    public int getPickMode() {
        return this.pickCanvas.getMode();
    }

    public void setPickMode(int pickMode) {
        this.pickCanvas.setMode(pickMode);
    }

    public void setTransformGroups(TransformGroup StarTG, TransformGroup VPTG) {
        this.orbit.setTransformGroups(StarTG, VPTG);
    }

    public void setupCallback(PickingCallback c) {
        this.callback = c;
        if (this.callback == null) {
            this.orbit.setupCallback(null);
        } else {
            this.orbit.setupCallback(this);
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(6, this.currentTG);
    }

    @Override
    public void transformClicked(int type, Transform3D transform) {
        this.callback.transformClicked(6, this.currentTG);
    }

    @Override
    public void transformDoubleClicked(int type, Transform3D transform) {
        this.callback.transformDoubleClicked(6, this.currentTG);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        TransformGroup tg = null;
        if (this.mevent.isMetaDown() && !this.mevent.isAltDown()) {
            this.pickCanvas.setShapeLocation(xpos, ypos);
            PickResult r = this.pickCanvas.pickClosest();
            if (r != null) {
                tg = (TransformGroup)r.getNode(32);
                if (tg != null && tg.getCapability(17) && tg.getCapability(18)) {
                    this.orbit.setTransformGroup(tg);
                    this.orbit.wakeup();
                    this.currentTG = tg;
                    if (this.callback != null) {
                        this.callback.transformClicked(6, this.currentTG);
                    }
                }
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }
}

