/*
 * Decompiled with CFR 0.152.
 */
package ffe.behaviors;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.java3d.WakeupOr;
import org.jogamp.java3d.utils.picking.PickCanvas;

public abstract class PickMouseBehavior
extends Behavior {
    static int count = 0;
    protected PickCanvas pickCanvas;
    protected WakeupCriterion[] conditions;
    protected WakeupOr wakeupCondition;
    protected boolean buttonPress = false;
    protected boolean shiftButton = false;
    protected boolean controlButton = false;
    protected TransformGroup currGrp;
    protected MouseEvent mevent;

    public PickMouseBehavior(Canvas3D canvas, BranchGroup root, Bounds bounds) {
        this.setSchedulingBounds(bounds);
        this.currGrp = new TransformGroup();
        this.currGrp.setCapability(18);
        this.currGrp.setCapability(17);
        root.addChild((Node)this.currGrp);
        this.pickCanvas = new PickCanvas(canvas, root);
        this.pickCanvas.setMode(256);
        this.pickCanvas.setTolerance(10.0f);
    }

    public void initialize() {
        this.conditions = new WakeupCriterion[1];
        this.conditions[0] = new WakeupOnAWTEvent(501);
        this.wakeupCondition = new WakeupOr(this.conditions);
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent evt) {
        this.buttonPress = false;
        if (evt.getID() == 501 | evt.getID() == 500 | evt.getID() == 502) {
            this.buttonPress = true;
        }
        this.controlButton = evt.isControlDown();
        this.shiftButton = evt.isShiftDown();
    }

    public void processStimulus(Iterator criteria) {
        AWTEvent[] evt = null;
        int xpos = 0;
        int ypos = 0;
        while (criteria.hasNext()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.next();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt[0] instanceof MouseEvent) {
            this.mevent = (MouseEvent)evt[0];
            this.processMouseEvent((MouseEvent)evt[0]);
            xpos = this.mevent.getPoint().x;
            ypos = this.mevent.getPoint().y;
        }
        if (this.buttonPress) {
            this.updateScene(xpos, ypos);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public void setTolerance(float tol) {
        if (this.pickCanvas != null) {
            this.pickCanvas.setTolerance(tol);
        }
    }

    public abstract void updateScene(int var1, int var2);
}

