/*
 * Decompiled with CFR 0.152.
 */
package ffe.behaviors;

import ffe.behaviors.MouseBehavior;
import ffe.behaviors.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.vecmath.Vector3d;

public class MouseZoom
extends MouseBehavior {
    double z_factor = 2.0E-4;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;
    int mouseButton = 2048;
    int doneID = 0;
    boolean first = true;

    public MouseZoom(int flags, TransformGroup VPTG) {
        super(flags, VPTG);
    }

    public MouseZoom(int flags, TransformGroup VPTG, Behavior behavior, int postID, int dID) {
        super(flags, VPTG, behavior, postID);
        this.doneID = dID;
    }

    public double getFactor() {
        return this.z_factor;
    }

    @Override
    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.z_factor *= -1.0;
            this.invert = true;
        }
    }

    public void setMouseButton(int button) {
        this.mouseButton = button;
    }

    @Override
    public void processStimulus(Iterator criteria) {
        boolean done = false;
        while (criteria.hasNext()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.next();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                boolean middleButton;
                this.processMouseEvent((MouseEvent)event[i]);
                int id = event[i].getID();
                MouseEvent mevent = (MouseEvent)event[i];
                int mod = mevent.getModifiersEx();
                boolean bl = middleButton = (mod & this.mouseButton) == this.mouseButton;
                if (!middleButton) {
                    boolean bl2 = middleButton = (mod & 0x200) == 512;
                }
                if (id == 506 && middleButton) {
                    this.y = ((MouseEvent)event[i]).getY();
                    int dy = this.y - this.y_last;
                    if (!this.reset) {
                        this.transformGroup.getTransform(this.currXform);
                        double z = -1.0 * (double)dy * this.z_factor;
                        double scale = this.currXform.getScale() + z;
                        if (scale > 0.0) {
                            this.currXform.setScale(scale);
                            this.transformGroup.setTransform(this.currXform);
                            this.transformChanged(this.currXform);
                        }
                        if (this.callback != null) {
                            this.callback.transformChanged(2, this.currXform);
                        }
                    } else {
                        this.reset = false;
                    }
                    this.x_last = this.x;
                    this.y_last = this.y;
                }
                if (id == 501) {
                    this.x_last = ((MouseEvent)event[i]).getX();
                    this.y_last = ((MouseEvent)event[i]).getY();
                    continue;
                }
                if (id != 502) continue;
                done = true;
            }
        }
        if (!done) {
            this.wakeupOn((WakeupCondition)this.mouseCriterion);
        } else {
            this.reset = true;
            this.mouseButton = 2048;
            this.postId(this.doneID);
            this.wakeupOn((WakeupCondition)this.postCriterion);
        }
    }

    public void setFactor(double factor) {
        this.z_factor = factor;
    }

    public void setupCallback(MouseBehaviorCallback c) {
        this.callback = c;
    }

    public void transformChanged(Transform3D transform) {
    }
}

