/*
 * Decompiled with CFR 0.152.
 */
package ffe.behaviors;

import ffe.behaviors.MouseBehavior;
import ffe.behaviors.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.vecmath.Vector3d;

public class MouseTranslate
extends MouseBehavior {
    private static Vector3d zero3d = new Vector3d(0.0, 0.0, 0.0);
    double x_factor = 0.05;
    double y_factor = 0.05;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;
    int mouseButton = 4096;
    int doneID = 0;

    public MouseTranslate(int flags, TransformGroup VPTG) {
        super(flags, VPTG);
    }

    public MouseTranslate(int flags, TransformGroup VPTG, Behavior behavior, int postID, int dID) {
        super(flags, VPTG, behavior, postID);
        this.doneID = dID;
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    @Override
    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public void setMouseButton(int button) {
        this.mouseButton = button;
    }

    @Override
    public void processStimulus(Iterator criteria) {
        while (criteria.hasNext()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.next();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                boolean rightButton;
                MouseEvent mevent = (MouseEvent)event[i];
                this.processMouseEvent(mevent);
                int id = event[i].getID();
                int mod = mevent.getModifiersEx();
                boolean bl = rightButton = (mod & this.mouseButton) == this.mouseButton;
                if (!rightButton) {
                    boolean bl2 = rightButton = (mod & 0x40) == 64;
                }
                if (id == 506 && rightButton && this.transformGroup != null) {
                    this.x = ((MouseEvent)event[i]).getX();
                    this.y = ((MouseEvent)event[i]).getY();
                    int dx = this.x - this.x_last;
                    int dy = this.y - this.y_last;
                    if (!this.reset && Math.abs(dy) < 50 && Math.abs(dx) < 50) {
                        this.transformGroup.getTransform(this.currXform);
                        Transform3D VPTG_T3D = new Transform3D();
                        this.ViewerTG.getTransform(VPTG_T3D);
                        VPTG_T3D.setTranslation(zero3d);
                        VPTG_T3D.invert();
                        this.currXform.mul(VPTG_T3D, this.currXform);
                        this.translation.x = (double)dx * this.x_factor;
                        this.translation.y = (double)(-dy) * this.y_factor;
                        this.transformX.set(this.translation);
                        if (this.invert) {
                            this.currXform.mul(this.currXform, this.transformX);
                        } else {
                            this.currXform.mul(this.transformX, this.currXform);
                        }
                        VPTG_T3D.invert();
                        this.currXform.mul(VPTG_T3D, this.currXform);
                        this.transformGroup.setTransform(this.currXform);
                        this.transformChanged(this.currXform);
                        if (this.callback != null) {
                            this.callback.transformChanged(1, this.currXform);
                        }
                    } else {
                        this.reset = false;
                    }
                    this.x_last = this.x;
                    this.y_last = this.y;
                }
                if (id == 501) {
                    this.x_last = ((MouseEvent)event[i]).getX();
                    this.y_last = ((MouseEvent)event[i]).getY();
                    continue;
                }
                if (id != 502) continue;
                this.setTransformGroup(null);
            }
        }
        if (this.transformGroup != null) {
            this.wakeupOn((WakeupCondition)this.mouseCriterion);
        } else {
            this.mouseButton = 4096;
            this.postId(this.doneID);
            this.wakeupOn((WakeupCondition)this.postCriterion);
        }
    }

    public void setFactor(double factor) {
        this.x_factor = this.y_factor = factor;
    }

    public void setFactor(double xFactor, double yFactor) {
        this.x_factor = xFactor;
        this.y_factor = yFactor;
    }

    public void setupCallback(MouseBehaviorCallback c) {
        this.callback = c;
    }

    public void transformChanged(Transform3D transform) {
    }
}

