/*
 * Decompiled with CFR 0.152.
 */
package ffe.behaviors;

import ffe.behaviors.MouseBehavior;
import ffe.behaviors.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public class MouseOrbit
extends MouseBehavior {
    double x_angle;
    double y_angle;
    double x_factor = 0.01;
    double y_factor = 0.01;
    private TransformGroup tg_ghost;
    private Transform3D VPTG_ghost_T3D;
    private MouseBehaviorCallback callback = null;

    public MouseOrbit(int flags, TransformGroup VPTG) {
        super(flags, VPTG);
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.x_angle = 0.0;
        this.y_angle = 0.0;
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    @Override
    public void processStimulus(Iterator criteria) {
        while (criteria.hasNext()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.next();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                this.processMouseEvent((MouseEvent)event[i]);
                if ((!this.buttonPress || (this.flags & 1) != 0) && (!this.wakeUp || (this.flags & 1) == 0)) continue;
                int id = event[i].getID();
                if (id == 506) {
                    this.x = ((MouseEvent)event[i]).getX();
                    this.y = ((MouseEvent)event[i]).getY();
                    int dx = this.x - this.x_last;
                    int dy = this.y - this.y_last;
                    if (!this.reset) {
                        Transform3D tempT3D = new Transform3D();
                        Transform3D orbitT3D = new Transform3D();
                        tempT3D.rotX((double)(-dy) * this.y_factor);
                        orbitT3D.mul(tempT3D);
                        tempT3D.rotY((double)(-dx) * this.x_factor);
                        orbitT3D.mul(tempT3D);
                        Transform3D tg_ghost_T3D = new Transform3D();
                        this.tg_ghost.getTransform(tg_ghost_T3D);
                        Vector3f tg_ghost_vec3f = new Vector3f();
                        tg_ghost_T3D.get(tg_ghost_vec3f);
                        Matrix4d tg_ghost_mat4d = new Matrix4d();
                        tg_ghost_T3D.get(tg_ghost_mat4d);
                        Transform3D VPTG_ghost_T3D_inverted = new Transform3D();
                        Transform3D VPTG_ghost_T3D_noninverted = new Transform3D();
                        this.ViewerTG.getTransform(VPTG_ghost_T3D_inverted);
                        this.ViewerTG.getTransform(VPTG_ghost_T3D_noninverted);
                        VPTG_ghost_T3D_inverted.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                        VPTG_ghost_T3D_noninverted.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                        VPTG_ghost_T3D_inverted.invert();
                        tg_ghost_T3D.mul(VPTG_ghost_T3D_inverted, tg_ghost_T3D);
                        tg_ghost_T3D.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                        if (this.invert) {
                            tg_ghost_T3D.mul(tg_ghost_T3D, orbitT3D);
                        } else {
                            tg_ghost_T3D.mul(orbitT3D, tg_ghost_T3D);
                        }
                        tg_ghost_T3D.mul(VPTG_ghost_T3D_noninverted, tg_ghost_T3D);
                        tg_ghost_T3D.setTranslation(tg_ghost_vec3f);
                        this.tg_ghost.setTransform(tg_ghost_T3D);
                        this.VPTG_ghost_T3D = new Transform3D();
                        this.ViewerTG.getTransform(this.VPTG_ghost_T3D);
                        Vector3f VPTG_ghost_vec3f = new Vector3f();
                        this.VPTG_ghost_T3D.get(VPTG_ghost_vec3f);
                        Vector3f temp_vec3f = new Vector3f();
                        temp_vec3f.x = VPTG_ghost_vec3f.x - tg_ghost_vec3f.x;
                        temp_vec3f.y = VPTG_ghost_vec3f.y - tg_ghost_vec3f.y;
                        temp_vec3f.z = VPTG_ghost_vec3f.z - tg_ghost_vec3f.z;
                        this.VPTG_ghost_T3D.setTranslation(temp_vec3f);
                        this.VPTG_ghost_T3D.mul(VPTG_ghost_T3D_inverted, this.VPTG_ghost_T3D);
                        if (this.invert) {
                            this.VPTG_ghost_T3D.mul(this.VPTG_ghost_T3D, orbitT3D);
                        } else {
                            this.VPTG_ghost_T3D.mul(orbitT3D, this.VPTG_ghost_T3D);
                        }
                        this.VPTG_ghost_T3D.mul(VPTG_ghost_T3D_noninverted, this.VPTG_ghost_T3D);
                        this.VPTG_ghost_T3D.get(temp_vec3f);
                        temp_vec3f.x += tg_ghost_vec3f.x;
                        temp_vec3f.y += tg_ghost_vec3f.y;
                        temp_vec3f.z += tg_ghost_vec3f.z;
                        this.VPTG_ghost_T3D.setTranslation(temp_vec3f);
                        this.ViewerTG.setTransform(this.VPTG_ghost_T3D);
                        this.transformChanged(this.currXform);
                        if (this.callback != null) {
                            this.callback.transformChanged(6, this.currXform);
                        }
                    } else {
                        this.reset = false;
                    }
                    this.x_last = this.x;
                    this.y_last = this.y;
                    continue;
                }
                if (id != 501) continue;
                this.x_last = ((MouseEvent)event[i]).getX();
                this.y_last = ((MouseEvent)event[i]).getY();
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void setFactor(double factor) {
        this.x_factor = this.y_factor = factor;
    }

    public void setFactor(double xFactor, double yFactor) {
        this.x_factor = xFactor;
        this.y_factor = yFactor;
    }

    public void setTransformGroups(TransformGroup tg, TransformGroup VPTG) {
        this.ViewerTG = VPTG;
        this.tg_ghost = new TransformGroup();
        Transform3D tgT3D = new Transform3D();
        tg.getTransform(tgT3D);
        this.tg_ghost.setTransform(tgT3D);
    }

    public void setupCallback(MouseBehaviorCallback c) {
        this.callback = c;
    }

    public void transformChanged(Transform3D transform) {
    }
}

