/*
 * Decompiled with CFR 0.152.
 */
package ffe;

import ffe.core.MainPanel;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.time.StopWatch;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Main
extends JFrame {
    public MainPanel mainPanel;
    public static StopWatch stopWatch = new StopWatch();
    private static Logger logger = Logger.getLogger("ffe");

    private void checkJava3D() {
        try {
            this.getClass().getClassLoader().loadClass("org.jogamp.java3d.Canvas3D");
        }
        catch (Exception e) {
            logger.severe("\n\nERROR: Java3D Extensions Are Not Installed\n\n" + String.valueOf(e));
            logger.severe("\n\nERROR: Force Field Explorer Cannot Continue\n\n");
            System.exit(-1);
        }
    }

    private static void configureLoggers() {
        try {
            Handler[] defaultHandlers;
            Logger defaultLogger = LogManager.getLogManager().getLogger("");
            for (Handler h : defaultHandlers = defaultLogger.getHandlers()) {
                defaultLogger.removeHandler(h);
            }
            logger.setLevel(Level.ALL);
            FileHandler fileHandler = new FileHandler("ffe.log");
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            logger.addHandler(consoleHandler);
        }
        catch (Exception e) {
            System.err.println("Exception During Initialization of Logging\n" + String.valueOf(e));
        }
    }

    public static void main(String[] args) throws Exception {
        if (SystemUtils.IS_OS_MAC) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        stopWatch.start();
        Main.configureLoggers();
        logger.info("Force Field Explorer is Starting Up");
        File commandLineFile = null;
        if (args != null && args.length > 0 && (commandLineFile = new File(args[0])).exists()) {
            commandLineFile = new File(commandLineFile.getAbsolutePath());
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        Main.setDefaultLookAndFeelDecorated(false);
        Main m = new Main(commandLineFile);
        if (System.getProperty("ffe.timer") != null) {
            logger.info("\nStart-up Time (msec): " + stopWatch.getTime());
            Runtime runtime = Runtime.getRuntime();
            runtime.runFinalization();
            runtime.gc();
            long occupiedMemory = runtime.totalMemory() - runtime.freeMemory();
            long KB = 1024L;
            logger.info("Memory for: " + String.valueOf(m) + "\nIn-Use Memory   (Kb): " + occupiedMemory / KB + "\nFree Memory     (Kb): " + runtime.freeMemory() / KB + "\nTotal Memory    (Kb): " + runtime.totalMemory() / KB);
        }
    }

    public Main(File commandLineFile) {
        super("Force Field Explorer");
        this.setVisible(false);
        this.checkJava3D();
        SignalHandler handler = new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                logger.severe(" Signal: " + sig.getName() + " - " + sig.getNumber() + "\n Force Field Explorer is Shutting Down");
                try {
                    if (Main.this.mainPanel != null) {
                        Main.this.mainPanel.exit();
                    }
                }
                catch (Exception e) {
                    logger.severe("FFE Could Not Cleanly Shut Down\n" + String.valueOf(e));
                }
                System.exit(-1);
            }
        };
        Signal.handle(new Signal("INT"), handler);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        this.mainPanel = new MainPanel(this);
        this.add(this.mainPanel);
        this.mainPanel.initialize();
        this.setJMenuBar(this.mainPanel.getMainMenu());
        this.setTitle("Force Field Explorer");
        URL iconURL = this.getClass().getClassLoader().getResource("ffe/icons/icon64.png");
        ImageIcon icon = new ImageIcon(iconURL);
        this.setIconImage(icon.getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Main.this.mainPanel != null) {
                    Main.this.mainPanel.exit();
                }
                System.exit(0);
            }
        });
        this.mainPanel.setPanel(3);
        this.setVisible(true);
        this.mainPanel.setPanel(0);
        if (commandLineFile != null) {
            if (commandLineFile.exists()) {
                this.mainPanel.open(commandLineFile, null);
            } else {
                logger.warning(commandLineFile.toString() + " was not found");
            }
        }
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this).append((Object)("Up Time: " + String.valueOf(stopWatch))).append((Object)("Logger: " + logger.getName()));
        return toStringBuilder.toString();
    }
}

