/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.NotSupportedInElevationException;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.NativeLogger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.InterProcessCommunication;
import com.install4j.runtime.installer.helper.comm.actions.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchIntAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.comm.impl.ClassLoaderObjectInputStream;
import com.install4j.runtime.installer.helper.comm.impl.HelperContextImpl;
import com.install4j.runtime.installer.helper.comm.impl.InstallerHelperContextImpl;
import com.install4j.runtime.installer.helper.comm.impl.UninstallerHelperContextImpl;
import com.install4j.runtime.installer.helper.comm.responses.BooleanResponse;
import com.install4j.runtime.installer.helper.comm.responses.IntResponse;
import com.install4j.runtime.installer.helper.comm.responses.LongResponse;
import com.install4j.runtime.installer.helper.comm.responses.ObjectResponse;
import com.install4j.runtime.installer.helper.comm.responses.Response;
import com.install4j.runtime.installer.helper.comm.responses.StringResponse;
import com.install4j.runtime.installer.helper.comm.responses.ThrowableResponse;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.swing.SwingUtilities;

public class HelperCommunication {
    private static final int TIMEOUT = 120000;
    private static HelperCommunication instance = new HelperCommunication();
    private boolean terminated;
    private static PrintStream debugLogWriter;
    private ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private DataOutputStream dout = new DataOutputStream(this.bout);
    private Thread executorThread;
    private final InterProcessCommunication interProcessCommunication;
    private HelperContextImpl helperContext;
    private final Stack<ActionWrapper> actions = new Stack();
    private final Map<Long, Response> responses = new HashMap<Long, Response>();
    private final Object sendMonitor = new Object();
    private long nextPacketId = 1L;
    private long lastPing = -1L;
    private volatile boolean edtWaiting = false;

    public HelperCommunication() {
        String parentIdentifier = System.getProperty("install4j.commIdentifier");
        InterProcessCommunication.ErrorLogger logger = parentIdentifier == null ? new InterProcessCommunication.ErrorLogger(){

            @Override
            public void log(String str) {
                HelperCommunication.log(str);
            }

            @Override
            public void log(Throwable t) {
                HelperCommunication.log(t);
            }
        } : InterProcessCommunication.INSTALLER_APP_LOGGER;
        this.interProcessCommunication = new InterProcessCommunication(parentIdentifier, System.getProperty("install4j.commHash"), false, logger);
    }

    public static HelperCommunication getInstance() {
        return instance;
    }

    public String getParentIdentifier() {
        return this.interProcessCommunication.getParentIdentifier();
    }

    public String getHash() {
        return this.interProcessCommunication.getHash();
    }

    public boolean isElevatedHelper() {
        return this.getParentIdentifier() != null;
    }

    public boolean hasElevatedHelper() {
        try {
            return !this.isElevatedHelper() && this.isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean connect() {
        if (this.interProcessCommunication.connect()) {
            this.terminated = false;
            if (this.isElevatedHelper()) {
                this.helperContext = Objects.equals(InstallerConfig.getCurrentApplicationId(), "uninstaller") ? new UninstallerHelperContextImpl() : new InstallerHelperContextImpl();
                ContextImpl.setSingleContextInt(this.helperContext);
                FileInstaller.getInstance().setDefaultProgressInterface(this.helperContext.getProgressInterface());
            }
            new ReaderThread().start();
            this.executorThread = new Thread("helper_ipc_executor"){

                @Override
                public void run() {
                    while (true) {
                        HelperCommunication.this.executeActionWrapper(HelperCommunication.this.getNextAction(true), true);
                    }
                }
            };
            new Thread("helper_ipc_ping"){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        HelperCommunication.ping();
                        if (!HelperCommunication.this.isElevatedHelper() || HelperCommunication.this.lastPing <= -1L || System.currentTimeMillis() - HelperCommunication.this.lastPing <= 120000L) continue;
                        System.exit(1);
                    }
                }
            }.start();
            if (this.hasElevatedHelper()) {
                Runtime.getRuntime().addShutdownHook(new Thread("helper_ipc_shutdown"){

                    @Override
                    public void run() {
                        HelperCommunication.this.terminate();
                    }
                });
            } else {
                InstallerUtil.initHelperState();
                InstallerVariables.initHelperState();
                Install4jClassLoader.initHelperState();
                Logger.getInstance().log(this, "Using communication backend " + this.interProcessCommunication.getBackendClass().getName(), true);
            }
            this.executorThread.start();
            return true;
        }
        return false;
    }

    private static void ping() {
        try {
            HelperCommunication.getInstance().executeAction(ExecutionContext.OTHER, new DirectRunAction(){

                @Override
                protected void run(Context context) {
                    HelperCommunication.getInstance().lastPing = System.currentTimeMillis();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isEdtWaiting() {
        return this.edtWaiting;
    }

    public String createListener() {
        return this.interProcessCommunication.createListener();
    }

    public String fetchStringChecked(ExecutionContext executionContext, FetchStringAction action) throws UserCanceledException, IOException {
        return ((StringResponse)this.executeActionChecked(executionContext, action)).getValue();
    }

    public <T> T fetchObjectChecked(ExecutionContext executionContext, FetchObjectAction<T> action) throws UserCanceledException, IOException {
        return (T)((ObjectResponse)this.executeActionChecked(executionContext, action)).getValue();
    }

    public long fetchLongChecked(ExecutionContext executionContext, FetchLongAction action) throws UserCanceledException, IOException {
        return ((LongResponse)this.executeActionChecked(executionContext, action)).getValue();
    }

    public boolean fetchBooleanChecked(ExecutionContext executionContext, FetchBooleanAction action) throws UserCanceledException, IOException {
        return ((BooleanResponse)this.executeActionChecked(executionContext, action)).getValue();
    }

    public int fetchIntChecked(ExecutionContext executionContext, FetchIntAction action) throws UserCanceledException, IOException {
        return ((IntResponse)this.executeActionChecked(executionContext, action)).getValue();
    }

    public Response executeActionChecked(ExecutionContext executionContext, CommunicationAction action) throws UserCanceledException, IOException {
        try {
            return this.executeActionInt(executionContext, action);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof UserCanceledException) {
                throw (UserCanceledException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public String fetchString(ExecutionContext executionContext, FetchStringAction action) {
        return ((StringResponse)this.executeAction(executionContext, action)).getValue();
    }

    public <T> T fetchObject(ExecutionContext executionContext, FetchObjectAction<T> action) {
        return (T)((ObjectResponse)this.executeAction(executionContext, action)).getValue();
    }

    public long fetchLong(ExecutionContext executionContext, FetchLongAction action) {
        return ((LongResponse)this.executeAction(executionContext, action)).getValue();
    }

    public boolean fetchBoolean(ExecutionContext executionContext, FetchBooleanAction action) {
        return ((BooleanResponse)this.executeAction(executionContext, action)).getValue();
    }

    public int fetchInt(ExecutionContext executionContext, FetchLongAction action) {
        return (int)((LongResponse)this.executeAction(executionContext, action)).getValue();
    }

    public Response executeAction(ExecutionContext executionContext, CommunicationAction action) {
        try {
            return this.executeActionInt(executionContext, action);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private Response executeActionInt(ExecutionContext executionContext, CommunicationAction action) throws Throwable {
        if (executionContext == null) {
            executionContext = ExecutionContext.SAME;
        }
        if (executionContext == ExecutionContext.ELEVATED) {
            if (this.isElevatedHelper()) {
                return this.executeActionDirect(action);
            }
            return this.executeOther(action);
        }
        if (executionContext == ExecutionContext.UNELEVATED) {
            if (!this.isElevatedHelper() || !this.isConnected()) {
                return this.executeActionDirect(action);
            }
            return this.executeOther(action);
        }
        if (executionContext == ExecutionContext.SAME) {
            return this.executeActionDirect(action);
        }
        if (executionContext == ExecutionContext.OTHER) {
            return this.executeOther(action);
        }
        if (executionContext == ExecutionContext.MAXIMUM) {
            if (this.isElevatedHelper() || !this.hasElevatedHelper()) {
                return this.executeActionDirect(action);
            }
            return this.executeOther(action);
        }
        if (executionContext == ExecutionContext.ALL) {
            if (this.isConnected()) {
                this.executeOther(action);
            }
            return this.executeActionDirect(action);
        }
        throw new RuntimeException("unknown ExecutionContext " + (Object)((Object)executionContext));
    }

    private Response executeActionDirect(CommunicationAction action) throws Throwable {
        Response response = action.execute(this.getContext());
        if (response instanceof ThrowableResponse) {
            throw ((ThrowableResponse)response).getThrowable();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response executeOther(CommunicationAction action) throws Throwable {
        if (!this.isConnected()) {
            throw new RuntimeException("other process not connected");
        }
        try {
            Long id;
            Map<Long, Response> map = this.sendMonitor;
            synchronized (map) {
                id = this.nextPacketId++;
            }
            this.sendObject(new ActionWrapper(id, action));
            if (action instanceof RunNoWaitAction) return null;
            this.edtWaiting = !this.isElevatedHelper() && SwingUtilities.isEventDispatchThread();
            try {
                map = this.responses;
                synchronized (map) {
                    Response response = this.responses.remove(id);
                    while (response == null) {
                        try {
                            this.responses.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if ((response = this.responses.remove(id)) != null || Thread.currentThread() != this.executorThread) continue;
                        ActionWrapper actionWrapper = this.getNextAction(false);
                        if (actionWrapper != null) {
                            this.executeActionWrapper(actionWrapper, true);
                        }
                        response = this.responses.remove(id);
                    }
                    if (response instanceof ThrowableResponse) {
                        throw ((ThrowableResponse)response).getThrowable();
                    }
                    Response response2 = response;
                    return response2;
                }
            }
            finally {
                if (this.edtWaiting && SwingUtilities.isEventDispatchThread()) {
                    this.edtWaiting = false;
                }
            }
        }
        catch (IOException e) {
            if (this.isElevatedHelper()) throw new RuntimeException(e);
            if (this.terminated) throw new RuntimeException(e);
            Logger.getInstance().log(e);
            throw new RuntimeException(e);
        }
    }

    public void terminate() {
        if (this.hasElevatedHelper() && this.isConnected()) {
            this.terminated = true;
            HelperCommunication.terminateInt();
            this.interProcessCommunication.setDisconnected();
        }
    }

    private static void terminateInt() {
        try {
            HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new DirectRunAction(){

                @Override
                protected void run(Context context) {
                    HelperCommunication.getInstance().interProcessCommunication.setDisconnected();
                    System.exit(0);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void executeActionWrapper(ActionWrapper actionWrapper, boolean sendResponse) {
        Response response;
        try {
            response = actionWrapper.action.execute(this.getContext());
        }
        catch (Throwable t) {
            response = new ThrowableResponse(t);
        }
        if (sendResponse) {
            try {
                this.sendObject(new ResponseWrapper(actionWrapper.id, response));
            }
            catch (Throwable e) {
                if (this.isElevatedHelper()) {
                    e.printStackTrace();
                }
                Logger.getInstance().log(e);
            }
        }
    }

    private Context getContext() {
        return this.helperContext != null ? this.helperContext : ContextImpl.getCurrentContext();
    }

    public static void helperUnsupported() throws NotSupportedInElevationException {
        if (HelperCommunication.getInstance().isElevatedHelper()) {
            throw new NotSupportedInElevationException();
        }
    }

    public static void checkEdtWaiting() {
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        if (!helperCommunication.isElevatedHelper() && helperCommunication.isEdtWaiting()) {
            throw new RuntimeException("Unable to perform this operation from the elevated helper process because the EDT thread in the unelevated process is waiting for a reply.");
        }
    }

    public static boolean executeAsHelper(String[] args) {
        if (System.getProperty("install4j.helperAppId") != null) {
            HelperCommunication.main(args);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionWrapper getNextAction(boolean wait) {
        Stack<ActionWrapper> stack = this.actions;
        synchronized (stack) {
            if (wait) {
                while (this.actions.empty()) {
                    try {
                        this.actions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.actions.pop();
            }
            if (this.actions.empty()) {
                return null;
            }
            return this.actions.pop();
        }
    }

    public void checkWork() {
    }

    public Object readData() throws IOException {
        byte[] bytes = this.interProcessCommunication.readDataBlock();
        ClassLoaderObjectInputStream oin = new ClassLoaderObjectInputStream(Install4jClassLoader.getInstance(), new ByteArrayInputStream(bytes));
        try {
            return oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendObject(Object data) throws IOException {
        try {
            Object object = this.sendMonitor;
            synchronized (object) {
                this.bout.reset();
                ObjectOutputStream oout = new ObjectOutputStream(this.dout);
                oout.writeObject(data);
                oout.close();
                this.interProcessCommunication.writeDataBlock(this.bout.toByteArray());
            }
        }
        catch (InvalidClassException | NotSerializableException e) {
            Util.fatalError(e);
        }
    }

    public boolean isConnected() {
        return this.interProcessCommunication.isConnected();
    }

    public static void main(String[] args) {
        InstallerUtil.setStartupVmParameters();
        if ("yes".equals(System.getenv("I4J_LOG_HELPER")) || Boolean.getBoolean("install4j.helperLog")) {
            try {
                File tempFile = Util.isMacOS() ? new File("/var/tmp/i4j_helper.log") : File.createTempFile("i4j_helper", ".log");
                debugLogWriter = new PrintStream(new FileOutputStream(tempFile), true);
                System.setErr(debugLogWriter);
                System.setOut(debugLogWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HelperCommunication.log("Started helper");
        InstallerUtil.setUnattended(true);
        InstallerConfig.setCurrentApplicationId(System.getProperty("install4j.helperAppId"));
        NativeLogger.registerCleanup();
        HelperCommunication.getInstance().connect();
    }

    public static synchronized void log(String msg) {
        if (debugLogWriter != null) {
            debugLogWriter.println(DateFormat.getTimeInstance().format(new Date()) + ": " + msg);
            debugLogWriter.flush();
        }
    }

    public static synchronized void log(Throwable t) {
        if (debugLogWriter != null) {
            debugLogWriter.println(DateFormat.getTimeInstance().format(new Date()) + ":");
            t.printStackTrace(debugLogWriter);
            debugLogWriter.flush();
        }
    }

    public static boolean getUnelevatedBooleanProperty(final String propertyName) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return Boolean.getBoolean(propertyName);
            }
        });
    }

    public static void setUnelevatedBooleanProperty(final String propertyName, final boolean value) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                System.setProperty(propertyName, String.valueOf(value));
            }
        });
    }

    public static String getUnelevatedProperty(final String propertyName) {
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            @Override
            protected String fetchValue(Context context) throws Exception {
                return System.getProperty(propertyName);
            }
        });
    }

    private static class ResponseWrapper
    implements Serializable {
        long id;
        Response response;

        private ResponseWrapper(long id, Response response) {
            this.id = id;
            this.response = response;
        }
    }

    private static class ActionWrapper
    implements Serializable {
        long id;
        CommunicationAction action;

        private ActionWrapper(long id, CommunicationAction action) {
            this.id = id;
            this.action = action;
        }
    }

    private class ReaderThread
    extends Thread {
        private ReaderThread() {
            super("helper_ipc_reader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleData(Object data) {
            if (data instanceof ActionWrapper) {
                ActionWrapper actionWrapper = (ActionWrapper)data;
                if (actionWrapper.action instanceof DirectRunAction) {
                    HelperCommunication.this.executeActionWrapper(actionWrapper, false);
                    return;
                }
                Object object = HelperCommunication.this.actions;
                synchronized (object) {
                    HelperCommunication.this.actions.push((ActionWrapper)data);
                    HelperCommunication.this.actions.notifyAll();
                }
                object = HelperCommunication.this.responses;
                synchronized (object) {
                    HelperCommunication.this.responses.notifyAll();
                    return;
                }
            }
            if (!(data instanceof ResponseWrapper)) return;
            Map map = HelperCommunication.this.responses;
            synchronized (map) {
                ResponseWrapper wrapper = (ResponseWrapper)data;
                HelperCommunication.this.responses.put(wrapper.id, wrapper.response);
                HelperCommunication.this.responses.notifyAll();
                return;
            }
        }

        @Override
        public void run() {
            block3: {
                try {
                    while (HelperCommunication.this.isConnected()) {
                        this.handleData(HelperCommunication.this.readData());
                    }
                }
                catch (Throwable e) {
                    HelperCommunication.log(e);
                    if (HelperCommunication.this.terminated || HelperCommunication.this.isElevatedHelper()) break block3;
                    Logger.getInstance().log(e);
                }
            }
        }
    }

    public static abstract class DirectRunAction
    extends RunNoWaitAction {
    }

    public static abstract class RunNoWaitAction
    extends RunAction {
    }
}

