/*
 * Decompiled with CFR 0.152.
 */
package net.highteq.nativetaglet;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Taglet;

public class NativeTaglet
implements Taglet {
    private Properties mapping = null;
    private static final String NAME = "native";
    private static final String[] openGLSuffixes = new String[]{"b", "s", "i", "f", "d", "ub", "us", "ui", "bv", "sv", "iv", "fv", "dv", "ubv", "usv", "uiv"};

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isInlineTag() {
        return true;
    }

    public static void register(Map map) {
        NativeTaglet nativeTaglet = new NativeTaglet();
        Taglet taglet = (Taglet)map.get(nativeTaglet.getName());
        if (taglet != null) {
            map.remove(nativeTaglet.getName());
        }
        map.put(nativeTaglet.getName(), nativeTaglet);
    }

    static String getTagsText(DocTree docTree) {
        return (String)new SimpleDocTreeVisitor<String, Void>(){

            @Override
            public String visitText(TextTree textTree, Void void_) {
                return textTree.getBody();
            }

            @Override
            public String visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, Void void_) {
                Iterator<? extends DocTree> iterator = unknownBlockTagTree.getContent().iterator();
                if (iterator.hasNext()) {
                    DocTree docTree = iterator.next();
                    return docTree.accept(this, void_);
                }
                return "";
            }

            @Override
            public String visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void void_) {
                Iterator<? extends DocTree> iterator = unknownInlineTagTree.getContent().iterator();
                if (iterator.hasNext()) {
                    DocTree docTree = iterator.next();
                    return docTree.accept(this, void_);
                }
                return "";
            }

            @Override
            protected String defaultAction(DocTree docTree, Void void_) {
                return "";
            }
        }.visit(docTree, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(List<? extends DocTree> list, Element element) {
        Object object;
        String string = NativeTaglet.getTagsText(list.get(0)).trim();
        if (this.mapping == null) {
            this.mapping = new Properties();
            object = null;
            try {
                Object object2;
                try {
                    object2 = new URL(System.getProperty("nativetaglet.mapping", "file:native-taglet.properties"));
                }
                catch (MalformedURLException malformedURLException) {
                    object2 = new URL("file:" + System.getProperty("nativetaglet.mapping", "file:native-taglet.properties"));
                }
                object = ((URL)object2).openStream();
                this.mapping.load((InputStream)object);
            }
            catch (Exception exception) {
                System.err.println("[NATIVE TAGLET] Could not read mapping file");
                System.err.println("-->");
                exception.printStackTrace(System.err);
                System.err.println("<--");
                System.err.println("[NATIVE TAGLET] !!! NO LINKS WILL BE GENERATED !!!");
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.mapping != null) {
            object = this.mapping.getProperty(string);
            if (object == null) {
                for (String string2 : this.mapping.keySet()) {
                    if (!NativeTaglet.hasOpenGLSuffix(string, string2)) continue;
                    object = this.mapping.getProperty(string2);
                    break;
                }
            }
            if (object != null) {
                object = this.mapping.getProperty("nativetaglet.baseUrl", "") + (String)object;
                string = "<a href=\"" + (String)object + "\">" + string + "</a>";
            }
        }
        return string;
    }

    private static boolean hasOpenGLSuffix(String string, String string2) {
        if (!string.startsWith(string2)) {
            return false;
        }
        for (int i = 0; i < openGLSuffixes.length; ++i) {
            String string3 = openGLSuffixes[i];
            if (!string.endsWith(string3)) continue;
            if (string.equals(string2 + string3)) {
                return true;
            }
            try {
                String string4 = string.substring(string2.length(), string.length() - string3.length());
                if (string4.length() != 1 || !Character.isDigit(string4.charAt(0))) continue;
                return true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Set<Taglet.Location> getAllowedLocations() {
        HashSet<Taglet.Location> hashSet = new HashSet<Taglet.Location>();
        hashSet.add(Taglet.Location.FIELD);
        hashSet.add(Taglet.Location.CONSTRUCTOR);
        hashSet.add(Taglet.Location.METHOD);
        hashSet.add(Taglet.Location.OVERVIEW);
        hashSet.add(Taglet.Location.PACKAGE);
        hashSet.add(Taglet.Location.TYPE);
        return hashSet;
    }
}

