/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.procaddress;

import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.procaddress.ProcAddressEmitter;

public class ProcAddressCMethodBindingEmitter
extends CMethodBindingEmitter {
    private boolean callThroughProcAddress;
    private boolean hasProcAddrTypedef;
    private String localTypedefCallingConvention;
    private static final String procAddressJavaTypeName = JavaType.createForClass(Long.TYPE).jniTypeName();
    private ProcAddressEmitter emitter;

    public ProcAddressCMethodBindingEmitter(CMethodBindingEmitter cMethodBindingEmitter, final boolean bl, boolean bl2, String string, ProcAddressEmitter procAddressEmitter) {
        super(new MethodBinding(cMethodBindingEmitter.getBinding()){

            @Override
            public String getImplName() {
                if (bl) {
                    return "dispatch_" + super.getImplName();
                }
                return super.getImplName();
            }
        }, cMethodBindingEmitter.getUnit(), cMethodBindingEmitter.getJavaPackageName(), cMethodBindingEmitter.getJavaClassName(), cMethodBindingEmitter.getIsOverloadedBinding(), cMethodBindingEmitter.getIsJavaMethodStatic(), true, cMethodBindingEmitter.forIndirectBufferAndArrayImplementation(), cMethodBindingEmitter.getMachineDataInfo(), procAddressEmitter.getConfig());
        if (cMethodBindingEmitter.getReturnValueCapacityExpression() != null) {
            this.setReturnValueCapacityExpression(cMethodBindingEmitter.getReturnValueCapacityExpression());
        }
        if (cMethodBindingEmitter.getReturnValueLengthExpression() != null) {
            this.setReturnValueLengthExpression(cMethodBindingEmitter.getReturnValueLengthExpression());
        }
        this.setTemporaryCVariableDeclarations(cMethodBindingEmitter.getTemporaryCVariableDeclarations());
        this.setTemporaryCVariableAssignments(cMethodBindingEmitter.getTemporaryCVariableAssignments());
        this.setCommentEmitter(defaultCommentEmitter);
        this.callThroughProcAddress = bl;
        this.hasProcAddrTypedef = bl2;
        this.localTypedefCallingConvention = string;
        this.emitter = procAddressEmitter;
    }

    @Override
    protected int appendArguments(StringBuilder stringBuilder) {
        int n = super.appendArguments(stringBuilder);
        if (this.callThroughProcAddress) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(procAddressJavaTypeName);
            stringBuilder.append(" procAddress");
            ++n;
        }
        return n;
    }

    @Override
    protected void emitBodyVariableDeclarations() {
        if (this.callThroughProcAddress) {
            FunctionSymbol functionSymbol = this.binding.getCSymbol();
            String string = this.emitter.getFunctionPointerTypedefName(functionSymbol);
            String string2 = "_local_" + string;
            String string3 = this.hasProcAddrTypedef ? string : string2;
            PointerType pointerType = new PointerType(null, functionSymbol.getType(), 0);
            this.unit.emit("  typedef ");
            this.unit.emit(pointerType.toString(string2, this.localTypedefCallingConvention));
            this.unit.emitln(";");
            this.unit.emit("  ");
            this.unit.emit(string3);
            this.unit.emit(" ptr_");
            this.unit.emit(this.getNativeName());
            this.unit.emitln(";");
        }
        super.emitBodyVariableDeclarations();
    }

    @Override
    protected void emitBodyVariablePreCallSetup() {
        super.emitBodyVariablePreCallSetup();
        if (this.callThroughProcAddress) {
            String string = this.emitter.getFunctionPointerTypedefName(this.binding.getCSymbol());
            String string2 = "_local_" + string;
            String string3 = this.hasProcAddrTypedef ? string : string2;
            String string4 = "ptr_" + this.getNativeName();
            if (this.hasProcAddrTypedef) {
                this.unit.emitln("  // implicit type validation of " + string2 + " -> " + string3);
            }
            this.unit.emit("  ");
            this.unit.emit(string4);
            this.unit.emit(" = (");
            this.unit.emit(string2);
            this.unit.emitln(") (intptr_t) procAddress;");
            this.unit.emitln("  assert(" + string4 + " != NULL);");
        }
    }

    @Override
    protected void emitBodyCallCFunction() {
        if (!this.callThroughProcAddress) {
            super.emitBodyCallCFunction();
        } else {
            MethodBinding methodBinding;
            this.unit.emit("  ");
            Type type = this.binding.getCReturnType();
            if (!type.isVoid()) {
                this.unit.emit("_res = (");
                this.unit.emit(type.getCName(false));
                this.unit.emit(") ");
            }
            if ((methodBinding = this.getBinding()).hasContainingType()) {
                throw new IllegalStateException("Cannot call through function pointer because binding has containing type: " + methodBinding);
            }
            this.unit.emit("(* ptr_");
            this.unit.emit(this.getNativeName());
            this.unit.emit(") ");
            this.unit.emit("(");
            this.emitBodyPassCArguments();
            this.unit.emitln(");");
        }
    }

    @Override
    protected String jniMangle(MethodBinding methodBinding) {
        StringBuilder stringBuilder = new StringBuilder(super.jniMangle(methodBinding));
        if (this.callThroughProcAddress && 0 <= stringBuilder.indexOf("__")) {
            JavaType.appendJNIDescriptor(stringBuilder, Long.TYPE, false);
        }
        return stringBuilder.toString();
    }
}

