/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.jcpp.Argument;
import com.jogamp.gluegen.jcpp.Feature;
import com.jogamp.gluegen.jcpp.FileLexerSource;
import com.jogamp.gluegen.jcpp.FixedTokenSource;
import com.jogamp.gluegen.jcpp.InternalException;
import com.jogamp.gluegen.jcpp.JavaFileSystem;
import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.LexerSource;
import com.jogamp.gluegen.jcpp.Macro;
import com.jogamp.gluegen.jcpp.MacroTokenSource;
import com.jogamp.gluegen.jcpp.NumericValue;
import com.jogamp.gluegen.jcpp.PreprocessorCommand;
import com.jogamp.gluegen.jcpp.PreprocessorListener;
import com.jogamp.gluegen.jcpp.Source;
import com.jogamp.gluegen.jcpp.State;
import com.jogamp.gluegen.jcpp.StringLexerSource;
import com.jogamp.gluegen.jcpp.Token;
import com.jogamp.gluegen.jcpp.VirtualFile;
import com.jogamp.gluegen.jcpp.VirtualFileSystem;
import com.jogamp.gluegen.jcpp.Warning;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class Preprocessor
implements Closeable {
    private final Logging.LoggerIf LOG;
    private static final Source INTERNAL = new Source(){

        @Override
        public Token token() throws IOException, LexerException {
            throw new LexerException("Cannot read from " + this.getName());
        }

        @Override
        public String getPath() {
            return "<internal-data>";
        }

        @Override
        public String getName() {
            return "internal data";
        }
    };
    private static final Macro __LINE__ = new Macro(INTERNAL, "__LINE__");
    private static final Macro __FILE__ = new Macro(INTERNAL, "__FILE__");
    private static final Macro __COUNTER__ = new Macro(INTERNAL, "__COUNTER__");
    private final List<Source> inputs;
    private final Map<String, Macro> macros;
    private final Stack<State> states;
    private Source source;
    private int counter;
    private final Set<String> onceseenpaths = new HashSet<String>();
    private final List<VirtualFile> includes = new ArrayList<VirtualFile>();
    private List<String> quoteincludepath;
    private List<String> sysincludepath;
    private List<String> frameworkspath;
    private final Set<Feature> features;
    private final Set<Warning> warnings;
    private VirtualFileSystem filesystem;
    private PreprocessorListener listener;
    private Token source_token;
    @CheckForNull
    private Token expr_token = null;

    public Preprocessor() {
        this.LOG = Logging.getLogger(Preprocessor.class);
        this.inputs = new ArrayList<Source>();
        this.macros = new HashMap<String, Macro>();
        this.macros.put(__LINE__.getName(), __LINE__);
        this.macros.put(__FILE__.getName(), __FILE__);
        this.macros.put(__COUNTER__.getName(), __COUNTER__);
        this.states = new Stack();
        this.states.push(new State());
        this.source = null;
        this.counter = 0;
        this.quoteincludepath = new ArrayList<String>();
        this.sysincludepath = new ArrayList<String>();
        this.frameworkspath = new ArrayList<String>();
        this.features = EnumSet.noneOf(Feature.class);
        this.warnings = EnumSet.noneOf(Warning.class);
        this.filesystem = new JavaFileSystem();
        this.listener = null;
    }

    public Preprocessor(@Nonnull Source source) {
        this();
        this.addInput(source);
    }

    public Preprocessor(@Nonnull File file) throws IOException {
        this(new FileLexerSource(file));
    }

    public void setFileSystem(@Nonnull VirtualFileSystem virtualFileSystem) {
        this.filesystem = virtualFileSystem;
    }

    @Nonnull
    public VirtualFileSystem getFileSystem() {
        return this.filesystem;
    }

    public void setListener(@Nonnull PreprocessorListener preprocessorListener) {
        this.listener = preprocessorListener;
        for (Source source = this.source; source != null; source = source.getParent()) {
            source.init(this);
        }
    }

    @Nonnull
    public PreprocessorListener getListener() {
        return this.listener;
    }

    @Nonnull
    public Set<Feature> getFeatures() {
        return this.features;
    }

    public void addFeature(@Nonnull Feature feature) {
        this.features.add(feature);
    }

    public void addFeatures(@Nonnull Collection<Feature> collection) {
        this.features.addAll(collection);
    }

    public void addFeatures(Feature ... featureArray) {
        this.addFeatures(Arrays.asList(featureArray));
    }

    public boolean getFeature(@Nonnull Feature feature) {
        return this.features.contains((Object)feature);
    }

    @Nonnull
    public Set<Warning> getWarnings() {
        return this.warnings;
    }

    public void addWarning(@Nonnull Warning warning) {
        this.warnings.add(warning);
    }

    public void addWarnings(@Nonnull Collection<Warning> collection) {
        this.warnings.addAll(collection);
    }

    public boolean getWarning(@Nonnull Warning warning) {
        return this.warnings.contains((Object)warning);
    }

    public void addInput(@Nonnull Source source) {
        source.init(this);
        this.inputs.add(source);
    }

    public void addInput(@Nonnull File file) throws IOException {
        this.addInput(new FileLexerSource(file));
    }

    protected void error(int n, int n2, @Nonnull String string) throws LexerException {
        if (this.listener == null) {
            throw new LexerException("Error at " + n + ":" + n2 + ": " + string);
        }
        this.listener.handleError(this.source, n, n2, string);
    }

    protected void error(@Nonnull Token token, @Nonnull String string) throws LexerException {
        this.error(token.getLine(), token.getColumn(), string);
    }

    protected void warning(int n, int n2, @Nonnull String string) throws LexerException {
        if (this.warnings.contains((Object)Warning.ERROR)) {
            this.error(n, n2, string);
        } else if (this.listener != null) {
            this.listener.handleWarning(this.source, n, n2, string);
        } else {
            throw new LexerException("Warning at " + n + ":" + n2 + ": " + string);
        }
    }

    protected void warning(@Nonnull Token token, @Nonnull String string) throws LexerException {
        this.warning(token.getLine(), token.getColumn(), string);
    }

    public void addMacro(@Nonnull Macro macro) throws LexerException, IOException {
        String string = macro.getName();
        if ("defined".equals(string)) {
            throw new LexerException("Cannot redefine name 'defined'");
        }
        this.macros.put(macro.getName(), macro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(@Nonnull String string, @Nonnull String string2) throws LexerException {
        try {
            Macro macro = new Macro(string);
            try (StringLexerSource stringLexerSource = new StringLexerSource(string2);){
                Token token;
                while ((token = stringLexerSource.token()).getType() != 265) {
                    macro.addToken(token);
                }
            }
            this.addMacro(macro);
        }
        catch (IOException iOException) {
            throw new LexerException(iOException);
        }
    }

    public void addMacro(@Nonnull String string) throws LexerException {
        this.addMacro(string, "1");
    }

    public void setQuoteIncludePath(@Nonnull List<String> list) {
        this.quoteincludepath = list;
    }

    @Nonnull
    public List<String> getQuoteIncludePath() {
        return this.quoteincludepath;
    }

    public void setSystemIncludePath(@Nonnull List<String> list) {
        this.sysincludepath = list;
    }

    @Nonnull
    public List<String> getSystemIncludePath() {
        return this.sysincludepath;
    }

    public void setFrameworksPath(@Nonnull List<String> list) {
        this.frameworkspath = list;
    }

    @Nonnull
    public List<String> getFrameworksPath() {
        return this.frameworkspath;
    }

    @Nonnull
    public Map<String, Macro> getMacros() {
        return this.macros;
    }

    public List<Macro> getMacros(boolean bl) throws IOException, LexerException {
        ArrayList<Macro> arrayList = new ArrayList<Macro>();
        Collection<Macro> collection = this.macros.values();
        for (Macro macro : collection) {
            if (bl && !macro.isFunctionLike()) {
                arrayList.add(new Macro(macro, this.expand(macro.getTokens())));
                continue;
            }
            arrayList.add(new Macro(macro));
        }
        return arrayList;
    }

    @CheckForNull
    public Macro getMacro(@Nonnull String string) {
        return this.macros.get(string);
    }

    @Nonnull
    public List<? extends VirtualFile> getIncludes() {
        return this.includes;
    }

    private void push_state() {
        State state = this.states.peek();
        this.states.push(new State(state));
    }

    private void pop_state() throws LexerException {
        State state = this.states.pop();
        if (this.states.isEmpty()) {
            this.error(0, 0, "#endif without #if");
            this.states.push(state);
        }
    }

    private boolean isActive() {
        State state = this.states.peek();
        return state.isParentActive() && state.isActive();
    }

    public Source getSource() {
        return this.source;
    }

    protected void push_source(@Nonnull Source source, boolean bl) {
        source.init(this);
        source.setParent(this.source, bl);
        if (this.listener != null) {
            this.listener.handleSourceChange(this.source, PreprocessorListener.SourceChangeEvent.SUSPEND);
        }
        this.source = source;
        if (this.listener != null) {
            this.listener.handleSourceChange(this.source, PreprocessorListener.SourceChangeEvent.PUSH);
        }
    }

    @CheckForNull
    protected Token pop_source(boolean bl) throws IOException {
        if (this.listener != null) {
            this.listener.handleSourceChange(this.source, PreprocessorListener.SourceChangeEvent.POP);
        }
        Source source = this.source;
        this.source = source.getParent();
        source.close();
        if (this.listener != null && this.source != null) {
            this.listener.handleSourceChange(this.source, PreprocessorListener.SourceChangeEvent.RESUME);
        }
        Source source2 = this.getSource();
        if (this.getFeature(Feature.LINEMARKERS) && source.isNumbered() && source2 != null) {
            return this.line_token(source2.getLine(), source2.getName(), " 2");
        }
        return null;
    }

    protected void pop_source() throws IOException {
        this.pop_source(false);
    }

    @Nonnull
    private Token next_source() {
        if (this.inputs.isEmpty()) {
            return new Token(265);
        }
        Source source = this.inputs.remove(0);
        this.push_source(source, true);
        return this.line_token(source.getLine(), source.getName(), " 1");
    }

    @Nonnull
    private Token line_token(int n, @CheckForNull String string, @Nonnull String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#line ").append(n).append(" \"");
        if (string == null) {
            stringBuilder.append("<no file>");
        } else if (File.separatorChar != '/' && this.getFeature(Feature.UNIFIED_OUTPUT)) {
            MacroTokenSource.escape(stringBuilder, string.replaceAll(Matcher.quoteReplacement(File.separator), "/"));
        } else {
            MacroTokenSource.escape(stringBuilder, string);
        }
        stringBuilder.append("\"").append(string2).append("\n");
        return new Token(299, n, 0, stringBuilder.toString(), null);
    }

    @Nonnull
    private Token source_token() throws IOException, LexerException {
        Token token;
        block5: {
            Token token2;
            if (this.source_token != null) {
                Token token3 = this.source_token;
                this.source_token = null;
                if (this.getFeature(Feature.DEBUG)) {
                    this.LOG.debug("Returning unget token " + token3);
                }
                return token3;
            }
            while (true) {
                Source source;
                if ((source = this.getSource()) == null) {
                    token = this.next_source();
                    if (token.getType() == 299 && !this.getFeature(Feature.LINEMARKERS)) continue;
                    return token;
                }
                token = source.token();
                if (token.getType() != 265 || !source.isAutopop()) break block5;
                token2 = this.pop_source(true);
                if (token2 != null) break;
            }
            return token2;
        }
        if (this.getFeature(Feature.DEBUG)) {
            this.LOG.debug("Returning fresh token " + token);
        }
        return token;
    }

    private void source_untoken(Token token) {
        if (this.source_token != null) {
            throw new IllegalStateException("Cannot return two tokens");
        }
        this.source_token = token;
    }

    private boolean isWhite(Token token) {
        int n = token.getType();
        return n == 294 || n == 260 || n == 261;
    }

    private Token source_token_nonwhite() throws IOException, LexerException {
        Token token;
        while (this.isWhite(token = this.source_token())) {
        }
        return token;
    }

    private Token source_skipline(boolean bl) throws IOException, LexerException {
        Token token;
        Source source = this.getSource();
        Token token2 = source.skipline(bl);
        if (token2.getType() == 265 && source.isAutopop() && (token = this.pop_source(true)) != null) {
            return token;
        }
        return token2;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean macro(Macro var1_1, Token var2_2) throws IOException, LexerException {
        block37: {
            block34: {
                block35: {
                    block36: {
                        if (!var1_1.isFunctionLike()) break block34;
                        block15: while (true) {
                            var3_3 = this.source_token();
                            switch (var3_3.getType()) {
                                case 260: 
                                case 261: 
                                case 284: 
                                case 294: {
                                    continue block15;
                                }
                                case 40: {
                                    break block15;
                                }
                                default: {
                                    this.source_untoken(var3_3);
                                    return false;
                                }
                            }
                            break;
                        }
                        var3_3 = this.source_token_nonwhite();
                        if (var3_3.getType() == 41 && var1_1.getArgs() <= 0) break block35;
                        var4_4 = new ArrayList<Serializable>();
                        var5_5 = new Argument();
                        var6_7 = 0;
                        var7_9 = 0;
                        block16: while (true) {
                            switch (var3_3.getType()) {
                                case 265: {
                                    this.error(var3_3, "EOF in macro args");
                                    return false;
                                }
                                case 44: {
                                    if (var6_7 == 0) {
                                        if (var1_1.isVariadic() && var4_4.size() == var1_1.getArgs() - 1) {
                                            var5_5.addToken(var3_3);
                                        } else {
                                            var4_4.add(var5_5);
                                            var5_5 = new Argument();
                                        }
                                    } else {
                                        var5_5.addToken(var3_3);
                                    }
                                    var7_9 = 0;
                                    break;
                                }
                                case 41: {
                                    if (var6_7 == 0) {
                                        var4_4.add(var5_5);
                                        break block16;
                                    }
                                    --var6_7;
                                    var5_5.addToken(var3_3);
                                    var7_9 = 0;
                                    break;
                                }
                                case 40: {
                                    ++var6_7;
                                    var5_5.addToken(var3_3);
                                    var7_9 = 0;
                                    break;
                                }
                                case 260: 
                                case 261: 
                                case 284: 
                                case 294: {
                                    var7_9 = 1;
                                    break;
                                }
                                default: {
                                    if (var7_9 != 0 && !var5_5.isEmpty()) {
                                        var5_5.addToken(Token.space);
                                    }
                                    var5_5.addToken(var3_3);
                                    var7_9 = 0;
                                }
                            }
                            var3_3 = this.source_token();
                        }
                        if (var4_4.size() == var1_1.getArgs()) break block36;
                        if (!var1_1.isVariadic()) ** GOTO lbl67
                        if (var4_4.size() == var1_1.getArgs() - 1) {
                            var4_4.add(new Argument());
                        } else {
                            this.error(var3_3, "variadic macro " + var1_1.getName() + " has at least " + (var1_1.getArgs() - 1) + " parameters but given " + var4_4.size() + " args");
                            return false;
lbl67:
                            // 1 sources

                            this.error(var3_3, "macro " + var1_1.getName() + " has " + var1_1.getArgs() + " parameters but given " + var4_4.size() + " args");
                            return false;
                        }
                    }
                    for (Argument var9_13 : var4_4) {
                        var9_13.expand(this);
                    }
                    break block37;
                }
                var4_4 = null;
                break block37;
            }
            var4_4 = null;
        }
        if (var1_1 == Preprocessor.__LINE__) {
            this.push_source(new FixedTokenSource(new Token[]{new Token(272, var2_2.getLine(), var2_2.getColumn(), Integer.toString(var2_2.getLine()), new NumericValue(10, Integer.toString(var2_2.getLine())))}), true);
        } else if (var1_1 == Preprocessor.__FILE__) {
            var5_5 = new StringBuilder("\"");
            var6_8 = this.getSource().getName();
            if (var6_8 == null) {
                var6_8 = "<no file>";
            }
            block18: for (var7_9 = 0; var7_9 < var6_8.length(); ++var7_9) {
                var8_12 = var6_8.charAt(var7_9);
                switch (var8_12) {
                    case '\\': {
                        var5_5.append("\\\\");
                        continue block18;
                    }
                    case '\"': {
                        var5_5.append("\\\"");
                        continue block18;
                    }
                    default: {
                        var5_5.append(var8_12);
                    }
                }
            }
            var5_5.append("\"");
            var7_10 = var5_5.toString();
            this.push_source(new FixedTokenSource(new Token[]{new Token(292, var2_2.getLine(), var2_2.getColumn(), var7_10, var7_10)}), true);
        } else if (var1_1 == Preprocessor.__COUNTER__) {
            var5_6 = this.counter++;
            this.push_source(new FixedTokenSource(new Token[]{new Token(272, var2_2.getLine(), var2_2.getColumn(), Integer.toString(var5_6), new NumericValue(10, Integer.toString(var5_6)))}), true);
        } else {
            this.push_source(new MacroTokenSource(var1_1, var4_4), true);
        }
        return true;
    }

    @Nonnull
    List<Token> expand(@Nonnull List<Token> list) throws IOException, LexerException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        boolean bl = false;
        this.push_source(new FixedTokenSource(list), false);
        block4: while (true) {
            Token token = this.expanded_token();
            switch (token.getType()) {
                case 265: {
                    break block4;
                }
                case 260: 
                case 261: 
                case 294: {
                    bl = true;
                    continue block4;
                }
                default: {
                    if (bl && !arrayList.isEmpty()) {
                        arrayList.add(Token.space);
                    }
                    arrayList.add(token);
                    bl = false;
                    continue block4;
                }
            }
            break;
        }
        this.pop_source(false);
        return arrayList;
    }

    private Token define() throws IOException, LexerException {
        List<String> list;
        Token token = this.source_token_nonwhite();
        if (token.getType() != 270) {
            this.error(token, "Expected identifier");
            return this.source_skipline(false);
        }
        String string = token.getText();
        if ("defined".equals(string)) {
            this.error(token, "Cannot redefine name 'defined'");
            return this.source_skipline(false);
        }
        Macro macro = new Macro(this.getSource(), string);
        token = this.source_token();
        if (token.getType() == 40) {
            block34: {
                token = this.source_token_nonwhite();
                if (token.getType() != 41) {
                    list = new ArrayList();
                    while (true) {
                        switch (token.getType()) {
                            case 270: {
                                list.add(token.getText());
                                break;
                            }
                            case 264: {
                                list.add("__VA_ARGS__");
                                this.source_untoken(token);
                                break;
                            }
                            case 265: 
                            case 284: {
                                this.error(token, "Unterminated macro parameter list");
                                return token;
                            }
                            default: {
                                this.error(token, "error in macro parameters: " + token.getText());
                                return this.source_skipline(false);
                            }
                        }
                        token = this.source_token_nonwhite();
                        switch (token.getType()) {
                            case 44: {
                                break;
                            }
                            case 264: {
                                token = this.source_token_nonwhite();
                                if (token.getType() != 41) {
                                    this.error(token, "ellipsis must be on last argument");
                                }
                                macro.setVariadic(true);
                                break block34;
                            }
                            case 41: {
                                break block34;
                            }
                            case 265: 
                            case 284: {
                                this.error(token, "Unterminated macro parameters");
                                return token;
                            }
                            default: {
                                this.error(token, "Bad token in macro parameters: " + token.getText());
                                return this.source_skipline(false);
                            }
                        }
                        token = this.source_token_nonwhite();
                    }
                }
                assert (token.getType() == 41) : "Expected ')'";
                list = Collections.emptyList();
            }
            macro.setArgs(list);
        } else {
            list = Collections.emptyList();
            this.source_untoken(token);
        }
        boolean bl = false;
        boolean bl2 = false;
        token = this.source_token_nonwhite();
        block20: while (true) {
            switch (token.getType()) {
                case 265: {
                    break block20;
                }
                case 284: {
                    break block20;
                }
                case 260: 
                case 261: 
                case 294: {
                    if (bl2) break;
                    bl = true;
                    break;
                }
                case 286: {
                    bl = false;
                    bl2 = true;
                    macro.addPaste(new Token(297, token.getLine(), token.getColumn(), "##", null));
                    break;
                }
                case 35: {
                    int n;
                    if (bl) {
                        macro.addToken(Token.space);
                    }
                    bl = false;
                    Token token2 = this.source_token_nonwhite();
                    if (token2.getType() == 270 && (n = list.indexOf(token2.getText())) != -1) {
                        macro.addToken(new Token(298, token2.getLine(), token2.getColumn(), "#" + token2.getText(), n));
                        break;
                    }
                    macro.addToken(token);
                    this.source_untoken(token2);
                    break;
                }
                case 270: {
                    if (bl) {
                        macro.addToken(Token.space);
                    }
                    bl = false;
                    bl2 = false;
                    int n = list.indexOf(token.getText());
                    if (n == -1) {
                        macro.addToken(token);
                        break;
                    }
                    macro.addToken(new Token(296, token.getLine(), token.getColumn(), token.getText(), n));
                    break;
                }
                default: {
                    if (bl) {
                        macro.addToken(Token.space);
                    }
                    bl = false;
                    bl2 = false;
                    macro.addToken(token);
                }
            }
            token = this.source_token();
        }
        if (this.getFeature(Feature.DEBUG)) {
            this.LOG.debug("Defined macro " + macro);
        }
        this.addMacro(macro);
        return token;
    }

    @Nonnull
    private Token undef() throws IOException, LexerException {
        Token token = this.source_token_nonwhite();
        if (token.getType() != 270) {
            this.error(token, "Expected identifier, not " + token.getText());
            if (token.getType() == 284 || token.getType() == 265) {
                return token;
            }
        } else {
            Macro macro = this.getMacro(token.getText());
            if (macro != null) {
                this.macros.remove(macro.getName());
            }
        }
        return this.source_skipline(true);
    }

    protected boolean include(@Nonnull VirtualFile virtualFile) throws IOException {
        if (!virtualFile.isFile()) {
            return false;
        }
        if (this.getFeature(Feature.DEBUG)) {
            this.LOG.debug("pp: including " + virtualFile);
        }
        this.includes.add(virtualFile);
        this.push_source(virtualFile.getSource(), true);
        return true;
    }

    protected boolean include(@Nonnull Iterable<String> iterable, @Nonnull String string) throws IOException {
        for (String string2 : iterable) {
            VirtualFile virtualFile = this.getFileSystem().getFile(string2, string);
            if (!this.include(virtualFile)) continue;
            return true;
        }
        return false;
    }

    private void include(@CheckForNull String string, int n, @Nonnull String string2, boolean bl, boolean bl2) throws IOException, LexerException {
        if (string2.startsWith("/")) {
            VirtualFile virtualFile = this.filesystem.getFile(string2);
            if (this.include(virtualFile)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("File not found: ").append(string2);
            this.error(n, 0, stringBuilder.toString());
            return;
        }
        VirtualFile virtualFile = null;
        if (bl) {
            VirtualFile virtualFile2;
            if (string != null) {
                virtualFile2 = this.filesystem.getFile(string);
                virtualFile = virtualFile2.getParentFile();
            }
            if (virtualFile != null && this.include(virtualFile2 = virtualFile.getChildFile(string2))) {
                return;
            }
            if (this.include(this.quoteincludepath, string2)) {
                return;
            }
        } else {
            int n2 = string2.indexOf(47);
            if (n2 != -1) {
                Iterator<String> iterator = string2.substring(0, n2);
                String string3 = string2.substring(n2 + 1);
                String string4 = (String)((Object)iterator) + ".framework/Headers/" + string3;
                if (this.include(this.frameworkspath, string4)) {
                    return;
                }
            }
        }
        if (this.include(this.sysincludepath, string2)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File not found: ").append(string2);
        stringBuilder.append(" in");
        if (bl) {
            stringBuilder.append(" .").append('(').append(virtualFile).append(')');
            for (String string3 : this.quoteincludepath) {
                stringBuilder.append(" ").append(string3);
            }
        }
        for (String string3 : this.sysincludepath) {
            stringBuilder.append(" ").append(string3);
        }
        this.error(n, 0, stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Token include(boolean bl) throws IOException, LexerException {
        LexerSource lexerSource = (LexerSource)this.source;
        try {
            boolean bl2;
            String string;
            Object object;
            lexerSource.setInclude(true);
            Token token = this.token_nonwhite();
            if (token.getType() == 292) {
                object = new StringBuilder((String)token.getValue());
                block14: while (true) {
                    token = this.token_nonwhite();
                    switch (token.getType()) {
                        case 292: {
                            ((StringBuilder)object).append((String)token.getValue());
                            continue block14;
                        }
                        case 265: 
                        case 284: {
                            break block14;
                        }
                        default: {
                            this.warning(token, "Unexpected token on #include line");
                            Token token2 = this.source_skipline(false);
                            return token2;
                        }
                    }
                    break;
                }
                string = ((StringBuilder)object).toString();
                bl2 = true;
            } else if (token.getType() == 269) {
                string = (String)token.getValue();
                bl2 = false;
                token = this.source_skipline(true);
            } else {
                this.error(token, "Expected string or header, not " + token.getText());
                switch (token.getType()) {
                    case 265: 
                    case 284: {
                        Token token3 = token;
                        return token3;
                    }
                }
                Token token4 = this.source_skipline(false);
                return token4;
            }
            this.include(this.source.getPath(), token.getLine(), string, bl2, bl);
            if (this.getFeature(Feature.LINEMARKERS)) {
                object = this.line_token(1, this.source.getName(), " 1");
                return object;
            }
            object = token;
            return object;
        }
        finally {
            lexerSource.setInclude(false);
        }
    }

    protected void pragma_once(@Nonnull Token token) throws IOException, LexerException {
        Token token2;
        Source source = this.source;
        if (!this.onceseenpaths.add(source.getPath()) && (token2 = this.pop_source(true)) != null) {
            this.push_source(new FixedTokenSource(Arrays.asList(token2)), true);
        }
    }

    protected void pragma(@Nonnull Token token, @Nonnull List<Token> list) throws IOException, LexerException {
        if (this.getFeature(Feature.PRAGMA_ONCE) && "once".equals(token.getText())) {
            this.pragma_once(token);
            return;
        }
        this.warning(token, "Unknown #pragma: " + token.getText());
    }

    @Nonnull
    private Token pragma() throws IOException, LexerException {
        Token token;
        Token token2;
        block12: while (true) {
            token2 = this.source_token();
            switch (token2.getType()) {
                case 265: {
                    this.warning(token2, "End of file in #pragma");
                    return token2;
                }
                case 284: {
                    this.warning(token2, "Empty #pragma");
                    return token2;
                }
                case 260: 
                case 261: 
                case 294: {
                    continue block12;
                }
                case 270: {
                    token = token2;
                    break block12;
                }
                default: {
                    this.warning(token2, "Illegal #pragma " + token2.getText());
                    return this.source_skipline(false);
                }
            }
            break;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        block13: while (true) {
            token2 = this.source_token();
            switch (token2.getType()) {
                case 265: {
                    this.warning(token2, "End of file in #pragma");
                    break block13;
                }
                case 284: {
                    break block13;
                }
                case 260: 
                case 261: {
                    continue block13;
                }
                case 294: {
                    arrayList.add(token2);
                    continue block13;
                }
                default: {
                    arrayList.add(token2);
                    continue block13;
                }
            }
            break;
        }
        this.pragma(token, arrayList);
        return token2;
    }

    private void error(@Nonnull Token token, boolean bl) throws IOException, LexerException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#').append(token.getText()).append(' ');
        Token token2 = this.source_token_nonwhite();
        block3: while (true) {
            switch (token2.getType()) {
                case 265: 
                case 284: {
                    break block3;
                }
                default: {
                    stringBuilder.append(token2.getText());
                    token2 = this.source_token();
                    continue block3;
                }
            }
            break;
        }
        if (bl) {
            this.error(token, stringBuilder.toString());
        } else {
            this.warning(token, stringBuilder.toString());
        }
    }

    @Nonnull
    private Token expanded_token() throws IOException, LexerException {
        Token token;
        while ((token = this.source_token()).getType() == 270) {
            Macro macro = this.getMacro(token.getText());
            if (macro == null) {
                return token;
            }
            if (this.source.isExpanding(macro)) {
                return token;
            }
            if (this.macro(macro, token)) continue;
        }
        return token;
    }

    @Nonnull
    private Token expanded_token_nonwhite() throws IOException, LexerException {
        Token token;
        while (this.isWhite(token = this.expanded_token())) {
        }
        return token;
    }

    @Nonnull
    private Token expr_token() throws IOException, LexerException {
        Token token = this.expr_token;
        if (token != null) {
            this.expr_token = null;
        } else {
            token = this.expanded_token_nonwhite();
            if (token.getType() == 270 && token.getText().equals("defined")) {
                Token token2 = this.source_token_nonwhite();
                boolean bl = false;
                if (token2.getType() == 40) {
                    bl = true;
                    token2 = this.source_token_nonwhite();
                }
                if (token2.getType() != 270) {
                    this.error(token2, "defined() needs identifier, not " + token2.getText());
                    token = new Token(272, token2.getLine(), token2.getColumn(), "0", new NumericValue(10, "0"));
                } else {
                    token = this.macros.containsKey(token2.getText()) ? new Token(272, token2.getLine(), token2.getColumn(), "1", new NumericValue(10, "1")) : new Token(272, token2.getLine(), token2.getColumn(), "0", new NumericValue(10, "0"));
                }
                if (bl && (token2 = this.source_token_nonwhite()).getType() != 41) {
                    this.expr_untoken(token2);
                    this.error(token2, "Missing ) in defined(). Got " + token2.getText());
                }
            }
        }
        return token;
    }

    private void expr_untoken(@Nonnull Token token) throws LexerException {
        if (this.expr_token != null) {
            throw new InternalException("Cannot unget two expression tokens.");
        }
        this.expr_token = token;
    }

    private int expr_priority(@Nonnull Token token) {
        switch (token.getType()) {
            case 47: {
                return 11;
            }
            case 37: {
                return 11;
            }
            case 42: {
                return 11;
            }
            case 43: {
                return 10;
            }
            case 45: {
                return 10;
            }
            case 279: {
                return 9;
            }
            case 289: {
                return 9;
            }
            case 60: {
                return 8;
            }
            case 62: {
                return 8;
            }
            case 275: {
                return 8;
            }
            case 267: {
                return 8;
            }
            case 266: {
                return 7;
            }
            case 283: {
                return 7;
            }
            case 38: {
                return 6;
            }
            case 94: {
                return 5;
            }
            case 124: {
                return 4;
            }
            case 273: {
                return 3;
            }
            case 277: {
                return 2;
            }
            case 63: {
                return 1;
            }
        }
        return 0;
    }

    private int expr_char(Token token) {
        Object object = token.getValue();
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        String string = String.valueOf(object);
        if (string.length() == 0) {
            return 0;
        }
        return string.charAt(0);
    }

    private long expr(int n) throws IOException, LexerException {
        Object object;
        long l;
        block35: {
            Token token = this.expr_token();
            switch (token.getType()) {
                case 40: {
                    l = this.expr(0);
                    token = this.expr_token();
                    if (token.getType() == 41) break;
                    this.expr_untoken(token);
                    this.error(token, "Missing ) in expression. Got " + token.getText());
                    return 0L;
                }
                case 126: {
                    l = this.expr(11) ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case 33: {
                    l = this.expr(11) == 0L ? 1L : 0L;
                    break;
                }
                case 45: {
                    l = -this.expr(11);
                    break;
                }
                case 272: {
                    object = (NumericValue)token.getValue();
                    l = ((NumericValue)object).longValue();
                    break;
                }
                case 259: {
                    l = this.expr_char(token);
                    break;
                }
                case 270: {
                    if (this.warnings.contains((Object)Warning.UNDEF)) {
                        this.warning(token, "Undefined token '" + token.getText() + "' encountered in conditional.");
                    }
                    l = 0L;
                    break;
                }
                default: {
                    this.expr_untoken(token);
                    this.error(token, "Bad token in expression: " + token.getText());
                    return 0L;
                }
            }
            block30: while (true) {
                int n2;
                if ((n2 = this.expr_priority((Token)(object = this.expr_token()))) == 0 || n >= n2) break block35;
                long l2 = this.expr(n2);
                switch (((Token)object).getType()) {
                    case 47: {
                        if (l2 == 0L) {
                            this.error((Token)object, "Division by zero");
                            l = 0L;
                            continue block30;
                        }
                        l /= l2;
                        continue block30;
                    }
                    case 37: {
                        if (l2 == 0L) {
                            this.error((Token)object, "Modulus by zero");
                            l = 0L;
                            continue block30;
                        }
                        l %= l2;
                        continue block30;
                    }
                    case 42: {
                        l *= l2;
                        continue block30;
                    }
                    case 43: {
                        l += l2;
                        continue block30;
                    }
                    case 45: {
                        l -= l2;
                        continue block30;
                    }
                    case 60: {
                        l = l < l2 ? 1L : 0L;
                        continue block30;
                    }
                    case 62: {
                        l = l > l2 ? 1L : 0L;
                        continue block30;
                    }
                    case 38: {
                        l &= l2;
                        continue block30;
                    }
                    case 94: {
                        l ^= l2;
                        continue block30;
                    }
                    case 124: {
                        l |= l2;
                        continue block30;
                    }
                    case 279: {
                        l <<= (int)l2;
                        continue block30;
                    }
                    case 289: {
                        l >>= (int)l2;
                        continue block30;
                    }
                    case 275: {
                        l = l <= l2 ? 1L : 0L;
                        continue block30;
                    }
                    case 267: {
                        l = l >= l2 ? 1L : 0L;
                        continue block30;
                    }
                    case 266: {
                        l = l == l2 ? 1L : 0L;
                        continue block30;
                    }
                    case 283: {
                        l = l != l2 ? 1L : 0L;
                        continue block30;
                    }
                    case 273: {
                        l = l != 0L && l2 != 0L ? 1L : 0L;
                        continue block30;
                    }
                    case 277: {
                        l = l != 0L || l2 != 0L ? 1L : 0L;
                        continue block30;
                    }
                    case 63: {
                        token = this.expr_token();
                        if (token.getType() != 58) {
                            this.expr_untoken(token);
                            this.error(token, "Missing : in conditional expression. Got " + token.getText());
                            return 0L;
                        }
                        long l3 = this.expr(0);
                        l = l != 0L ? l2 : l3;
                        continue block30;
                    }
                }
                break;
            }
            this.error((Token)object, "Unexpected operator " + ((Token)object).getText());
            return 0L;
        }
        this.expr_untoken((Token)object);
        return l;
    }

    @Nonnull
    private Token toWhitespace(@Nonnull Token token) {
        String string = token.getText();
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    bl = true;
                    ++n2;
                    continue block5;
                }
                case '\n': {
                    if (bl) {
                        bl = false;
                        continue block5;
                    }
                }
                case '\u000b': 
                case '\f': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    bl = false;
                    ++n2;
                }
            }
        }
        char[] cArray = new char[n2];
        Arrays.fill(cArray, '\n');
        return new Token(294, token.getLine(), token.getColumn(), new String(cArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Token _token() throws IOException, LexerException {
        block38: while (true) {
            Token token;
            Object object;
            Object object2;
            if (!this.isActive()) {
                object2 = this.getSource();
                if (object2 == null) {
                    object = this.next_source();
                    if (((Token)object).getType() == 299 && !this.getFeature(Feature.LINEMARKERS)) continue;
                    return object;
                }
                try {
                    ((Source)object2).setActive(false);
                    token = this.source_token();
                }
                finally {
                    ((Source)object2).setActive(true);
                }
                switch (token.getType()) {
                    case 265: 
                    case 268: 
                    case 284: {
                        break;
                    }
                    case 294: {
                        return token;
                    }
                    case 260: 
                    case 261: {
                        if (this.getFeature(Feature.KEEPALLCOMMENTS)) {
                            return token;
                        }
                        if (!this.isActive()) {
                            return this.toWhitespace(token);
                        }
                        if (this.getFeature(Feature.KEEPCOMMENTS)) {
                            return token;
                        }
                        return this.toWhitespace(token);
                    }
                    default: {
                        return this.source_skipline(false);
                    }
                }
            } else {
                token = this.source_token();
            }
            block6 : switch (token.getType()) {
                case 265: {
                    return token;
                }
                case 284: 
                case 294: {
                    return token;
                }
                case 260: 
                case 261: {
                    return token;
                }
                case 33: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 257: 
                case 258: 
                case 259: 
                case 262: 
                case 263: 
                case 264: 
                case 266: 
                case 267: 
                case 269: 
                case 271: 
                case 273: 
                case 275: 
                case 277: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 292: 
                case 293: 
                case 295: {
                    return token;
                }
                case 272: {
                    return token;
                }
                case 270: {
                    object2 = this.getMacro(token.getText());
                    if (object2 == null) {
                        return token;
                    }
                    if (this.source.isExpanding((Macro)object2)) {
                        return token;
                    }
                    if (this.macro((Macro)object2, token)) continue block38;
                    return token;
                }
                case 299: {
                    if (!this.getFeature(Feature.LINEMARKERS)) continue block38;
                    return token;
                }
                case 300: {
                    if (this.getFeature(Feature.CSYNTAX)) {
                        this.error(token, String.valueOf(token.getValue()));
                    }
                    return token;
                }
                default: {
                    throw new InternalException("Bad token " + token);
                }
                case 268: {
                    token = this.source_token_nonwhite();
                    switch (token.getType()) {
                        case 284: {
                            break block6;
                        }
                        case 270: {
                            break;
                        }
                        default: {
                            this.error(token, "Preprocessor directive not a word " + token.getText());
                            return this.source_skipline(false);
                        }
                    }
                    object = PreprocessorCommand.forText(token.getText());
                    if (object == null) {
                        this.error(token, "Unknown preprocessor directive " + token.getText());
                        return this.source_skipline(false);
                    }
                    switch (2.$SwitchMap$com$jogamp$gluegen$jcpp$PreprocessorCommand[((Enum)object).ordinal()]) {
                        case 1: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.define();
                        }
                        case 2: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.undef();
                        }
                        case 3: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.include(false);
                        }
                        case 4: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            if (!this.getFeature(Feature.INCLUDENEXT)) {
                                this.error(token, "Directive include_next not enabled");
                                return this.source_skipline(false);
                            }
                            return this.include(true);
                        }
                        case 5: 
                        case 6: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            this.error(token, object == PreprocessorCommand.PP_ERROR);
                            break block6;
                        }
                        case 7: {
                            this.push_state();
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            this.expr_token = null;
                            this.states.peek().setActive(this.expr(0) != 0L);
                            token = this.expr_token();
                            if (token.getType() == 284) {
                                return token;
                            }
                            return this.source_skipline(true);
                        }
                        case 8: {
                            State state = this.states.peek();
                            if (state.sawElse()) {
                                this.error(token, "#elif after #else");
                                return this.source_skipline(false);
                            }
                            if (!state.isParentActive()) {
                                return this.source_skipline(false);
                            }
                            if (state.isActive()) {
                                state.setParentActive(false);
                                state.setActive(false);
                                return this.source_skipline(false);
                            }
                            this.expr_token = null;
                            state.setActive(this.expr(0) != 0L);
                            token = this.expr_token();
                            if (token.getType() == 284) {
                                return token;
                            }
                            return this.source_skipline(true);
                        }
                        case 9: {
                            State state = this.states.peek();
                            if (state.sawElse()) {
                                this.error(token, "#else after #else");
                                return this.source_skipline(false);
                            }
                            state.setSawElse();
                            state.setActive(!state.isActive());
                            return this.source_skipline(this.warnings.contains((Object)Warning.ENDIF_LABELS));
                        }
                        case 10: {
                            this.push_state();
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            token = this.source_token_nonwhite();
                            if (token.getType() != 270) {
                                this.error(token, "Expected identifier, not " + token.getText());
                                return this.source_skipline(false);
                            }
                            String string = token.getText();
                            boolean bl = this.macros.containsKey(string);
                            this.states.peek().setActive(bl);
                            return this.source_skipline(true);
                        }
                        case 11: {
                            String string;
                            boolean bl;
                            this.push_state();
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            token = this.source_token_nonwhite();
                            if (token.getType() != 270) {
                                this.error(token, "Expected identifier, not " + token.getText());
                                return this.source_skipline(false);
                            }
                            this.states.peek().setActive(!(bl = this.macros.containsKey(string = token.getText())));
                            return this.source_skipline(true);
                        }
                        case 12: {
                            this.pop_state();
                            return this.source_skipline(this.warnings.contains((Object)Warning.ENDIF_LABELS));
                        }
                        case 13: {
                            return this.source_skipline(false);
                        }
                        case 14: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.pragma();
                        }
                    }
                    throw new InternalException("Internal error: Unknown directive " + token);
                }
            }
        }
    }

    @Nonnull
    private Token token_nonwhite() throws IOException, LexerException {
        Token token;
        while (this.isWhite(token = this._token())) {
        }
        return token;
    }

    @Nonnull
    public Token token() throws IOException, LexerException {
        Token token = this._token();
        if (this.getFeature(Feature.DEBUG)) {
            this.LOG.debug("pp: Returning " + token);
        }
        return token;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Source source = this.getSource(); source != null; source = source.getParent()) {
            stringBuilder.append(" -> ").append(String.valueOf(source)).append("\n");
        }
        TreeMap<String, Macro> treeMap = new TreeMap<String, Macro>(this.getMacros());
        for (Macro macro : treeMap.values()) {
            stringBuilder.append("#").append("macro ").append(macro).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        for (Object object = this.source; object != null; object = ((Source)object).getParent()) {
            ((Source)object).close();
        }
        for (Source source : this.inputs) {
            source.close();
        }
    }
}

