/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.GenericCPP;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.jcpp.DefaultPreprocessorListener;
import com.jogamp.gluegen.jcpp.Feature;
import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.LexerSource;
import com.jogamp.gluegen.jcpp.Macro;
import com.jogamp.gluegen.jcpp.Preprocessor;
import com.jogamp.gluegen.jcpp.Source;
import com.jogamp.gluegen.jcpp.Token;
import com.jogamp.gluegen.jcpp.Warning;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class JCPP
implements GenericCPP {
    private final Logging.LoggerIf LOG = Logging.getLogger(JCPP.class);
    public final Preprocessor cpp;
    private OutputStream out;
    private final List<String> includePaths;
    private final boolean enableCopyOutput2Stderr;

    public JCPP(List<String> list, boolean bl, boolean bl2, boolean bl3) {
        this.setOut(System.out);
        this.includePaths = list;
        this.enableCopyOutput2Stderr = bl2;
        this.cpp = new Preprocessor();
        this.cpp.addFeature(Feature.DIGRAPHS);
        this.cpp.addFeature(Feature.TRIGRAPHS);
        this.cpp.addFeature(Feature.LINEMARKERS);
        this.cpp.addFeature(Feature.UNIFIED_OUTPUT);
        this.cpp.addFeature(Feature.CSYNTAX);
        this.cpp.addFeature(Feature.KEEPCOMMENTS);
        if (bl3) {
            this.cpp.addFeature(Feature.PRAGMA_ONCE);
        }
        this.cpp.addWarning(Warning.IMPORT);
        this.cpp.setListener(new DefaultPreprocessorListener(){

            @Override
            public void handleError(Source source, int n, int n2, String string) throws LexerException {
                super.handleError(source, n, n2, string);
                throw new GlueGenException(string, new ASTLocusTag(source.getPath(), n, n2, null));
            }
        });
        if (bl) {
            this.cpp.addFeature(Feature.DEBUG);
        }
        this.cpp.setSystemIncludePath(list);
        this.cpp.setQuoteIncludePath(list);
        if (this.cpp.getFeature(Feature.DEBUG)) {
            this.LOG.info("#include \"...\" search starts here:");
            for (String string : this.cpp.getQuoteIncludePath()) {
                this.LOG.info("  " + string);
            }
            this.LOG.info("#include <...> search starts here:");
            for (String string : this.cpp.getSystemIncludePath()) {
                this.LOG.info("  " + string);
            }
            this.LOG.info("End of search list.");
        }
    }

    @Override
    public void addDefine(String string, String string2) throws LexerException {
        this.cpp.addMacro(string, string2);
    }

    @Override
    public List<ConstantDefinition> getConstantDefinitions() throws GlueGenException {
        List<Macro> list;
        ArrayList<ConstantDefinition> arrayList = new ArrayList<ConstantDefinition>();
        try {
            list = this.cpp.getMacros(true);
        }
        catch (Throwable throwable) {
            throw new GlueGenException(throwable);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Macro macro = list.get(i);
            String string2 = macro.getName();
            if ("__GLUEGEN__".equals(string2) || macro.isFunctionLike() || !ConstantDefinition.isConstantExpression(string = macro.getText())) continue;
            Source source = macro.getSource();
            ASTLocusTag aSTLocusTag = new ASTLocusTag(null != source ? source.getPath() : "<programmatic>", null != source ? source.getLine() : -1, null != source ? source.getColumn() : -1, macro.toString());
            ConstantDefinition constantDefinition = new ConstantDefinition(macro.getName(), string, null, aSTLocusTag);
            arrayList.add(constantDefinition);
        }
        return arrayList;
    }

    @Override
    public String findFile(String string) {
        String string2 = File.separator;
        for (String string3 : this.includePaths) {
            String string4 = string3 + string2 + string;
            File file = new File(string4);
            if (!file.exists()) continue;
            return string4;
        }
        return null;
    }

    @Override
    public OutputStream out() {
        return this.out;
    }

    @Override
    public void setOut(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public void run(Reader reader, final String string) throws GlueGenException {
        PrintWriter printWriter = new PrintWriter(this.out);
        this.cpp.addInput(new LexerSource(reader, true){

            @Override
            public String getPath() {
                return string;
            }

            @Override
            public String getName() {
                return string;
            }

            public String toString() {
                return "file " + string;
            }
        });
        try {
            Token token;
            while ((token = this.cpp.token()) != null && token.getType() != 265) {
                String string2 = token.getText();
                printWriter.print(string2);
                if (!this.enableCopyOutput2Stderr) continue;
                System.err.print(string2);
                System.err.flush();
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            Source source;
            StringBuilder stringBuilder = new StringBuilder("Preprocessor failed:\n");
            for (source = this.cpp.getSource(); source != null; source = source.getParent()) {
                stringBuilder.append(" -> ").append(source).append("\n");
            }
            stringBuilder.append(" : {0}\n");
            this.LOG.log(Level.SEVERE, stringBuilder.toString(), (Object)exception);
            if (exception instanceof GlueGenException) {
                throw (GlueGenException)exception;
            }
            throw new GlueGenException("Preprocessor failed", new ASTLocusTag(null != source ? source.getPath() : "n/a", null != source ? source.getLine() : -1, null != source ? source.getColumn() : -1, null), exception);
        }
    }
}

