/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.InputLexerSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class FileLexerSource
extends InputLexerSource {
    private final String path;
    private final File file;

    public FileLexerSource(@Nonnull File file, @Nonnull Charset charset, @Nonnull String string) throws IOException {
        super(new FileInputStream(file), charset);
        this.file = file;
        this.path = string;
    }

    public FileLexerSource(@Nonnull File file, @Nonnull String string) throws IOException {
        this(file, Charset.defaultCharset(), string);
    }

    public FileLexerSource(@Nonnull File file, @Nonnull Charset charset) throws IOException {
        this(file, charset, file.getPath());
    }

    @Deprecated
    public FileLexerSource(@Nonnull File file) throws IOException {
        this(file, Charset.defaultCharset());
    }

    public FileLexerSource(@Nonnull String string, @Nonnull Charset charset) throws IOException {
        this(new File(string), charset, string);
    }

    @Deprecated
    public FileLexerSource(@Nonnull String string) throws IOException {
        this(string, Charset.defaultCharset());
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.getPath();
    }

    @Override
    public String toString() {
        return "file " + this.getPath();
    }
}

