/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.PreprocessorListener;
import com.jogamp.gluegen.jcpp.Source;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class DefaultPreprocessorListener
implements PreprocessorListener {
    private final Logging.LoggerIf LOG = Logging.getLogger(DefaultPreprocessorListener.class);
    private int errors;
    private int warnings;

    public DefaultPreprocessorListener() {
        this.clear();
    }

    public void clear() {
        this.errors = 0;
        this.warnings = 0;
    }

    @Nonnegative
    public int getErrors() {
        return this.errors;
    }

    @Nonnegative
    public int getWarnings() {
        return this.warnings;
    }

    protected void print(@Nonnull String string) {
        this.LOG.info(string);
    }

    @Override
    public void handleWarning(Source source, int n, int n2, String string) throws LexerException {
        ++this.warnings;
        this.print(source.getName() + ":" + n + ":" + n2 + ": warning: " + string);
    }

    @Override
    public void handleError(Source source, int n, int n2, String string) throws LexerException {
        ++this.errors;
        this.print(source.getName() + ":" + n + ":" + n2 + ": error: " + string);
    }

    @Override
    public void handleSourceChange(Source source, PreprocessorListener.SourceChangeEvent sourceChangeEvent) {
    }
}

