/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.DefaultPreprocessorListener;
import com.jogamp.gluegen.jcpp.Preprocessor;
import com.jogamp.gluegen.jcpp.Token;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.Path;

public class CppTask
extends Copy {
    private final Listener listener = new Listener();
    private final List<Macro> macros = new ArrayList<Macro>();
    private Path systemincludepath;
    private Path localincludepath;

    public void addMacro(Macro macro) {
        this.macros.add(macro);
    }

    public void addSystemincludepath(Path path) {
        if (this.systemincludepath == null) {
            this.systemincludepath = new Path(this.getProject());
        }
        this.systemincludepath.add(path);
    }

    public void addLocalincludepath(Path path) {
        if (this.localincludepath == null) {
            this.localincludepath = new Path(this.getProject());
        }
        this.localincludepath.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preprocess(File file, File file2) throws Exception {
        Object object;
        if (file == null) {
            throw new BuildException("Input not specified");
        }
        if (file2 == null) {
            throw new BuildException("Output not specified");
        }
        Preprocessor preprocessor = new Preprocessor();
        preprocessor.setListener(this.listener);
        Object object2 = this.macros.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            preprocessor.addMacro(((Macro)object).getName(), ((Macro)object).getValue());
        }
        if (this.systemincludepath != null) {
            preprocessor.setSystemIncludePath(Arrays.asList(this.systemincludepath.list()));
        }
        if (this.localincludepath != null) {
            preprocessor.setQuoteIncludePath(Arrays.asList(this.localincludepath.list()));
        }
        if (!((File)(object2 = file2.getParentFile())).exists()) {
            if (!((File)object2).mkdirs()) {
                throw new BuildException("Failed to make parent directory " + object2);
            }
        } else if (!((File)object2).isDirectory()) {
            throw new BuildException("Parent directory of output file " + file2 + " exists, but is not a directory.");
        }
        object = null;
        try {
            Token token;
            preprocessor.addInput(file);
            object = new FileWriter(file2);
            while ((token = preprocessor.token()) != null) {
                if (token.getType() == 265) {
                    break;
                }
                ((Writer)object).write(token.getText());
            }
        }
        finally {
            if (object != null) {
                try {
                    ((OutputStreamWriter)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void doFileOperations() {
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration enumeration = this.fileCopyMap.keys();
            while (enumeration.hasMoreElements()) {
                String[] stringArray;
                String string = (String)enumeration.nextElement();
                for (String string2 : stringArray = (String[])this.fileCopyMap.get(string)) {
                    Object object;
                    if (string.equals(string2)) {
                        this.log("Skipping self-copy of " + string, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Copying " + string + " to " + string2, this.verbosity);
                        File file = new File(string);
                        object = new File(string2);
                        this.preprocess(file, (File)object);
                    }
                    catch (Exception exception) {
                        object = "Failed to copy " + string + " to " + string2 + " due to " + exception.getMessage();
                        File file = new File(string2);
                        if (file.exists() && !file.delete()) {
                            object = (String)object + " and I couldn't delete the corrupt " + string2;
                        }
                        throw new BuildException((String)object, (Throwable)exception, this.getLocation());
                    }
                }
            }
        }
    }

    private class Listener
    extends DefaultPreprocessorListener {
        private Listener() {
        }

        @Override
        protected void print(String string) {
            CppTask.this.log(string);
        }
    }

    public static class Macro {
        private String name;
        private String value;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }
}

