/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import java.util.List;

public class FunctionSymbol
extends AliasedSymbol.AliasedSymbolImpl
implements TypeComparator.AliasedSemanticSymbol,
ASTLocusTag.ASTLocusTagProvider {
    private final FunctionType type;
    private final ASTLocusTag astLocus;

    public FunctionSymbol(String string, FunctionType functionType) {
        this(string, functionType, null);
    }

    public FunctionSymbol(String string, FunctionType functionType, ASTLocusTag aSTLocusTag) {
        super(string);
        this.type = functionType;
        this.astLocus = aSTLocusTag;
        this.addAliasedName(functionType.getCName());
    }

    public static FunctionSymbol cloneWithDeepAliases(FunctionSymbol functionSymbol) {
        return new FunctionSymbol(functionSymbol);
    }

    private FunctionSymbol(FunctionSymbol functionSymbol) {
        super(functionSymbol);
        this.type = functionSymbol.type;
        this.astLocus = functionSymbol.astLocus;
    }

    @Override
    public ASTLocusTag getASTLocusTag() {
        return this.astLocus;
    }

    public FunctionType getType() {
        return this.type;
    }

    public Type getReturnType() {
        return this.type.getReturnType();
    }

    public int getNumArguments() {
        return this.type.getNumArguments();
    }

    public String getArgumentName(int n) {
        return this.type.getArgumentName(n);
    }

    public Type getArgumentType(int n) {
        return this.type.getArgumentType(n);
    }

    public void addArgument(Type type, String string) {
        this.type.addArgument(type, string);
    }

    public String toString() {
        return this.getType().toString(this.getName(), false);
    }

    public String toString(boolean bl) {
        return this.getType().toString(this.getName(), bl);
    }

    public int hashCode() {
        if (this.getName() == null) {
            return 0;
        }
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FunctionSymbol)) {
            return false;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)object;
        if (this.getName() == null && functionSymbol.getName() != null) {
            return false;
        }
        return this.getName().equals(functionSymbol.getName());
    }

    @Override
    public int hashCodeSemantics() {
        return this.type.hashCodeSemantics();
    }

    @Override
    public final boolean equalSemantics(TypeComparator.SemanticEqualityOp semanticEqualityOp) {
        if (semanticEqualityOp == this) {
            return true;
        }
        if (!(semanticEqualityOp instanceof FunctionSymbol)) {
            return false;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)semanticEqualityOp;
        return this.type.equalSemantics(functionSymbol.type);
    }

    public static boolean containsExactly(List<FunctionSymbol> list, FunctionSymbol functionSymbol) {
        return FunctionSymbol.exactIndexOf(list, functionSymbol) >= 0;
    }

    public static int exactIndexOf(List<FunctionSymbol> list, FunctionSymbol functionSymbol) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FunctionSymbol functionSymbol2 = list.get(i);
            if ((null != functionSymbol || null != functionSymbol2) && (!functionSymbol.equals(functionSymbol2) || !functionSymbol.type.equals(functionSymbol2.type))) continue;
            return i;
        }
        return -1;
    }

    public boolean exactlyEqual(Object object) {
        if (!this.equals(object)) {
            return false;
        }
        return this.type.equals(((FunctionSymbol)object).type);
    }
}

