/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.CompoundTypeKind;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.MemoryLayoutType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.StructType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import com.jogamp.gluegen.cgram.types.UnionType;
import java.util.ArrayList;
import java.util.Set;

public abstract class CompoundType
extends MemoryLayoutType
implements Cloneable,
AliasedSymbol {
    private final String structName;
    private ArrayList<Field> fields;
    private boolean visiting;
    private boolean bodyParsed;

    @Override
    public void rename(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAliasedName(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasAliases() {
        return false;
    }

    @Override
    public Set<String> getAliasedNames() {
        return null;
    }

    @Override
    public String getAliasedString() {
        return this.toString();
    }

    @Override
    public String getOrigName() {
        return this.getName();
    }

    public static CompoundType create(String string, SizeThunk sizeThunk, CompoundTypeKind compoundTypeKind, int n, ASTLocusTag aSTLocusTag) {
        CompoundType compoundType;
        switch (compoundTypeKind) {
            case STRUCT: {
                compoundType = new StructType(null, sizeThunk, n, string, aSTLocusTag);
                break;
            }
            case UNION: {
                compoundType = new UnionType(null, sizeThunk, n, string, aSTLocusTag);
                break;
            }
            default: {
                throw new RuntimeException("OO relation " + (Object)((Object)compoundTypeKind) + " / Compount not yet supported");
            }
        }
        return compoundType;
    }

    CompoundType(String string, SizeThunk sizeThunk, int n, String string2, ASTLocusTag aSTLocusTag) {
        super(null == string ? string2 : string, sizeThunk, n, aSTLocusTag);
        this.structName = string2;
    }

    CompoundType(CompoundType compoundType, int n, ASTLocusTag aSTLocusTag) {
        super(compoundType, n, aSTLocusTag);
        this.structName = compoundType.structName;
        if (null != compoundType.fields) {
            this.fields = new ArrayList<Field>(compoundType.fields);
        }
        this.bodyParsed = compoundType.bodyParsed;
    }

    @Override
    protected int hashCodeImpl() {
        int n = 31 + (null != this.structName ? this.structName.hashCode() : 0);
        return (n << 5) - n + TypeComparator.listsHashCode(this.fields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean equalsImpl(Type type) {
        CompoundType compoundType = (CompoundType)type;
        if (!(this.structName != null ? this.structName.equals(compoundType.structName) : compoundType.structName == null)) {
            if (this.structName == null) return false;
            if (!this.structName.equals(compoundType.structName)) return false;
        }
        if (!TypeComparator.listsEqual(this.fields, compoundType.fields)) return false;
        return true;
    }

    @Override
    protected int hashCodeSemanticsImpl() {
        return TypeComparator.listsHashCodeSemantics(this.fields);
    }

    @Override
    protected boolean equalSemanticsImpl(Type type) {
        CompoundType compoundType = (CompoundType)type;
        return TypeComparator.listsEqualSemantics(this.fields, compoundType.fields);
    }

    public String getStructName() {
        return this.structName;
    }

    @Override
    public CompoundType asCompound() {
        return this;
    }

    @Override
    public String getCName(boolean bl) {
        if (this.isTypedef()) {
            return this.getName(bl);
        }
        return (this.isStruct() ? "struct " : "union ") + this.getName(bl);
    }

    ArrayList<Field> getFields() {
        return this.fields;
    }

    void setFields(ArrayList<Field> arrayList) {
        this.fields = arrayList;
        this.clearCache();
    }

    public int getNumFields() {
        return this.fields == null ? 0 : this.fields.size();
    }

    public Field getField(int n) {
        return this.fields.get(n);
    }

    public Field getField(String string) {
        for (Field field : this.fields) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public void addField(Field field) {
        if (this.bodyParsed) {
            throw new IllegalStateException(String.format("Body of this CompoundType (%s) has been already closed (Field supplied %s)", this, field));
        }
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(field);
        this.clearCache();
    }

    public void setBodyParsed() throws IllegalStateException {
        if (this.bodyParsed) {
            throw new IllegalStateException(String.format("Body of this CompoundType (%s) has been already closed", this));
        }
        this.bodyParsed = true;
    }

    public abstract boolean isStruct();

    public abstract boolean isUnion();

    @Override
    public String toString() {
        String string = this.getCVAttributesString();
        String string2 = this.getCName();
        if (null != string2) {
            return string + string2;
        }
        if (this.getStructName() != null) {
            return string + "struct " + this.getStructName();
        }
        return string + this.getStructString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(TypeVisitor typeVisitor) {
        if (this.visiting) {
            return;
        }
        try {
            this.visiting = true;
            super.visit(typeVisitor);
            int n = this.getNumFields();
            for (int i = 0; i < n; ++i) {
                this.getField(i).getType().visit(typeVisitor);
            }
        }
        finally {
            this.visiting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStructString() {
        if (this.visiting) {
            if (this.getName() != null) {
                return this.getName();
            }
            return "struct {/*Recursive type reference*/}";
        }
        try {
            this.visiting = true;
            String string = this.isStruct() ? "struct {" : "union {";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            int n = this.getNumFields();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append(this.getField(i));
            }
            stringBuilder.append(" }");
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            this.visiting = false;
        }
    }
}

