/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ReferencedStructs
implements TypeVisitor {
    private final Map<String, Type> resultMap = new HashMap<String, Type>();
    private final Set<CompoundType> layoutSet = new HashSet<CompoundType>();
    private final Set<Type> skip = new HashSet<Type>();

    public void clear() {
        this.resultMap.clear();
    }

    public Iterator<Type> results() {
        return this.resultMap.values().iterator();
    }

    public Iterator<CompoundType> layouts() {
        return this.layoutSet.iterator();
    }

    @Override
    public void visitType(Type type) {
        if (this.skip.contains(type)) {
            return;
        }
        if (type.isPointer()) {
            PointerType pointerType = type.asPointer();
            CompoundType compoundType = pointerType.getTargetType().asCompound();
            if (pointerType.isTypedef() && null != compoundType) {
                this.skip.add(compoundType);
                this.resultMap.put(compoundType.getName(), pointerType);
                this.layoutSet.add(compoundType);
            }
        } else if (type.isCompound()) {
            if (!this.resultMap.containsKey(type.getName())) {
                this.resultMap.put(type.getName(), type);
            }
            this.layoutSet.add(type.asCompound());
        }
    }
}

