/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jogamp.common.Debug;

public class Logging {
    public static final boolean DEBUG = Debug.debug("Logging");
    private static final Map<String, LoggerIf> loggers = new HashMap<String, LoggerIf>();
    private static final FQNLogger rootPackageLogger;

    static void init() {
    }

    public static String getCanonicalName(Level level) {
        if (Level.CONFIG == level) {
            return "config";
        }
        if (Level.FINER == level) {
            return "verbose";
        }
        if (Level.FINE == level) {
            return "debug";
        }
        if (Level.INFO == level) {
            return "info";
        }
        if (Level.WARNING == level) {
            return "warning";
        }
        if (Level.SEVERE == level) {
            return "error";
        }
        return level.getName().toLowerCase();
    }

    public static LoggerIf getLogger() {
        return rootPackageLogger;
    }

    public static synchronized LoggerIf getLogger(Class<?> clazz) {
        return Logging.getLogger(clazz.getPackage().getName(), clazz.getSimpleName());
    }

    public static synchronized LoggerIf getLogger(String string, String string2) {
        String string3 = string + "." + string2;
        LoggerIf loggerIf = loggers.get(string3);
        if (null == loggerIf) {
            loggerIf = new FQNLogger(string3, string2, rootPackageLogger.getLevel());
            loggers.put(string3, loggerIf);
        }
        return loggerIf;
    }

    public static void alignLevel(LoggerIf loggerIf) {
        Logging.alignLevel(loggerIf, rootPackageLogger.getLevel());
    }

    public static void alignLevel(LoggerIf loggerIf, Level level) {
        loggerIf.setLevel(level);
        loggerIf.setLevelOfAllHandler(level);
    }

    static {
        String string = Logging.class.getPackage().getName();
        String string2 = PropertyAccess.getProperty(string + ".level", true);
        Level level = string2 != null ? Level.parse(string2) : (DEBUG || GlueGen.debug() ? Level.ALL : Level.WARNING);
        String string3 = Logging.class.getSimpleName();
        String string4 = string + "." + string3;
        rootPackageLogger = new FQNLogger(string4, string3, level);
        loggers.put(string4, rootPackageLogger);
    }

    static class FQNLogger
    implements LoggerIf {
        public final Logger impl;
        public final PlainLogConsoleHandler handler;

        FQNLogger(String string, String string2, Level level) {
            this.impl = Logger.getLogger(string);
            this.handler = new PlainLogConsoleHandler(new PlainLogFormatter(string2), Level.ALL);
            this.impl.setUseParentHandlers(false);
            this.impl.setLevel(level);
            this.impl.addHandler(this.handler);
            this.impl.log(Level.INFO, "Logging.new: " + this.impl.getName() + ": level " + level + ": obj 0x" + Integer.toHexString(this.impl.hashCode()));
        }

        @Override
        public void info(String string) {
            this.impl.info(string);
        }

        @Override
        public void info(ASTLocusTag aSTLocusTag, String string) {
            this.handler.plf.setASTLocusTag(aSTLocusTag);
            try {
                this.impl.info(string);
            }
            finally {
                this.handler.plf.setASTLocusTag(null);
            }
        }

        @Override
        public void warning(String string) {
            this.impl.warning(string);
        }

        @Override
        public void warning(ASTLocusTag aSTLocusTag, String string) {
            this.handler.plf.setASTLocusTag(aSTLocusTag);
            try {
                this.impl.warning(string);
            }
            finally {
                this.handler.plf.setASTLocusTag(null);
            }
        }

        @Override
        public void debug(String string) {
            this.log(Level.FINE, string);
        }

        @Override
        public void debug(ASTLocusTag aSTLocusTag, String string) {
            this.log(Level.FINE, aSTLocusTag, string);
        }

        @Override
        public void log(Level level, String string) {
            this.impl.log(level, string);
        }

        @Override
        public void log(Level level, String string, Object object) {
            this.impl.log(level, string, object);
        }

        @Override
        public void log(Level level, String string, Object ... objectArray) {
            this.impl.log(level, string, objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(Level level, ASTLocusTag aSTLocusTag, String string) {
            this.handler.plf.setASTLocusTag(aSTLocusTag);
            try {
                this.impl.log(level, string);
            }
            finally {
                this.handler.plf.setASTLocusTag(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(Level level, ASTLocusTag aSTLocusTag, String string, Object object) {
            this.handler.plf.setASTLocusTag(aSTLocusTag);
            try {
                this.impl.log(level, string, object);
            }
            finally {
                this.handler.plf.setASTLocusTag(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(Level level, ASTLocusTag aSTLocusTag, String string, Object ... objectArray) {
            this.handler.plf.setASTLocusTag(aSTLocusTag);
            try {
                this.impl.log(level, string, objectArray);
            }
            finally {
                this.handler.plf.setASTLocusTag(null);
            }
        }

        @Override
        public void setLevel(Level level) throws SecurityException {
            this.impl.setLevel(level);
        }

        @Override
        public void setLevelOfAllHandler(Level level) throws SecurityException {
            Handler[] handlerArray;
            for (Handler handler : handlerArray = this.getHandlers()) {
                handler.setLevel(level);
            }
        }

        @Override
        public Level getLevel() {
            return this.impl.getLevel();
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.impl.isLoggable(level);
        }

        @Override
        public String getName() {
            return this.impl.getName();
        }

        @Override
        public synchronized Handler[] getHandlers() {
            return this.impl.getHandlers();
        }

        @Override
        public String getSourceClassName() {
            return this.handler.plf.simpleClassName;
        }
    }

    public static interface LoggerIf {
        public void info(String var1);

        public void info(ASTLocusTag var1, String var2);

        public void warning(String var1);

        public void warning(ASTLocusTag var1, String var2);

        public void debug(String var1);

        public void debug(ASTLocusTag var1, String var2);

        public void log(Level var1, String var2);

        public void log(Level var1, String var2, Object var3);

        public void log(Level var1, String var2, Object ... var3);

        public void log(Level var1, ASTLocusTag var2, String var3);

        public void log(Level var1, ASTLocusTag var2, String var3, Object var4);

        public void log(Level var1, ASTLocusTag var2, String var3, Object ... var4);

        public void setLevel(Level var1) throws SecurityException;

        public void setLevelOfAllHandler(Level var1) throws SecurityException;

        public Level getLevel();

        public boolean isLoggable(Level var1);

        public String getName();

        public Handler[] getHandlers();

        public String getSourceClassName();
    }

    static class PlainLogFormatter
    extends Formatter {
        final String simpleClassName;
        ASTLocusTag astLocus;

        PlainLogFormatter(String string) {
            this.simpleClassName = string;
        }

        public void setASTLocusTag(ASTLocusTag aSTLocusTag) {
            this.astLocus = aSTLocusTag;
        }

        @Override
        public String format(LogRecord logRecord) {
            Object[] objectArray = logRecord.getParameters();
            if (null != objectArray) {
                for (int i = objectArray.length - 1; 0 <= i; --i) {
                    Object object = objectArray[i];
                    if (object instanceof Type) {
                        objectArray[i] = ((Type)object).getDebugString();
                        continue;
                    }
                    if (object instanceof JavaType) {
                        objectArray[i] = ((JavaType)object).getDebugString();
                        continue;
                    }
                    if (!(object instanceof AliasedSymbol)) continue;
                    objectArray[i] = ((AliasedSymbol)object).getAliasedString();
                }
            }
            StringBuilder stringBuilder = new StringBuilder(256);
            if (null != this.astLocus) {
                this.astLocus.toString(stringBuilder, Logging.getCanonicalName(logRecord.getLevel()), GlueGen.debug()).append(": ");
            }
            if (GlueGen.debug()) {
                stringBuilder.append(this.simpleClassName).append(": ");
            }
            stringBuilder.append(this.formatMessage(logRecord)).append("\n");
            return stringBuilder.toString();
        }
    }

    static class PlainLogConsoleHandler
    extends ConsoleHandler {
        final PlainLogFormatter plf;

        PlainLogConsoleHandler(PlainLogFormatter plainLogFormatter, Level level) {
            this.plf = plainLogFormatter;
            this.setFormatter(plainLogFormatter);
            this.setLevel(level);
        }

        @Override
        public Formatter getFormatter() {
            return this.plf;
        }
    }
}

