/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.CodeUnit;
import com.jogamp.gluegen.CommentEmitter;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.JavaCallbackEmitter;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.EnumType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.Type;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JavaMethodBindingEmitter
extends FunctionEmitter {
    public static final FunctionEmitter.EmissionModifier PUBLIC = new FunctionEmitter.EmissionModifier("public");
    public static final FunctionEmitter.EmissionModifier PROTECTED = new FunctionEmitter.EmissionModifier("protected");
    public static final FunctionEmitter.EmissionModifier PRIVATE = new FunctionEmitter.EmissionModifier("private");
    public static final FunctionEmitter.EmissionModifier ABSTRACT = new FunctionEmitter.EmissionModifier("abstract");
    public static final FunctionEmitter.EmissionModifier FINAL = new FunctionEmitter.EmissionModifier("final");
    public static final FunctionEmitter.EmissionModifier NATIVE = new FunctionEmitter.EmissionModifier("native");
    public static final FunctionEmitter.EmissionModifier SYNCHRONIZED = new FunctionEmitter.EmissionModifier("synchronized");
    protected final CommentEmitter defaultJavaCommentEmitter = new DefaultCommentEmitter();
    protected final CommentEmitter defaultInterfaceCommentEmitter = new InterfaceCommentEmitter();
    protected final boolean tagNativeBinding;
    protected final boolean useNIODirectOnly;
    private final String runtimeExceptionType;
    private final String unsupportedExceptionType;
    private final boolean useNIOOnly;
    private final boolean isNativeMethod;
    private final boolean isUnimplemented;
    private boolean emitBody;
    private boolean eraseBufferAndArrayTypes;
    private boolean isPrivateNativeMethod;
    private boolean forDirectBufferImplementation;
    private boolean forIndirectBufferAndArrayImplementation;
    protected List<String> prologue;
    protected List<String> epilogue;
    private String returnedArrayLengthExpression;
    private boolean returnedArrayLengthExpressionOnlyForComments = false;
    private final JavaCallbackEmitter javaCallbackEmitter;
    private static final String COMPOUND_ARRAY_SUFFIX = "_buf_array_copy";

    public JavaMethodBindingEmitter(MethodBinding methodBinding, CodeUnit codeUnit, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, JavaConfiguration javaConfiguration) {
        super(methodBinding, codeUnit, bl9, javaConfiguration);
        this.runtimeExceptionType = string;
        this.unsupportedExceptionType = string2;
        this.emitBody = bl;
        this.tagNativeBinding = bl2;
        this.eraseBufferAndArrayTypes = bl3;
        this.useNIOOnly = bl4;
        this.useNIODirectOnly = bl5;
        this.forDirectBufferImplementation = bl6;
        this.forIndirectBufferAndArrayImplementation = bl7;
        this.isUnimplemented = bl8;
        this.isNativeMethod = bl10;
        this.isPrivateNativeMethod = bl11;
        if (bl11) {
            this.setCommentEmitter(this.defaultJavaCommentEmitter);
        } else {
            this.setCommentEmitter(this.defaultInterfaceCommentEmitter);
        }
        JavaConfiguration.JavaCallbackInfo javaCallbackInfo = this.cfg.setFuncToJavaCallbackMap.get(methodBinding.getName());
        this.javaCallbackEmitter = null != javaCallbackInfo ? new JavaCallbackEmitter(this.cfg, methodBinding, javaCallbackInfo, this.appendSignature(new StringBuilder()).toString()) : null;
    }

    public JavaMethodBindingEmitter(JavaMethodBindingEmitter javaMethodBindingEmitter) {
        super(javaMethodBindingEmitter);
        this.runtimeExceptionType = javaMethodBindingEmitter.runtimeExceptionType;
        this.unsupportedExceptionType = javaMethodBindingEmitter.unsupportedExceptionType;
        this.emitBody = javaMethodBindingEmitter.emitBody;
        this.tagNativeBinding = javaMethodBindingEmitter.tagNativeBinding;
        this.eraseBufferAndArrayTypes = javaMethodBindingEmitter.eraseBufferAndArrayTypes;
        this.useNIOOnly = javaMethodBindingEmitter.useNIOOnly;
        this.useNIODirectOnly = javaMethodBindingEmitter.useNIODirectOnly;
        this.isNativeMethod = javaMethodBindingEmitter.isNativeMethod;
        this.isPrivateNativeMethod = javaMethodBindingEmitter.isPrivateNativeMethod;
        this.forDirectBufferImplementation = javaMethodBindingEmitter.forDirectBufferImplementation;
        this.forIndirectBufferAndArrayImplementation = javaMethodBindingEmitter.forIndirectBufferAndArrayImplementation;
        this.isUnimplemented = javaMethodBindingEmitter.isUnimplemented;
        this.prologue = javaMethodBindingEmitter.prologue;
        this.epilogue = javaMethodBindingEmitter.epilogue;
        this.returnedArrayLengthExpression = javaMethodBindingEmitter.returnedArrayLengthExpression;
        this.returnedArrayLengthExpressionOnlyForComments = javaMethodBindingEmitter.returnedArrayLengthExpressionOnlyForComments;
        this.javaCallbackEmitter = javaMethodBindingEmitter.javaCallbackEmitter;
    }

    public boolean isNativeMethod() {
        return this.isNativeMethod;
    }

    public boolean isPrivateNativeMethod() {
        return this.isPrivateNativeMethod;
    }

    public boolean isForDirectBufferImplementation() {
        return this.forDirectBufferImplementation;
    }

    public boolean isForIndirectBufferAndArrayImplementation() {
        return this.forIndirectBufferAndArrayImplementation;
    }

    @Override
    public String getInterfaceName() {
        return this.binding.getInterfaceName();
    }

    @Override
    public String getImplName() {
        return this.binding.getImplName();
    }

    @Override
    public String getNativeName() {
        return this.binding.getNativeName();
    }

    @Override
    public FunctionSymbol getCSymbol() {
        return this.binding.getCSymbol();
    }

    protected String getArgumentName(int n) {
        return this.binding.getArgumentName(n);
    }

    public String getRuntimeExceptionType() {
        return this.runtimeExceptionType;
    }

    public String getUnsupportedExceptionType() {
        return this.unsupportedExceptionType;
    }

    public void setReturnedArrayLengthExpression(String string) {
        this.returnedArrayLengthExpression = string;
        this.returnedArrayLengthExpressionOnlyForComments = false;
    }

    protected void setReturnedArrayLengthExpression(String string, boolean bl) {
        this.returnedArrayLengthExpression = string;
        this.returnedArrayLengthExpressionOnlyForComments = bl;
    }

    protected String getReturnedArrayLengthExpression() {
        return this.returnedArrayLengthExpressionOnlyForComments ? null : this.returnedArrayLengthExpression;
    }

    protected String getReturnedArrayLengthComment() {
        return this.returnedArrayLengthExpression;
    }

    public void setPrologue(List<String> list) {
        this.prologue = list;
    }

    public void setEpilogue(List<String> list) {
        this.epilogue = list;
    }

    public boolean signatureOnly() {
        return !this.emitBody;
    }

    public void setEmitBody(boolean bl) {
        this.emitBody = bl;
    }

    public void setEraseBufferAndArrayTypes(boolean bl) {
        this.eraseBufferAndArrayTypes = bl;
    }

    public void setPrivateNativeMethod(boolean bl) {
        this.isPrivateNativeMethod = bl;
    }

    public void setForDirectBufferImplementation(boolean bl) {
        this.forDirectBufferImplementation = bl;
    }

    public void setForIndirectBufferAndArrayImplementation(boolean bl) {
        this.forIndirectBufferAndArrayImplementation = bl;
    }

    @Override
    protected StringBuilder appendReturnType(StringBuilder stringBuilder) {
        return stringBuilder.append(this.getReturnTypeString(false));
    }

    protected String erasedTypeString(JavaType javaType, boolean bl) {
        String string;
        if (this.eraseBufferAndArrayTypes) {
            if (javaType.isNIOBuffer()) {
                if (!bl) {
                    return "Object";
                }
                if (!javaType.isNIOByteBuffer()) {
                    return "ByteBuffer";
                }
            } else if (javaType.isPrimitiveArray()) {
                if (!bl) {
                    return "Object";
                }
            } else {
                if (javaType.isNIOBufferArray()) {
                    return "Object[]";
                }
                if (javaType.isCompoundTypeWrapper()) {
                    return "ByteBuffer";
                }
                if (javaType.isArrayOfCompoundTypeWrappers()) {
                    if (bl) {
                        return "ByteBuffer";
                    }
                    return "ByteBuffer[]";
                }
            }
        }
        if (null == (string = javaType.getName())) {
            throw new IllegalArgumentException("null type name: " + javaType.getDebugString());
        }
        int n = string.lastIndexOf(46) + 1;
        string = string.substring(n);
        if (javaType.isArrayOfCompoundTypeWrappers()) {
            return string + "[]";
        }
        return string;
    }

    protected String getReturnTypeString(boolean bl) {
        if (bl || this.getReturnedArrayLengthExpression() == null && !this.binding.getJavaReturnType().isArrayOfCompoundTypeWrappers() || this.eraseBufferAndArrayTypes && this.binding.getJavaReturnType().isCompoundTypeWrapper() && this.getReturnedArrayLengthExpression() != null) {
            return this.erasedTypeString(this.binding.getJavaReturnType(), true);
        }
        return this.erasedTypeString(this.binding.getJavaReturnType(), true) + "[]";
    }

    @Override
    protected StringBuilder appendName(StringBuilder stringBuilder) {
        if (this.isPrivateNativeMethod) {
            stringBuilder.append(this.getNativeImplMethodName());
        } else if (this.isInterface()) {
            stringBuilder.append(this.getInterfaceName());
        } else {
            stringBuilder.append(this.getImplName());
        }
        return stringBuilder;
    }

    @Override
    protected int appendArguments(StringBuilder stringBuilder) {
        boolean bl = false;
        int n = 0;
        if (this.hasModifier(NATIVE) && this.binding.isReturnCompoundByValue()) {
            stringBuilder.append("final Class<?> _clazzBuffers");
            ++n;
            bl = true;
        }
        if (this.isPrivateNativeMethod && this.binding.hasContainingType()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("ByteBuffer ");
            stringBuilder.append(JavaMethodBindingEmitter.javaThisArgumentName());
            ++n;
            bl = true;
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (this.binding.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this.binding + "\"");
            }
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.erasedTypeString(javaType, false));
            stringBuilder.append(" ");
            stringBuilder.append(this.getArgumentName(i));
            ++n;
            bl = true;
            if (this.forDirectBufferImplementation || this.forIndirectBufferAndArrayImplementation) {
                if (javaType.isNIOBuffer()) {
                    stringBuilder.append(", int " + this.byteOffsetArgName(i));
                    if (!this.useNIODirectOnly) {
                        stringBuilder.append(", boolean " + this.isNIOArgName(i));
                    }
                } else if (javaType.isNIOBufferArray()) {
                    stringBuilder.append(", int[] " + this.byteOffsetArrayArgName(i));
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            if (this.useNIOOnly) {
                throw new RuntimeException("NIO[Direct]Only " + this.binding + " is set, but " + this.getArgumentName(i) + " is a primitive array");
            }
            stringBuilder.append(", int " + this.offsetArgName(i));
        }
        if (this.hasModifier(NATIVE) && null != this.javaCallbackEmitter) {
            if (bl) {
                stringBuilder.append(", ");
            }
            n += this.javaCallbackEmitter.appendJavaAdditionalJNIParameter(stringBuilder);
        }
        return n;
    }

    protected String getNativeImplMethodName() {
        return this.binding.getImplName() + (this.useNIODirectOnly ? "0" : "1");
    }

    protected String byteOffsetArgName(int n) {
        return JavaMethodBindingEmitter.byteOffsetArgName(this.getArgumentName(n));
    }

    protected static String byteOffsetArgName(String string) {
        return string + "_byte_offset";
    }

    protected String isNIOArgName(int n) {
        return this.isNIOArgName(this.binding.getArgumentName(n));
    }

    protected String isNIOArgName(String string) {
        return string + "_is_direct";
    }

    protected String byteOffsetArrayArgName(int n) {
        return this.getArgumentName(n) + "_byte_offset_array";
    }

    protected String offsetArgName(int n) {
        return this.getArgumentName(n) + "_offset";
    }

    @Override
    protected void emitAdditionalCode() {
        if (null != this.javaCallbackEmitter && !this.isPrivateNativeMethod) {
            this.javaCallbackEmitter.emitJavaAdditionalCode(this.unit, this.isInterface());
        }
    }

    @Override
    protected void emitBody() {
        if (!this.emitBody) {
            this.unit.emitln(";");
        } else {
            MethodBinding methodBinding = this.getBinding();
            this.unit.emitln("  {");
            this.unit.emitln();
            if (this.isUnimplemented) {
                this.unit.emitln("    throw new " + this.getUnsupportedExceptionType() + "(\"Unimplemented\");");
            } else {
                this.emitPrologueOrEpilogue(this.prologue);
                this.emitPreCallSetup(methodBinding);
                this.emitReturnVariableSetupAndCall(methodBinding);
            }
            this.unit.emitln("  }");
        }
    }

    protected void emitPrologueOrEpilogue(List<String> list) {
        if (list != null) {
            String[] stringArray = this.argumentNameArray();
            for (String string : list) {
                try {
                    MessageFormat messageFormat = new MessageFormat(string);
                    this.unit.emitln("    " + messageFormat.format(stringArray));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.unit.emitln("    " + string);
                }
            }
        }
    }

    protected void emitPreCallSetup(MethodBinding methodBinding) {
        this.emitArrayLengthAndNIOBufferChecks(methodBinding);
        this.emitCompoundArrayCopies(methodBinding);
    }

    protected void emitArrayLengthAndNIOBufferChecks(MethodBinding methodBinding) {
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            String string;
            Object object;
            Type type = methodBinding.getCArgumentType(i);
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (type.isArray()) {
                object = type.asArray();
                if (javaType.isNIOBuffer()) {
                    this.unit.emitln("    if ( Buffers.remainingElem(" + this.getArgumentName(i) + ") < " + ((ArrayType)object).getLength() + ")");
                } else {
                    this.unit.emitln("    if ( " + this.getArgumentName(i) + ".length < " + ((ArrayType)object).getLength() + ")");
                }
                this.unit.emit("      throw new " + this.getRuntimeExceptionType() + "(\"Array \\\"" + this.getArgumentName(i) + "\\\" length (\" + ");
                if (javaType.isNIOBuffer()) {
                    this.unit.emit("Buffers.remainingElem(" + this.getArgumentName(i) + ")");
                } else {
                    this.unit.emit(this.getArgumentName(i) + ".length");
                }
                this.unit.emitln("+ \") was less than the required (" + ((ArrayType)object).getLength() + ")\");");
            }
            if (javaType.isNIOBuffer()) {
                if (this.useNIODirectOnly) {
                    this.unit.emitln("    if (!Buffers.isDirect(" + this.getArgumentName(i) + "))");
                    this.unit.emitln("      throw new " + this.getRuntimeExceptionType() + "(\"Argument \\\"" + this.getArgumentName(i) + "\\\" is not a direct buffer\");");
                    continue;
                }
                this.unit.emitln("    final boolean " + this.isNIOArgName(i) + " = Buffers.isDirect(" + this.getArgumentName(i) + ");");
                continue;
            }
            if (javaType.isNIOBufferArray()) {
                object = this.getArgumentName(i);
                string = this.byteOffsetArrayArgName(i);
                this.unit.emitln("    final int[] " + string + " = new int[" + (String)object + ".length];");
                this.unit.emitln("    if (" + (String)object + " != null) {");
                this.unit.emitln("      for (int _ctr = 0; _ctr < " + (String)object + ".length; _ctr++) {");
                this.unit.emitln("        if (!Buffers.isDirect(" + (String)object + "[_ctr])) {");
                this.unit.emitln("          throw new " + this.getRuntimeExceptionType() + "(\"Element \" + _ctr + \" of argument \\\"" + this.getArgumentName(i) + "\\\" was not a direct buffer\");");
                this.unit.emitln("        }");
                this.unit.emit("        " + string + "[_ctr] = Buffers.getDirectBufferByteOffset(");
                this.unit.emitln((String)object + "[_ctr]);");
                this.unit.emitln("      }");
                this.unit.emitln("    }");
                continue;
            }
            if (!javaType.isPrimitiveArray()) continue;
            object = this.getArgumentName(i);
            string = this.offsetArgName(i);
            this.unit.emitln("    if(" + (String)object + " != null && " + (String)object + ".length <= " + string + ")");
            this.unit.emit("      throw new " + this.getRuntimeExceptionType());
            this.unit.emitln("(\"array offset argument \\\"" + string + "\\\" (\" + " + string + " + \") equals or exceeds array length (\" + " + (String)object + ".length + \")\");");
        }
    }

    protected void emitCompoundArrayCopies(MethodBinding methodBinding) {
        if (methodBinding.signatureUsesArraysOfCompoundTypeWrappers()) {
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                JavaType javaType = methodBinding.getJavaArgumentType(i);
                if (!javaType.isArrayOfCompoundTypeWrappers()) continue;
                String string = this.getArgumentName(i);
                String string2 = string + COMPOUND_ARRAY_SUFFIX;
                this.unit.emitln("    final ByteBuffer[] " + string2 + " = new ByteBuffer[" + string + ".length];");
                this.unit.emitln("    for (int _ctr = 0; _ctr < + " + string + ".length; _ctr++) {");
                this.unit.emitln("      " + javaType.getName() + " _tmp = " + string + "[_ctr];");
                this.unit.emitln("      " + string2 + "[_ctr] = ((_tmp == null) ? null : _tmp.getBuffer());");
                this.unit.emitln("    }");
            }
        }
    }

    protected void emitCall(MethodBinding methodBinding) {
        this.unit.emit(this.getNativeImplMethodName());
        this.unit.emit("(");
        this.emitCallArguments(methodBinding);
        this.unit.emit(");");
    }

    protected void emitReturnVariableSetupAndCall(MethodBinding methodBinding) {
        JavaType javaType = methodBinding.getJavaReturnType();
        boolean bl = false;
        if (null != this.javaCallbackEmitter) {
            this.javaCallbackEmitter.emitJavaSetFuncPreCall(this.unit);
        }
        if (!javaType.isVoid()) {
            this.unit.emit("    ");
            if (javaType.isCompoundTypeWrapper() || javaType.isNIOBuffer()) {
                this.unit.emitln("final ByteBuffer _res;");
                bl = true;
            } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                this.unit.emitln("final ByteBuffer[] _res;");
                bl = true;
            } else if (this.epilogue != null && this.epilogue.size() > 0 || methodBinding.signatureUsesArraysOfCompoundTypeWrappers()) {
                this.unit.emit("final ");
                this.emitReturnType();
                this.unit.emitln(" _res;");
                bl = true;
            }
        }
        if (bl) {
            this.unit.emit("    _res = ");
        } else {
            this.unit.emit("    ");
            if (!javaType.isVoid()) {
                this.unit.emit("return ");
            }
        }
        this.emitCall(methodBinding);
        this.unit.emitln();
        this.emitPostCallCleanup(methodBinding);
        this.emitPrologueOrEpilogue(this.epilogue);
        if (bl) {
            this.emitCallResultReturn(methodBinding);
        }
    }

    protected int emitCallArguments(MethodBinding methodBinding) {
        boolean bl = false;
        int n = 0;
        if (methodBinding.isReturnCompoundByValue()) {
            this.unit.emit("com.jogamp.common.nio.Buffers.class");
            bl = true;
            ++n;
        }
        if (methodBinding.hasContainingType()) {
            assert (methodBinding.getContainingType().isCompoundTypeWrapper());
            if (bl) {
                this.unit.emit(", ");
            }
            this.unit.emit("getBuffer()");
            bl = true;
            ++n;
        }
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || methodBinding.isArgumentThisPointer(i)) continue;
            if (javaType.isVoid()) {
                assert (methodBinding.getNumArguments() == 1);
                continue;
            }
            if (bl) {
                this.unit.emit(", ");
            }
            if (javaType.isCompoundTypeWrapper()) {
                this.unit.emit("((");
            }
            if (javaType.isNIOBuffer()) {
                if (javaType.isNIOPointerBuffer()) {
                    if (this.useNIODirectOnly) {
                        this.unit.emit(this.getArgumentName(i) + " != null ? " + this.getArgumentName(i) + ".getBuffer() : null");
                    } else {
                        this.unit.emit(this.isNIOArgName(i) + " ? ( " + this.getArgumentName(i) + " != null ? " + this.getArgumentName(i) + ".getBuffer() : null )");
                        this.unit.emit(" : Buffers.getArray(" + this.getArgumentName(i) + ")");
                    }
                } else if (this.useNIODirectOnly) {
                    this.unit.emit(this.getArgumentName(i));
                } else {
                    this.unit.emit(this.isNIOArgName(i) + " ? " + this.getArgumentName(i) + " : Buffers.getArray(" + this.getArgumentName(i) + ")");
                }
            } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                this.unit.emit(this.getArgumentName(i) + COMPOUND_ARRAY_SUFFIX);
            } else {
                this.unit.emit(this.getArgumentName(i));
            }
            if (javaType.isCompoundTypeWrapper()) {
                this.unit.emit(" == null) ? null : ");
                this.unit.emit(this.getArgumentName(i));
                this.unit.emit(".getBuffer())");
            }
            if (javaType.isNIOBuffer()) {
                if (this.useNIODirectOnly) {
                    this.unit.emit(", Buffers.getDirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                } else {
                    this.unit.emit(", " + this.isNIOArgName(i) + " ? Buffers.getDirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                    this.unit.emit(" : Buffers.getIndirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                }
            } else if (javaType.isNIOBufferArray()) {
                this.unit.emit(", " + this.byteOffsetArrayArgName(i));
            } else if (javaType.isPrimitiveArray()) {
                if (javaType.isFloatArray()) {
                    this.unit.emit(", Buffers.SIZEOF_FLOAT * ");
                } else if (javaType.isDoubleArray()) {
                    this.unit.emit(", Buffers.SIZEOF_DOUBLE * ");
                } else if (javaType.isByteArray()) {
                    this.unit.emit(", ");
                } else if (javaType.isLongArray()) {
                    this.unit.emit(", Buffers.SIZEOF_LONG * ");
                } else if (javaType.isShortArray()) {
                    this.unit.emit(", Buffers.SIZEOF_SHORT * ");
                } else if (javaType.isIntArray()) {
                    this.unit.emit(", Buffers.SIZEOF_INT * ");
                } else {
                    throw new GlueGenException("Unsupported type for calculating array offset argument for " + this.getArgumentName(i) + " -- error occurred while processing Java glue code for " + this.getCSymbol().getAliasedString(), this.getCSymbol().getASTLocusTag());
                }
                this.unit.emit(this.offsetArgName(i));
            }
            if (javaType.isNIOBuffer()) {
                if (!this.useNIODirectOnly) {
                    this.unit.emit(", " + this.isNIOArgName(i));
                }
            } else if (javaType.isPrimitiveArray()) {
                if (this.useNIOOnly) {
                    throw new GlueGenException("NIO[Direct]Only " + methodBinding + " is set, but " + this.getArgumentName(i) + " is a primitive array", this.getCSymbol().getASTLocusTag());
                }
                this.unit.emit(", false");
            }
            bl = true;
            ++n;
        }
        if (null != this.javaCallbackEmitter) {
            if (bl) {
                this.unit.emit(", ");
            }
            StringBuilder stringBuilder = new StringBuilder();
            n += this.javaCallbackEmitter.appendJavaAdditionalJNIArguments(stringBuilder);
            this.unit.emit(stringBuilder.toString());
        }
        return n;
    }

    protected void emitPostCallCleanup(MethodBinding methodBinding) {
        if (methodBinding.signatureUsesArraysOfCompoundTypeWrappers()) {
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                JavaType javaType = methodBinding.getJavaArgumentType(i);
                if (!javaType.isArrayOfCompoundTypeWrappers() || javaType.getElementCType().isBaseTypeConst()) continue;
                String string = methodBinding.getArgumentName(i);
                this.unit.emitln("    for (int _ctr = 0; _ctr < " + string + ".length; _ctr++) {");
                this.unit.emitln("      if ((" + string + "[_ctr] == null && " + string + COMPOUND_ARRAY_SUFFIX + "[_ctr] == null) ||");
                this.unit.emitln("          (" + string + "[_ctr] != null && " + string + "[_ctr].getBuffer() == " + string + COMPOUND_ARRAY_SUFFIX + "[_ctr])) {");
                this.unit.emitln("        // No copy back needed");
                this.unit.emitln("      } else {");
                this.unit.emitln("        if (" + string + COMPOUND_ARRAY_SUFFIX + "[_ctr] == null) {");
                this.unit.emitln("          " + string + "[_ctr] = null;");
                this.unit.emitln("        } else {");
                this.unit.emitln("          " + string + "[_ctr] = " + javaType.getName() + ".create(" + string + COMPOUND_ARRAY_SUFFIX + "[_ctr]);");
                this.unit.emitln("        }");
                this.unit.emitln("      }");
                this.unit.emitln("    }");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void emitCallResultReturn(MethodBinding methodBinding) {
        JavaType javaType = methodBinding.getJavaReturnType();
        if (javaType.isCompoundTypeWrapper()) {
            this.unit.emitln("    if (_res == null) return null;");
            this.unit.emitln("    return " + javaType.getName() + ".create(Buffers.nativeOrder(_res));");
            return;
        } else if (javaType.isNIOBuffer()) {
            this.unit.emitln("    if (_res == null) return null;");
            this.unit.emitln("    Buffers.nativeOrder(_res);");
            if (!javaType.isNIOByteBuffer()) {
                if (this.getBinding().getCReturnType().pointerDepth() >= 2) {
                    if (javaType.isNIOPointerBuffer()) {
                        this.unit.emitln("    return PointerBuffer.wrap(_res);");
                        return;
                    } else {
                        if (!javaType.isNIOLongBuffer()) throw new GlueGenException("While emitting glue code for " + this.getCSymbol().getAliasedString() + ": can not legally make pointers opaque to anything but PointerBuffer or LongBuffer/long", this.getCSymbol().getASTLocusTag());
                        this.unit.emitln("    return _res.asLongBuffer();");
                    }
                    return;
                } else if (this.getBinding().getCReturnType().pointerDepth() == 1 && javaType.isNIOLongBuffer()) {
                    this.unit.emitln("    return _res.asLongBuffer();");
                    return;
                } else {
                    String string = javaType.getName().substring("java.nio.".length());
                    this.unit.emitln("    return _res.as" + string + "();");
                }
                return;
            } else {
                this.unit.emitln("    return _res;");
            }
            return;
        } else if (javaType.isArrayOfCompoundTypeWrappers()) {
            this.unit.emitln("    if (_res == null) return null;");
            this.unit.emitln("    final " + this.getReturnTypeString(false) + " _retarray = new " + this.getReturnTypeString(true) + "[_res.length];");
            this.unit.emitln("    for (int _count = 0; _count < _res.length; _count++) {");
            this.unit.emitln("      _retarray[_count] = " + this.getReturnTypeString(true) + ".create(_res[_count]);");
            this.unit.emitln("    }");
            this.unit.emitln("    return _retarray;");
            return;
        } else {
            this.unit.emitln("    return _res;");
        }
    }

    protected String[] argumentNameArray() {
        String[] stringArray = new String[this.binding.getNumArguments()];
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            stringArray[i] = this.getArgumentName(i);
            if (!this.binding.getJavaArgumentType(i).isPrimitiveArray()) continue;
            stringArray[i] = stringArray[i] + ", " + this.offsetArgName(i);
        }
        return stringArray;
    }

    public static String javaThisArgumentName() {
        return "jthis0";
    }

    @Override
    protected String getCommentStartString() {
        return "/** ";
    }

    @Override
    protected String getCommentEndString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.binding.getName();
        List<String> list = this.cfg.javadocForMethod(string);
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(JavaConfiguration.NEWLINE).append(this.getBaseIndentString()).append(iterator.next());
        }
        if (list.size() > 0) {
            stringBuilder.append(JavaConfiguration.NEWLINE).append(this.getBaseIndentString());
        }
        stringBuilder.append(" */");
        return stringBuilder.toString();
    }

    @Override
    protected String getBaseIndentString() {
        return "  ";
    }

    protected class DefaultCommentEmitter
    implements CommentEmitter {
        protected DefaultCommentEmitter() {
        }

        protected void emitAliasedDocNamesComment(AliasedSymbol aliasedSymbol, PrintWriter printWriter) {
            printWriter.print(this.emitAliasedDocNamesComment(aliasedSymbol, new StringBuilder()).toString());
        }

        protected StringBuilder emitAliasedDocNamesComment(AliasedSymbol aliasedSymbol, StringBuilder stringBuilder) {
            Set<String> set = JavaMethodBindingEmitter.this.cfg.getAliasedDocNames(aliasedSymbol);
            if (set != null && set.size() > 0) {
                int n = 0;
                stringBuilder.append("Alias for: <code>");
                for (String string : set) {
                    if (0 < n) {
                        stringBuilder.append("</code>, <code>");
                    }
                    stringBuilder.append(string);
                    ++n;
                }
                stringBuilder.append("</code>");
            }
            return stringBuilder;
        }

        @Override
        public void emit(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            this.emitBeginning(functionEmitter, printWriter);
            this.emitBindingCSignature(((JavaMethodBindingEmitter)functionEmitter).getBinding(), printWriter);
            String string = JavaMethodBindingEmitter.this.getReturnedArrayLengthComment();
            if (null != string) {
                printWriter.print(", covering an array of length <code>" + string + "</code>");
            }
            this.emitEnding(functionEmitter, printWriter);
        }

        protected void emitBeginning(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            printWriter.print("Entry point to C language function: ");
        }

        protected void emitBindingCSignature(MethodBinding methodBinding, PrintWriter printWriter) {
            FunctionSymbol functionSymbol = methodBinding.getCSymbol();
            printWriter.print("<code>");
            printWriter.print(functionSymbol.toString(JavaMethodBindingEmitter.this.tagNativeBinding));
            printWriter.print("</code><br>");
            this.emitAliasedDocNamesComment((AliasedSymbol)functionSymbol, printWriter);
        }

        protected void emitEnding(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            MethodBinding methodBinding = ((JavaMethodBindingEmitter)functionEmitter).getBinding();
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                Type type = methodBinding.getCArgumentType(i);
                JavaType javaType = methodBinding.getJavaArgumentType(i);
                if (type.isEnum() && !"<anonymous>".equals(type.getName())) {
                    EnumType enumType = (EnumType)type;
                    printWriter.println();
                    printWriter.print(functionEmitter.getBaseIndentString());
                    printWriter.print("    ");
                    printWriter.print("@param ");
                    printWriter.print(JavaMethodBindingEmitter.this.getArgumentName(i));
                    printWriter.print(" valid values are: <code>");
                    for (int j = 0; j < enumType.getNumEnumerates(); ++j) {
                        if (j > 0) {
                            printWriter.print(", ");
                        }
                        printWriter.print(enumType.getEnum(j).getName());
                    }
                    printWriter.println("</code>");
                    continue;
                }
                if (!javaType.isNIOBuffer()) continue;
                printWriter.println();
                printWriter.print(functionEmitter.getBaseIndentString());
                printWriter.print("    ");
                printWriter.print("@param ");
                printWriter.print(JavaMethodBindingEmitter.this.getArgumentName(i));
                if (JavaMethodBindingEmitter.this.useNIODirectOnly) {
                    printWriter.print(" a direct only {@link " + javaType.getName() + "}");
                    continue;
                }
                printWriter.print(" a direct or array-backed {@link " + javaType.getName() + "}");
            }
        }
    }

    protected class InterfaceCommentEmitter
    extends DefaultCommentEmitter {
        protected InterfaceCommentEmitter() {
        }

        @Override
        protected void emitBeginning(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            printWriter.print("Interface to C language function: <br> ");
        }
    }
}

