/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.util.ArrayHashMap;
import com.jogamp.common.util.HashUtil;
import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.ArrayTypes;
import com.jogamp.gluegen.CCodeUnit;
import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.CodeUnit;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.JavaCodeUnit;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.TypeInfo;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.StructLayout;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import jogamp.common.os.MachineDataInfoRuntime;

public class JavaEmitter
implements GlueEmitter {
    private StructLayout layout;
    private Map<Type, Type> canonMap;
    protected JavaConfiguration cfg;
    private JavaCodeUnit javaUnit;
    private JavaCodeUnit javaImplUnit;
    private CCodeUnit cUnit;
    private final MachineDataInfo machDescJava;
    private final MachineDataInfo.StaticConfig[] machDescTargetConfigs;
    protected final Logging.LoggerIf LOG;
    private final Map<String, ConstantDefinition.JavaExpr> constMap;
    private final Map<String, JavaConfiguration.JavaCallbackInfo> javaCallbackInterfaceMap;
    private static final String GetElemValueApiDocTail = "@return element value of the corresponding field-array";
    private static final String GetElemCountApiDocTail = "@return element count of the corresponding field-array";
    private static final String SetSubArrayArgsPost = "final int srcPos, final int destPos, final int length";
    private static final String SetSubArrayArgsCheck = "    if( 0 > srcPos || 0 > destPos || 0 > length || srcPos + length > src.length ) { throw new IndexOutOfBoundsException(\"src[pos \"+srcPos+\", length \"+src.length+\"], destPos \"+destPos+\", length \"+length); }";
    private static final String SetSubArrayApiDocDetail = "Copies the given source elements into the respective field's existing memory.";
    private static final String SetSubArrayApiDocArgs = "   * @param src the source array of elements\n   * @param srcPos starting element position within the source array with 'srcPos >= 0` &&  `srcPos + length <= src.length`, otherwise an {@link IndexOutOfBoundsException} is thrown\n   * @param destPos starting element position within the destination with 'destPos >= 0` && `destPos + length <= elemCount`, otherwise an exception is thrown\n   * @param length the element count to be copied with 'length >= 0` &&  `srcPos + length <= src.length` && `destPos + length <= elemCount`, otherwise an {@link IndexOutOfBoundsException} is thrown\n   * @return this instance of chaining";
    private static final String SetArrayArgsPre = "final boolean subset";
    private static final String SetArrayArgsPost = "final int srcPos, final int destPos, final int length";
    private static final String SetArrayArgsCheck = "    if( 0 > srcPos || 0 > destPos || 0 > length || srcPos + length > src.length ) { throw new IndexOutOfBoundsException(\"subset \"+subset+\", src[pos \"+srcPos+\", length \"+src.length+\"], destPos \"+destPos+\", length \"+length); }";
    private static final String SetArrayApiDocDetail = "Copies the given source elements into the respective field, either writing into the existing memory or creating a new memory and referencing it.";
    private static final String SetArrayApiDocArgs = "   * @param subset if `true` keeps the underlying memory and only allows to set up to `elemCount` elements. Otherwise may replace the underlying memory if `destPos + length != elemCount`.\n   * @param src the source array of elements\n   * @param srcPos starting element position within the source array with 'srcPos >= 0` &&  `srcPos + length <= src.length`, otherwise an {@link IndexOutOfBoundsException} is thrown\n   * @param destPos starting element position within the destination with 'destPos >= 0`. If `subset == true`, `destPos + length <= elemCount` also must be be `true`. Otherwise an exception is thrown\n   * @param length the element count to be copied with 'length >= 0` &&  `srcPos + length <= src.length`, otherwise an {@link IndexOutOfBoundsException} is thrown\n   * @return this instance of chaining";
    private static final String SetReplaceArrayArgsPost = "final int srcPos, final int length";
    private static final String SetReplaceArrayArgsCheck = "    if( 0 > srcPos || 0 > length || srcPos + length > src.length ) { throw new IndexOutOfBoundsException(\"src[pos \"+srcPos+\", length \"+src.length+\"], length \"+length); }";
    private static final String SetReplaceArrayApiDocDetail = "Replaces the respective field's memory with a new memory segment containing given source elements and referencing it.";
    private static final String SetReplaceArrayApiDocArgs = "   * @param src the source array of elements\n   * @param srcPos starting element position within the source array with 'srcPos >= 0` &&  `srcPos + length <= src.length`, otherwise an {@link IndexOutOfBoundsException} is thrown\n   * @param length the element count to be copied with 'length >= 0` &&  `srcPos + length <= src.length`, otherwise an {@link IndexOutOfBoundsException} is thrown\n   * @return this instance of chaining";
    private static final String GetArrayArgs = "final int destPos, final int length";
    private static final String GetArrayArgsCheck = "    if( 0 > srcPos || 0 > destPos || 0 > length || destPos + length > dest.length ) { throw new IndexOutOfBoundsException(\"dest[pos \"+destPos+\", length \"+dest.length+\"], srcPos \"+srcPos+\", length \"+length); }";
    private static final String optStringCharsetCode = "  private static Charset _charset = StandardCharsets.UTF_8;\n\n  /** Returns the Charset for this class's String mapping, default is StandardCharsets.UTF_8. */\n  public static Charset getCharset() { return _charset; };\n\n  /** Sets the Charset for this class's String mapping, default is StandardCharsets.UTF_8. */\n  public static void setCharset(Charset cs) { _charset = cs; }\n";
    private static final String optStringMaxStrnlenCode = "  private static int _max_strnlen = 8192;\n\n  /** Returns the maximum number of bytes to read to determine native string length using `strnlen(..)`, default is 8192. */\n  public static int getMaxStrnlen() { return _max_strnlen; };\n\n  /** Sets the maximum number of bytes to read to determine native string length using `strnlen(..)`, default is 8192. */\n  public static void setMaxStrnlen(int v) { _max_strnlen = v; }\n";

    public JavaEmitter() {
        this.machDescJava = MachineDataInfo.StaticConfig.LP64_UNIX.md;
        this.machDescTargetConfigs = MachineDataInfo.StaticConfig.values();
        this.constMap = new HashMap<String, ConstantDefinition.JavaExpr>();
        this.javaCallbackInterfaceMap = new HashMap<String, JavaConfiguration.JavaCallbackInfo>();
        this.LOG = Logging.getLogger(JavaEmitter.class.getPackage().getName(), JavaEmitter.class.getSimpleName());
    }

    public JavaEmitter(JavaConfiguration javaConfiguration) {
        this();
        this.cfg = javaConfiguration;
    }

    @Override
    public void readConfigurationFile(String string) throws Exception {
        this.cfg = this.createConfig();
        this.cfg.read(string);
    }

    @Override
    public JavaConfiguration getConfig() {
        return this.cfg;
    }

    @Override
    public void beginEmission(GlueEmitterControls glueEmitterControls) throws IOException {
        glueEmitterControls.runSymbolFilter(new ConstFuncRenamer());
        for (String string : this.cfg.forcedStructs()) {
            glueEmitterControls.forceStructEmission(string);
        }
        if (!this.cfg.structsOnly()) {
            try {
                this.openCodeUnits();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to open files for writing", exception);
            }
            this.emitAllFileHeaders();
        }
    }

    @Override
    public void endEmission() {
        if (!this.cfg.structsOnly()) {
            this.emitAllFileFooters();
            try {
                this.closeWriters();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to close open files", exception);
            }
        }
    }

    @Override
    public void beginDefines() throws Exception {
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaUnit().emitln();
        }
    }

    protected static String jniMangle(String string) {
        return string.replaceAll("_", "_1").replace('.', '_');
    }

    protected static String getJNIMethodNamePrefix(String string, String string2) {
        return "Java_" + JavaEmitter.jniMangle(string) + "_" + JavaEmitter.jniMangle(string2);
    }

    @Override
    public void emitDefine(ConstantDefinition constantDefinition, String string) throws Exception {
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly() && !this.cfg.shouldIgnoreInInterface(constantDefinition)) {
            ConstantDefinition.JavaExpr javaExpr = constantDefinition.computeJavaExpr(this.constMap);
            this.constMap.put(constantDefinition.getName(), javaExpr);
            this.javaUnit().emit("  /** ");
            if (string != null && string.length() != 0) {
                this.javaUnit().emit(string);
                this.javaUnit().emit(", ");
            }
            this.javaUnit().emit("CType: ");
            if (javaExpr.resultType.isUnsigned) {
                this.javaUnit().emit("unsigned ");
            }
            this.javaUnit().emit(javaExpr.resultJavaTypeName);
            this.javaUnit().emitln(" */");
            this.javaUnit().emitln("  public static final " + javaExpr.resultJavaTypeName + " " + constantDefinition.getName() + " = " + javaExpr.javaExpression + ";");
        }
    }

    @Override
    public void endDefines() throws Exception {
    }

    @Override
    public void beginFunctions(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map, List<FunctionSymbol> list) throws Exception {
        this.canonMap = map;
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaUnit().emitln();
            if (!this.cfg.getJavaCallbackList().isEmpty()) {
                List<JavaConfiguration.JavaCallbackDef> list2 = this.cfg.getJavaCallbackList();
                for (JavaConfiguration.JavaCallbackDef javaCallbackDef : list2) {
                    Type type = typeDictionary.get(javaCallbackDef.cbFuncTypeName);
                    if (null != type && type.isFunctionPointer()) {
                        Optional<FunctionSymbol> optional = list.stream().filter(functionSymbol -> javaCallbackDef.setFuncName.equals(functionSymbol.getName())).findFirst();
                        if (optional.isPresent()) {
                            this.generateJavaCallbackCode(javaCallbackDef, type.getTargetFunction());
                            continue;
                        }
                        this.LOG.log(Level.WARNING, "JavaCallback '{0}' setter not available", (Object)javaCallbackDef);
                        continue;
                    }
                    this.LOG.log(Level.WARNING, "JavaCallback '{0}' function-pointer type not available", (Object)javaCallbackDef);
                }
            }
        }
    }

    @Override
    public Iterator<FunctionSymbol> emitFunctions(List<FunctionSymbol> list) throws Exception {
        if (!this.cfg.structsOnly()) {
            ArrayList<? extends FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>(2 * list.size());
            int n = 0;
            for (FunctionSymbol object : list) {
                if (this.cfg.shouldIgnoreInImpl(object)) continue;
                arrayList.addAll(this.generateMethodBindingEmitters(object));
                this.LOG.log(Level.INFO, object.getASTLocusTag(), "Non-Ignored Impl[{0}]: {1}", n++, object);
            }
            n = 0;
            for (FunctionEmitter functionEmitter : arrayList) {
                try {
                    FunctionSymbol functionSymbol = functionEmitter.getCSymbol();
                    if (functionEmitter.isInterface() && this.cfg.shouldIgnoreInInterface(functionSymbol)) continue;
                    functionEmitter.emit();
                    functionEmitter.getUnit().emitln();
                    this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "Non-Ignored Intf[{0}]: {1}", n++, functionSymbol);
                }
                catch (Exception exception) {
                    throw new GlueGenException("Error while emitting binding for \"" + functionEmitter.getCSymbol().getAliasedString() + "\"", functionEmitter.getCSymbol().getASTLocusTag(), exception);
                }
            }
        }
        return list.iterator();
    }

    protected JavaConfiguration createConfig() {
        return new JavaConfiguration();
    }

    protected void generatePublicEmitters(MethodBinding methodBinding, List<FunctionEmitter> list, boolean bl) {
        FunctionSymbol functionSymbol = methodBinding.getCSymbol();
        if (!bl && this.cfg.manuallyImplement(functionSymbol)) {
            return;
        }
        MethodAccess methodAccess = !bl && null != methodBinding.getDelegationImplName() ? MethodAccess.PRIVATE : this.cfg.accessControl(methodBinding.getName());
        if (bl && MethodAccess.PUBLIC != methodAccess) {
            return;
        }
        boolean bl2 = this.cfg.isUnimplemented(functionSymbol);
        List<String> list2 = this.cfg.javaPrologueForMethod(methodBinding, false, false);
        List<String> list3 = this.cfg.javaEpilogueForMethod(methodBinding, false, false);
        boolean bl3 = this.cfg.requiresJavaCallbackCode(methodBinding.getName());
        boolean bl4 = bl2 || methodBinding.needsNIOWrappingOrUnwrapping() || methodBinding.signatureUsesJavaPrimitiveArrays() || bl3 || null != list2 || null != list3;
        boolean bl5 = !bl && bl4;
        boolean bl6 = !bl2 && !bl4 && !bl;
        JavaCodeUnit javaCodeUnit = bl || this.cfg.allStatic() ? this.javaUnit() : this.javaImplUnit();
        JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, javaCodeUnit, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), bl5, this.cfg.tagNativeBinding(), false, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), false, false, bl2, bl, bl6, false, this.cfg);
        switch (methodAccess) {
            case PUBLIC: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
                break;
            }
            case PROTECTED: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PROTECTED);
                break;
            }
            case PRIVATE: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                break;
            }
        }
        if (this.cfg.allStatic()) {
            javaMethodBindingEmitter.addModifier(FunctionEmitter.STATIC);
        }
        if (bl6) {
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
        }
        javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
        javaMethodBindingEmitter.setPrologue(list2);
        javaMethodBindingEmitter.setEpilogue(list3);
        list.add(javaMethodBindingEmitter);
    }

    protected void generatePrivateEmitters(MethodBinding methodBinding, List<FunctionEmitter> list) {
        FunctionSymbol functionSymbol = methodBinding.getCSymbol();
        if (this.cfg.manuallyImplement(functionSymbol)) {
            return;
        }
        boolean bl = this.cfg.javaPrologueForMethod(methodBinding, false, false) != null || this.cfg.javaEpilogueForMethod(methodBinding, false, false) != null;
        boolean bl2 = this.cfg.requiresJavaCallbackCode(methodBinding.getName());
        if (!this.cfg.isUnimplemented(functionSymbol)) {
            Object object;
            if (!methodBinding.signatureUsesJavaPrimitiveArrays() && (methodBinding.needsNIOWrappingOrUnwrapping() || bl || bl2)) {
                object = this.cfg.allStatic() ? this.javaUnit() : this.javaImplUnit();
                JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, (CodeUnit)object, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), true, false, false, false, true, true, this.cfg);
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                if (this.cfg.allStatic()) {
                    javaMethodBindingEmitter.addModifier(FunctionEmitter.STATIC);
                }
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
                javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
                list.add(javaMethodBindingEmitter);
            }
            if (!methodBinding.signatureUsesJavaPrimitiveArrays()) {
                object = new CMethodBindingEmitter(methodBinding, this.cUnit(), this.cfg.implPackageName(), this.cfg.implClassName(), true, this.cfg.allStatic(), methodBinding.needsNIOWrappingOrUnwrapping() || bl || bl2, !this.cfg.useNIODirectOnly(methodBinding.getName()), this.machDescJava, this.getConfig());
                this.prepCEmitter(methodBinding.getName(), methodBinding.getJavaReturnType(), (CMethodBindingEmitter)object);
                list.add((FunctionEmitter)object);
            }
        }
    }

    protected void prepCEmitter(String string, JavaType javaType, CMethodBindingEmitter cMethodBindingEmitter) {
        if (javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper()) {
            String string2 = this.cfg.returnValueCapacity(string);
            if (string2 != null) {
                cMethodBindingEmitter.setReturnValueCapacityExpression(new MessageFormat(string2));
            }
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            if (javaType.isPrimitiveArray()) {
                throw new RuntimeException("Primitive array return types not yet supported");
            }
            String string3 = this.cfg.returnValueLength(string);
            if (string3 != null) {
                cMethodBindingEmitter.setReturnValueLengthExpression(new MessageFormat(string3));
            }
        }
        cMethodBindingEmitter.setTemporaryCVariableDeclarations(this.cfg.temporaryCVariableDeclarations(string));
        cMethodBindingEmitter.setTemporaryCVariableAssignments(this.cfg.temporaryCVariableAssignments(string));
    }

    protected List<? extends FunctionEmitter> generateMethodBindingEmitters(FunctionSymbol functionSymbol) throws Exception {
        ArrayList<FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>();
        try {
            if (this.cfg.emitInterface()) {
                this.generateMethodBindingEmittersImpl(arrayList, functionSymbol, true);
            }
            if (this.cfg.emitImpl()) {
                this.generateMethodBindingEmittersImpl(arrayList, functionSymbol, false);
            }
        }
        catch (Exception exception) {
            throw new GlueGenException("Error while generating bindings for \"" + functionSymbol + "\"", functionSymbol.getASTLocusTag(), exception);
        }
        return arrayList;
    }

    private void generateMethodBindingEmittersImpl(ArrayList<FunctionEmitter> arrayList, FunctionSymbol functionSymbol, boolean bl) throws Exception {
        MethodBinding methodBinding = this.bindFunction(functionSymbol, bl, this.machDescJava, null, null);
        List<MethodBinding> list = this.expandMethodBinding(methodBinding);
        HashSet<MethodBinding> hashSet = new HashSet<MethodBinding>();
        for (MethodBinding methodBinding2 : list) {
            if (!hashSet.add(methodBinding2)) continue;
            if (this.cfg.allStatic() && methodBinding2.hasContainingType()) {
                throw new IllegalArgumentException("Cannot create binding in AllStatic mode because method has containing type: \"" + methodBinding2 + "\"");
            }
            if (bl) {
                this.generatePublicEmitters(methodBinding2, arrayList, true);
                continue;
            }
            this.generatePublicEmitters(methodBinding2, arrayList, false);
            this.generatePrivateEmitters(methodBinding2, arrayList);
        }
    }

    @Override
    public void endFunctions() throws Exception {
        if (!this.cfg.structsOnly()) {
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                this.emitCustomJavaCode(this.javaUnit(), this.cfg.className());
            }
            if (this.cfg.allStatic() && this.cfg.emitImpl()) {
                this.emitCustomJNICode(this.cUnit(), this.cfg.className());
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                this.emitCustomJavaCode(this.javaImplUnit(), this.cfg.implClassName());
                this.emitCustomJNICode(this.cUnit(), this.cfg.implClassName());
            }
        }
    }

    @Override
    public void beginStructLayout() throws Exception {
    }

    @Override
    public void layoutStruct(CompoundType compoundType) throws Exception {
        this.getLayout().layout(compoundType);
    }

    @Override
    public void endStructLayout() throws Exception {
    }

    @Override
    public void beginStructs(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.canonMap = map;
    }

    @Override
    public void emitStruct(CompoundType compoundType, Type type) throws Exception {
        Object object;
        String string;
        String string2;
        String string3;
        Object object2;
        TypeComparator.SemanticEqualityOp semanticEqualityOp;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        int n;
        String string4;
        String string5;
        Object object10 = compoundType.getName();
        if (null != type && null != type.getName()) {
            string4 = string5 = type.getName();
        } else {
            string5 = null;
            string4 = object10;
        }
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "Struct emission of structCType {0}", (Object)compoundType);
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "              structCTypedefPtr {0}", (Object)type);
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "   : structCTypeName \"{0}\" -> typedefedName \"{1}\" -> \"{2}\"", object10, string5, string4);
        if (null == string4) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of unnamed struct {0} w/o typedef", (Object)compoundType);
            return;
        }
        Object object11 = new AliasedSymbol.AliasedSymbolImpl(string4);
        ((AliasedSymbol.AliasedSymbolImpl)object11).addAliasedName((String)object10);
        ((AliasedSymbol.AliasedSymbolImpl)object11).addAliasedName(string5);
        if (this.cfg.shouldIgnoreInInterface((AliasedSymbol)object11)) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of ignored \"{0}\": {1}", object11, compoundType);
            return;
        }
        boolean bl = this.cfg.immutableAccess((AliasedSymbol)object11);
        if (null != type && this.isOpaque(type)) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of opaque typedef {0}", (Object)type);
            return;
        }
        if (this.isOpaque(compoundType)) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of opaque c-struct {0}", (Object)compoundType);
            return;
        }
        if (null != string5) {
            object11 = type;
            n = 1;
        } else {
            object11 = new PointerType(SizeThunk.POINTER, compoundType, 0);
            ((Type)object11).setTypedefName(string5);
            n = 2;
        }
        object10 = this.canonicalize((Type)object11);
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "containingCType[{0}]: {1} -canon-> {2}", n, object11, object10);
        object11 = this.typeToJavaType((Type)object10, null);
        if (((JavaType)object11).isOpaqued()) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of opaque {0}, {1}", object11, compoundType);
            return;
        }
        if (!((JavaType)object11).isCompoundTypeWrapper()) {
            this.LOG.log(Level.WARNING, compoundType.getASTLocusTag(), "skipping emission of non-compound {0}, {1}", object11, compoundType);
            return;
        }
        String string6 = ((JavaType)object11).getName();
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "perform emission of \"{0}\" -> \"{1}\": {2}", string4, string6, compoundType);
        if (0 == compoundType.getNumFields()) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "emission of \"{0}\" with zero fields {1}", string6, compoundType);
        }
        boolean bl2 = !this.cfg.customJNICodeForClass(string6).isEmpty();
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            boolean bl3;
            object9 = compoundType.getField(i);
            object8 = ((Field)object9).getType();
            object7 = JavaConfiguration.canonicalStructFieldSymbol(string6, ((Field)object9).getName());
            if (this.cfg.shouldIgnoreInInterface((String)object7)) continue;
            object6 = this.cfg.getJavaSymbolRename((String)object7);
            object5 = object6 == null ? ((Field)object9).getName() : object6;
            object4 = JavaConfiguration.canonicalStructFieldSymbol(string6, (String)object5);
            object3 = this.cfg.canonicalNameOpaque((String)object4);
            boolean bl4 = bl3 = null != object3;
            if (!((Type)object8).isFunctionPointer() || bl3) continue;
            bl2 = true;
            break;
        }
        String string7 = this.cfg.packageForStruct(string4);
        try {
            object7 = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(string7) + File.separator + string6 + ".java";
            object9 = this.openJavaUnit((String)object7, string7, string6);
            if (null == object9) {
                return;
            }
            if (bl2) {
                object7 = this.cfg.nativeOutputDir();
                if (this.cfg.nativeOutputUsesJavaHierarchy()) {
                    object7 = (String)object7 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
                }
                object6 = string6 + "_JNI.c";
                object5 = (String)object7 + File.separator + (String)object6;
                object8 = this.openCUnit((String)object5, (String)object6);
                ((CCodeUnit)object8).emitHeader(string7, string6, this.cfg.customCCode());
            } else {
                object8 = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to open files for emission of struct class", exception);
        }
        ((CodeUnit)object9).emitln();
        ((CodeUnit)object9).emitln("package " + string7 + ";");
        ((CodeUnit)object9).emitln();
        ((CodeUnit)object9).emitln("import java.nio.*;");
        ((CodeUnit)object9).emitln("import java.nio.charset.Charset;");
        ((CodeUnit)object9).emitln("import java.nio.charset.StandardCharsets;");
        ((CodeUnit)object9).emitln();
        ((CodeUnit)object9).emitln("import " + this.cfg.gluegenRuntimePackage() + ".*;");
        ((CodeUnit)object9).emitln("import " + DynamicLookupHelper.class.getPackage().getName() + ".*;");
        ((CodeUnit)object9).emitln("import " + Buffers.class.getPackage().getName() + ".*;");
        ((CodeUnit)object9).emitln("import " + MachineDataInfoRuntime.class.getName() + ";");
        ((CodeUnit)object9).emitln();
        object7 = this.cfg.imports();
        object6 = object7.iterator();
        while (object6.hasNext()) {
            object5 = (String)object6.next();
            ((CodeUnit)object9).emit("import ");
            ((CodeUnit)object9).emit((String)object5);
            ((CodeUnit)object9).emitln(";");
        }
        ((CodeUnit)object9).emitln();
        object6 = this.cfg.javadocForClass(string6);
        object5 = object6.iterator();
        while (object5.hasNext()) {
            object4 = (String)object5.next();
            ((CodeUnit)object9).emitln((String)object4);
        }
        ((CodeUnit)object9).emit("public class " + string6 + " ");
        boolean bl5 = true;
        object4 = this.cfg.implementedInterfaces(string6);
        object3 = object4.iterator();
        while (object3.hasNext()) {
            String string8 = (String)object3.next();
            if (bl5) {
                ((CodeUnit)object9).emit("implements ");
            }
            bl5 = false;
            ((CodeUnit)object9).emit(string8);
            ((CodeUnit)object9).emit(" ");
        }
        ((CodeUnit)object9).emitln("{");
        ((CodeUnit)object9).emitln();
        ((CodeUnit)object9).emitln("  StructAccessor accessor;");
        ((CodeUnit)object9).emitln();
        object3 = this.cfg.returnStructMachineDataInfoIndex(string6);
        Object object12 = null != object3 ? object3 : "private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();";
        ((CodeUnit)object9).emitln("  " + (String)object12);
        ((CodeUnit)object9).emitln("  private final MachineDataInfo md;");
        ((CodeUnit)object9).emitln();
        this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string6, compoundType, null, null);
        if (GlueGen.debug()) {
            System.err.printf("SE.__: structCType %s%n", compoundType.getDebugString());
            System.err.printf("SE.__: contCTypeName %s%n", ((Type)object10).getDebugString());
            System.err.printf("SE.__: contJTypeName %s%n", ((JavaType)object11).getDebugString());
        }
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            Field field = compoundType.getField(i);
            semanticEqualityOp = field.getType();
            object2 = JavaConfiguration.canonicalStructFieldSymbol(string6, field.getName());
            if (!this.cfg.shouldIgnoreInInterface((String)object2)) {
                string3 = this.cfg.getJavaSymbolRename((String)object2);
                string2 = null == string3 ? field.getName() : string3;
                string = JavaConfiguration.canonicalStructFieldSymbol(string6, string2);
                if (((Type)semanticEqualityOp).isFunctionPointer()) {
                    if (GlueGen.debug()) {
                        System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "FuncPtr");
                    }
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string2, null, field, null);
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "//", string2, (Type)semanticEqualityOp, null, null);
                    continue;
                }
                if (((Type)semanticEqualityOp).isCompound()) {
                    if (((Type)semanticEqualityOp).getName() == null) {
                        throw new GlueGenException("Anonymous structs as fields not supported yet, field \"" + string + "\", " + ((Type)semanticEqualityOp).getDebugString(), ((Type)semanticEqualityOp).getASTLocusTag());
                    }
                    if (GlueGen.debug()) {
                        System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "compound");
                    }
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string2, (Type)semanticEqualityOp, field, null);
                    continue;
                }
                if (((Type)semanticEqualityOp).isArray()) {
                    object = ((Type)semanticEqualityOp).getBaseType();
                    if (GlueGen.debug()) {
                        System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "array");
                        System.err.printf("SE.os.%02d: baseType %s%n", i + 1, ((Type)object).getDebugString());
                    }
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string2, null, field, null);
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "//", string2, (Type)semanticEqualityOp, null, null);
                    continue;
                }
                try {
                    object = this.typeToJavaType((Type)semanticEqualityOp, this.machDescJava);
                }
                catch (Exception exception) {
                    throw new GlueGenException("Error occurred while creating accessor for field \"" + string + "\", " + ((Type)semanticEqualityOp).getDebugString(), ((Type)semanticEqualityOp).getASTLocusTag(), exception);
                }
                if (GlueGen.debug()) {
                    System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "MISC");
                    System.err.printf("SE.os.%02d: javaType %s%n", i + 1, ((JavaType)object).getDebugString());
                }
                if (((JavaType)object).isPrimitive()) {
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string2, null, field, null);
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "//", string2, (Type)semanticEqualityOp, null, null);
                    continue;
                }
                if (((JavaType)object).isCPrimitivePointerType()) {
                    if (this.requiresGetCStringLength((Type)semanticEqualityOp, string)) {
                        this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string2, null, field, null);
                        this.generateOffsetAndSizeArrays((CodeUnit)object9, "//", string2, (Type)semanticEqualityOp, null, "// " + ((JavaType)object).getDebugString());
                        continue;
                    }
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string2, null, field, null);
                    this.generateOffsetAndSizeArrays((CodeUnit)object9, "//", string2, (Type)semanticEqualityOp, field, "// " + ((JavaType)object).getDebugString());
                    continue;
                }
                this.generateOffsetAndSizeArrays((CodeUnit)object9, "  ", string2, null, field, null);
                this.generateOffsetAndSizeArrays((CodeUnit)object9, "//", string2, (Type)semanticEqualityOp, null, "// " + ((JavaType)object).getDebugString());
                continue;
            }
            if (!GlueGen.debug()) continue;
            System.err.printf("SE.os.%02d: %s, %s (IGNORED)%n", i + 1, field, ((Type)semanticEqualityOp).getDebugString());
        }
        ((CodeUnit)object9).emitln();
        ((CodeUnit)object9).emitln("  /** Returns true if this generated implementation uses native code, otherwise false. */");
        ((CodeUnit)object9).emitln("  public static boolean usesNativeCode() {");
        ((CodeUnit)object9).emitln("    return " + bl2 + ";");
        ((CodeUnit)object9).emitln("  }");
        ((CodeUnit)object9).emitln();
        if (!this.cfg.manuallyImplement(JavaConfiguration.canonicalStructFieldSymbol(string6, "size"))) {
            ((CodeUnit)object9).emitln("  /** Returns the aligned total size of a native instance. */");
            ((CodeUnit)object9).emitln("  public static int size() {");
            ((CodeUnit)object9).emitln("    return " + string6 + "_size[mdIdx];");
            ((CodeUnit)object9).emitln("  }");
            ((CodeUnit)object9).emitln();
        }
        if (!this.cfg.manuallyImplement(JavaConfiguration.canonicalStructFieldSymbol(string6, "create"))) {
            ((CodeUnit)object9).emitln("  /** Returns a new instance with all bytes set to zero. */");
            ((CodeUnit)object9).emitln("  public static " + string6 + " create() {");
            ((CodeUnit)object9).emitln("    return create(Buffers.newDirectByteBuffer(size()));");
            ((CodeUnit)object9).emitln("  }");
            ((CodeUnit)object9).emitln();
            ((CodeUnit)object9).emitln("  /** Returns a new instance using the given ByteBuffer having at least {#link size()} bytes capacity. The ByteBuffer will be {@link ByteBuffer#rewind()} and native-order set. */");
            ((CodeUnit)object9).emitln("  public static " + string6 + " create(java.nio.ByteBuffer buf) {");
            ((CodeUnit)object9).emitln("      return new " + string6 + "(buf);");
            ((CodeUnit)object9).emitln("  }");
            ((CodeUnit)object9).emitln();
        }
        ((CodeUnit)object9).emitln("  /** Returns new instance dereferencing ByteBuffer at given native address `addr` with size {@link #size()}. */");
        ((CodeUnit)object9).emitln("  public static " + string6 + " derefPointer(final long addr) {");
        ((CodeUnit)object9).emitln("      return create( ElementBuffer.derefPointer(size(), addr, 1).getByteBuffer() );");
        ((CodeUnit)object9).emitln("  }");
        ((CodeUnit)object9).emitln();
        if (!this.cfg.manuallyImplement(JavaConfiguration.canonicalStructFieldSymbol(string6, string6))) {
            ((CodeUnit)object9).emitln("  " + string6 + "(java.nio.ByteBuffer buf) {");
            ((CodeUnit)object9).emitln("    md = MachineDataInfo.StaticConfig.values()[mdIdx].md;");
            ((CodeUnit)object9).emitln("    accessor = new StructAccessor(buf);");
            ((CodeUnit)object9).emitln("  }");
            ((CodeUnit)object9).emitln();
        }
        ((CodeUnit)object9).emitln("  /** Return the underlying native direct ByteBuffer */");
        ((CodeUnit)object9).emitln("  public final java.nio.ByteBuffer getBuffer() {");
        ((CodeUnit)object9).emitln("    return accessor.getBuffer();");
        ((CodeUnit)object9).emitln("  }");
        ((CodeUnit)object9).emitln();
        ((CodeUnit)object9).emitln("  /** Returns the native address of the underlying native ByteBuffer {@link #getBuffer()} */");
        ((CodeUnit)object9).emitln("  public final long getDirectBufferAddress() {");
        ((CodeUnit)object9).emitln("    return accessor.getDirectBufferAddress();");
        ((CodeUnit)object9).emitln("  }");
        ((CodeUnit)object9).emitln();
        HashSet<MethodBinding> hashSet = new HashSet<MethodBinding>();
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            Object object13;
            boolean bl6;
            semanticEqualityOp = compoundType.getField(i);
            object2 = ((Field)semanticEqualityOp).getType();
            string3 = JavaConfiguration.canonicalStructFieldSymbol(string6, ((Field)semanticEqualityOp).getName());
            if (this.cfg.shouldIgnoreInInterface(string3)) continue;
            string2 = this.cfg.getJavaSymbolRename(string3);
            string = string2 == null ? ((Field)semanticEqualityOp).getName() : string2;
            object = JavaConfiguration.canonicalStructFieldSymbol(string6, string);
            TypeInfo typeInfo = this.cfg.typeInfo((Type)object2);
            boolean bl7 = null != typeInfo;
            TypeInfo typeInfo2 = this.cfg.canonicalNameOpaque((String)object);
            boolean bl8 = null != typeInfo2;
            boolean bl9 = bl6 = bl || this.cfg.immutableAccess((String)object);
            if (GlueGen.debug()) {
                System.err.printf("SE.ac.%02d: field %s / %s / rename %s -> %s / opaque %b, fieldType %s (opaque %b), immutable[struct %b, field %b]%n", i + 1, semanticEqualityOp, object, string2, string, bl8, ((Type)object2).getDebugString(), bl7, bl, bl6);
                System.err.printf("SE.ac.%02d: opaqueFieldType %s%n", i + 1, typeInfo);
            }
            if (((Type)object2).isFunctionPointer() && !bl8) {
                object13 = new FunctionSymbol(((Field)semanticEqualityOp).getName(), ((Type)object2).getTargetFunction());
                ((AliasedSymbol.AliasedSymbolImpl)object13).rename(string2);
                String string9 = CodeGenUtils.capitalizeString(string);
                if (!bl6 && !((Type)object2).isConst()) {
                    this.generateSetterSignature((CodeUnit)object9, MethodAccess.PUBLIC, false, false, string, (Type)object2, Ownership.Parent, string6, string9, null, "long", null, false, false, null, null, null);
                    ((CodeUnit)object9).emitln(" {");
                    ((CodeUnit)object9).emitln("    accessor.setLongAt(" + string + "_offset[mdIdx], src, md.pointerSizeInBytes());");
                    ((CodeUnit)object9).emitln("    return this;");
                    ((CodeUnit)object9).emitln("  }");
                    ((CodeUnit)object9).emitln();
                }
                this.generateGetterSignature((CodeUnit)object9, false, false, string, (Type)object2, Ownership.Parent, "long", string9, null, false, false, null, null);
                ((CodeUnit)object9).emitln(" {");
                ((CodeUnit)object9).emitln("    return accessor.getLongAt(" + string + "_offset[mdIdx], md.pointerSizeInBytes());");
                ((CodeUnit)object9).emitln("  }");
                ((CodeUnit)object9).emitln();
                this.generateFunctionPointerCode(hashSet, (JavaCodeUnit)object9, (CCodeUnit)object8, string4, (Type)object10, (JavaType)object11, i, (FunctionSymbol)object13, (String)object);
                continue;
            }
            if (((Type)object2).isCompound() && !bl8) {
                if (((Type)object2).getName() == null) {
                    throw new GlueGenException("Anonymous structs as fields not supported yet (field \"" + semanticEqualityOp + "\" in type \"" + string4 + "\")", ((Type)object2).getASTLocusTag());
                }
                if (!bl6 && !((Type)object2).isConst()) {
                    this.generateSetterSignature((CodeUnit)object9, MethodAccess.PUBLIC, false, false, string, (Type)object2, Ownership.Parent, string6, CodeGenUtils.capitalizeString(string), null, ((Type)object2).getName(), null, false, false, null, null, null);
                    ((CodeUnit)object9).emitln(" {");
                    ((CodeUnit)object9).emitln("    final ByteBuffer bb = src.getBuffer();");
                    ((CodeUnit)object9).emitln("    final int size = " + string + "_size[mdIdx];");
                    ((CodeUnit)object9).emitln("    final byte[] content = new byte[size];");
                    ((CodeUnit)object9).emitln("    bb.get(content, 0, size);");
                    ((CodeUnit)object9).emitln("    accessor.setBytesAt(" + string + "_offset[mdIdx], content);");
                    ((CodeUnit)object9).emitln("    return this;");
                    ((CodeUnit)object9).emitln("  }");
                    ((CodeUnit)object9).emitln();
                }
                this.generateGetterSignature((CodeUnit)object9, false, false, string, (Type)object2, Ownership.Parent, ((Type)object2).getName(), CodeGenUtils.capitalizeString(string), null, false, false, null, null);
                ((CodeUnit)object9).emitln(" {");
                ((CodeUnit)object9).emitln("    return " + ((Type)object2).getName() + ".create( accessor.slice( " + string + "_offset[mdIdx], " + string + "_size[mdIdx] ) );");
                ((CodeUnit)object9).emitln("  }");
                ((CodeUnit)object9).emitln();
                continue;
            }
            if ((((Type)object2).isArray() || ((Type)object2).isPointer()) && !bl8) {
                this.generateArrayGetterSetterCode((JavaCodeUnit)object9, compoundType, (JavaType)object11, i, (Field)semanticEqualityOp, string, bl6, (String)object);
                continue;
            }
            try {
                object13 = this.typeToJavaType((Type)object2, this.machDescJava);
            }
            catch (Exception exception) {
                throw new GlueGenException("Error occurred while creating accessor for field \"" + ((Field)semanticEqualityOp).getName() + "\", " + ((Type)object2).getDebugString(), ((Type)object2).getASTLocusTag(), exception);
            }
            if (bl7 || bl8 || ((JavaType)object13).isPrimitive()) {
                boolean bl10 = ((Type)object2).getSize().hasFixedNativeSize();
                String string10 = bl7 ? typeInfo.javaType().getName() : (bl8 ? typeInfo2.javaType().getName() : ((JavaType)object13).getName());
                String string11 = CodeGenUtils.capitalizeString(string10);
                String string12 = CodeGenUtils.capitalizeString(string);
                String string13 = ((Type)object2).isPointer() ? "pointer" : string10;
                this.LOG.log(Level.FINE, compoundType.getASTLocusTag(), "Java.StructEmitter.Primitive: " + ((Field)semanticEqualityOp).getName() + ", " + object2 + ", " + string10 + ", , fixedSize " + bl10 + ", opaque[t " + bl7 + ", f " + bl8 + "], sizeDenominator " + string13);
                if (!bl6 && !((Type)object2).isConst()) {
                    this.generateSetterSignature((CodeUnit)object9, MethodAccess.PUBLIC, false, false, string, (Type)object2, Ownership.Parent, string6, string12, null, string10, null, false, false, null, null, null);
                    ((CodeUnit)object9).emitln(" {");
                    if (bl10) {
                        ((CodeUnit)object9).emitln("    accessor.set" + string11 + "At(" + string + "_offset[mdIdx], src);");
                    } else {
                        ((CodeUnit)object9).emitln("    accessor.set" + string11 + "At(" + string + "_offset[mdIdx], src, md." + string13 + "SizeInBytes());");
                    }
                    ((CodeUnit)object9).emitln("    return this;");
                    ((CodeUnit)object9).emitln("  }");
                    ((CodeUnit)object9).emitln();
                }
                this.generateGetterSignature((CodeUnit)object9, false, false, string, (Type)object2, Ownership.Parent, string10, string12, null, false, false, null, null);
                ((CodeUnit)object9).emitln(" {");
                ((CodeUnit)object9).emit("    return ");
                if (bl10) {
                    ((CodeUnit)object9).emitln("accessor.get" + string11 + "At(" + string + "_offset[mdIdx]);");
                } else {
                    ((CodeUnit)object9).emitln("accessor.get" + string11 + "At(" + string + "_offset[mdIdx], md." + string13 + "SizeInBytes());");
                }
                ((CodeUnit)object9).emitln("  }");
            } else {
                ((CodeUnit)object9).emitln("  /** UNKNOWN: " + (String)object + ": " + ((Type)object2).getDebugString() + ", " + ((JavaType)object13).getDebugString() + " */");
            }
            ((CodeUnit)object9).emitln();
        }
        this.emitCustomJavaCode((CodeUnit)object9, string6);
        ((CodeUnit)object9).emitTailCode();
        ((CodeUnit)object9).emitln("}");
        ((CodeUnit)object9).close();
        if (bl2) {
            this.emitCustomJNICode((CodeUnit)object8, string6);
            ((CodeUnit)object8).close();
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.XX: structCType %s%n", compoundType.getDebugString());
            System.err.printf("SE.XX: contCTypeName %s%n", ((Type)object10).getDebugString());
            System.err.printf("SE.XX: contJTypeName %s%n", ((JavaType)object11).getDebugString());
        }
    }

    @Override
    public void endStructs() throws Exception {
    }

    public static int addStrings2Buffer(StringBuilder stringBuilder, String string, String string2, Collection<String> collection) {
        int n = 0;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Iterator<String> iterator = collection.iterator();
        if (null != string2) {
            stringBuilder.append(string2);
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        return n;
    }

    private void generateArrayFieldNote(CodeUnit codeUnit, String string, String string2, String string3, Type type, Ownership ownership, boolean bl, boolean bl2, String string4, boolean bl3, boolean bl4) {
        Object object;
        String string5;
        Object object2;
        boolean bl5;
        if (type.isFunctionPointer()) {
            bl5 = false;
            object2 = null;
            string5 = "being";
        } else if (type.isPointer()) {
            bl5 = true;
            object2 = type.getTargetType();
            string5 = "referencing";
        } else if (type.isArray()) {
            bl5 = true;
            object = type.getArrayBaseOrPointerTargetType();
            object2 = object != type && ((Type)object).isPointer() ? object : null;
            string5 = "being";
        } else {
            bl5 = false;
            object2 = null;
            string5 = "being";
        }
        if (bl3) {
            if (bl4) {
                codeUnit.emitln("   * <p>");
            }
            codeUnit.emit("   * ");
        }
        if (null != string) {
            codeUnit.emit(string + " ");
        }
        switch (ownership) {
            case Parent: {
                object = "a <i>struct</i> owned";
                break;
            }
            case Java: {
                object = "a <i>Java</i> owned";
                break;
            }
            case Native: {
                object = "a <i>natively</i> owned";
                break;
            }
            default: {
                object = "a <i>mixed and ambigously</i> owned (<b>warning</b>)";
            }
        }
        String string6 = type.isFunctionPointer() ? "function pointer" : (bl5 ? "array" : type.getClass().getSimpleName());
        codeUnit.emit("native field <code>" + string3 + "</code>, " + string5 + " " + (String)object + " " + string6);
        if (bl5) {
            codeUnit.emit(" with " + (bl ? "fixed" : "variable") + " element count");
            if (null != string4) {
                if (string4.startsWith("get") && string4.endsWith("()")) {
                    codeUnit.emit(" of {@link #" + string4 + "} ");
                } else {
                    codeUnit.emit(" of <code>" + string4 + "</code> ");
                }
                if (bl || Ownership.Mixed == ownership) {
                    codeUnit.emit("elements.");
                } else {
                    codeUnit.emit("initial elements.");
                }
            } else {
                codeUnit.emit(".");
            }
        } else {
            codeUnit.emit(".");
        }
        if (bl3) {
            codeUnit.emitln();
            if (bl4) {
                codeUnit.emitln("   * </p>");
            }
        }
        if (bl2) {
            if (bl3) {
                codeUnit.emitln("   * <p>");
                codeUnit.emitln("   * Maximum element count is <code>1</code>.");
                codeUnit.emitln("   * </p>");
            } else {
                codeUnit.emit(" Maximum element count is <code>1</code>.");
            }
        }
        if (bl3) {
            codeUnit.emitln("   * <p>");
            if (null == object2) {
                codeUnit.emitln("   * Native Field Signature <code>" + type.getSignature(null).toString() + "</code>");
            } else {
                codeUnit.emitln("   * Native Signature:");
                codeUnit.emitln("   * <ul>");
                codeUnit.emitln("   *   <li>field-type <code>" + type.getSignature(null).toString() + "</code></li>");
                codeUnit.emitln("   *   <li>referenced <code>" + ((Type)object2).getSignature(null).toString() + "</code></li>");
                codeUnit.emitln("   * </ul>");
            }
            codeUnit.emitln("   * </p>");
        } else {
            codeUnit.emit(" NativeSig <code>" + type.getSignature(null).toString() + "</code>");
        }
        if (null != string2) {
            codeUnit.emit(" " + string2);
        }
        if (!bl3) {
            codeUnit.emitln();
        }
    }

    private void generateIsNullSignature(CodeUnit codeUnit, boolean bl, String string, Type type, Ownership ownership, String string2, boolean bl2, boolean bl3, String string3) {
        codeUnit.emitln("  /**");
        codeUnit.emitln("   * Returns `true` if native pointer <code>" + string + "</code> is `null`, otherwise `false`.");
        this.generateArrayFieldNote(codeUnit, "Corresponds to", null, string, type, ownership, bl2, bl3, string3, true, true);
        codeUnit.emitln("   */");
        codeUnit.emit("  public " + (bl ? "abstract " : "final ") + "boolean is" + string2 + "Null()");
    }

    private void generateReleaseSignature(CodeUnit codeUnit, boolean bl, String string, Type type, Ownership ownership, String string2, String string3, boolean bl2, boolean bl3, String string4) {
        codeUnit.emitln("  /**");
        this.generateArrayFieldNote(codeUnit, "Releases memory referenced by", null, string, type, ownership, bl2, bl3, string4, true, false);
        codeUnit.emitln("   */");
        codeUnit.emit("  public " + (bl ? "abstract " : "final ") + string2 + " release" + string3 + "()");
    }

    private void generateGetterSignature(CodeUnit codeUnit, boolean bl, boolean bl2, String string, Type type, Ownership ownership, String string2, String string3, String string4, boolean bl3, boolean bl4, String string5, String string6) {
        codeUnit.emitln("  /**");
        this.generateArrayFieldNote(codeUnit, "Getter for", null, string, type, ownership, bl3, bl4, string5, true, false);
        if (null != string6) {
            codeUnit.emitln("   * " + string6);
        }
        codeUnit.emitln("   */");
        codeUnit.emit("  public " + (bl ? "static " : "final ") + (bl2 ? "abstract " : "") + string2 + " get" + string3 + "(");
        if (null != string4) {
            codeUnit.emit(string4);
        }
        codeUnit.emit(")");
    }

    private void generateSetterSignature(CodeUnit codeUnit, MethodAccess methodAccess, boolean bl, boolean bl2, String string, Type type, Ownership ownership, String string2, String string3, String string4, String string5, String string6, boolean bl3, boolean bl4, String string7, String string8, String string9) {
        codeUnit.emitln("  /**");
        this.generateArrayFieldNote(codeUnit, "Setter for", null, string, type, ownership, bl3, bl4, string7, true, false);
        if (null != string8) {
            codeUnit.emitln("   * <p>");
            codeUnit.emitln("   * " + string8);
            codeUnit.emitln("   * </p>");
        }
        if (null != string9) {
            codeUnit.emitln(string9);
        }
        codeUnit.emitln("   */");
        codeUnit.emit("  " + methodAccess.getJavaName() + " " + (bl ? "static " : "final ") + (bl2 ? "abstract " : "") + string2 + " set" + string3 + "(");
        if (null != string4) {
            codeUnit.emit(string4 + ", ");
        }
        codeUnit.emit(string5 + " src");
        if (null != string6) {
            codeUnit.emit(", " + string6);
        }
        codeUnit.emit(")");
    }

    private void generateOffsetAndSizeArrays(CodeUnit codeUnit, String string, String string2, Type type, Field field, String string3) {
        int n;
        if (null != field) {
            codeUnit.emit(string + "private static final int[] " + string2 + "_offset = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    codeUnit.emit(", ");
                }
                codeUnit.emit(field.getOffset(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            codeUnit.emitln(" };");
        }
        if (null != type) {
            codeUnit.emit(string + "private static final int[] " + string2 + "_size = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    codeUnit.emit(", ");
                }
                codeUnit.emit(type.getSize(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            codeUnit.emit("  };");
            if (null != string3) {
                codeUnit.emitln(string3);
            } else {
                codeUnit.emitln();
            }
        }
    }

    private void generateJavaCallbackCode(JavaConfiguration.JavaCallbackDef javaCallbackDef, FunctionType functionType) {
        FunctionSymbol functionSymbol = new FunctionSymbol("callback", functionType);
        functionSymbol.addAliasedName(javaCallbackDef.cbFuncTypeName);
        this.LOG.log(Level.INFO, "JavaCallback: fSym {0}, {1}", functionSymbol.getAliasedString(), javaCallbackDef);
        String string = CodeGenUtils.capitalizeString(javaCallbackDef.cbFuncTypeName);
        String string2 = this.cfg.packageName() + "." + this.cfg.className() + "." + string;
        JavaConfiguration.JavaCallbackInfo javaCallbackInfo = this.javaCallbackInterfaceMap.get(string2);
        if (null != javaCallbackInfo) {
            if (javaCallbackInfo.cbFuncUserParamIdx != javaCallbackDef.cbFuncUserParamIdx) {
                throw new UnsupportedOperationException("Reused FuncTypeName " + javaCallbackDef.cbFuncTypeName + " used with different FuncUserParamIdx " + javaCallbackInfo.cbFuncUserParamIdx + " -> " + javaCallbackDef.cbFuncUserParamIdx + ". Func " + functionType.toString(javaCallbackDef.cbFuncTypeName, false, true));
            }
            JavaConfiguration.JavaCallbackInfo javaCallbackInfo2 = new JavaConfiguration.JavaCallbackInfo(javaCallbackDef.cbFuncTypeName, string, string2, javaCallbackInfo.staticCBMethodSignature, functionType, javaCallbackInfo.cbFuncBinding, javaCallbackInfo.cbFuncUserParamIdx, javaCallbackDef.cbFuncKeyIndices, javaCallbackDef.setFuncName, javaCallbackDef.setFuncUserParamIdx, javaCallbackDef.setFuncKeyIndices, javaCallbackDef.userParamClassName, javaCallbackDef.customKeyClassName);
            this.cfg.setFuncToJavaCallbackMap.put(javaCallbackDef.setFuncName, javaCallbackInfo2);
            this.LOG.log(Level.INFO, "JavaCallbackInfo: Reusing {0} -> {1}", javaCallbackDef.setFuncName, javaCallbackInfo);
        } else {
            List<MethodBinding> list;
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.cfg.shouldIgnoreInInterface(javaCallbackDef.cbFuncTypeName)) {
                this.javaUnit.emitln("  /** JavaCallback interface: " + javaCallbackDef.cbFuncTypeName + " -> " + functionType.toString(javaCallbackDef.cbFuncTypeName, false, true) + " */");
                this.javaUnit.emitln("  public static interface " + string + " {");
                list = this.generateFunctionInterfaceCode(this.javaUnit, functionSymbol, javaCallbackDef, stringBuilder);
                this.javaUnit.emitln("  }");
                this.javaUnit.emitln();
            } else {
                this.LOG.log(Level.WARNING, "JavaCallbackInfo: Java Configuration indicate current JavaCallback must be ignored so assume JavaCallback meet presents requirements of {0}", (Object)javaCallbackDef.setFuncName);
                list = this.generateFunctionInterfaceCode(null, functionSymbol, javaCallbackDef, stringBuilder);
            }
            if (1 != list.size()) {
                throw new UnsupportedOperationException("Multiple bindings generated where only 1 is allowed for func " + functionType.toString(javaCallbackDef.cbFuncTypeName, false, true));
            }
            MethodBinding methodBinding = list.get(0);
            if (!methodBinding.getJavaReturnType().isVoid() && !methodBinding.getJavaReturnType().isPrimitive()) {
                throw new UnsupportedOperationException("Non void or non-primitive callback return types not suppored. Java " + methodBinding.getJavaReturnType() + ", func " + functionType.toString(javaCallbackDef.cbFuncTypeName, false, true));
            }
            JavaConfiguration.JavaCallbackInfo javaCallbackInfo3 = new JavaConfiguration.JavaCallbackInfo(javaCallbackDef.cbFuncTypeName, string, string2, stringBuilder.toString(), functionType, methodBinding, javaCallbackDef.cbFuncUserParamIdx, javaCallbackDef.cbFuncKeyIndices, javaCallbackDef.setFuncName, javaCallbackDef.setFuncUserParamIdx, javaCallbackDef.setFuncKeyIndices, javaCallbackDef.userParamClassName, javaCallbackDef.customKeyClassName);
            this.cfg.setFuncToJavaCallbackMap.put(javaCallbackDef.setFuncName, javaCallbackInfo3);
            this.javaCallbackInterfaceMap.put(string2, javaCallbackInfo3);
            this.LOG.log(Level.INFO, "JavaCallbackInfo: Added {0} -> {1}", javaCallbackDef.setFuncName, javaCallbackInfo3);
        }
    }

    private List<MethodBinding> generateFunctionInterfaceCode(JavaCodeUnit javaCodeUnit, FunctionSymbol functionSymbol, JavaConfiguration.JavaCallbackDef javaCallbackDef, StringBuilder stringBuilder) {
        Object object;
        JavaType javaType;
        MethodBinding methodBinding = this.bindFunction(functionSymbol, true, this.machDescJava, null, null);
        int n = javaCallbackDef.cbFuncUserParamIdx;
        if (0 <= n && n < methodBinding.getNumArguments() && (javaType = methodBinding.getJavaArgumentType(n)).isCVoidPointerType()) {
            if (null != javaCallbackDef.userParamClassName) {
                object = JavaType.createForNamedClass(javaCallbackDef.userParamClassName);
                methodBinding = methodBinding.replaceJavaArgumentType(n, JavaType.forObjectClass());
            } else {
                object = JavaType.forObjectClass();
            }
            methodBinding = methodBinding.replaceJavaArgumentType(n, (JavaType)object);
        }
        stringBuilder.append("(");
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            object = methodBinding.getJavaArgumentType(i);
            stringBuilder.append(((JavaType)object).getDescriptor(this.cfg));
        }
        stringBuilder.append(")");
        Object object2 = methodBinding.getJavaReturnType();
        stringBuilder.append(((JavaType)object2).getDescriptor(this.cfg));
        object2 = this.expandMethodBinding(methodBinding);
        if (null != javaCodeUnit) {
            object = object2.iterator();
            while (object.hasNext()) {
                MethodBinding methodBinding2 = (MethodBinding)object.next();
                JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, javaCodeUnit, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), false, true, true, false, false, true, true, false, false, this.cfg){

                    @Override
                    protected String getBaseIndentString() {
                        return "    ";
                    }
                };
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
                javaMethodBindingEmitter.emit();
            }
        }
        return object2;
    }

    private void generateFunctionPointerCode(Set<MethodBinding> set, JavaCodeUnit javaCodeUnit, CCodeUnit cCodeUnit, String string, Type type, JavaType javaType, int n, FunctionSymbol functionSymbol, String string2) {
        MethodBinding methodBinding = this.bindFunction(functionSymbol, true, this.machDescJava, javaType, type);
        methodBinding.findThisPointer();
        List<MethodBinding> list = this.expandMethodBinding(methodBinding);
        for (MethodBinding methodBinding2 : list) {
            if (!set.add(methodBinding2)) continue;
            JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, javaCodeUnit, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), true, this.cfg.tagNativeBinding(), false, true, true, false, false, false, false, false, false, this.cfg);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.FINAL);
            javaMethodBindingEmitter.emit();
            javaCodeUnit.emitln();
            javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, javaCodeUnit, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, true, true, true, false, false, false, false, true, this.cfg);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
            javaMethodBindingEmitter.emit();
            javaCodeUnit.emitln();
            CMethodBindingEmitter cMethodBindingEmitter = new CMethodBindingEmitter(methodBinding2, cCodeUnit, javaCodeUnit.pkgName, javaType.getName(), true, false, true, false, this.machDescJava, this.getConfig());
            cMethodBindingEmitter.setIsCStructFunctionPointer(true);
            this.prepCEmitter(string2, methodBinding2.getJavaReturnType(), cMethodBindingEmitter);
            cMethodBindingEmitter.emit();
            cCodeUnit.emitln();
        }
    }

    private String getArrayArrayLengthExpr(ArrayType arrayType, String string, boolean[] blArray, int[][] nArray) {
        int[] nArray2 = new int[arrayType.arrayDimension()];
        nArray[0] = nArray2;
        StringBuilder stringBuilder = new StringBuilder();
        blArray[0] = true;
        ArrayType arrayType2 = arrayType;
        for (int i = 0; i < nArray2.length; ++i) {
            if (null != arrayType2 && arrayType2.hasLength()) {
                nArray2[i] = arrayType2.getLength();
                if (0 < i) {
                    stringBuilder.append("*");
                }
                stringBuilder.append(nArray2[i]);
            } else {
                nArray2[i] = -1;
                blArray[0] = false;
            }
            if (null == arrayType2) continue;
            arrayType2 = arrayType2.getTargetType().asArray();
        }
        String string2 = this.cfg.returnedArrayLength(string);
        if (null != string2) {
            if (blArray[0]) {
                this.LOG.log(Level.WARNING, arrayType.getASTLocusTag(), "struct array field '" + string + "' of '" + arrayType + "' length '" + Arrays.toString(nArray2) + "' overwritten by cfg-expression: " + string2);
            }
            return string2;
        }
        if (blArray[0]) {
            return stringBuilder.toString();
        }
        this.LOG.log(Level.WARNING, arrayType.getASTLocusTag(), "struct array field '" + string + "' length '" + Arrays.toString(nArray2) + "' without fixed- nor configured-size: {0}", (Object)arrayType);
        return null;
    }

    private boolean requiresGetCStringLength(Type type, String string) {
        if (!this.cfg.returnsString(string) && !this.cfg.returnsStringOnly(string)) {
            return false;
        }
        PointerType pointerType = type.asPointer();
        if (null != pointerType) {
            return null == this.cfg.returnedArrayLength(string);
        }
        return false;
    }

    private void generateArrayGetterSetterCode(JavaCodeUnit javaCodeUnit, CompoundType compoundType, JavaType javaType, int n, Field field, String string, boolean bl, String string2) throws Exception {
        boolean bl2;
        String string3;
        Object object;
        boolean bl3;
        String string4;
        boolean bl4;
        int n2;
        String string5;
        Object object2;
        Class<? extends Buffer> clazz;
        boolean bl5;
        boolean bl6;
        String string6;
        boolean bl7;
        boolean bl8;
        String string7;
        JavaType javaType2;
        boolean bl9;
        Ownership ownership;
        boolean bl10;
        Object object3;
        boolean bl11;
        boolean bl12;
        boolean bl13;
        boolean bl14;
        Type type = field.getType();
        TypeInfo typeInfo = this.cfg.typeInfo(type);
        boolean bl15 = null != typeInfo;
        Type type2 = type.getArrayBaseOrPointerTargetType();
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: fieldName    %s, fqName %s%n", n + 1, string, string2);
            System.err.printf("SE.ac.%02d: structCType  %s, %s%n", n + 1, compoundType.toString(), compoundType.getSignature(null).toString());
            System.err.printf("SE.ac.%02d: fieldType    %s, %s%n", n + 1, type.toString(), type.getSignature(null).toString());
            System.err.printf("SE.ac.%02d: opaqueInfo   %b, %s%n", n + 1, bl15, typeInfo);
            System.err.printf("SE.ac.%02d: baseElemType %s, %s%n", n + 1, type2.toString(), type2.getSignature(null).toString());
        }
        String string8 = javaType.getName();
        boolean bl16 = this.cfg.returnsStringOnly(string2);
        boolean bl17 = bl14 = bl16 || this.cfg.returnsString(string2);
        if (bl14) {
            javaCodeUnit.addTailCode(optStringCharsetCode);
        }
        MethodAccess methodAccess = MethodAccess.PUBLIC;
        if (bl15 && typeInfo.pointerDepth() <= 1 || type.isPrimitive() && !type2.isFunctionPointer() || type.isPointer() && type2.isVoid()) {
            bl13 = true;
            bl12 = false;
            bl11 = type.isConst();
            object3 = "1";
            bl10 = true;
            ownership = Ownership.Parent;
            bl9 = true;
            javaType2 = null;
            string7 = this.compatiblePrimitiveJavaTypeName(type, this.machDescJava);
            bl8 = false;
            bl7 = type.isPointer();
            string6 = bl7 ? "pointer" : string7;
            bl6 = false;
            bl5 = true;
        } else {
            Object object4;
            if (type.arrayDimension() > 0) {
                object4 = new int[1][];
                boolean[] blArray = new boolean[]{false};
                object3 = this.getArrayArrayLengthExpr(type.asArray(), string2, blArray, (int[][])object4);
                if (null == object3) {
                    String string9 = "SKIP unsized array in struct: " + string2 + ": " + type.getSignature(null).toString();
                    javaCodeUnit.emitln("  // " + string9);
                    javaCodeUnit.emitln();
                    this.LOG.log(Level.WARNING, compoundType.getASTLocusTag(), string9);
                    return;
                }
                bl10 = blArray[0];
                ownership = Ownership.Parent;
                bl9 = bl10;
                bl12 = false;
                bl6 = false;
            } else {
                object4 = this.cfg.returnedArrayLength(string2);
                bl12 = true;
                if (null == object4 && bl14) {
                    bl6 = true;
                    javaCodeUnit.addTailCode(optStringMaxStrnlenCode);
                    object3 = "Buffers.strnlen(pString, _max_strnlen)+1";
                    bl10 = false;
                    ownership = Ownership.Java;
                    bl9 = bl10;
                } else if (null == object4) {
                    bl6 = false;
                    object3 = "0";
                    bl10 = false;
                    ownership = Ownership.Java;
                    bl9 = bl10;
                } else {
                    bl6 = false;
                    object3 = object4;
                    boolean bl18 = false;
                    boolean bl19 = false;
                    try {
                        Integer.parseInt((String)object3);
                        bl18 = true;
                        bl19 = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl18 && ((String)object3).startsWith("get") && ((String)object3).endsWith("()")) {
                        String string10 = ((String)object3).substring(3, ((String)object3).length() - 2);
                        clazz = CodeGenUtils.decapitalizeString(string10);
                        object2 = compoundType.getField((String)((Object)clazz));
                        if (null == object2) {
                            clazz = string10;
                            object2 = compoundType.getField((String)((Object)clazz));
                        }
                        if (null == object2) {
                            throw new GlueGenException("Unable to creating array accessors for field \"" + string2 + "\", because elemCountExpr specify following getter \"" + (String)object3 + "\" and host structure doesn't contain following field \"" + CodeGenUtils.decapitalizeString(string10) + "\" or \"" + string10 + "\"", type.getASTLocusTag());
                        }
                        bl18 = ((Field)object2).getType().isConst();
                        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), javaCodeUnit.className + ": elemCountExpr " + (String)object3 + ", lenFieldName " + (String)((Object)clazz) + " -> " + ((Field)object2).toString() + ", isConst " + bl18);
                    }
                    ownership = (bl10 = bl18) ? Ownership.Native : Ownership.Mixed;
                    bl9 = bl19;
                }
            }
            boolean bl20 = this.cfg.maxOneElement(string2);
            if (!bl20) {
                try {
                    bl20 = 1 == Integer.parseInt((String)object3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bl5 = bl20;
            if (GlueGen.debug()) {
                System.err.printf("SE.ac.%02d: ownership %s%n", new Object[]{n + 1, ownership});
            }
            bl7 = type2.isPointer();
            bl11 = type2.isConst();
            if (bl7) {
                javaType2 = this.javaType(Long.TYPE);
            } else {
                try {
                    javaType2 = this.typeToJavaType(type2, this.machDescJava);
                }
                catch (Exception exception) {
                    throw new GlueGenException("Error occurred while creating array/pointer accessor for field \"" + string2 + "\", baseType " + type2.getDebugString() + ", topType " + type.getDebugString(), type.getASTLocusTag(), exception);
                }
            }
            string7 = javaType2.getName();
            bl13 = javaType2.isPrimitive() || type2.isPrimitive() || type2.isFunctionPointer();
            bl8 = bl13 ? type2.getSize().hasFixedNativeSize() : false;
            String string11 = string6 = bl7 ? "pointer" : string7;
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: baseJElemType %s%n", n + 1, null != javaType2 ? javaType2.getDebugString() : null);
        }
        if (bl13) {
            clazz = Buffers.typeNameToBufferClass(string7);
            if (null == clazz) {
                object2 = "Failed to map '" + string7 + "' to Buffer class, field " + field + ", j-type " + javaType2;
                javaCodeUnit.emitln("  // ERROR: " + (String)object2);
                javaCodeUnit.emitln();
                this.LOG.log(Level.SEVERE, compoundType.getASTLocusTag(), (String)object2);
                throw new InternalError((String)object2);
            }
            string5 = clazz.getSimpleName();
            n2 = Buffers.sizeOfBufferElem(clazz);
            boolean bl21 = bl4 = null != clazz ? ByteBuffer.class.isAssignableFrom(clazz) : false;
            string4 = bl8 ? String.valueOf(n2) : "md." + string6 + "SizeInBytes()";
        } else {
            string5 = null;
            n2 = 0;
            bl4 = false;
            string4 = null;
        }
        clazz = CodeGenUtils.capitalizeString(string);
        if (bl10) {
            bl3 = true;
            object = "get" + (String)((Object)clazz) + "ElemCount()";
            string3 = null;
        } else if (bl6) {
            bl3 = true;
            object = "get" + (String)((Object)clazz) + "ElemCount()";
            string3 = null;
        } else if (((String)object3).startsWith("get") && ((String)object3).endsWith("()")) {
            bl3 = false;
            object = object3;
            string3 = "set" + ((String)object3).substring(3, ((String)object3).length() - 2);
        } else {
            bl3 = true;
            object = "get" + (String)((Object)clazz) + "ElemCount()";
            string3 = "set" + (String)((Object)clazz) + "ElemCount";
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: baseJElemTypeName %s%n", n + 1, string7);
            System.err.printf("SE.ac.%02d: elemCountExpr: %s (const %b, ownership %s), ownArrayLenCpde %b, maxOneElement %b, Primitive[is %b, aptr %b, buffer %s, fixedSize %b, elemSize %d, sizeDenom %s, sizeExpr %s, isByteBuffer %b], isString[%b, only %b, strnlen %b], isPointer %b, isOpaque %b, constVal %b, immutableAccess %b%n", new Object[]{n + 1, object3, bl10, ownership, bl3, bl5, bl13, bl7, string5, bl8, n2, string6, string4, bl4, bl14, bl16, bl6, bl12, bl15, bl11, bl});
        }
        if (bl3) {
            if (bl10) {
                if (!bl13 || bl12 || !bl9 || !bl5) {
                    this.generateGetterSignature(javaCodeUnit, bl9, false, string, type, ownership, "int", (String)((Object)clazz) + "ElemCount", null, bl10, bl5, (String)object3, GetElemCountApiDocTail);
                    javaCodeUnit.emitln(" { return " + (String)object3 + "; }");
                }
            } else if (bl6) {
                this.generateGetterSignature(javaCodeUnit, bl9, false, string, type, ownership, "int", (String)((Object)clazz) + "ElemCount", null, bl10, bl5, (String)object3, GetElemCountApiDocTail);
                javaCodeUnit.emitln(" {");
                javaCodeUnit.emitln("    final long pString = PointerBuffer.wrap( accessor.slice(" + string + "_offset[mdIdx],  PointerBuffer.POINTER_SIZE) ).get(0);");
                javaCodeUnit.emitln("    return 0 != pString ? " + (String)object3 + " : 0;");
                javaCodeUnit.emitln("  }");
            } else {
                javaCodeUnit.emitln("  private int _" + string + "ArrayLen = " + (String)object3 + "; // " + (bl10 ? "const" : "initial") + " array length");
                this.generateGetterSignature(javaCodeUnit, bl9, false, string, type, ownership, "int", (String)((Object)clazz) + "ElemCount", null, bl10, bl5, (String)object3, GetElemCountApiDocTail);
                javaCodeUnit.emitln("  { return _" + string + "ArrayLen; }");
                if (!bl) {
                    this.generateSetterSignature(javaCodeUnit, MethodAccess.PRIVATE, bl9, false, string, type, ownership, "void", (String)((Object)clazz) + "ElemCount", null, "int", null, bl10, bl5, (String)object3, null, null);
                    javaCodeUnit.emitln("  { _" + string + "ArrayLen = src; }");
                }
            }
            javaCodeUnit.emitln();
        }
        if (bl12) {
            this.generateIsNullSignature(javaCodeUnit, false, string, type, ownership, (String)((Object)clazz), bl10, bl5, (String)object3);
            javaCodeUnit.emitln(" {");
            javaCodeUnit.emitln("    return 0 == PointerBuffer.wrap(getBuffer(), " + string + "_offset[mdIdx], 1).get(0);");
            javaCodeUnit.emitln("  }");
            javaCodeUnit.emitln();
            if (!bl10 && !bl) {
                this.generateReleaseSignature(javaCodeUnit, false, string, type, ownership, string8, (String)((Object)clazz), bl10, bl5, (String)object3);
                javaCodeUnit.emitln(" {");
                javaCodeUnit.emitln("    accessor.setLongAt(" + string + "_offset[mdIdx], 0, md.pointerSizeInBytes()); // write nullptr");
                javaCodeUnit.emitln("    _eb" + (String)((Object)clazz) + " = null;");
                this.emitSetElemCount(javaCodeUnit, string3, "0", !bl6, (String)((Object)clazz), compoundType, "    ");
                javaCodeUnit.emitln("    return this;");
                javaCodeUnit.emitln("  }");
                javaCodeUnit.emitln("  @SuppressWarnings(\"unused\")");
                if (bl7) {
                    javaCodeUnit.emitln("  private PointerBuffer _eb" + (String)((Object)clazz) + "; // cache new memory buffer ensuring same lifecycle");
                } else {
                    javaCodeUnit.emitln("  private ElementBuffer _eb" + (String)((Object)clazz) + "; // cache new memory buffer ensuring same lifecycle");
                }
                javaCodeUnit.emitln();
            }
        }
        if (bl) {
            this.generateArrayFieldNote(javaCodeUnit, "  /** SKIP setter for immutable", " */", string, type, ownership, bl10, bl5, (String)object3, false, false);
            javaCodeUnit.emitln();
        } else if (bl12 && bl11 && (Ownership.Native == ownership || bl10)) {
            this.generateArrayFieldNote(javaCodeUnit, "  /** SKIP setter for constValue constElemCount Pointer w/ native ownership", " */", string, type, ownership, bl10, bl5, (String)object3, false, false);
            javaCodeUnit.emitln();
        } else if (!bl12 && bl11) {
            this.generateArrayFieldNote(javaCodeUnit, "  /** SKIP setter for constValue Array", " */", string, type, ownership, bl10, bl5, (String)object3, false, false);
            javaCodeUnit.emitln();
        } else if (bl13) {
            if (bl5) {
                if (bl12) {
                    this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7, null, bl10, bl5, (String)object3, null, null);
                    if (bl11) {
                        if (Ownership.Native == ownership) {
                            throw new InternalError("Native ownership but adding potential memory-replacement for '" + string2 + "': " + type.getSignature(null).toString());
                        }
                        javaCodeUnit.emitln(" {");
                        if (bl7) {
                            javaCodeUnit.emitln("    final PointerBuffer eb = PointerBuffer.allocateDirect(1);");
                            javaCodeUnit.emitln("    eb.put(0, src);");
                        } else {
                            javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.allocateDirect(" + string4 + ", 1);");
                            javaCodeUnit.emit("    eb.getByteBuffer()");
                            if (!bl4) {
                                javaCodeUnit.emit(".as" + string5 + "()");
                            }
                            javaCodeUnit.emitln(".put(0, src);");
                        }
                        javaCodeUnit.emitln("    eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                        javaCodeUnit.emitln("    _eb" + (String)((Object)clazz) + " = eb;");
                        this.emitSetElemCount(javaCodeUnit, string3, "1", !bl6, (String)((Object)clazz), compoundType, "      ");
                        javaCodeUnit.emitln("    return this;");
                        javaCodeUnit.emitln("  }");
                    } else {
                        javaCodeUnit.emitln(" {");
                        javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                        javaCodeUnit.emitln("    if( 1 == elemCount ) {");
                        if (bl7) {
                            javaCodeUnit.emitln("      PointerBuffer.derefPointer(getBuffer(), " + string + "_offset[mdIdx], 1)");
                            javaCodeUnit.emitln("        .put(0, src);");
                        } else {
                            javaCodeUnit.emitln("      ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], 1)");
                            javaCodeUnit.emit("        .getByteBuffer()");
                            if (!bl4) {
                                javaCodeUnit.emit(".as" + string5 + "()");
                            }
                            javaCodeUnit.emitln(".put(0, src);");
                        }
                        javaCodeUnit.emitln("    } else {");
                        if (bl10 || Ownership.Native == ownership) {
                            javaCodeUnit.emitln("      throw new RuntimeException(\"Primitive '" + string + "' of " + (Object)((Object)ownership) + " ownership and maxOneElement has " + (bl10 ? "const" : "") + "elemCount \"+elemCount);");
                            javaCodeUnit.emitln("    }");
                            javaCodeUnit.emitln("    return this;");
                            javaCodeUnit.emitln("  }");
                        } else {
                            if (bl7) {
                                javaCodeUnit.emitln("      final PointerBuffer eb = PointerBuffer.allocateDirect(1);");
                                javaCodeUnit.emitln("      eb.put(0, src);");
                            } else {
                                javaCodeUnit.emitln("      final ElementBuffer eb = ElementBuffer.allocateDirect(" + string4 + ", 1);");
                                javaCodeUnit.emit("      eb.getByteBuffer()");
                                if (!bl4) {
                                    javaCodeUnit.emit(".as" + string5 + "()");
                                }
                                javaCodeUnit.emitln(".put(0, src);");
                            }
                            javaCodeUnit.emitln("      eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                            javaCodeUnit.emitln("      _eb" + (String)((Object)clazz) + " = eb;");
                            this.emitSetElemCount(javaCodeUnit, string3, "1", !bl6, (String)((Object)clazz), compoundType, "      ");
                            javaCodeUnit.emitln("    }");
                            javaCodeUnit.emitln("    return this;");
                            javaCodeUnit.emitln("  }");
                        }
                    }
                } else {
                    this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7, null, bl10, bl5, (String)object3, null, null);
                    javaCodeUnit.emitln(" {");
                    if (bl7) {
                        javaCodeUnit.emitln("    PointerBuffer.wrap(getBuffer(), " + string + "_offset[mdIdx], 1).put(0, src);");
                    } else {
                        javaCodeUnit.emitln("    ElementBuffer.wrap(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], 1)");
                        javaCodeUnit.emit("      .getByteBuffer()");
                        if (!bl4) {
                            javaCodeUnit.emit(".as" + string5 + "()");
                        }
                        javaCodeUnit.emitln(".put(0, src);");
                    }
                    javaCodeUnit.emitln("    return this;");
                    javaCodeUnit.emitln("  }");
                }
                javaCodeUnit.emitln();
            } else {
                bl2 = false;
                if (bl14 && bl4 && bl12) {
                    this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, "String", null, bl10, bl5, (String)object3, null, null);
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln("    final byte[] srcBytes = src.getBytes(_charset);");
                    if (bl10 || Ownership.Native == ownership) {
                        javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                        javaCodeUnit.emitln("    if( srcBytes.length + 1 != elemCount ) { throw new IllegalArgumentException(\"strlen+1 \"+(srcBytes.length+1)+\" != " + (bl10 ? "const" : "") + " elemCount \"+elemCount+\" of " + (Object)((Object)ownership) + " ownership\"); };");
                        javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                    } else {
                        javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.allocateDirect(" + string4 + ", srcBytes.length + 1);");
                    }
                    javaCodeUnit.emitln("    eb.getByteBuffer().put(srcBytes, 0, srcBytes.length).put((byte)0).rewind(); // w/ EOS");
                    if (!bl10) {
                        javaCodeUnit.emitln("    eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                        javaCodeUnit.emitln("    _eb" + (String)((Object)clazz) + " = eb;");
                        this.emitSetElemCount(javaCodeUnit, string3, "srcBytes.length + 1", !bl6, (String)((Object)clazz), compoundType, "    ");
                    }
                    javaCodeUnit.emitln("    return this;");
                    javaCodeUnit.emitln("  }");
                    javaCodeUnit.emitln();
                    bl2 = true;
                }
                if (bl2 && bl16) {
                    this.generateArrayFieldNote(javaCodeUnit, "  /** SKIP setter for String alternative (ByteBuffer)", " */", string, type, ownership, bl10, bl5, (String)object3, false, false);
                } else if (bl11) {
                    if (bl12) {
                        this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7 + "[]", SetReplaceArrayArgsPost, bl10, bl5, (String)object3, SetReplaceArrayApiDocDetail, SetReplaceArrayApiDocArgs);
                        if (Ownership.Native == ownership) {
                            throw new InternalError("Native ownership but adding potential memory-replacement for '" + string2 + "': " + type.getSignature(null).toString());
                        }
                        javaCodeUnit.emitln(" {");
                        if (bl7) {
                            javaCodeUnit.emitln("    final PointerBuffer eb = PointerBuffer.allocateDirect(length);");
                        } else {
                            javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.allocateDirect(" + string4 + ", length);");
                        }
                        javaCodeUnit.emitln("    eb.put(src, srcPos, 0, length).storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                        javaCodeUnit.emitln("    _eb" + (String)((Object)clazz) + " = eb;");
                        this.emitSetElemCount(javaCodeUnit, string3, "length", !bl6, (String)((Object)clazz), compoundType, "    ");
                        javaCodeUnit.emitln("    return this;");
                        javaCodeUnit.emitln("  }");
                    }
                } else if (bl10 || !bl12) {
                    this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7 + "[]", "final int srcPos, final int destPos, final int length", bl10, bl5, (String)object3, SetSubArrayApiDocDetail, SetSubArrayApiDocArgs);
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                    if (bl7) {
                        if (bl12) {
                            javaCodeUnit.emitln("    final PointerBuffer eb = PointerBuffer.derefPointer(getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                        } else {
                            javaCodeUnit.emitln("    final PointerBuffer eb = PointerBuffer.wrap(getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                        }
                    } else if (bl12) {
                        javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                    } else {
                        javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.wrap(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                    }
                    javaCodeUnit.emitln("    eb.put(src, srcPos, destPos, length);");
                    javaCodeUnit.emitln("    return this;");
                    javaCodeUnit.emitln("  }");
                } else {
                    this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), SetArrayArgsPre, string7 + "[]", "final int srcPos, final int destPos, final int length", bl10, bl5, (String)object3, SetArrayApiDocDetail, SetArrayApiDocArgs);
                    if (Ownership.Native == ownership) {
                        throw new InternalError("Native ownership but adding potential memory-replacement for '" + string2 + "': " + type.getSignature(null).toString());
                    }
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                    javaCodeUnit.emitln("    if( subset || destPos + length == elemCount ) {");
                    if (bl7) {
                        javaCodeUnit.emitln("      final PointerBuffer eb = PointerBuffer.derefPointer(getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                    } else {
                        javaCodeUnit.emitln("      final ElementBuffer eb = ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                    }
                    javaCodeUnit.emitln("      eb.put(src, srcPos, destPos, length);");
                    javaCodeUnit.emitln("    } else {");
                    javaCodeUnit.emitln("      final int newElemCount = destPos + length;");
                    if (bl7) {
                        javaCodeUnit.emitln("      final PointerBuffer eb = PointerBuffer.allocateDirect(newElemCount);");
                        javaCodeUnit.emitln("      if( 0 < destPos ) {");
                        javaCodeUnit.emitln("        final PointerBuffer pre_eb = PointerBuffer.derefPointer(getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                        javaCodeUnit.emitln("        pre_eb.position(0).limit(destPos);");
                        javaCodeUnit.emitln("        eb.put(pre_eb).rewind();");
                        javaCodeUnit.emitln("      }");
                    } else {
                        javaCodeUnit.emitln("      final ElementBuffer eb = ElementBuffer.allocateDirect(" + string4 + ", newElemCount);");
                        javaCodeUnit.emitln("      if( 0 < destPos ) {");
                        javaCodeUnit.emitln("        final ElementBuffer pre_eb = ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                        javaCodeUnit.emitln("        eb.put(pre_eb.getByteBuffer(), 0, 0, destPos);");
                        javaCodeUnit.emitln("      }");
                    }
                    javaCodeUnit.emitln("      eb.put(src, srcPos, destPos, length);");
                    javaCodeUnit.emitln("      eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                    javaCodeUnit.emitln("      _eb" + (String)((Object)clazz) + " = eb;");
                    this.emitSetElemCount(javaCodeUnit, string3, "newElemCount", !bl6, (String)((Object)clazz), compoundType, "      ");
                    javaCodeUnit.emitln("    }");
                    javaCodeUnit.emitln("    return this;");
                    javaCodeUnit.emitln("  }");
                }
                javaCodeUnit.emitln();
            }
        } else if (bl5) {
            if (bl12) {
                this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7, null, bl10, bl5, (String)object3, null, null);
                if (bl11) {
                    if (Ownership.Native == ownership) {
                        throw new InternalError("Native ownership but adding potential memory-replacement for '" + string2 + "': " + type.getSignature(null).toString());
                    }
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.allocateDirect(" + string7 + ".size(), 1);");
                    javaCodeUnit.emitln("    eb.put(0, src.getBuffer());");
                    javaCodeUnit.emitln("    eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                    javaCodeUnit.emitln("    _eb" + (String)((Object)clazz) + " = eb;");
                    this.emitSetElemCount(javaCodeUnit, string3, "1", !bl6, (String)((Object)clazz), compoundType, "      ");
                    javaCodeUnit.emitln("    return this;");
                    javaCodeUnit.emitln("  }");
                } else {
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                    javaCodeUnit.emitln("    if( 1 == elemCount ) {");
                    javaCodeUnit.emitln("      ElementBuffer.derefPointer(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], 1)");
                    javaCodeUnit.emitln("        .put(0, src.getBuffer());");
                    javaCodeUnit.emitln("    } else {");
                    if (bl10 || Ownership.Native == ownership) {
                        javaCodeUnit.emitln("      throw new RuntimeException(\"Primitive '" + string + "' of " + (Object)((Object)ownership) + " ownership and maxOneElement has " + (bl10 ? "const" : "") + "elemCount \"+elemCount);");
                        javaCodeUnit.emitln("    }");
                        javaCodeUnit.emitln("    return this;");
                        javaCodeUnit.emitln("  }");
                    } else {
                        javaCodeUnit.emitln("      final ElementBuffer eb = ElementBuffer.allocateDirect(" + string7 + ".size(), 1);");
                        javaCodeUnit.emitln("      eb.put(0, src.getBuffer());");
                        javaCodeUnit.emitln("      eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                        javaCodeUnit.emitln("      _eb" + (String)((Object)clazz) + " = eb;");
                        this.emitSetElemCount(javaCodeUnit, string3, "1", !bl6, (String)((Object)clazz), compoundType, "      ");
                        javaCodeUnit.emitln("    }");
                        javaCodeUnit.emitln("    return this;");
                        javaCodeUnit.emitln("  }");
                    }
                }
            } else if (!bl11) {
                this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7, null, bl10, bl5, (String)object3, null, null);
                javaCodeUnit.emitln(" {");
                javaCodeUnit.emitln("    ElementBuffer.wrap(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], 1)");
                javaCodeUnit.emitln("      .put(0, src.getBuffer());");
                javaCodeUnit.emitln("    return this;");
                javaCodeUnit.emitln("  }");
            }
            javaCodeUnit.emitln();
        } else {
            if (bl11) {
                if (bl12) {
                    this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7 + "[]", SetReplaceArrayArgsPost, bl10, bl5, (String)object3, SetReplaceArrayApiDocDetail, SetReplaceArrayApiDocArgs);
                    if (Ownership.Native == ownership) {
                        throw new InternalError("Native ownership but adding potential memory-replacement for '" + string2 + "': " + type.getSignature(null).toString());
                    }
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln(SetReplaceArrayArgsCheck);
                    javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.allocateDirect(" + string7 + ".size(), length);");
                    javaCodeUnit.emitln("    for(int i=0; i<length; ++i) {");
                    javaCodeUnit.emitln("      eb.put(i, src[srcPos+i].getBuffer());");
                    javaCodeUnit.emitln("    }");
                    javaCodeUnit.emitln("    eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                    javaCodeUnit.emitln("    _eb" + (String)((Object)clazz) + " = eb;");
                    this.emitSetElemCount(javaCodeUnit, string3, "length", !bl6, (String)((Object)clazz), compoundType, "    ");
                    javaCodeUnit.emitln("    return this;");
                    javaCodeUnit.emitln("  }");
                }
            } else if (bl10 || !bl12) {
                this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), null, string7 + "[]", "final int srcPos, final int destPos, final int length", bl10, bl5, (String)object3, SetSubArrayApiDocDetail, SetSubArrayApiDocArgs);
                javaCodeUnit.emitln(" {");
                javaCodeUnit.emitln(SetSubArrayArgsCheck);
                javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                javaCodeUnit.emitln("    if( destPos + length > elemCount ) { throw new IndexOutOfBoundsException(\"destPos \"+destPos+\" + length \"+length+\" > elemCount \"+elemCount); };");
                if (bl12) {
                    javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.derefPointer(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                } else {
                    javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.wrap(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                }
                javaCodeUnit.emitln("    for(int i=0; i<length; ++i) {");
                javaCodeUnit.emitln("      eb.put(destPos+i, src[srcPos+i].getBuffer());");
                javaCodeUnit.emitln("    }");
                javaCodeUnit.emitln("    return this;");
                javaCodeUnit.emitln("  }");
            } else {
                this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), SetArrayArgsPre, string7 + "[]", "final int srcPos, final int destPos, final int length", bl10, bl5, (String)object3, SetArrayApiDocDetail, SetArrayApiDocArgs);
                if (Ownership.Native == ownership) {
                    throw new InternalError("Native ownership but adding potential memory-replacement for '" + string2 + "': " + type.getSignature(null).toString());
                }
                javaCodeUnit.emitln(" {");
                javaCodeUnit.emitln(SetArrayArgsCheck);
                javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                javaCodeUnit.emitln("    if( subset || destPos + length == elemCount ) {");
                javaCodeUnit.emitln("      if( destPos + length > elemCount ) { throw new IndexOutOfBoundsException(\"subset \"+subset+\", destPos \"+destPos+\" + length \"+length+\" > elemCount \"+elemCount); };");
                javaCodeUnit.emitln("      final ElementBuffer eb = ElementBuffer.derefPointer(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                javaCodeUnit.emitln("      for(int i=0; i<length; ++i) {");
                javaCodeUnit.emitln("        eb.put(destPos+i, src[srcPos+i].getBuffer());");
                javaCodeUnit.emitln("      }");
                javaCodeUnit.emitln("    } else {");
                javaCodeUnit.emitln("      final int newElemCount = destPos + length;");
                javaCodeUnit.emitln("      final ElementBuffer eb = ElementBuffer.allocateDirect(" + string7 + ".size(), newElemCount);");
                javaCodeUnit.emitln("      if( 0 < destPos ) {");
                javaCodeUnit.emitln("        final ElementBuffer pre_eb = ElementBuffer.derefPointer(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount);");
                javaCodeUnit.emitln("        eb.put(pre_eb.getByteBuffer(), 0, 0, destPos);");
                javaCodeUnit.emitln("      }");
                javaCodeUnit.emitln("      for(int i=0; i<length; ++i) {");
                javaCodeUnit.emitln("        eb.put(destPos+i, src[srcPos+i].getBuffer());");
                javaCodeUnit.emitln("      }");
                javaCodeUnit.emitln("      eb.storeDirectAddress(getBuffer(), " + string + "_offset[mdIdx]);");
                javaCodeUnit.emitln("      _eb" + (String)((Object)clazz) + " = eb;");
                this.emitSetElemCount(javaCodeUnit, string3, "newElemCount", !bl6, (String)((Object)clazz), compoundType, "      ");
                javaCodeUnit.emitln("    }");
                javaCodeUnit.emitln("    return this;");
                javaCodeUnit.emitln("  }");
            }
            javaCodeUnit.emitln();
            if (!bl11) {
                this.generateSetterSignature(javaCodeUnit, methodAccess, false, false, string, type, ownership, string8, (String)((Object)clazz), "final int destPos", string7, null, bl10, bl5, (String)object3, null, null);
                javaCodeUnit.emitln(" {");
                javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                javaCodeUnit.emitln("    if( destPos + 1 > elemCount ) { throw new IndexOutOfBoundsException(\"destPos \"+destPos+\" + 1 > elemCount \"+elemCount); };");
                if (bl12) {
                    javaCodeUnit.emitln("    ElementBuffer.derefPointer(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount)");
                } else {
                    javaCodeUnit.emitln("    ElementBuffer.wrap(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount)");
                }
                javaCodeUnit.emitln("      .put(destPos, src.getBuffer());");
                javaCodeUnit.emitln("    return this;");
                javaCodeUnit.emitln("  }");
                javaCodeUnit.emitln();
            }
        }
        if (bl13) {
            if (bl5) {
                this.generateGetterSignature(javaCodeUnit, false, false, string, type, ownership, string7, (String)((Object)clazz), null, bl10, bl5, (String)object3, GetElemValueApiDocTail);
                javaCodeUnit.emitln(" {");
                if (bl7) {
                    if (bl12) {
                        javaCodeUnit.emit("    return PointerBuffer.derefPointer(getBuffer(), " + string + "_offset[mdIdx], 1)");
                    } else {
                        javaCodeUnit.emit("    return PointerBuffer.wrap(getBuffer(), " + string + "_offset[mdIdx], 1)");
                    }
                } else {
                    if (bl12) {
                        javaCodeUnit.emitln("    return ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], 1)");
                    } else {
                        javaCodeUnit.emitln("    return ElementBuffer.wrap(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], 1)");
                    }
                    javaCodeUnit.emit("             .getByteBuffer()");
                    if (!bl4) {
                        javaCodeUnit.emit(".as" + string5 + "()");
                    }
                }
                javaCodeUnit.emitln(".get(0);");
                javaCodeUnit.emitln("  }");
                javaCodeUnit.emitln();
            } else {
                bl2 = false;
                if (bl14 && bl4) {
                    this.generateGetterSignature(javaCodeUnit, false, false, string, type, ownership, "String", (String)((Object)clazz) + (bl16 ? "" : "AsString"), null, bl10, bl5, (String)object3, GetElemValueApiDocTail);
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                    if (bl12) {
                        javaCodeUnit.emitln("    final ByteBuffer bb = ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount).getByteBuffer();");
                    } else {
                        javaCodeUnit.emitln("    final ByteBuffer bb = ElementBuffer.wrap(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount).getByteBuffer();");
                    }
                    javaCodeUnit.emitln("    final byte[] ba = new byte[elemCount];");
                    javaCodeUnit.emitln("    int i = -1;");
                    javaCodeUnit.emitln("    while( ++i < elemCount ) {");
                    javaCodeUnit.emitln("      ba[i] = bb.get(i);");
                    javaCodeUnit.emitln("      if( (byte)0 == ba[i] ) break;");
                    javaCodeUnit.emitln("    }");
                    javaCodeUnit.emitln("    return new String(ba, 0, i, _charset);");
                    javaCodeUnit.emitln("  }");
                    javaCodeUnit.emitln();
                    bl2 = true;
                }
                if (bl2 && bl16) {
                    this.generateArrayFieldNote(javaCodeUnit, "  /** SKIP getter for String alternative (ByteBuffer)", " */", string, type, ownership, bl10, bl5, (String)object3, false, false);
                    javaCodeUnit.emitln();
                } else if (!bl7) {
                    this.generateGetterSignature(javaCodeUnit, false, false, string, type, ownership, string5, (String)((Object)clazz), null, bl10, bl5, (String)object3, GetElemValueApiDocTail);
                    javaCodeUnit.emitln(" {");
                    if (bl12) {
                        javaCodeUnit.emitln("    return ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], " + (String)object + ")");
                    } else {
                        javaCodeUnit.emitln("    return ElementBuffer.wrap(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], " + (String)object + ")");
                    }
                    javaCodeUnit.emit("             .getByteBuffer()");
                    if (!bl4) {
                        javaCodeUnit.emit(".as" + string5 + "()");
                    }
                    javaCodeUnit.emitln(";");
                    javaCodeUnit.emitln("  }");
                    javaCodeUnit.emitln();
                }
                if (!bl2) {
                    this.generateGetterSignature(javaCodeUnit, false, false, string, type, ownership, string7 + "[]", (String)((Object)clazz), "final int srcPos, " + string7 + " dest[], " + GetArrayArgs, bl10, bl5, (String)object3, GetElemValueApiDocTail);
                    javaCodeUnit.emitln(" {");
                    javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
                    if (bl7) {
                        if (bl12) {
                            javaCodeUnit.emit("    PointerBuffer.derefPointer(getBuffer(), " + string + "_offset[mdIdx], elemCount)");
                        } else {
                            javaCodeUnit.emit("    PointerBuffer.wrap(getBuffer(), " + string + "_offset[mdIdx], elemCount)");
                        }
                    } else if (bl12) {
                        javaCodeUnit.emit("    ElementBuffer.derefPointer(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount)");
                    } else {
                        javaCodeUnit.emit("    ElementBuffer.wrap(" + string4 + ", getBuffer(), " + string + "_offset[mdIdx], elemCount)");
                    }
                    javaCodeUnit.emitln(".get(srcPos, dest, destPos, length);");
                    javaCodeUnit.emitln("    return dest;");
                    javaCodeUnit.emitln("  }");
                    javaCodeUnit.emitln();
                }
            }
        } else if (bl5) {
            this.generateGetterSignature(javaCodeUnit, false, false, string, type, ownership, string7, (String)((Object)clazz), null, bl10, bl5, (String)object3, GetElemValueApiDocTail);
            javaCodeUnit.emitln(" {");
            javaCodeUnit.emitln("    return " + string7 + ".create(");
            if (bl12) {
                javaCodeUnit.emitln("             ElementBuffer.derefPointer(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], 1).getByteBuffer() );");
            } else {
                javaCodeUnit.emitln("             ElementBuffer.wrap(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], 1).getByteBuffer() );");
            }
            javaCodeUnit.emitln("  }");
            javaCodeUnit.emitln();
        } else {
            this.generateGetterSignature(javaCodeUnit, false, false, string, type, ownership, string7 + "[]", (String)((Object)clazz), "final int srcPos, " + string7 + " dest[], " + GetArrayArgs, bl10, bl5, (String)object3, GetElemValueApiDocTail);
            javaCodeUnit.emitln(" {");
            javaCodeUnit.emitln(GetArrayArgsCheck);
            javaCodeUnit.emitln("    final int elemCount = " + (String)object + ";");
            javaCodeUnit.emitln("    if( srcPos + length > elemCount ) { throw new IndexOutOfBoundsException(\"srcPos \"+srcPos+\" + length \"+length+\" > elemCount \"+elemCount); };");
            if (bl12) {
                javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.derefPointer(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount);");
            } else {
                javaCodeUnit.emitln("    final ElementBuffer eb = ElementBuffer.wrap(" + string7 + ".size(), getBuffer(), " + string + "_offset[mdIdx], elemCount);");
            }
            javaCodeUnit.emitln("    for(int i=0; i<length; ++i) {");
            javaCodeUnit.emitln("      dest[destPos+i] = " + string7 + ".create( eb.slice(srcPos+i, 1) );");
            javaCodeUnit.emitln("    }");
            javaCodeUnit.emitln("    return dest;");
            javaCodeUnit.emitln("  }");
            javaCodeUnit.emitln();
        }
    }

    private void emitSetElemCount(JavaCodeUnit javaCodeUnit, String string, String string2, boolean bl, String string3, Type type, String string4) {
        if (null != string) {
            javaCodeUnit.emitln(string4 + string + "( " + string2 + " );");
        } else if (bl) {
            String string5 = "Missing set" + string3 + "ElemCount( " + string2 + " )";
            javaCodeUnit.emitln(string4 + "// ERROR: " + string5);
            javaCodeUnit.emitln();
            this.LOG.log(Level.SEVERE, type.getASTLocusTag(), string5);
            throw new RuntimeException(string5);
        }
    }

    private JavaType typeToJavaType(Type type, MachineDataInfo machineDataInfo) {
        JavaType javaType = this.typeToJavaTypeImpl(type, machineDataInfo);
        this.LOG.log(Level.FINE, type.getASTLocusTag(), "typeToJavaType: {0} -> {1}", type, javaType);
        return javaType;
    }

    private boolean isJNIEnvPointer(Type type) {
        PointerType pointerType = type.asPointer();
        return pointerType != null && pointerType.getTargetType().getName() != null && pointerType.getTargetType().getName().equals("JNIEnv");
    }

    private JavaType typeToJavaTypeImpl(Type type, MachineDataInfo machineDataInfo) {
        Object object;
        if (this.isJNIEnvPointer(type)) {
            return JavaType.createForJNIEnv();
        }
        TypeInfo typeInfo = this.cfg.typeInfo(type);
        if (typeInfo != null) {
            boolean bl = false;
            if (type.pointerDepth() > 0 || type.arrayDimension() > 0) {
                object = type.getArrayBaseOrPointerTargetType();
                if ((type.pointerDepth() == 2 || type.arrayDimension() == 2) && ((Type)object).isPointer()) {
                    bl = true;
                    if (GlueGen.debug()) {
                        Type type2 = ((Type)object).asPointer().getTargetType();
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "Opaque Type: {0}, targetType: {1}, bottomType: {2} is ptr-ptr", type, object, type2);
                    }
                }
            }
            if (!bl) {
                return typeInfo.javaType();
            }
        }
        if (type.isInt() || type.isEnum()) {
            switch ((int)type.getSize(machineDataInfo)) {
                case 1: {
                    return this.javaType(Byte.TYPE);
                }
                case 2: {
                    return this.javaType(Short.TYPE);
                }
                case 4: {
                    return this.javaType(Integer.TYPE);
                }
                case 8: {
                    return this.javaType(Long.TYPE);
                }
            }
            throw new GlueGenException("Unknown integer type of size " + type.getSize(machineDataInfo) + " and name " + type.getName(), type.getASTLocusTag());
        }
        if (type.isFloat()) {
            return this.javaType(Float.TYPE);
        }
        if (type.isDouble()) {
            return this.javaType(Double.TYPE);
        }
        if (type.isVoid()) {
            return this.javaType(Void.TYPE);
        }
        if (type.pointerDepth() > 0 || type.arrayDimension() > 0) {
            Type type3 = type.getArrayBaseOrPointerTargetType();
            if (type.pointerDepth() == 1 || type.arrayDimension() == 1) {
                if (type3.isVoid()) {
                    return JavaType.createForCVoidPointer();
                }
                if (type3.isFunctionPointer()) {
                    return this.javaType(Long.TYPE);
                }
                if (type3.isInt()) {
                    object = type3.getSize();
                    if (null != object && SizeThunk.POINTER == object) {
                        return JavaType.forNIOPointerBufferClass();
                    }
                    switch ((int)type3.getSize(machineDataInfo)) {
                        case 1: {
                            return JavaType.createForCCharPointer();
                        }
                        case 2: {
                            return JavaType.createForCShortPointer();
                        }
                        case 4: {
                            return JavaType.createForCInt32Pointer();
                        }
                        case 8: {
                            return JavaType.createForCInt64Pointer();
                        }
                    }
                    throw new GlueGenException("Unknown integer array type of size " + type.getSize(machineDataInfo) + " and name " + type.getName() + ", " + type.getDebugString() + ", target " + type3.getDebugString(), type.getASTLocusTag());
                }
                if (type3.isFloat()) {
                    return JavaType.createForCFloatPointer();
                }
                if (type3.isDouble()) {
                    return JavaType.createForCDoublePointer();
                }
                if (type3.isCompound()) {
                    if (type.isArray()) {
                        return JavaType.createForCArray(type3);
                    }
                    if (type.getName() != null && type.getName().equals("jobject")) {
                        return this.javaType(Object.class);
                    }
                    if (!type3.isTypedef() && type.isTypedef()) {
                        object = type.getName();
                    } else {
                        object = type3.getName();
                        if (null == object && (object = type.getName()) == null) {
                            throw new GlueGenException("Couldn't find a proper type name for pointer type " + type.getDebugString() + ", target " + type3.getDebugString(), type.getASTLocusTag());
                        }
                    }
                    return JavaType.createForCStruct(this.cfg.renameJavaType((String)object));
                }
                throw new GlueGenException("Don't know how to convert pointer/array type " + type.getDebugString() + ", target " + type3.getDebugString(), type.getASTLocusTag());
            }
            if (type.pointerDepth() == 2 || type.arrayDimension() == 2) {
                if (type3.isPointer()) {
                    object = type3.asPointer().getTargetType();
                    if (GlueGen.debug()) {
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "typeToJavaType(ptr-ptr): {0}, targetType: {1}, bottomType: {2}", type.getDebugString(), type3.getDebugString(), ((Type)object).getDebugString());
                    }
                    return JavaType.forNIOPointerBufferClass();
                }
                if (type3.isArray()) {
                    object = type3.getBaseType();
                    if (GlueGen.debug()) {
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "typeToJavaType(ptr-ptr.array): {0}, targetType: {1}, bottomType: {2}", type.getDebugString(), type3.getDebugString(), ((Type)object).getDebugString());
                    }
                } else {
                    object = type3;
                    if (GlueGen.debug()) {
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "typeToJavaType(ptr-ptr.primitive): {0}, targetType: {1}, bottomType: {2}", type.getDebugString(), type3.getDebugString(), ((Type)object).getDebugString());
                    }
                }
                if (((Type)object).isPrimitive()) {
                    if (((Type)object).isInt()) {
                        switch ((int)((Type)object).getSize(machineDataInfo)) {
                            case 1: {
                                return this.javaType(ArrayTypes.byteBufferArrayClass);
                            }
                            case 2: {
                                return this.javaType(ArrayTypes.shortBufferArrayClass);
                            }
                            case 4: {
                                return this.javaType(ArrayTypes.intBufferArrayClass);
                            }
                            case 8: {
                                return this.javaType(ArrayTypes.longBufferArrayClass);
                            }
                        }
                        throw new GlueGenException("Unknown two-dimensional integer array type of element size " + ((Type)object).getSize(machineDataInfo) + " and name " + ((Type)object).getName() + ", " + ((Type)object).getDebugString(), ((Type)object).getASTLocusTag());
                    }
                    if (((Type)object).isFloat()) {
                        return this.javaType(ArrayTypes.floatBufferArrayClass);
                    }
                    if (((Type)object).isDouble()) {
                        return this.javaType(ArrayTypes.doubleBufferArrayClass);
                    }
                    throw new GlueGenException("Unexpected primitive type " + ((Type)object).getDebugString() + " in two-dimensional array", ((Type)object).getASTLocusTag());
                }
                if (((Type)object).isVoid()) {
                    return this.javaType(ArrayTypes.bufferArrayClass);
                }
                if (type3.isPointer() && type3.pointerDepth() == 1 && type3.asPointer().getTargetType().isCompound()) {
                    return JavaType.createForCArray((Type)object);
                }
                throw new GlueGenException("Could not convert C type " + type.getDebugString() + " to appropriate Java type; need to add more support for depth=2 pointer/array types [debug info: targetType=" + type3.getDebugString() + "]", type.getASTLocusTag());
            }
            throw new GlueGenException("Could not convert C pointer/array " + type.getDebugString() + " to appropriate Java type; types with pointer/array depth greater than 2 are not yet supported [debug info: pointerDepth=" + type.pointerDepth() + " arrayDimension=" + type.arrayDimension() + " targetType=" + type3.getDebugString() + "]", type.getASTLocusTag());
        }
        if (type.isCompound()) {
            String string = type.getName();
            if (string == null && (string = type.asCompound().getStructName()) == null) {
                throw new GlueGenException("Couldn't find a proper type name for pointer type " + type.getDebugString(), type.getASTLocusTag());
            }
            return JavaType.createForCStruct(this.cfg.renameJavaType(string));
        }
        throw new GlueGenException("Could not convert C type " + type.getDebugString() + " (class " + type.getClass().getName() + ") to appropriate Java type", type.getASTLocusTag());
    }

    private StructLayout getLayout() {
        if (this.layout == null) {
            this.layout = StructLayout.create(0);
        }
        return this.layout;
    }

    protected CCodeUnit openCUnit(String string, String string2) throws IOException {
        return new CCodeUnit(string, string2, this);
    }

    protected JavaCodeUnit openJavaUnit(String string, String string2, String string3) throws IOException {
        return new JavaCodeUnit(string, string2, string3, this);
    }

    private boolean isOpaque(Type type) {
        return null != this.cfg.typeInfo(type);
    }

    private String compatiblePrimitiveJavaTypeName(Type type, MachineDataInfo machineDataInfo) {
        if (!(type.isInt() || type.isPointer() || type.isArray())) {
            throw new GlueGenException("Can't yet handle opaque definitions of structs' fields to non-integer types (byte, short, int, long, etc.): type: " + type, type.getASTLocusTag());
        }
        switch ((int)type.getSize(machineDataInfo)) {
            case 1: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 8: {
                return "long";
            }
        }
        throw new GlueGenException("Can't handle opaque definitions if the starting type isn't compatible with integral types, type " + type.getDebugString(), type.getASTLocusTag());
    }

    private void openCodeUnits() throws IOException {
        String string;
        String string2 = null;
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            string2 = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        String string3 = null;
        if (!this.cfg.allStatic()) {
            string3 = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.implPackageName());
        }
        String string4 = this.cfg.nativeOutputDir();
        if (this.cfg.nativeOutputUsesJavaHierarchy()) {
            string4 = string4 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            string = string2 + File.separator + this.cfg.className() + ".java";
            this.javaUnit = this.openJavaUnit(string, this.cfg.packageName(), this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            string = string3 + File.separator + this.cfg.implClassName() + ".java";
            this.javaImplUnit = this.openJavaUnit(string, this.cfg.implPackageName(), this.cfg.implClassName());
        }
        if (this.cfg.emitImpl()) {
            string = this.cfg.implClassName() + "_JNI.c";
            String string5 = string4 + File.separator + string;
            this.cUnit = this.openCUnit(string5, string);
        }
    }

    protected JavaCodeUnit javaUnit() {
        if (!this.cfg.allStatic() && !this.cfg.emitInterface()) {
            throw new InternalError("Should not call this");
        }
        return this.javaUnit;
    }

    protected JavaCodeUnit javaImplUnit() {
        if (this.cfg.allStatic() || !this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.javaImplUnit;
    }

    protected CCodeUnit cUnit() {
        if (!this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.cUnit;
    }

    private void closeWriters() throws IOException {
        if (this.javaUnit != null) {
            this.javaUnit.close();
            this.javaUnit = null;
        }
        if (this.javaImplUnit != null) {
            this.javaImplUnit.close();
            this.javaImplUnit = null;
        }
        if (this.cUnit != null) {
            this.cUnit.close();
            this.cUnit = null;
        }
    }

    protected String getJavaOutputDir() {
        return this.cfg.javaOutputDir();
    }

    protected String getJavaPackageName() {
        return this.cfg.packageName();
    }

    protected String getImplPackageName() {
        return this.cfg.implPackageName();
    }

    protected void emitCustomJavaCode(CodeUnit codeUnit, String string) throws Exception {
        List<String> list = this.cfg.customJavaCodeForClass(string);
        if (list.isEmpty()) {
            return;
        }
        codeUnit.emitln();
        codeUnit.emitln("  // --- Begin CustomJavaCode .cfg declarations");
        for (String string2 : list) {
            codeUnit.emitln(string2);
        }
        codeUnit.emitln("  // ---- End CustomJavaCode .cfg declarations");
    }

    protected void emitCustomJNICode(CodeUnit codeUnit, String string) throws Exception {
        List<String> list = this.cfg.customJNICodeForClass(string);
        if (list.isEmpty()) {
            return;
        }
        codeUnit.emitln();
        codeUnit.emitln("  // --- Begin CustomJNICode .cfg declarations");
        for (String string2 : list) {
            codeUnit.emitln(string2);
        }
        codeUnit.emitln("  // ---- End CustomJNICode .cfg declarations");
    }

    public String[] getClassAccessModifiers(String string) {
        String[] stringArray;
        MethodAccess methodAccess = this.cfg.accessControl(string);
        if (MethodAccess.PUBLIC_ABSTRACT == methodAccess) {
            stringArray = new String[]{MethodAccess.PUBLIC.getJavaName(), MethodAccess.PUBLIC_ABSTRACT.getJavaName()};
        } else if (MethodAccess.PACKAGE_PRIVATE == methodAccess) {
            stringArray = new String[]{MethodAccess.PACKAGE_PRIVATE.getJavaName()};
        } else {
            if (MethodAccess.PRIVATE == methodAccess) {
                throw new IllegalArgumentException("Class access " + string + " cannot be private");
            }
            stringArray = MethodAccess.PROTECTED == methodAccess ? new String[]{MethodAccess.PROTECTED.getJavaName()} : new String[]{MethodAccess.PUBLIC.getJavaName()};
        }
        return stringArray;
    }

    protected void emitAllFileHeaders() throws IOException {
        try {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            List<String> list;
            ArrayList<String> arrayList = new ArrayList<String>(this.cfg.imports());
            arrayList.add(this.cfg.gluegenRuntimePackage() + ".*");
            arrayList.add(DynamicLookupHelper.class.getPackage().getName() + ".*");
            arrayList.add(Buffers.class.getPackage().getName() + ".*");
            arrayList.add(Buffer.class.getPackage().getName() + ".*");
            arrayList.add(HashUtil.class.getPackage().getName() + ".*");
            arrayList.add("java.util.Set");
            arrayList.add("java.util.Map");
            arrayList.add("java.util.HashMap");
            arrayList.add("java.nio.charset.Charset");
            arrayList.add("java.nio.charset.StandardCharsets");
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                list = null;
                list = this.cfg.emitInterface() ? this.cfg.extendedInterfaces(this.cfg.className()) : this.cfg.implementedInterfaces(this.cfg.className());
                stringArray2 = new String[list.size()];
                list.toArray(stringArray2);
                stringArray = this.cfg.javadocForClass(this.cfg.className());
                object = new CodeGenUtils.EmissionCallback(){
                    final /* synthetic */ List val$intfDocs;
                    {
                        this.val$intfDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$intfDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                String[] stringArray3 = this.getClassAccessModifiers(this.cfg.className());
                CodeGenUtils.emitJavaHeaders(this.javaUnit().output, this.cfg.packageName(), this.cfg.className(), this.cfg.allStatic(), arrayList, stringArray3, stringArray2, this.cfg.extendedParentClass(this.cfg.className()), (CodeGenUtils.EmissionCallback)object);
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                stringArray2 = this.cfg.javadocForClass(this.cfg.implClassName());
                list = new CodeGenUtils.EmissionCallback(){
                    final /* synthetic */ List val$implDocs;
                    {
                        this.val$implDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$implDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                object = null;
                object = this.cfg.implementedInterfaces(this.cfg.implClassName());
                int n = 0;
                if (this.cfg.className() != null) {
                    n = 1;
                }
                stringArray = new String[n + object.size()];
                object.toArray(stringArray);
                if (n == 1) {
                    stringArray[object.size()] = this.cfg.className();
                }
                String[] stringArray4 = this.getClassAccessModifiers(this.cfg.implClassName());
                CodeGenUtils.emitJavaHeaders(this.javaImplUnit().output, this.cfg.implPackageName(), this.cfg.implClassName(), true, arrayList, stringArray4, stringArray, this.cfg.extendedParentClass(this.cfg.implClassName()), (CodeGenUtils.EmissionCallback)((Object)list));
            }
            if (this.cfg.emitImpl()) {
                if (!this.cfg.getJavaCallbackList().isEmpty() && null == this.cfg.libraryOnLoadName()) {
                    this.LOG.log(Level.WARNING, "JavaCallback used, but no 'LibraryOnLoad' basename specified for JNI_OnLoad(..). Exactly one native code-unit for the library must specify 'LibraryOnLoad' basename");
                }
                this.cUnit().emitHeader(this.getImplPackageName(), this.cfg.implClassName(), this.cfg.customCCode());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error emitting all file headers: cfg.allStatic()=" + this.cfg.allStatic() + " cfg.emitImpl()=" + this.cfg.emitImpl() + " cfg.emitInterface()=" + this.cfg.emitInterface(), exception);
        }
    }

    protected void emitAllFileFooters() {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaUnit.emitTailCode();
            this.javaUnit().emitln("} // end of class " + this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplUnit.emitTailCode();
            this.javaImplUnit().emitln("} // end of class " + this.cfg.implClassName());
        }
        if (this.cfg.emitImpl() && null != this.cfg.libraryOnLoadName()) {
            this.cUnit.emitJNIOnLoadJNIEnvCode(this.cfg.libraryOnLoadName());
        }
    }

    private JavaType javaType(Class<?> clazz) {
        return JavaType.createForClass(clazz);
    }

    private JavaType javaStringType(Class<?> clazz, boolean bl) {
        return JavaType.createForStringClass(clazz, bl);
    }

    private MethodBinding bindFunction(FunctionSymbol functionSymbol, boolean bl, MachineDataInfo machineDataInfo, JavaType javaType, Type type) {
        Object object;
        Object object2;
        String string;
        String string2 = string = null == javaType && null == type ? this.cfg.getDelegatedImplementation(functionSymbol) : null;
        if (!bl && null != string) {
            functionSymbol = FunctionSymbol.cloneWithDeepAliases(functionSymbol);
            functionSymbol.addAliasedName(string);
        }
        if (this.cfg.returnsString(functionSymbol)) {
            object2 = functionSymbol.getReturnType().asPointer();
            if (object2 == null || ((PointerType)object2).getTargetType().asInt() == null || ((PointerType)object2).getTargetType().getSize(machineDataInfo) != 1L) {
                throw new GlueGenException("Cannot apply ReturnsString configuration directive to \"" + functionSymbol + "\". ReturnsString requires native method to have return type \"char *\"", functionSymbol.getASTLocusTag());
            }
            object = this.javaStringType(String.class, false);
        } else {
            object2 = this.cfg.getOpaqueReturnType(functionSymbol);
            object = null != object2 ? object2 : this.typeToJavaType(functionSymbol.getReturnType(), machineDataInfo);
        }
        object2 = new ArrayList<JavaType>();
        List<Integer> list = this.cfg.stringArguments(functionSymbol);
        List<JavaConfiguration.PascalStringIdx> list2 = this.cfg.pascalStringArgument(functionSymbol);
        if (null != list2) {
            list = JavaConfiguration.PascalStringIdx.pushValueIndex(list2, list);
        }
        JavaConfiguration.JavaCallbackInfo javaCallbackInfo = this.cfg.setFuncToJavaCallbackMap.get(functionSymbol.getName());
        int n = -1;
        for (int i = 0; i < functionSymbol.getNumArguments(); ++i) {
            Type type2 = functionSymbol.getArgumentType(i);
            String string3 = functionSymbol.getArgumentName(i);
            JavaType javaType2 = this.typeToJavaType(type2, machineDataInfo);
            int n2 = 0;
            if (null != javaCallbackInfo && javaCallbackInfo.cbFuncTypeName.equals(type2.getName()) && (!javaCallbackInfo.setFuncProcessed || i == javaCallbackInfo.setFuncCBParamIdx)) {
                n = i;
                javaType2 = JavaType.createForNamedClass(javaCallbackInfo.cbFQClazzName);
                n2 = 10;
            } else if (null != javaCallbackInfo && i == javaCallbackInfo.setFuncUserParamIdx && type2.isPointer() && type2.getTargetType().isVoid()) {
                if (javaCallbackInfo.cbFuncUserParamType.isCompound()) {
                    javaType2 = JavaType.createForClass(Long.TYPE);
                    n2 = 20;
                } else if (null != javaCallbackInfo.userParamClassName) {
                    javaType2 = JavaType.createForNamedClass(javaCallbackInfo.userParamClassName);
                    n2 = 21;
                } else {
                    javaType2 = JavaType.forObjectClass();
                    n2 = 22;
                }
            }
            if (0 == n2 && list != null && list.contains(i)) {
                if (javaType2.isCVoidPointerType() || javaType2.isCCharPointerType() || javaType2.isCShortPointerType() || javaType2.isNIOPointerBuffer() || javaType2.isArray() && javaType2.getJavaClass() == ArrayTypes.byteBufferArrayClass || javaType2.getJavaClass() == ArrayTypes.shortBufferArrayClass) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.cfg.pascalStringLengthIndex(functionSymbol, i) >= 0;
                    if (javaType2.isArray() || javaType2.isNIOPointerBuffer()) {
                        javaType2 = this.javaStringType(ArrayTypes.stringArrayClass, bl2);
                        n2 = 30;
                    } else {
                        javaType2 = this.javaStringType(String.class, bl2);
                        n2 = 31;
                    }
                } else {
                    n2 = 99;
                    throw new GlueGenException("Cannot apply ArgumentIsString configuration directive to argument " + i + " of \"" + functionSymbol + "\": argument type is not a \"void*\", \"char *\", \"short *\", \"char**\", or \"short**\" equivalent", functionSymbol.getASTLocusTag());
                }
            }
            object2.add((JavaType)javaType2);
            this.LOG.log(Level.INFO, "BindFunc: {0}: added mapping ({1}) for {2} from C type: {3} to Java type: {4}", functionSymbol.getName(), n2, string3, type2, javaType2);
        }
        if (null != javaCallbackInfo) {
            javaCallbackInfo.setFuncProcessed(functionSymbol.getType(), n);
            this.LOG.log(Level.INFO, "BindFunc.JavaCallback: {0}: set[cbParamIdx {1}], {3}, {4}", functionSymbol.getName(), n, functionSymbol.getType().toString(functionSymbol.getName(), false, true), javaCallbackInfo);
        }
        MethodBinding methodBinding = new MethodBinding(functionSymbol, string, (JavaType)object, (List<JavaType>)object2, javaType, type);
        this.mangleBinding(methodBinding);
        return methodBinding;
    }

    private MethodBinding lowerMethodBindingPointerTypes(MethodBinding methodBinding, boolean bl, boolean[] blArray) {
        MethodBinding methodBinding2 = methodBinding;
        boolean bl2 = false;
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (!javaType.isCPrimitivePointerType()) continue;
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOBufferClass());
                continue;
            }
            if (javaType.isCCharPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.byteArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOByteBufferClass());
                continue;
            }
            if (javaType.isCShortPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.shortArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOShortBufferClass());
                continue;
            }
            if (javaType.isCInt32PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.intArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOIntBufferClass());
                continue;
            }
            if (javaType.isCInt64PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.longArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOLongBufferClass());
                continue;
            }
            if (javaType.isCFloatPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.floatArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOFloatBufferClass());
                continue;
            }
            if (javaType.isCDoublePointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.doubleArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIODoubleBufferClass());
                continue;
            }
            throw new GlueGenException("Unknown C pointer type " + javaType);
        }
        JavaType javaType = methodBinding2.getJavaReturnType();
        if (javaType.isCPrimitivePointerType()) {
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCCharPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCShortPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOShortBufferClass());
            } else if (javaType.isCInt32PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOIntBufferClass());
            } else if (javaType.isCInt64PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOLongBufferClass());
            } else if (javaType.isCFloatPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOFloatBufferClass());
            } else if (javaType.isCDoublePointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIODoubleBufferClass());
            } else {
                throw new GlueGenException("Unknown C pointer type " + javaType, methodBinding2.getCReturnType().getASTLocusTag());
            }
        }
        if (blArray != null) {
            blArray[0] = bl2;
        }
        return methodBinding2;
    }

    protected void mangleBinding(MethodBinding methodBinding) {
    }

    protected List<MethodBinding> expandMethodBinding(MethodBinding methodBinding) {
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        boolean[] blArray = new boolean[1];
        if (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCVoidPointers() || methodBinding.signatureUsesCArrays()) {
            arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, false, blArray));
            if (blArray[0] && (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCArrays()) && !this.cfg.useNIOOnly(methodBinding.getName())) {
                arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, true, null));
            }
        } else {
            arrayList.add(methodBinding);
        }
        return arrayList;
    }

    private Type canonicalize(Type type) {
        Type type2 = this.canonMap.get(type);
        if (type2 != null) {
            return type2;
        }
        this.canonMap.put(type, type);
        return type;
    }

    class ConstFuncRenamer
    implements SymbolFilter {
        private List<ConstantDefinition> constants;
        private List<FunctionSymbol> functions;

        ConstFuncRenamer() {
        }

        @Override
        public List<ConstantDefinition> getConstants() {
            return this.constants;
        }

        @Override
        public List<FunctionSymbol> getFunctions() {
            return this.functions;
        }

        private <T extends TypeComparator.AliasedSemanticSymbol> List<T> filterSymbolsInt(List<T> list, boolean bl, List<T> list2) {
            JavaConfiguration javaConfiguration = JavaEmitter.this.getConfig();
            ArrayHashMap<String, TypeComparator.AliasedSemanticSymbol> arrayHashMap = new ArrayHashMap<String, TypeComparator.AliasedSemanticSymbol>(false, 100, 0.75f);
            for (TypeComparator.AliasedSemanticSymbol aliasedSemanticSymbol : list) {
                TypeComparator.AliasedSemanticSymbol aliasedSemanticSymbol2;
                String string = aliasedSemanticSymbol.getName();
                String string2 = javaConfiguration.getJavaSymbolRename(string);
                if (null != string2) {
                    aliasedSemanticSymbol2 = (TypeComparator.AliasedSemanticSymbol)arrayHashMap.get(string2);
                    if (null != aliasedSemanticSymbol2) {
                        aliasedSemanticSymbol.rename(string2);
                    }
                } else {
                    aliasedSemanticSymbol2 = (TypeComparator.AliasedSemanticSymbol)arrayHashMap.get(string);
                }
                if (null != aliasedSemanticSymbol2 && !aliasedSemanticSymbol2.equalSemantics(aliasedSemanticSymbol)) {
                    ASTLocusTag aSTLocusTag = aliasedSemanticSymbol instanceof ASTLocusTag.ASTLocusTagProvider ? ((ASTLocusTag.ASTLocusTagProvider)((Object)aliasedSemanticSymbol)).getASTLocusTag() : null;
                    String string3 = aliasedSemanticSymbol2 instanceof ASTLocusTag.ASTLocusTagProvider ? String.format(",%n  %s: previous definition is here", ((ASTLocusTag.ASTLocusTagProvider)((Object)aliasedSemanticSymbol2)).getASTLocusTag().toString(new StringBuilder(), "note", true)) : "";
                    String string4 = null != string2 ? "alias" : "orig";
                    String string5 = String.format("Duplicate Name (%s) w/ incompatible value:%n  this '%s',%n  have '%s'%s", string4, aliasedSemanticSymbol.getAliasedString(), aliasedSemanticSymbol2.getAliasedString(), string3);
                    throw new GlueGenException(string5, aSTLocusTag);
                }
                if (null != string2) {
                    if (null != aliasedSemanticSymbol2) {
                        aliasedSemanticSymbol2.addAliasedName(string);
                        continue;
                    }
                    aliasedSemanticSymbol.rename(string2);
                    arrayHashMap.put(string2, aliasedSemanticSymbol);
                    continue;
                }
                if (null != aliasedSemanticSymbol2) continue;
                arrayHashMap.put(string, aliasedSemanticSymbol);
            }
            list2.addAll(arrayHashMap.getData());
            if (!bl) {
                Collections.sort(list2, new Comparator<T>(){

                    @Override
                    public int compare(T t, T t2) {
                        return t.getName().compareTo(t2.getName());
                    }
                });
            }
            return list2;
        }

        @Override
        public void filterSymbols(List<ConstantDefinition> list, List<FunctionSymbol> list2) {
            this.constants = this.filterSymbolsInt(list, true, new ArrayList(100));
            this.functions = this.filterSymbolsInt(list2, true, new ArrayList(100));
        }
    }

    public static enum MethodAccess {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private"),
        PACKAGE_PRIVATE("/* pp */"),
        PUBLIC_ABSTRACT("abstract");

        private final String javaName;

        public final String getJavaName() {
            return this.javaName;
        }

        private MethodAccess(String string2) {
            this.javaName = string2;
        }
    }

    public static enum Ownership {
        Parent,
        Java,
        Native,
        Mixed;

    }

    public static enum EmissionStyle {
        AllStatic,
        InterfaceAndImpl,
        InterfaceOnly,
        ImplOnly;

    }
}

