/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import com.jogamp.common.GlueGenVersion;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.GenericCPP;
import com.jogamp.gluegen.GlueEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.ReferencedStructs;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.cgram.CToken;
import com.jogamp.gluegen.cgram.Define;
import com.jogamp.gluegen.cgram.GNUCTokenTypes;
import com.jogamp.gluegen.cgram.GnuCLexer;
import com.jogamp.gluegen.cgram.GnuCParser;
import com.jogamp.gluegen.cgram.HeaderParser;
import com.jogamp.gluegen.cgram.TNode;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.EnumType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import com.jogamp.gluegen.jcpp.JCPP;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class GlueGen
implements GlueEmitterControls {
    private final List<String> forcedStructNames = new ArrayList<String>();
    private GenericCPP preprocessor;
    private List<ConstantDefinition> allConstants;
    private List<FunctionSymbol> allFunctions;
    private static boolean debug;
    private static Level logLevel;
    public static final String __GLUEGEN__ = "__GLUEGEN__";

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static void setLogLevel(Level level) {
        logLevel = level;
    }

    public static boolean debug() {
        return debug;
    }

    @Override
    public void forceStructEmission(String string) {
        this.forcedStructNames.add(string);
    }

    @Override
    public String findHeaderFile(String string) {
        return this.preprocessor.findFile(string);
    }

    @Override
    public void runSymbolFilter(SymbolFilter symbolFilter) {
        symbolFilter.filterSymbols(this.allConstants, this.allFunctions);
        List<ConstantDefinition> list = symbolFilter.getConstants();
        List<FunctionSymbol> list2 = symbolFilter.getFunctions();
        if (list != null) {
            this.allConstants = list;
        }
        if (list2 != null) {
            this.allFunctions = list2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(Reader reader, String string, Class<?> clazz, List<String> list, List<String> list2, String string2, boolean bl, boolean bl2, boolean bl3) {
        try {
            Object object;
            Iterator n;
            GlueEmitter glueEmitter;
            if (debug) {
                Logging.getLogger().setLevel(Level.ALL);
                System.err.println("GlueGen.run: filename: " + string + ", emitter: " + clazz.getName() + ", outputRootDir " + string2 + ", copyCPPOutput2Stderr " + bl + ", enablePragmaOnce " + bl2 + ", preserveGeneratedCPP " + bl3);
                System.err.println("GlueGen.run: includePaths " + list);
                System.err.println("GlueGen.run: cfgFiles " + list2);
            } else if (null != logLevel) {
                Logging.getLogger().setLevel(logLevel);
            }
            if (clazz == null) {
                glueEmitter = new JavaEmitter();
            } else {
                try {
                    glueEmitter = (GlueEmitter)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Exception occurred while instantiating emitter class.", exception);
                }
            }
            for (String object42 : list2) {
                glueEmitter.readConfigurationFile(object42);
            }
            JavaConfiguration javaConfiguration = glueEmitter.getConfig();
            File file = File.createTempFile("CPPTemp", ".cpp");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.preprocessor = new JCPP(list, debug, bl, bl2);
            String string3 = this.preprocessor.getClass().getSimpleName();
            if (debug || bl3) {
                System.err.println("CPP <" + string3 + "> output at (persistent): " + file.getAbsolutePath());
            } else {
                file.deleteOnExit();
            }
            this.preprocessor.addDefine(__GLUEGEN__, "2");
            this.preprocessor.setOut(fileOutputStream);
            this.preprocessor.run(reader, string);
            fileOutputStream.flush();
            fileOutputStream.close();
            if (debug) {
                System.err.println("CPP <" + string3 + "> done");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            GnuCLexer gnuCLexer = new GnuCLexer(dataInputStream);
            gnuCLexer.setTokenObjectClass(CToken.class.getName());
            gnuCLexer.initialize();
            GnuCParser gnuCParser = new GnuCParser(gnuCLexer);
            gnuCParser.setASTNodeClass(TNode.class.getName());
            TNode.setTokenVocabulary(GNUCTokenTypes.class.getName());
            try {
                gnuCParser.translationUnit();
            }
            catch (RecognitionException tokenStreamRecognitionException) {
                throw new RuntimeException(String.format("Fatal error during translation (Localisation : %s:%s:%s)", tokenStreamRecognitionException.getFilename(), tokenStreamRecognitionException.getLine(), tokenStreamRecognitionException.getColumn()), tokenStreamRecognitionException);
            }
            catch (TokenStreamRecognitionException tokenStreamException) {
                throw new RuntimeException(String.format("Fatal error during translation (Localisation : %s:%s:%s)", tokenStreamException.recog.getFilename(), tokenStreamException.recog.getLine(), tokenStreamException.recog.getColumn()), tokenStreamException);
            }
            catch (TokenStreamException headerParser) {
                throw new RuntimeException("Fatal IO error", headerParser);
            }
            HeaderParser headerParser = new HeaderParser();
            headerParser.setDebug(debug);
            headerParser.setJavaConfiguration(javaConfiguration);
            TypeDictionary typeDictionary = new TypeDictionary();
            headerParser.setTypedefDictionary(typeDictionary);
            TypeDictionary typeDictionary2 = new TypeDictionary();
            headerParser.setStructDictionary(typeDictionary2);
            headerParser.setASTNodeClass(TNode.class.getName());
            headerParser.translationUnit(gnuCParser.getAST());
            dataInputStream.close();
            fileInputStream.close();
            if (null != string2 && string2.trim().length() > 0 && glueEmitter instanceof JavaEmitter && null != ((JavaEmitter)((Object)(n = (JavaEmitter)glueEmitter))).getConfig()) {
                ((JavaEmitter)((Object)n)).getConfig().setOutputRootDir(string2);
            }
            this.allConstants = new ArrayList<ConstantDefinition>();
            for (EnumType enumType : headerParser.getEnums()) {
                String string4 = enumType.getName();
                if (string4.equals("<anonymous>")) {
                    Object var24_46 = null;
                }
                for (int i = 0; i < enumType.getNumEnumerates(); ++i) {
                    void var24_44;
                    object = enumType.getEnum(i);
                    ConstantDefinition constantDefinition = new ConstantDefinition(((EnumType.Enumerator)object).getName(), ((EnumType.Enumerator)object).getExpr(), ((EnumType.Enumerator)object).getNumber(), (String)var24_44, enumType.getASTLocusTag());
                    this.allConstants.add(constantDefinition);
                }
            }
            for (Object e : gnuCLexer.getDefines()) {
                Define define = (Define)e;
                this.allConstants.add(new ConstantDefinition(define.getName(), define.getValue(), null, define.getASTLocusTag()));
            }
            this.allConstants.addAll(this.preprocessor.getConstantDefinitions());
            this.allFunctions = headerParser.getParsedFunctions();
            glueEmitter.beginEmission(this);
            if (GlueGen.debug()) {
                int hashSet = 0;
                System.err.println("Filtered Constants: " + this.allConstants.size());
                for (ConstantDefinition constantDefinition : this.allConstants) {
                    if (!GlueGen.debug()) continue;
                    System.err.println("Filtered [" + hashSet + "]: " + constantDefinition.getAliasedString());
                    ++hashSet;
                }
                hashSet = 0;
                System.err.println("Filtered Functions: " + this.allFunctions.size());
                for (FunctionSymbol functionSymbol : this.allFunctions) {
                    System.err.println("Filtered [" + hashSet + "]: " + functionSymbol.getAliasedString());
                    ++hashSet;
                }
            }
            if (!javaConfiguration.structsOnly()) {
                glueEmitter.beginDefines();
                HashSet<String> referencedStructs = new HashSet<String>(100);
                StringBuilder stringBuilder = new StringBuilder();
                for (ConstantDefinition constantDefinition : this.allConstants) {
                    if (referencedStructs.contains(constantDefinition.getName())) continue;
                    referencedStructs.add(constantDefinition.getName());
                    object = javaConfiguration.getAliasedDocNames(constantDefinition);
                    if (object != null && object.size() > 0) {
                        int n2 = 0;
                        stringBuilder.append("Alias for: <code>");
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string5 = (String)iterator.next();
                            if (0 < n2) {
                                stringBuilder.append("</code>, <code>");
                            }
                            stringBuilder.append(string5);
                            ++n2;
                        }
                        stringBuilder.append("</code>");
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("<br>\n");
                    }
                    if (constantDefinition.getEnumName() != null) {
                        stringBuilder.append("Defined as part of enum type \"");
                        stringBuilder.append(constantDefinition.getEnumName());
                        stringBuilder.append("\"");
                    } else {
                        stringBuilder.append("Define \"");
                        stringBuilder.append(constantDefinition.getName());
                        stringBuilder.append("\"");
                    }
                    stringBuilder.append(" with expression '<code>" + constantDefinition.getNativeExpr() + "</code>'");
                    if (stringBuilder.length() > 0) {
                        glueEmitter.emitDefine(constantDefinition, stringBuilder.toString());
                        stringBuilder.setLength(0);
                        continue;
                    }
                    glueEmitter.emitDefine(constantDefinition, null);
                }
                glueEmitter.endDefines();
            }
            ReferencedStructs referencedStructs = new ReferencedStructs();
            for (FunctionSymbol functionSymbol : this.allFunctions) {
                functionSymbol.getType().visit(referencedStructs);
            }
            for (String string6 : this.forcedStructNames) {
                Type type = typeDictionary.get(string6);
                if (type == null) {
                    System.err.println("WARNING: during forced struct emission: struct \"" + string6 + "\" not found");
                    continue;
                }
                if (!type.isCompound()) {
                    System.err.println("WARNING: during forced struct emission: type \"" + string6 + "\" was not a struct");
                    continue;
                }
                type.visit(referencedStructs);
            }
            glueEmitter.beginStructLayout();
            Iterator<CompoundType> iterator = referencedStructs.layouts();
            while (iterator.hasNext()) {
                CompoundType compoundType = iterator.next();
                if (compoundType.isLayouted()) continue;
                glueEmitter.layoutStruct(compoundType);
            }
            glueEmitter.endStructLayout();
            glueEmitter.beginStructs(typeDictionary, typeDictionary2, headerParser.getCanonMap());
            Iterator<Type> iterator2 = referencedStructs.results();
            while (iterator2.hasNext()) {
                Type type = iterator2.next();
                if (type.isCompound()) {
                    assert (type.isTypedef() && type.getName() == null) : "ReferencedStructs incorrectly recorded compound type " + type;
                    glueEmitter.emitStruct(type.asCompound(), null);
                    continue;
                }
                if (!type.isPointer()) continue;
                PointerType pointerType = type.asPointer();
                object = pointerType.getTargetType().asCompound();
                assert (pointerType.isTypedef() && ((Type)object).getName() == null) : "ReferencedStructs incorrectly recorded pointer type " + pointerType;
                glueEmitter.emitStruct((CompoundType)object, pointerType);
            }
            glueEmitter.endStructs();
            if (!javaConfiguration.structsOnly()) {
                glueEmitter.beginFunctions(typeDictionary, typeDictionary2, headerParser.getCanonMap(), this.allFunctions);
                glueEmitter.emitFunctions(this.allFunctions);
                glueEmitter.endFunctions();
            }
            glueEmitter.endEmission();
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception occurred while generating glue code.", exception);
        }
    }

    public static void main(String ... stringArray) {
        if (stringArray.length == 0) {
            System.err.println(GlueGenVersion.getInstance());
            GlueGen.usage();
        }
        Reader reader = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            if (i < stringArray.length - 1) {
                string4 = stringArray[i];
                if (string4.startsWith("-I")) {
                    String[] stringArray2 = string4.substring(2).split(System.getProperty("path.separator"));
                    arrayList2.addAll(Arrays.asList(stringArray2));
                    continue;
                }
                if (string4.startsWith("-O")) {
                    string3 = string4.substring(2);
                    continue;
                }
                if (string4.startsWith("-E")) {
                    string2 = string4.substring(2);
                    continue;
                }
                if (string4.startsWith("-C")) {
                    arrayList.add(string4.substring(2));
                    continue;
                }
                if (string4.equals("--logLevel")) {
                    logLevel = Level.parse(stringArray[++i]);
                    continue;
                }
                if (string4.equals("--debug")) {
                    debug = true;
                    continue;
                }
                if (string4.equals("--dumpCPP")) {
                    bl = true;
                    continue;
                }
                if (string4.equals("--disablePragmaOnce")) {
                    bl2 = false;
                    continue;
                }
                if (string4.equals("--preserveGeneratedCPP")) {
                    bl3 = true;
                    continue;
                }
                GlueGen.usage();
                continue;
            }
            string4 = stringArray[i];
            if (string4.equals("-")) {
                reader = new InputStreamReader(System.in);
                string = "standard input";
                continue;
            }
            if (string4.startsWith("-")) {
                GlueGen.usage();
            }
            string = string4;
            try {
                reader = new BufferedReader(new FileReader(string));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("input file not found", fileNotFoundException);
            }
        }
        try {
            Class<?> clazz = string2 == null ? null : Class.forName(string2);
            new GlueGen().run(reader, string, clazz, arrayList2, arrayList, string3, bl, bl2, bl3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("specified emitter class was not in the classpath", classNotFoundException);
        }
    }

    private static void usage() {
        System.out.println("Usage: java GlueGen [-I...] [-Eemitter_class_name] [-Ccfg_file_name...] <filename | ->");
        System.out.println();
        System.out.println("Runs C header parser on input file or standard input, first");
        System.out.println("passing input through minimal pseudo-C-preprocessor. Use -I");
        System.out.println("command-line arguments to specify the search path for #includes.");
        System.out.println("Emitter class name can be specified with -E option: i.e.,");
        System.out.println("-Ecom.jogamp.gluegen.JavaEmitter (the default). Use");
        System.out.println("-Ecom.jogamp.gluegen.DebugEmitter to print recognized entities");
        System.out.println("(#define directives to constant numbers, typedefs, and function");
        System.out.println("declarations) to standard output. Emitter-specific configuration");
        System.out.println("file or files can be specified with -C option; e.g,");
        System.out.println("-Cjava-emitter.cfg.");
        System.out.println("  --debug enables debug mode");
        System.out.println("  --dumpCPP directs CPP to dump all output to stderr as well");
        System.out.println("  --disablePragmaOnce disable handling of #pragma once directive during parsing (enabled by default)");
        System.out.println("  --preserveGeneratedCPP preserve generated CPP file during generation (File it's already preserved by debug mode)");
        System.exit(1);
    }

    static {
        Logging.init();
        debug = false;
        logLevel = null;
    }
}

