/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.CodeUnit;
import com.jogamp.gluegen.CommentEmitter;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class FunctionEmitter {
    public static final EmissionModifier STATIC = new EmissionModifier("static");
    private final boolean isInterface;
    private final ArrayList<EmissionModifier> modifiers;
    private CommentEmitter commentEmitter = null;
    protected final MethodBinding binding;
    protected final CodeUnit unit;
    protected final JavaConfiguration cfg;

    public FunctionEmitter(MethodBinding methodBinding, CodeUnit codeUnit, boolean bl, JavaConfiguration javaConfiguration) {
        assert (codeUnit != null);
        this.isInterface = bl;
        this.modifiers = new ArrayList();
        this.binding = methodBinding;
        this.unit = codeUnit;
        this.cfg = javaConfiguration;
    }

    public FunctionEmitter(FunctionEmitter functionEmitter) {
        this.isInterface = functionEmitter.isInterface;
        this.modifiers = new ArrayList<EmissionModifier>(functionEmitter.modifiers);
        this.commentEmitter = functionEmitter.commentEmitter;
        this.binding = functionEmitter.binding;
        this.unit = functionEmitter.unit;
        this.cfg = functionEmitter.cfg;
    }

    public final boolean isInterface() {
        return this.isInterface;
    }

    public final MethodBinding getBinding() {
        return this.binding;
    }

    public final CodeUnit getUnit() {
        return this.unit;
    }

    public void addModifiers(Iterator<EmissionModifier> iterator) {
        while (iterator.hasNext()) {
            this.modifiers.add(iterator.next());
        }
    }

    public void addModifier(EmissionModifier emissionModifier) {
        this.modifiers.add(emissionModifier);
    }

    public boolean removeModifier(EmissionModifier emissionModifier) {
        return this.modifiers.remove(emissionModifier);
    }

    public void clearModifiers() {
        this.modifiers.clear();
    }

    public boolean hasModifier(EmissionModifier emissionModifier) {
        return this.modifiers.contains(emissionModifier);
    }

    public Iterator<EmissionModifier> getModifiers() {
        return this.modifiers.iterator();
    }

    public abstract String getInterfaceName();

    public abstract String getImplName();

    public abstract String getNativeName();

    public abstract FunctionSymbol getCSymbol();

    public final void emit() {
        this.emitAdditionalCode();
        this.emitDocComment();
        this.emitSignature();
        this.emitBody();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.binding.toString() + "]";
    }

    public void setCommentEmitter(CommentEmitter commentEmitter) {
        this.commentEmitter = commentEmitter;
    }

    public CommentEmitter getCommentEmitter() {
        return this.commentEmitter;
    }

    protected void emitAdditionalCode() {
    }

    protected void emitDocComment() {
        if (this.commentEmitter != null) {
            this.unit.emit(this.getBaseIndentString());
            this.unit.emit(this.getCommentStartString());
            this.commentEmitter.emit(this, this.unit.output);
            this.unit.emit(this.getBaseIndentString());
            this.unit.emitln(this.getCommentEndString());
        }
    }

    protected final void emitSignature() {
        this.unit.emit(this.appendSignature(new StringBuilder()).toString());
    }

    protected StringBuilder appendSignature(StringBuilder stringBuilder) {
        stringBuilder.append(this.getBaseIndentString());
        int n = this.appendModifiers(stringBuilder);
        if (n > 0) {
            stringBuilder.append(" ");
        }
        this.appendReturnType(stringBuilder);
        stringBuilder.append(" ");
        this.appendName(stringBuilder);
        stringBuilder.append("(");
        this.appendArguments(stringBuilder);
        stringBuilder.append(")");
        return stringBuilder;
    }

    protected final int emitModifiers() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.appendModifiers(stringBuilder);
        this.unit.emit(stringBuilder.toString());
        return n;
    }

    protected int appendModifiers(StringBuilder stringBuilder) {
        int n = 0;
        Iterator<EmissionModifier> iterator = this.getModifiers();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            ++n;
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" ");
        }
        return n;
    }

    protected String getBaseIndentString() {
        return "";
    }

    protected String getCommentStartString() {
        return "/* ";
    }

    protected String getCommentEndString() {
        return " */";
    }

    protected final void emitReturnType() {
        this.unit.emit(this.appendReturnType(new StringBuilder()).toString());
    }

    protected abstract StringBuilder appendReturnType(StringBuilder var1);

    protected final void emitName() {
        this.unit.emit(this.appendName(new StringBuilder()).toString());
    }

    protected abstract StringBuilder appendName(StringBuilder var1);

    protected final int emitArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.appendArguments(stringBuilder);
        this.unit.emit(stringBuilder.toString());
        return n;
    }

    protected abstract int appendArguments(StringBuilder var1);

    protected abstract void emitBody();

    public static class EmissionModifier {
        private final String emittedForm;

        public final String toString() {
            return this.emittedForm;
        }

        public int hashCode() {
            return this.emittedForm.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof EmissionModifier)) {
                return false;
            }
            return this.emittedForm.equals(((EmissionModifier)object).emittedForm);
        }

        protected EmissionModifier(String string) {
            this.emittedForm = string;
        }
    }
}

