/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.TypeConfig;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import java.math.BigInteger;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstantDefinition
extends AliasedSymbol.AliasedSymbolImpl
implements TypeComparator.AliasedSemanticSymbol,
ASTLocusTag.ASTLocusTagProvider {
    public static final long UNSIGNED_INT_MAX_VALUE = 0xFFFFFFFFL;
    public static final BigInteger UNSIGNED_LONG_MAX_VALUE = new BigInteger("ffffffffffffffff", 16);
    private final boolean relaxedEqSem;
    private final String nativeExpr;
    private final CNumber number;
    private final boolean isEnum;
    private final String enumName;
    private final ASTLocusTag astLocus;
    public static Pattern patternHexNumber = Pattern.compile("[\\x00-\\x20]*[+-]?0[xX](\\p{XDigit}+)([uU]|([uU][lL])|[lL]|([lL][uU]))?[\\x00-\\x20]*");
    public static final Pattern patternDecimalNumber;
    public static final Pattern patternDecimalOrIntNumber;
    public static final Pattern patternIntegerNumber;
    public static Pattern patternCPPOperand;

    public ConstantDefinition(String string, String string2, CNumber cNumber, ASTLocusTag aSTLocusTag) {
        this(string, string2, cNumber, false, null, aSTLocusTag);
    }

    public ConstantDefinition(String string, String string2, CNumber cNumber, String string3, ASTLocusTag aSTLocusTag) {
        this(string, string2, cNumber, true, string3, aSTLocusTag);
    }

    private ConstantDefinition(String string, String string2, CNumber cNumber, boolean bl, String string3, ASTLocusTag aSTLocusTag) {
        super(string);
        CNumber cNumber2;
        CNumber cNumber3;
        this.nativeExpr = string2;
        this.relaxedEqSem = TypeConfig.relaxedEqualSemanticsTest();
        this.number = null != cNumber ? cNumber : (null != (cNumber3 = ConstantDefinition.decodeIntegerNumber(string2)) ? cNumber3 : (null != (cNumber2 = ConstantDefinition.decodeDecimalNumber(string2)) ? cNumber2 : null));
        this.isEnum = bl;
        this.enumName = string3;
        this.astLocus = aSTLocusTag;
    }

    @Override
    public ASTLocusTag getASTLocusTag() {
        return this.astLocus;
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConstantDefinition)) {
            return false;
        }
        ConstantDefinition constantDefinition = (ConstantDefinition)object;
        return ConstantDefinition.equals(this.getName(), constantDefinition.getName());
    }

    @Override
    public final int hashCodeSemantics() {
        int n = 31 + (null != this.getName() ? this.getName().hashCode() : 0);
        n = (n << 5) - n + (this.isEnum ? 1 : 0);
        n = (n << 5) - n + (null != this.enumName ? this.enumName.hashCode() : 0);
        n = (n << 5) - n + (null != this.number ? this.number.hashCode() : 0);
        return (n << 5) - n + (!this.relaxedEqSem && null != this.nativeExpr ? this.nativeExpr.hashCode() : 0);
    }

    @Override
    public final boolean equalSemantics(TypeComparator.SemanticEqualityOp semanticEqualityOp) {
        if (semanticEqualityOp == this) {
            return true;
        }
        if (!(semanticEqualityOp instanceof ConstantDefinition)) {
            return false;
        }
        ConstantDefinition constantDefinition = (ConstantDefinition)semanticEqualityOp;
        if (!ConstantDefinition.equals(this.getName(), constantDefinition.getName()) || this.isEnum != constantDefinition.isEnum || !ConstantDefinition.equals(this.enumName, constantDefinition.enumName)) {
            return false;
        }
        if (null != this.number) {
            if (this.number.isInteger) {
                return this.number.i == constantDefinition.number.i;
            }
            return this.number.f == constantDefinition.number.f;
        }
        return this.relaxedEqSem || ConstantDefinition.equals(this.nativeExpr, constantDefinition.nativeExpr);
    }

    public String getNativeExpr() {
        return this.nativeExpr;
    }

    public CNumber getNumber() {
        return this.number;
    }

    public boolean hasNumber() {
        return null != this.number;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public String toString() {
        return "ConstantDefinition [name \"" + this.getName() + "\", expression \"" + this.nativeExpr + "\", number " + this.number + "], enum[is " + this.isEnum + ", name \"" + this.enumName + "\"]]";
    }

    private static boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.equals(string2);
    }

    public final JavaExpr computeJavaExpr(Map<String, JavaExpr> map) {
        return JavaExpr.compute(this, map);
    }

    public static boolean isConstantExpression(String string) {
        if (null != string && string.length() > 0) {
            if (ConstantDefinition.isNumber(string)) {
                return true;
            }
            String[] stringArray = string.split("[\\s\\+\\-\\*\\/\\|\\&\\(\\)]|(\\<\\<)|(\\>\\>)|(\\~)");
            int n = 0;
            for (String string2 : stringArray) {
                if (string2.length() <= 0 || ConstantDefinition.isCPPOperand(string2)) continue;
                if (ConstantDefinition.isNumber(string2)) {
                    ++n;
                    continue;
                }
                return false;
            }
            boolean bl = n > 0;
            return bl;
        }
        return false;
    }

    public static boolean isIdentifier(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) continue;
                bl = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static CNumber decodeANumber(String string) {
        CNumber cNumber = ConstantDefinition.decodeIntegerNumber(string);
        if (null != cNumber) {
            return cNumber;
        }
        return ConstantDefinition.decodeDecimalNumber(string);
    }

    public static CNumber decodeIntegerNumber(String string) {
        long l;
        boolean bl;
        if (null == string || !ConstantDefinition.isIntegerNumber(string)) {
            return null;
        }
        String string2 = string.trim();
        if (0 == string2.length()) {
            return null;
        }
        if (string2.startsWith("+") && 0 == (string2 = string2.substring(1, string2.length()).trim()).length()) {
            return null;
        }
        if (string2.startsWith("-")) {
            if (0 == (string2 = string2.substring(1, string2.length()).trim()).length()) {
                return null;
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n = string2.length() - 2;
        for (int i = string2.length() - 1; i >= 0 && i >= n; --i) {
            char c = string2.charAt(string2.length() - 1);
            if (c == 'u' || c == 'U') {
                string2 = string2.substring(0, string2.length() - 1);
                bl2 = true;
                continue;
            }
            if (c != 'l' && c != 'L') break;
            string2 = string2.substring(0, string2.length() - 1);
            bl3 = true;
        }
        if (0 == string2.length()) {
            return null;
        }
        if (bl3 && bl2) {
            l = ConstantDefinition.decodeULong(string2, bl);
        } else {
            if (bl) {
                string2 = "-" + string2;
            }
            l = Long.decode(string2);
        }
        boolean bl4 = bl3 || !bl2 && (Integer.MIN_VALUE > l || l > Integer.MAX_VALUE) || bl2 && l > 0xFFFFFFFFL;
        return new CNumber(bl4, bl2, l);
    }

    private static long decodeULong(String string, boolean bl) throws NumberFormatException {
        int n;
        int n2;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n2 = 2;
            n = 16;
        } else if (string.startsWith("#")) {
            n2 = 1;
            n = 16;
        } else if (string.startsWith("0") && string.length() > 1) {
            n2 = 1;
            n = 8;
        } else {
            n2 = 0;
            n = 10;
        }
        String string2 = (bl ? "-" : "") + string.substring(n2);
        BigInteger bigInteger = new BigInteger(string2, n);
        if (bigInteger.compareTo(UNSIGNED_LONG_MAX_VALUE) > 0) {
            throw new NumberFormatException("Value \"" + string + "\" is > UNSIGNED_LONG_MAX");
        }
        return bigInteger.longValue();
    }

    public static CNumber decodeDecimalNumber(String string) {
        if (null == string || !ConstantDefinition.isDecimalNumber(string)) {
            return null;
        }
        String string2 = string.trim();
        if (0 == string2.length()) {
            return null;
        }
        boolean bl = false;
        char c = string2.charAt(string2.length() - 1);
        if (c == 'd' || c == 'D') {
            bl = true;
        }
        double d = Double.valueOf(string2);
        double d2 = Math.abs(d);
        return new CNumber(bl || (double)1.4E-45f > d2 || d2 > 3.4028234663852886E38, d);
    }

    public static boolean isNumber(String string) {
        if (ConstantDefinition.isHexNumber(string)) {
            return true;
        }
        return ConstantDefinition.isDecimalOrIntNumber(string);
    }

    public static boolean isIntegerNumber(String string) {
        if (ConstantDefinition.isHexNumber(string)) {
            return true;
        }
        return patternIntegerNumber.matcher(string).matches();
    }

    public static boolean isHexNumber(String string) {
        return patternHexNumber.matcher(string).matches();
    }

    public static boolean isDecimalNumber(String string) {
        return patternDecimalNumber.matcher(string).matches();
    }

    public static boolean isDecimalOrIntNumber(String string) {
        return patternDecimalOrIntNumber.matcher(string).matches();
    }

    public static boolean isCPPOperand(String string) {
        return patternCPPOperand.matcher(string).matches();
    }

    static {
        patternIntegerNumber = Pattern.compile("[\\x00-\\x20]*[+-]?(\\p{Digit}+)([uU]|([uU][lL])|[lL]|([lL][uU]))?[\\x00-\\x20]*");
        patternDecimalNumber = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
        patternDecimalOrIntNumber = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((\\p{Digit}+)([uU]|([uU][lL])|[lL]|([lL][uU])))|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
        patternCPPOperand = Pattern.compile("(?![\\x00-\\x20]*(NaN|Infinity|((\\p{Digit}+)([uU]|([uU][lL])|[lL]|([lL][uU])))|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*)[\\+\\-\\*\\/\\|\\&\\(\\)]|(\\<\\<)|(\\>\\>)|(\\~)");
    }

    public static class CNumber {
        public final boolean isInteger;
        public final boolean isLong;
        public final boolean isUnsigned;
        public final long i;
        public final boolean isDouble;
        public final double f;

        public CNumber(boolean bl, boolean bl2, long l) {
            this.isInteger = true;
            this.isLong = bl;
            this.isUnsigned = bl2;
            this.i = l;
            this.isDouble = false;
            this.f = 0.0;
        }

        public CNumber(boolean bl, double d) {
            this.isInteger = false;
            this.isLong = false;
            this.isUnsigned = false;
            this.i = 0L;
            this.isDouble = bl;
            this.f = d;
        }

        public int hashCode() {
            return this.isInteger ? Long.valueOf(this.i).hashCode() : Double.valueOf(this.f).hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CNumber)) {
                return false;
            }
            CNumber cNumber = (CNumber)object;
            return this.isInteger == cNumber.isInteger && (this.isInteger ? this.i == cNumber.i : this.f == cNumber.f);
        }

        public final String toJavaString() {
            if (this.isInteger) {
                if (this.i >= 0L || this.isUnsigned) {
                    if (this.isLong) {
                        return "0x" + Long.toHexString(this.i) + "L";
                    }
                    return "0x" + Integer.toHexString((int)this.i);
                }
                if (this.isLong) {
                    return String.valueOf(this.i) + "L";
                }
                return String.valueOf((int)this.i);
            }
            return String.valueOf(this.f) + (!this.isDouble ? "f" : "");
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            if (this.isInteger) {
                if (this.isUnsigned) {
                    stringBuilder.append("unsigned ");
                }
                if (this.isLong) {
                    stringBuilder.append("long: ");
                } else {
                    stringBuilder.append("int: ");
                }
                stringBuilder.append(this.i);
            } else {
                if (this.isDouble) {
                    stringBuilder.append("double: ");
                } else {
                    stringBuilder.append("float: ");
                }
                stringBuilder.append(this.f);
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static class JavaExpr {
        public final String javaExpression;
        public final CNumber resultType;
        public final Number resultJavaType;
        public final String resultJavaTypeName;

        public JavaExpr(String string, CNumber cNumber) {
            this.javaExpression = string;
            this.resultType = cNumber;
            if (cNumber.isDouble) {
                this.resultJavaTypeName = "double";
                this.resultJavaType = cNumber.f;
            } else if (!cNumber.isInteger) {
                this.resultJavaTypeName = "float";
                this.resultJavaType = Float.valueOf(Double.valueOf(cNumber.f).floatValue());
            } else if (cNumber.isLong) {
                this.resultJavaTypeName = "long";
                this.resultJavaType = cNumber.i;
            } else {
                this.resultJavaTypeName = "int";
                this.resultJavaType = Long.valueOf(cNumber.i).intValue();
            }
        }

        public static JavaExpr compute(ConstantDefinition constantDefinition, Map<String, JavaExpr> map) {
            String string;
            boolean bl = GlueGen.debug();
            if (bl) {
                System.err.println("ConstJavaExpr.create: " + constantDefinition);
            }
            if (constantDefinition.hasNumber()) {
                if (bl) {
                    System.err.printf("V %s (isCNumber)%n", constantDefinition);
                }
                return new JavaExpr(constantDefinition.getNumber().toJavaString(), constantDefinition.getNumber());
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = constantDefinition.getNativeExpr();
            CNumber cNumber = null;
            Matcher matcher = patternCPPOperand.matcher(string2);
            int n = 0;
            int n2 = 0;
            while (matcher.find()) {
                String string3;
                int n3 = matcher.start();
                if (n3 > n && (string3 = string2.substring(n, n3).trim()).length() > 0) {
                    if (bl) {
                        System.err.printf("V %03d-%03d: %s%n", n, n3, string3);
                    }
                    cNumber = JavaExpr.processValue(constantDefinition, string3, map, cNumber, stringBuilder);
                    stringBuilder.append(" ");
                }
                n2 = matcher.end();
                string3 = string2.substring(n3, n2);
                if (bl) {
                    System.err.printf("O %03d-%03d: %s%n", n3, n2, string3);
                }
                stringBuilder.append(string3).append(" ");
                n = n2;
            }
            if (n2 < string2.length() && (string = string2.substring(n2).trim()).length() > 0) {
                if (bl) {
                    System.err.printf("V %03d %03d-%03d: %s (tail)%n", n, n2, string2.length(), string);
                }
                cNumber = JavaExpr.processValue(constantDefinition, string, map, cNumber, stringBuilder);
            }
            String string4 = stringBuilder.toString().trim();
            if (null == cNumber) {
                throw new GlueGenException("Cannot emit const \"" + constantDefinition.getName() + "\": value \"" + string2 + "\", parsed \"" + string4 + "\" does not contain a constant number", constantDefinition.getASTLocusTag());
            }
            return new JavaExpr(string4, cNumber);
        }

        private static CNumber processValue(ConstantDefinition constantDefinition, String string, Map<String, JavaExpr> map, CNumber cNumber, StringBuilder stringBuilder) {
            CNumber cNumber2 = JavaExpr.getANumber(constantDefinition, string);
            if (null != cNumber2) {
                cNumber = JavaExpr.evalType(cNumber, cNumber2);
                stringBuilder.append(cNumber2.toJavaString());
            } else {
                JavaExpr javaExpr = map.get(string);
                if (null != javaExpr) {
                    cNumber = JavaExpr.evalType(cNumber, javaExpr.resultType);
                }
                stringBuilder.append(string);
            }
            return cNumber;
        }

        private static CNumber getANumber(ConstantDefinition constantDefinition, String string) {
            try {
                CNumber cNumber = ConstantDefinition.decodeANumber(string);
                if (null != cNumber) {
                    return cNumber;
                }
            }
            catch (Throwable throwable) {
                String string2 = "Cannot emit const \"" + constantDefinition.getName() + "\": value \"" + string + "\" cannot be assigned to a int, long, float, or double";
                throw new GlueGenException(string2, constantDefinition.getASTLocusTag(), throwable);
            }
            return null;
        }

        private static CNumber evalType(CNumber cNumber, CNumber cNumber2) {
            if (cNumber2.isDouble) {
                return cNumber2;
            }
            if (null != cNumber) {
                if (cNumber.isInteger ? (cNumber.isLong ? !cNumber2.isInteger : cNumber2.isLong || !cNumber2.isInteger) : !cNumber.isInteger && !cNumber.isDouble && cNumber2.isDouble) {
                    return cNumber2;
                }
            } else {
                return cNumber2;
            }
            return cNumber;
        }
    }
}

