/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class CodeUnit {
    public final String filename;
    public final PrintWriter output;
    private final Set<String> tailCode = new HashSet<String>();

    protected CodeUnit(String string, Object object) throws IOException {
        this.filename = string;
        this.output = CodeUnit.openFile(string);
    }

    private static PrintWriter openFile(String string) throws IOException {
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null) {
            new File(string2).mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    public boolean addTailCode(String string) {
        return this.tailCode.add(string);
    }

    public void emitln() {
        this.output.println();
    }

    public void emitln(String string) {
        this.output.println(string);
    }

    public void emit(String string) {
        this.output.print(string);
    }

    public void emitf(String string, Object ... objectArray) {
        this.output.printf(string, objectArray);
    }

    public void emitTailCode() {
        this.tailCode.forEach(string -> {
            this.output.write((String)string);
            this.output.println();
        });
        this.tailCode.clear();
    }

    public void close() {
        this.emitTailCode();
        this.output.flush();
        this.output.close();
    }

    public String toString() {
        return "CodeUnit[file " + this.filename + "]";
    }
}

