/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.gluegen.CodeUnit;
import com.jogamp.gluegen.CommentEmitter;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.JavaCallbackEmitter;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.List;

public class CMethodBindingEmitter
extends FunctionEmitter {
    protected static final CommentEmitter defaultCommentEmitter = new DefaultCommentEmitter();
    protected static final String arrayResLength = "_array_res_length";
    protected static final String arrayRes = "_array_res";
    protected static final String arrayIdx = "_array_idx";
    protected final Logging.LoggerIf LOG = Logging.getLogger(CMethodBindingEmitter.class.getPackage().getName(), CMethodBindingEmitter.class.getSimpleName());
    private final String packageName;
    private final String className;
    private final boolean isOverloadedBinding;
    private final boolean isJavaMethodStatic;
    protected boolean forImplementingMethodCall;
    protected boolean forIndirectBufferAndArrayImplementation;
    private List<String> temporaryCVariableDeclarations;
    private List<String> temporaryCVariableAssignments;
    private MessageFormat returnValueCapacityExpression = null;
    private MessageFormat returnValueLengthExpression = null;
    protected static final String STRING_CHARS_PREFIX = "_strchars_";
    protected MachineDataInfo machDesc;
    private final CMethodBindingEmitter jcbFuncCMethodEmitter;
    private final JavaCallbackEmitter javaCallbackEmitter;
    private boolean isCStructFunctionPointer = false;

    public CMethodBindingEmitter(MethodBinding methodBinding, CodeUnit codeUnit, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, MachineDataInfo machineDataInfo, JavaConfiguration javaConfiguration) {
        super(methodBinding, codeUnit, false, javaConfiguration);
        assert (methodBinding != null);
        assert (string2 != null);
        assert (string != null);
        this.packageName = string;
        this.className = string2;
        this.isOverloadedBinding = bl;
        this.isJavaMethodStatic = bl2;
        this.forImplementingMethodCall = bl3;
        this.forIndirectBufferAndArrayImplementation = bl4;
        this.machDesc = machineDataInfo;
        JavaConfiguration.JavaCallbackInfo javaCallbackInfo = this.cfg.setFuncToJavaCallbackMap.get(methodBinding.getName());
        if (null != javaCallbackInfo) {
            this.jcbFuncCMethodEmitter = new CMethodBindingEmitter(javaCallbackInfo.cbFuncBinding, codeUnit, string, string2, bl, bl2, bl3, bl4, machineDataInfo, javaConfiguration);
            this.javaCallbackEmitter = new JavaCallbackEmitter(this.cfg, methodBinding, javaCallbackInfo, null);
        } else {
            this.jcbFuncCMethodEmitter = null;
            this.javaCallbackEmitter = null;
        }
        this.setCommentEmitter(defaultCommentEmitter);
    }

    @Override
    public String getInterfaceName() {
        return this.binding.getInterfaceName();
    }

    @Override
    public String getImplName() {
        return this.binding.getImplName();
    }

    @Override
    public String getNativeName() {
        return this.binding.getNativeName();
    }

    @Override
    public FunctionSymbol getCSymbol() {
        return this.binding.getCSymbol();
    }

    public final MessageFormat getReturnValueCapacityExpression() {
        return this.returnValueCapacityExpression;
    }

    public final void setReturnValueCapacityExpression(MessageFormat messageFormat) {
        this.returnValueCapacityExpression = messageFormat;
        if (!this.binding.getJavaReturnType().isNIOBuffer() && !this.binding.getJavaReturnType().isCompoundTypeWrapper()) {
            throw new IllegalArgumentException("Cannot specify return value capacity for a method that does not return java.nio.Buffer or a compound type wrapper: \"" + this.binding + "\"");
        }
    }

    public final MessageFormat getReturnValueLengthExpression() {
        return this.returnValueLengthExpression;
    }

    public final void setReturnValueLengthExpression(MessageFormat messageFormat) {
        this.returnValueLengthExpression = messageFormat;
        if (!this.binding.getJavaReturnType().isArray() && !this.binding.getJavaReturnType().isArrayOfCompoundTypeWrappers()) {
            throw new IllegalArgumentException("Cannot specify return value length for a method that does not return an array: \"" + this.binding + "\"");
        }
    }

    public final List<String> getTemporaryCVariableDeclarations() {
        return this.temporaryCVariableDeclarations;
    }

    public final void setTemporaryCVariableDeclarations(List<String> list) {
        this.temporaryCVariableDeclarations = list;
    }

    public final List<String> getTemporaryCVariableAssignments() {
        return this.temporaryCVariableAssignments;
    }

    public final void setTemporaryCVariableAssignments(List<String> list) {
        this.temporaryCVariableAssignments = list;
    }

    public String getJavaPackageName() {
        return this.packageName;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public final boolean getIsOverloadedBinding() {
        return this.isOverloadedBinding;
    }

    public final boolean getIsJavaMethodStatic() {
        return this.isJavaMethodStatic;
    }

    public final boolean forIndirectBufferAndArrayImplementation() {
        return this.forIndirectBufferAndArrayImplementation;
    }

    public final MachineDataInfo getMachineDataInfo() {
        return this.machDesc;
    }

    @Override
    protected StringBuilder appendReturnType(StringBuilder stringBuilder) {
        stringBuilder.append("JNIEXPORT ");
        stringBuilder.append(this.binding.getJavaReturnType().jniTypeName());
        stringBuilder.append(" JNICALL");
        return stringBuilder;
    }

    @Override
    protected StringBuilder appendName(StringBuilder stringBuilder) {
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(JavaEmitter.getJNIMethodNamePrefix(this.getJavaPackageName(), this.getJavaClassName()));
        stringBuilder.append("_");
        if (this.isOverloadedBinding) {
            stringBuilder.append(this.jniMangle(this.binding));
        } else {
            stringBuilder.append(JavaEmitter.jniMangle(this.getImplName()));
        }
        return stringBuilder;
    }

    protected String getImplSuffix() {
        if (this.forImplementingMethodCall) {
            if (this.forIndirectBufferAndArrayImplementation) {
                return "1";
            }
            return "0";
        }
        return "";
    }

    @Override
    protected int appendArguments(StringBuilder stringBuilder) {
        stringBuilder.append("JNIEnv *env, ");
        int n = 1;
        if (this.isJavaMethodStatic && !this.binding.hasContainingType()) {
            stringBuilder.append("jclass");
        } else {
            stringBuilder.append("jobject");
        }
        stringBuilder.append(" _unused");
        ++n;
        if (this.binding.isReturnCompoundByValue()) {
            stringBuilder.append(", jclass _clazzBuffers");
            ++n;
        }
        if (this.binding.hasContainingType()) {
            stringBuilder.append(", jobject " + JavaMethodBindingEmitter.javaThisArgumentName());
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            stringBuilder.append(", ");
            stringBuilder.append(javaType.jniTypeName());
            stringBuilder.append(" ");
            stringBuilder.append(this.binding.getArgumentName(i));
            ++n;
            if (javaType.isPrimitiveArray() || javaType.isNIOBuffer()) {
                stringBuilder.append(", jint " + this.byteOffsetArgName(i));
                if (!this.forIndirectBufferAndArrayImplementation) continue;
                stringBuilder.append(", jboolean " + this.isNIOArgName(i));
                continue;
            }
            if (!javaType.isNIOBufferArray()) continue;
            stringBuilder.append(", jintArray " + this.byteOffsetArrayArgName(i));
        }
        if (null != this.javaCallbackEmitter) {
            n += this.javaCallbackEmitter.appendCAdditionalParameter(stringBuilder);
        }
        return n;
    }

    @Override
    protected void emitAdditionalCode() {
        if (null != this.javaCallbackEmitter) {
            this.javaCallbackEmitter.emitCAdditionalCode(this.unit, this.jcbFuncCMethodEmitter);
        }
    }

    @Override
    protected void emitBody() {
        this.unit.emitln(" {");
        this.emitBodyVariableDeclarations();
        this.emitBodyUserVariableDeclarations();
        this.emitBodyVariablePreCallSetup();
        if (null != this.javaCallbackEmitter) {
            this.javaCallbackEmitter.emitCSetFuncPreCall(this.unit);
        }
        this.emitBodyCallCFunction();
        this.emitBodyUserVariableAssignments();
        this.emitBodyVariablePostCallCleanup();
        if (this.emitBodyMapCToJNIType(-1, true)) {
            this.unit.emitln("  return _res_jni;");
        }
        this.unit.emitln("}");
        this.unit.emitln();
    }

    protected void emitBodyVariableDeclarations() {
        String string;
        Object object;
        JavaType javaType;
        if (this.binding.hasContainingType()) {
            this.emitPointerDeclaration(this.binding.getContainingType(), this.binding.getContainingCType(), CMethodBindingEmitter.cThisArgumentName(), null);
        }
        boolean bl = false;
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (javaType.isArray() || javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper() || javaType.isArrayOfCompoundTypeWrappers()) {
                object = this.binding.getArgumentName(i);
                string = this.pointerConversionArgumentName((String)object);
                boolean bl2 = this.emitPointerDeclaration(javaType, this.binding.getCArgumentType(i), string, (String)object);
                if (!bl2 || bl) continue;
                this.unit.emitln("  jobject _tmpObj;");
                this.unit.emitln("  int _copyIndex;");
                this.unit.emitln("  jsize _tmpArrayLen;");
                if (javaType.isNIOBufferArray()) {
                    this.unit.emitln("  int * _offsetHandle = NULL;");
                }
                bl = true;
                continue;
            }
            if (!javaType.isString()) continue;
            object = this.binding.getCArgumentType(i);
            if (this.isUTF8Type((Type)object)) {
                this.unit.emit("  const char* ");
            } else {
                this.unit.emit("  jchar* ");
            }
            this.unit.emit(STRING_CHARS_PREFIX);
            this.unit.emit(this.binding.getArgumentName(i));
            this.unit.emitln(" = NULL;");
        }
        Type type = this.binding.getCReturnType();
        javaType = this.binding.getJavaReturnType();
        if (!type.isVoid()) {
            this.unit.emit("  ");
            this.unit.emit(this.binding.getCSymbol().getReturnType().getCName(false));
            this.unit.emitln(" _res;");
            if (javaType.isNIOByteBufferArray() || javaType.isArrayOfCompoundTypeWrappers()) {
                this.unit.emit("  int ");
                this.unit.emit(arrayResLength);
                this.unit.emitln(";");
                this.unit.emit("  int ");
                this.unit.emit(arrayIdx);
                this.unit.emitln(";");
                this.unit.emit("  jobjectArray ");
                this.unit.emit(arrayRes);
                this.unit.emitln(";");
            } else if (javaType.isArray()) {
                this.unit.emit("  int ");
                this.unit.emit(arrayResLength);
                this.unit.emitln(";");
                object = javaType.getJavaClass().getComponentType();
                if (((Class)object).isArray()) {
                    throw new RuntimeException("Multi-dimensional arrays not supported yet");
                }
                string = ((Class)object).getName();
                String string2 = "j" + string + "Array";
                this.unit.emit("  ");
                this.unit.emit(string2);
                this.unit.emit(" ");
                this.unit.emit(arrayRes);
                this.unit.emitln(";");
            }
        }
    }

    protected void emitBodyUserVariableDeclarations() {
        if (this.temporaryCVariableDeclarations != null) {
            for (String string : this.temporaryCVariableDeclarations) {
                this.unit.emit("  ");
                this.unit.emitln(string);
            }
        }
    }

    protected boolean isUTF8Type(Type type) {
        while (!type.isInt() && !type.isVoid()) {
            PointerType pointerType = type.asPointer();
            if (pointerType != null) {
                type = pointerType.getTargetType();
                continue;
            }
            ArrayType arrayType = type.asArray();
            if (arrayType == null) {
                throw new IllegalArgumentException("Type " + type + " should have been a pointer or array type");
            }
            type = arrayType.getTargetType();
        }
        if (type.isVoid()) {
            return true;
        }
        if (!type.isInt()) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional integer pointer or array type");
        }
        if (type.getSize(this.machDesc) != 1L && type.getSize(this.machDesc) != 2L) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional pointer to char or short");
        }
        return type.getSize(this.machDesc) == 1L;
    }

    protected void emitBodyVariablePreCallSetup() {
        if (this.binding.hasContainingType()) {
            this.emitPointerConversion(this.binding, this.binding.getContainingType(), this.binding.getContainingCType(), JavaMethodBindingEmitter.javaThisArgumentName(), CMethodBindingEmitter.cThisArgumentName(), null);
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            String string = this.binding.getArgumentName(i);
            if (javaType.isCompoundTypeWrapper() || javaType.isNIOBuffer() && !this.forIndirectBufferAndArrayImplementation) {
                this.emitPointerConversion(this.binding, javaType, this.binding.getCArgumentType(i), string, this.pointerConversionArgumentName(string), this.byteOffsetArgName(i));
                continue;
            }
            if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation) {
                boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
                this.unit.emitln("  if ( NULL != " + string + " ) {");
                Type type = this.binding.getCArgumentType(i);
                String string2 = type.getCName();
                String string3 = this.pointerConversionArgumentName(string);
                if (!bl) {
                    this.unit.emit("    ");
                    this.unit.emit(string3);
                    this.unit.emit(" = (");
                    if (javaType.isStringArray()) {
                        string2 = "jstring *";
                    }
                    this.unit.emit(string2);
                    this.unit.emit(") ( JNI_TRUE == " + this.isNIOArgName(i) + " ? ");
                    this.unit.emit(" (*env)->GetDirectBufferAddress(env, " + string + ") : ");
                    this.unit.emit(" (*env)->GetPrimitiveArrayCritical(env, " + string + ", NULL) );");
                } else {
                    Type type2;
                    Type type3;
                    if (!type.isBaseTypeConst() && !javaType.isArrayOfCompoundTypeWrappers()) {
                        throw new GlueGenException("Cannot copy data for ptr-to-ptr arg type \"" + type.getDebugString() + "\": support for non-const ptr-to-ptr types not implemented: " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                    }
                    this.unit.emitln();
                    this.unit.emitln("    /* Copy contents of " + string + " into " + string3 + "_copy */");
                    this.unit.emit("    ");
                    this.unit.emit("_tmpArrayLen");
                    this.unit.emit(" = (*env)->GetArrayLength(env, ");
                    this.unit.emit(string);
                    this.unit.emitln(");");
                    int n = 0;
                    if (type.isPointer()) {
                        type3 = type.asPointer().getTargetType();
                        if (type3.isPointer()) {
                            type2 = type3.asPointer().getTargetType();
                            if (type2.isPointer()) {
                                n = 1;
                            }
                            if (type.pointerDepth() != 2) {
                                n = 2;
                            }
                        } else {
                            type2 = null;
                            if (type.pointerDepth() != 1) {
                                n = 10;
                            }
                        }
                    } else if (type.isArray()) {
                        type3 = type.getBaseType();
                        type2 = null;
                    } else {
                        type3 = null;
                        type2 = null;
                        n = 100;
                    }
                    if (0 < n) {
                        throw new GlueGenException("Could not copy data for type \"" + type.getDebugString() + "\"; currently only pointer- and array-types are supported. (error " + n + "): " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                    }
                    this.emitMalloc(string3 + "_copy", type3.getCName(), type.isBaseTypeConst(), "_tmpArrayLen", "Could not allocate buffer for copying data in argument \\\"" + string + "\\\"");
                    if (javaType.isNIOBufferArray()) {
                        this.unit.emitln("    _offsetHandle = (int *) (*env)->GetPrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", NULL);");
                    }
                    this.unit.emitln("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                    this.unit.emitln("      /* get each element of the array argument \"" + string + "\" */");
                    this.unit.emit("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                    this.unit.emit(string);
                    this.unit.emitln(", _copyIndex);");
                    if (javaType.isStringArray()) {
                        this.unit.emit("  ");
                        this.emitGetStringChars("(jstring) _tmpObj", string3 + "_copy[_copyIndex]", this.isUTF8Type(type), true);
                    } else if (javaType.isNIOBufferArray()) {
                        this.emitGetDirectBufferAddress("_tmpObj", type3.getCName(), string3 + "_copy[_copyIndex]", true, "_offsetHandle[_copyIndex]", true);
                    } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                        this.emitGetDirectBufferAddress("_tmpObj", type3.getCName(), "(" + string3 + "_copy + _copyIndex)", false, null, true);
                    } else {
                        if (null == type2) {
                            throw new GlueGenException("XXX: Type " + type.getDebugString() + " not properly handled as ptr-to-ptr: " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                        }
                        this.unit.emit("      ");
                        this.emitMalloc(string3 + "_copy[_copyIndex]", type2.getCName(), type.isBaseTypeConst(), "(*env)->GetArrayLength(env, _tmpObj)", "Could not allocate buffer during copying of data in argument \\\"" + string + "\\\"");
                        throw new GlueGenException("Cannot yet handle type \"" + type.getDebugString() + "\"; need to add support for copying ptr-to-ptr-to-primitiveType subarrays: " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                    }
                    this.unit.emitln("    }");
                    if (javaType.isNIOBufferArray()) {
                        this.unit.emitln("    (*env)->ReleasePrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", _offsetHandle, JNI_ABORT);");
                    }
                    this.unit.emitln();
                }
                this.unit.emitln("  }");
                continue;
            }
            if (!javaType.isString()) continue;
            this.emitGetStringChars(string, STRING_CHARS_PREFIX + string, this.isUTF8Type(this.binding.getCArgumentType(i)), false);
        }
    }

    protected void emitBodyVariablePostCallCleanup() {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            Type type = this.binding.getCArgumentType(i);
            String string = this.binding.getArgumentName(i);
            if (javaType.isArray() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation || javaType.isArrayOfCompoundTypeWrappers()) {
                Object object;
                boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
                String string2 = this.pointerConversionArgumentName(string);
                if (!bl) {
                    this.unit.emitln("  if ( JNI_FALSE == " + this.isNIOArgName(i) + " && NULL != " + string + " ) {");
                    object = type.isBaseTypeConst() ? "JNI_ABORT" : "0";
                    this.unit.emit("    (*env)->ReleasePrimitiveArrayCritical(env, " + string + ", " + string2 + ", " + (String)object + ");");
                } else {
                    this.unit.emitln("  if ( NULL != " + string + " ) {");
                    if (!type.isBaseTypeConst()) {
                        if (javaType.isArrayOfCompoundTypeWrappers()) {
                            this.unit.emitln("    _tmpArrayLen = (*env)->GetArrayLength(env, " + string + ");");
                            this.unit.emitln("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                            this.unit.emitln("      _tmpObj = (*env)->GetObjectArrayElement(env, " + string + ", _copyIndex);");
                            this.emitReturnDirectBufferAddress("_tmpObj", type.getBaseType().getCName(), "(" + string2 + "_copy + _copyIndex)", false, null);
                            this.unit.emitln("    }");
                        } else {
                            throw new GlueGenException("Cannot clean up copied data for ptr-to-ptr arg type \"" + type.getDebugString() + "\": support for cleaning up most non-const ptr-to-ptr types not implemented.", this.binding.getCSymbol().getASTLocusTag());
                        }
                    }
                    this.unit.emitln("    /* Clean up " + string2 + "_copy */");
                    if (!javaType.isNIOBufferArray() && !javaType.isArrayOfCompoundTypeWrappers()) {
                        this.unit.emit("    ");
                        this.unit.emit("_tmpArrayLen");
                        this.unit.emit(" = (*env)->GetArrayLength(env, ");
                        this.unit.emit(string);
                        this.unit.emitln(");");
                        object = type.asPointer();
                        if (object == null) {
                            throw new GlueGenException("Could not copy data for type \"" + type.getDebugString() + "\"; currently only pointer types supported.", this.binding.getCSymbol().getASTLocusTag());
                        }
                        this.unit.emitln("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                        this.unit.emitln("      /* free each element of " + string2 + "_copy */");
                        this.unit.emit("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                        this.unit.emit(string);
                        this.unit.emitln(", _copyIndex);");
                        if (!javaType.isStringArray()) {
                            throw new GlueGenException("Cannot yet handle type \"" + type.getDebugString() + "\"; need to add support for cleaning up copied ptr-to-ptr-to-primitiveType subarrays", this.binding.getCSymbol().getASTLocusTag());
                        }
                        this.unit.emit("     (*env)->ReleaseStringUTFChars(env, ");
                        this.unit.emit("(jstring) _tmpObj");
                        this.unit.emit(", ");
                        this.unit.emit(string2 + "_copy[_copyIndex]");
                        this.unit.emitln(");");
                        this.unit.emitln("    }");
                    }
                    this.unit.emit("    free((void*) ");
                    this.unit.emit(string2 + "_copy");
                    this.unit.emitln(");");
                }
                this.unit.emitln("  }");
                continue;
            }
            if (!javaType.isString()) continue;
            this.unit.emitln("  if ( NULL != " + string + " ) {");
            if (this.isUTF8Type(type)) {
                this.unit.emit("    (*env)->ReleaseStringUTFChars(env, ");
                this.unit.emit(string);
                this.unit.emit(", _strchars_");
                this.unit.emit(string);
                this.unit.emitln(");");
            } else {
                this.unit.emitln("    free((void*) _strchars_" + string + ");");
            }
            this.unit.emitln("  }");
        }
    }

    protected int emitBodyPassCArguments() {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType;
            if (i != 0) {
                this.unit.emit(", ");
            }
            if ((javaType = this.binding.getJavaArgumentType(i)).isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv()) {
                this.unit.emit("env");
                continue;
            }
            if (this.binding.isArgumentThisPointer(i)) {
                this.unit.emit(CMethodBindingEmitter.cThisArgumentName());
                continue;
            }
            this.unit.emit("(");
            Type type = this.binding.getCArgumentType(i);
            boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
            boolean bl2 = !bl && (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation);
            this.unit.emit(type.getCName(true));
            this.unit.emit(") ");
            if (type.isPointer() && javaType.isPrimitive()) {
                this.unit.emit("(intptr_t) ");
            }
            if (javaType.isArray() || javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper() || javaType.isArrayOfCompoundTypeWrappers()) {
                if (bl2) {
                    this.unit.emit("(((char *) ");
                } else if (!type.isPointer() && javaType.isCompoundTypeWrapper()) {
                    this.unit.emit("*");
                }
                this.unit.emit(this.pointerConversionArgumentName(this.binding.getArgumentName(i)));
                if (bl) {
                    this.unit.emit("_copy");
                }
                if (!bl2) continue;
                this.unit.emit(") + " + this.byteOffsetArgName(i) + ")");
                continue;
            }
            if (javaType.isString()) {
                this.unit.emit(STRING_CHARS_PREFIX);
            }
            this.unit.emit(this.binding.getArgumentName(i));
            if (javaType.isString() || null == this.javaCallbackEmitter) continue;
            this.javaCallbackEmitter.emitCOptArgumentSuffix(this.unit, i);
        }
        return this.binding.getNumArguments();
    }

    protected void setIsCStructFunctionPointer(boolean bl) {
        this.isCStructFunctionPointer = bl;
    }

    protected void emitBodyCallCFunction() {
        this.unit.emit("  ");
        Type type = this.binding.getCReturnType();
        if (!type.isVoid()) {
            this.unit.emit("_res = (");
            this.unit.emit(type.getCName(false));
            this.unit.emit(") ");
        }
        if (this.isCStructFunctionPointer && this.binding.hasContainingType()) {
            this.unit.emit(CMethodBindingEmitter.cThisArgumentName() + "->");
        }
        this.unit.emit(this.getNativeName());
        this.unit.emit("(");
        this.emitBodyPassCArguments();
        this.unit.emitln(");");
    }

    protected void emitBodyUserVariableAssignments() {
        if (this.temporaryCVariableAssignments != null) {
            for (String string : this.temporaryCVariableAssignments) {
                this.unit.emit("  ");
                this.unit.emitln(string);
            }
        }
    }

    public boolean emitBodyMapCToJNIType(int n, boolean bl) {
        String string;
        JavaType javaType;
        Type type;
        boolean bl2;
        if (0 > n) {
            bl2 = true;
            type = this.binding.getCReturnType();
            javaType = this.binding.getJavaReturnType();
            string = "_res";
        } else {
            bl2 = false;
            type = this.binding.getCArgumentType(n);
            javaType = this.binding.getJavaArgumentType(n);
            string = this.binding.getArgumentName(n);
        }
        String string2 = string + "_jni";
        if (type.isVoid()) {
            return false;
        }
        if (javaType.isPrimitive()) {
            if (bl) {
                this.unit.emit("  " + javaType.jniTypeName() + " " + string2 + " = ");
            } else {
                this.unit.emit("  " + string2 + " = ");
            }
            if (type.isPointer()) {
                this.unit.emit("(" + javaType.jniTypeName() + ") (intptr_t) ");
            }
            this.unit.emit(string);
            this.unit.emitln(";");
        } else if (!type.isPointer() && javaType.isCompoundTypeWrapper()) {
            if (bl) {
                this.unit.emit("  " + javaType.jniTypeName() + " " + string2 + " = ");
            } else {
                this.unit.emit("  " + string2 + " = ");
            }
            String string3 = bl2 && this.returnValueCapacityExpression != null ? this.returnValueCapacityExpression.format(this.argumentNameArray()) : "sizeof(" + type.getCName() + ")";
            this.unit.emitln("JVMUtil_NewDirectByteBufferCopy(env, _clazzBuffers, &" + string + ", " + string3 + ");");
            this.unit.addTailCode("static const char * nameCopyNativeToDirectByteBuffer = \"copyNativeToDirectByteBuffer\";\nstatic const char * nameCopyNativeToDirectByteBufferSignature = \"(JJ)Ljava/nio/ByteBuffer;\";\n\nstatic jobject JVMUtil_NewDirectByteBufferCopy(JNIEnv *env, jclass clazzBuffers, void * source_address, size_t capacity) {\n    jmethodID cstrBuffersNew = (*env)->GetStaticMethodID(env, clazzBuffers, nameCopyNativeToDirectByteBuffer, nameCopyNativeToDirectByteBufferSignature);\n    if(NULL==cstrBuffersNew) {\n        fprintf(stderr, \"Can't get method Buffers.%s(%s)\\n\", nameCopyNativeToDirectByteBuffer, nameCopyNativeToDirectByteBufferSignature);\n        (*env)->FatalError(env, nameCopyNativeToDirectByteBuffer);\n        return JNI_FALSE;\n    }\n    jobject jbyteBuffer  = (*env)->CallStaticObjectMethod(env, clazzBuffers, cstrBuffersNew, (jlong)(intptr_t)source_address, (jlong)capacity);\n    if( (*env)->ExceptionCheck(env) ) {\n        (*env)->ExceptionDescribe(env);\n        (*env)->ExceptionClear(env);\n        (*env)->FatalError(env, \"Exception occurred\");\n        return NULL;\n    }\n    return jbyteBuffer;\n}\n");
        } else if (javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper()) {
            if (bl) {
                this.unit.emitln("  " + javaType.jniTypeName() + " " + string2 + ";");
            } else {
                this.unit.emitln("  " + string2 + ";");
            }
            this.unit.emitln("  if(NULL == " + string + ") {");
            this.unit.emitln("    " + string2 + " = NULL;");
            this.unit.emitln("  } else {");
            this.unit.emit("    " + string2 + " = (*env)->NewDirectByteBuffer(env, (void *)" + string + ", ");
            if (bl2 && this.returnValueCapacityExpression != null) {
                this.unit.emitln(this.returnValueCapacityExpression.format(this.argumentNameArray()) + ");");
            } else {
                Type type2 = type.isPointer() ? type.getTargetType() : null;
                int n2 = 0;
                if (1 == type.pointerDepth() && null != type2) {
                    if (type2.isCompound()) {
                        if (!type2.isAnon() && type2.asCompound().getNumFields() > 0) {
                            if (type2.getSize() == null) {
                                throw new GlueGenException("Error emitting code for compound type for function \"" + this.binding + "\": Structs to be emitted should have been laid out by this point (type " + type2.getCName() + " / " + type2.getDebugString() + " was not) for " + this.binding.getCSymbol(), this.binding.getCSymbol().getASTLocusTag());
                            }
                            this.unit.emitln("sizeof(" + type2.getCName() + ") );");
                            n2 = 10;
                        } else if (type2.asCompound().getNumFields() == 0) {
                            this.unit.emitln("sizeof(" + type.getCName() + ") );");
                            n2 = 11;
                        }
                    }
                    if (0 == n2) {
                        if (type2.isPrimitive()) {
                            this.unit.emitln("sizeof(" + type2.getCName() + ") );");
                            n2 = 20;
                        } else if (type2.isVoid()) {
                            this.unit.emitln("sizeof(" + type.getCName() + ") );");
                            n2 = 21;
                        }
                    }
                }
                if (0 == n2) {
                    if (null != this.cfg.typeInfo(type)) {
                        this.unit.emitln("sizeof(" + type.getCName() + ") );");
                        n2 = 88;
                    } else {
                        this.unit.emitln("sizeof(" + type.getCName() + ") ); // WARNING: " + "Assumed return size of equivalent C return type");
                        n2 = 99;
                        this.LOG.warning(this.binding.getCSymbol().getASTLocusTag(), "No capacity specified for java.nio.Buffer return value for function \"" + this.binding.getName() + "\". " + "Assumed return size of equivalent C return type" + " (sizeof(" + type.getCName() + ")): " + this.binding);
                    }
                }
                this.unit.emitln("    /** ");
                this.unit.emitln("     * mode: " + n2 + ", arg #" + n);
                this.unit.emitln("     * cType: " + type.getDebugString());
                this.unit.emitln("     * cTargetType: " + type2.getDebugString());
                this.unit.emitln("     * javaType: " + javaType.getDebugString());
                this.unit.emitln("     */");
            }
            this.unit.emitln("  }");
        } else if (javaType.isString()) {
            int n3;
            boolean bl3 = javaType.isPascalStringVariant();
            String string4 = bl3 ? (0 <= (n3 = this.cfg.pascalStringLengthIndex(this.getCSymbol(), n)) ? this.binding.getArgumentName(n3) : null) : null;
            if (bl) {
                this.unit.emitln("  " + javaType.jniTypeName() + " " + string2 + ";");
            }
            if (null != string4) {
                this.unit.emitln("  if (NULL == " + string + " || 0 >= " + string4 + " ) {");
            } else {
                this.unit.emitln("  if (NULL == " + string + ") {");
            }
            this.unit.emitln("    " + string2 + " = NULL;");
            this.unit.emitln("  } else {");
            if (null != string4) {
                this.unit.emitln("    char* " + string + "_cstr = calloc(" + string4 + "+1, sizeof(char)); // PascalString -> Add EOS");
                this.unit.emitln("    memcpy(" + string + "_cstr, " + string + ", " + string4 + ");");
            }
            this.unit.emit("    " + string2 + " = ");
            if (null != string4) {
                this.unit.emitln("(*env)->NewStringUTF(env, (const char *)" + string + "_cstr);");
                this.unit.emitln("    free(" + string + "_cstr);");
            } else {
                this.unit.emitln("(*env)->NewStringUTF(env, (const char *)" + string + ");");
            }
            this.unit.emitln("  }");
        } else if (javaType.isArrayOfCompoundTypeWrappers() || javaType.isArray() && javaType.isNIOByteBufferArray()) {
            if (bl) {
                this.unit.emitln("  " + javaType.jniTypeName() + " " + string2 + ";");
            }
            this.unit.emitln("  if (NULL == " + string + ") { " + string2 + " = NULL; } else {");
            if (!bl2 || this.returnValueLengthExpression == null) {
                throw new GlueGenException("Error while generating C code: No length specified for array returned from function for arg #" + n + ", " + type.getDebugString() + ", for " + this.binding, this.binding.getCSymbol().getASTLocusTag());
            }
            this.unit.emitln("    _array_res_length = " + this.returnValueLengthExpression.format(this.argumentNameArray()) + ";");
            this.unit.emitln("    _array_res = (*env)->NewObjectArray(env, _array_res_length, (*env)->FindClass(env, \"java/nio/ByteBuffer\"), NULL);");
            this.unit.emitln("    for (_array_idx = 0; _array_idx < _array_res_length; _array_idx++) {");
            Type type3 = this.binding.getCSymbol().getReturnType();
            Type type4 = type3.getArrayBaseOrPointerTargetType();
            this.unit.emitln("      (*env)->SetObjectArrayElement(env, _array_res, _array_idx, (*env)->NewDirectByteBuffer(env, (void *)" + string + "[" + arrayIdx + "], sizeof(" + type4.getCName() + ")));");
            this.unit.emitln("    }");
            this.unit.emitln("  " + string2 + " = " + arrayRes + ";");
            this.unit.emitln("  }");
        } else {
            if (javaType.isArray()) {
                throw new GlueGenException("Could not emit native code for arg #" + n + ", " + type.getDebugString() + ", for " + this.binding + ": array return values for non-char types not implemented yet.", this.binding.getCSymbol().getASTLocusTag());
            }
            throw new GlueGenException("Unhandled return type: arg #" + n + ", C " + type.getDebugString() + ", java " + javaType.getDebugString() + " for " + this.binding, this.binding.getCSymbol().getReturnType().getASTLocusTag());
        }
        return true;
    }

    protected static String cThisArgumentName() {
        return "this0";
    }

    protected String jniMangle(MethodBinding methodBinding) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JavaEmitter.jniMangle(this.getImplName()));
        stringBuilder.append(this.getImplSuffix());
        if (null == this.javaCallbackEmitter) {
            stringBuilder.append("__");
            CMethodBindingEmitter.appendJNIMangledArgs(methodBinding, this.forIndirectBufferAndArrayImplementation, stringBuilder);
            if (null != this.javaCallbackEmitter) {
                this.javaCallbackEmitter.appendCAdditionalJNIDescriptor(stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    public static StringBuilder appendJNIMangledArgs(MethodBinding methodBinding, boolean bl, StringBuilder stringBuilder) {
        if (methodBinding.isReturnCompoundByValue()) {
            JavaType.appendJNIDescriptor(stringBuilder, Class.class, true);
        }
        if (methodBinding.hasContainingType()) {
            JavaType.appendJNIDescriptor(stringBuilder, ByteBuffer.class, true);
        }
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            Object[] objectArray;
            if (methodBinding.isArgumentThisPointer(i)) continue;
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (i == 0 && methodBinding.getNumArguments() <= 1) continue;
                throw new GlueGenException("Saw illegal \"void\" argument while emitting arg " + i + " of " + methodBinding, methodBinding.getCArgumentType(i).getASTLocusTag());
            }
            Class<?> clazz = javaType.getJavaClass();
            if (clazz != null) {
                JavaType.appendJNIDescriptor(stringBuilder, clazz, false);
                if (javaType.isNIOBuffer()) {
                    JavaType.appendJNIDescriptor(stringBuilder, Integer.TYPE, false);
                    if (bl) {
                        JavaType.appendJNIDescriptor(stringBuilder, Boolean.TYPE, false);
                    }
                } else if (javaType.isNIOBufferArray()) {
                    objectArray = new int[0];
                    clazz = objectArray.getClass();
                    JavaType.appendJNIDescriptor(stringBuilder, clazz, true);
                }
                if (!javaType.isPrimitiveArray()) continue;
                JavaType.appendJNIDescriptor(stringBuilder, Integer.TYPE, false);
                continue;
            }
            if (javaType.isNamedClass()) {
                stringBuilder.append(javaType.getJNIMethodDesciptor());
                continue;
            }
            if (javaType.isCompoundTypeWrapper()) {
                JavaType.appendJNIDescriptor(stringBuilder, ByteBuffer.class, true);
                continue;
            }
            if (javaType.isArrayOfCompoundTypeWrappers()) {
                objectArray = new ByteBuffer[]{};
                JavaType.appendJNIDescriptor(stringBuilder, objectArray.getClass(), true);
                continue;
            }
            if (javaType.isJNIEnv()) continue;
            throw new GlueGenException("Unknown kind of JavaType: arg " + i + ", name=" + javaType.getName() + " of " + methodBinding, methodBinding.getCArgumentType(i).getASTLocusTag());
        }
        return stringBuilder;
    }

    private void emitOutOfMemoryCheck(String string, String string2) {
        this.unit.emitln("  if ( NULL == " + string + " ) {");
        this.unit.emitln("      (*env)->ThrowNew(env, (*env)->FindClass(env, \"java/lang/OutOfMemoryError\"),");
        this.unit.emit("                       \"" + string2);
        this.unit.emit(" in native dispatcher for \\\"");
        this.unit.emit(this.getInterfaceName());
        this.unit.emitln("\\\"\");");
        this.unit.emit("      return");
        if (!this.binding.getJavaReturnType().isVoid()) {
            this.unit.emit(" 0");
        }
        this.unit.emitln(";");
        this.unit.emitln("    }");
    }

    private void emitMalloc(String string, String string2, boolean bl, String string3, String string4) {
        this.unit.emit("    ");
        this.unit.emit(string);
        this.unit.emit(" = (");
        if (bl) {
            this.unit.emit("const ");
        }
        this.unit.emit(string2);
        this.unit.emit(" *) malloc(");
        this.unit.emit(string3);
        this.unit.emit(" * sizeof(");
        this.unit.emit(string2);
        this.unit.emitln("));");
        this.emitOutOfMemoryCheck(string, string4);
    }

    private void emitCalloc(String string, String string2, String string3, String string4) {
        this.unit.emit("    ");
        this.unit.emit(string);
        this.unit.emit(" = (");
        this.unit.emit(string2);
        this.unit.emit(" *) calloc(");
        this.unit.emit(string3);
        this.unit.emit(", sizeof(");
        this.unit.emit(string2);
        this.unit.emitln("));");
        this.emitOutOfMemoryCheck(string, string4);
    }

    private void emitGetStringChars(String string, String string2, boolean bl, boolean bl2) {
        this.unit.emitln("  if ( NULL != " + string + " ) {");
        if (bl) {
            this.unit.emit("    ");
            this.unit.emit(string2);
            this.unit.emit(" = (*env)->GetStringUTFChars(env, ");
            this.unit.emit(string);
            this.unit.emitln(", (jboolean*)NULL);");
            this.emitOutOfMemoryCheck(string2, "Failed to get UTF-8 chars for argument \\\"" + string + "\\\"");
        } else {
            this.emitCalloc(string2, "jchar", "(*env)->GetStringLength(env, " + string + ") + 1", "Could not allocate temporary buffer for copying string argument \\\"" + string + "\\\"");
            this.unit.emitln("    (*env)->GetStringRegion(env, " + string + ", 0, (*env)->GetStringLength(env, " + string + "), " + string2 + ");");
        }
        this.unit.emit("  }");
        if (bl2) {
            this.unit.emit(" else {");
            this.unit.emit("      ");
            this.unit.emit(string2);
            this.unit.emitln(" = NULL;");
            this.unit.emitln("  }");
        } else {
            this.unit.emitln();
        }
    }

    private void emitGetDirectBufferAddress(String string, String string2, String string3, boolean bl, String string4, boolean bl2) {
        this.unit.emitln("    if ( NULL != " + string + " ) {");
        this.unit.emit("    ");
        this.unit.emit("    ");
        if (bl) {
            this.unit.emit(string3 + " = (" + string2 + ") (((char*) (*env)->GetDirectBufferAddress(env, " + string + "))");
            this.unit.emitln(" + " + (string4 != null ? string4 : "0") + ");");
        } else {
            this.unit.emitln("memcpy((void *)" + string3 + ", (*env)->GetDirectBufferAddress(env, " + string + "), sizeof(" + string2 + "));");
        }
        if (bl2) {
            this.unit.emitln("    } else {");
            this.unit.emit("    ");
            this.unit.emit("    ");
            if (bl) {
                this.unit.emit(string3);
                this.unit.emitln(" = NULL;");
            } else {
                this.unit.emitln("memset((void *)" + string3 + ", 0, sizeof(" + string2 + "));");
            }
        }
        this.unit.emitln("    }");
        this.unit.emitln();
    }

    private void emitReturnDirectBufferAddress(String string, String string2, String string3, boolean bl, String string4) {
        this.unit.emit("    ");
        this.unit.emit("    ");
        if (bl) {
            this.unit.emit("(((char*) (*env)->GetDirectBufferAddress(env, " + string + "))");
            this.unit.emitln(" + " + (string4 != null ? string4 : "0") + ") = " + string3 + ";");
            throw new RuntimeException("incomplete implementation");
        }
        this.unit.emitln("memcpy((*env)->GetDirectBufferAddress(env, " + string + "), " + string3 + ", sizeof(" + string2 + "));");
        this.unit.emitln();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean emitPointerDeclaration(JavaType javaType, Type type, String string, String string2) {
        Object object;
        Class<?> clazz;
        String string3 = null;
        boolean bl = false;
        if (javaType.isNIOBuffer()) {
            string3 = type.getCName();
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            bl = this.javaArgTypeNeedsDataCopy(javaType);
            if (javaType.isPrimitiveArray() || javaType.isNIOBufferArray() || javaType.isArrayOfCompoundTypeWrappers()) {
                string3 = type.getCName();
            } else if (!javaType.isStringArray()) {
                clazz = javaType.getJavaClass().getComponentType();
                if (!clazz.isArray()) throw new GlueGenException("Unsupported pointer type: \"" + type.getDebugString() + "\"", type.getASTLocusTag());
                object = clazz.getComponentType();
                if (!((Class)object).isPrimitive()) throw new GlueGenException("Unsupported pointer type: \"" + type.getDebugString() + "\"", type.getASTLocusTag());
                string3 = type.getCName();
            }
        } else {
            string3 = type.getCName();
        }
        this.unit.emit("  ");
        if (!bl) {
            this.unit.emit(string3);
            if (!type.isPointer() && javaType.isCompoundTypeWrapper()) {
                this.unit.emit(" * ");
            } else {
                this.unit.emit(" ");
            }
            this.unit.emit(string);
            this.unit.emitln(" = NULL;");
            return bl;
        } else {
            if (javaType.isStringArray()) {
                clazz = "char *";
                object = type.asPointer();
                if (object != null) {
                    clazz = ((PointerType)object).getTargetType().asPointer().getCName();
                }
                if (type.isBaseTypeConst()) {
                    this.unit.emit("const ");
                }
                this.unit.emit((String)((Object)clazz) + " *");
            } else {
                if (type.isBaseTypeConst()) {
                    this.unit.emit("const ");
                }
                this.unit.emit(string3);
            }
            this.unit.emit(" ");
            this.unit.emit(string);
            this.unit.emit("_copy = NULL; /* copy of data in ");
            this.unit.emit(string2);
            this.unit.emitln(", laid out according to C memory model */");
        }
        return bl;
    }

    private void emitPointerConversion(MethodBinding methodBinding, JavaType javaType, Type type, String string, String string2, String string3) {
        if (javaType.isCompoundTypeWrapper()) {
            string3 = null;
        }
        String string4 = !type.isPointer() && javaType.isCompoundTypeWrapper() ? type.getCName() + " *" : type.getCName();
        this.emitGetDirectBufferAddress(string, string4, string2, true, string3, false);
    }

    protected String byteOffsetArgName(int n) {
        return JavaMethodBindingEmitter.byteOffsetArgName(this.binding.getArgumentName(n));
    }

    protected String isNIOArgName(int n) {
        return this.isNIOArgName(this.binding.getArgumentName(n));
    }

    protected String isNIOArgName(String string) {
        return string + "_is_nio";
    }

    protected String byteOffsetArrayArgName(int n) {
        return this.binding.getArgumentName(n) + "_byte_offset_array";
    }

    protected String[] argumentNameArray() {
        String[] stringArray = new String[this.binding.getNumArguments()];
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            stringArray[i] = this.binding.getArgumentName(i);
            if (!this.binding.getJavaArgumentType(i).isPrimitiveArray()) continue;
            stringArray[i] = stringArray[i] + ", " + this.byteOffsetArgName(i);
        }
        return stringArray;
    }

    protected String pointerConversionArgumentName(String string) {
        return "_" + string + "_ptr";
    }

    protected boolean javaArgTypeNeedsDataCopy(JavaType javaType) {
        if (javaType.isArray()) {
            return javaType.isNIOBufferArray() || javaType.isStringArray() || javaType.getJavaClass().getComponentType().isArray();
        }
        return javaType.isArrayOfCompoundTypeWrappers();
    }

    protected static class DefaultCommentEmitter
    implements CommentEmitter {
        protected DefaultCommentEmitter() {
        }

        @Override
        public void emit(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            this.emitBeginning((CMethodBindingEmitter)functionEmitter, printWriter);
            this.emitEnding((CMethodBindingEmitter)functionEmitter, printWriter);
        }

        protected void emitBeginning(CMethodBindingEmitter cMethodBindingEmitter, PrintWriter printWriter) {
            printWriter.println("  Java->C glue code:");
            printWriter.print(" *   Java package: ");
            printWriter.print(cMethodBindingEmitter.getJavaPackageName());
            printWriter.print(".");
            printWriter.println(cMethodBindingEmitter.getJavaClassName());
            printWriter.print(" *    Java method: ");
            MethodBinding methodBinding = cMethodBindingEmitter.getBinding();
            printWriter.println(methodBinding);
            printWriter.println(" *     C function: " + methodBinding.getCSymbol());
        }

        protected void emitEnding(CMethodBindingEmitter cMethodBindingEmitter, PrintWriter printWriter) {
        }
    }
}

